package jp.co.sra.jun.geometry.solid;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSphereTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/29 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSphereTestExamples.java,v 8.6 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunSphereTestExamples extends JunTestExamples {
	/**
	 * Example1: Show a sphere as JunOpenGL3dObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSphere aSphere = new JunSphere(new Jun3dPoint(1, 1, 1), 1);
		System.out.println(aSphere.printString());
		System.out.println(aSphere.storeString());
		System.out.println("area: " + aSphere.area());
		System.out.println("volume:" + aSphere.volume());
		aSphere.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSphereTestExamples();
	}
}
