package jp.co.sra.jun.geometry.solid;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCircularCylinderTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/29 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCircularCylinderTestExamples.java,v 8.5 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunCircularCylinderTestExamples extends JunTestExamples {
	/**
	 * Example1: Show a cone as <code>JunOpenGL3dObject</code>.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunCircularCylinder aCircularCylinder = new JunCircularCylinder(new Jun3dPoint(1, 1, 1), 1, 2);
		System.out.println(aCircularCylinder.printString());
		System.out.println(aCircularCylinder.storeString());
		System.out.println("area: " + aCircularCylinder.area());
		System.out.println("volume:" + aCircularCylinder.volume());
		aCircularCylinder.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunCircularCylinderTestExamples();
	}
}
