package jp.co.sra.jun.geometry.pluralities;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunGeometries class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/29 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGeometries.java,v 8.8 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunGeometries extends JunGeometry {
	protected List geometries;

	/**
	 * Create a new instance of <code>JunGeometries</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunGeometries() {
		super();
	}

	/**
	 * Create a new instance of <code>JunGeometries</code> and initialize it.
	 * 
	 * @category Instance creation
	 * @param sizeInteger int
	 */
	public JunGeometries(int sizeInteger) {
		super();
		this.initialize_(sizeInteger);
	}

	/**
	 * Initialize this object.
	 * 
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		geometries = new ArrayList();
	}

	/**
	 * Initialize this object with array size.
	 * 
	 * @param sizeInteger int
	 * @category initialize-release
	 */
	public void initialize_(int sizeInteger) {
		super.initialize();
		geometries = new ArrayList(sizeInteger);
	}

	/**
	 * Answer the geometry objects as <code>List</code>.
	 * 
	 * @return java.util.List
	 * @category accessing
	 */
	protected List _geometries() {
		return geometries;
	}

	/**
	 * Returns the element at the specified position in this list.
	 *
	 * @param index int
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @throws java.lang.IndexOutOfBoundsException
	 * @category accessing
	 */
	public JunGeometry at_(int index) {
		return (JunGeometry) this._geometries().get(index);
	}

	/**
	 * Replaces the element at the specified position in this list with the specified element.
	 *
	 * @param index int
	 * @param geometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @throws java.lang.IndexOutOfBoundsException
	 * @category accessing
	 */
	public void at_put_(int index, JunGeometry geometry) {
		if (geometry == null) {
			return;
		}
		if (this.size() == index) {
			this._geometries().add(geometry);
		} else {
			this._geometries().set(index, geometry);
		}
	}

	/**
	 * Answer the geometry objects.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category accessing
	 */
	public JunGeometry[] geometries() {
		return (JunGeometry[]) this._geometries().toArray(new JunGeometry[this.size()]);
	}

	/**
	 * Set the geometry objects.
	 * 
	 * @param geometryCollection java.util.Collection
	 * @category accessing
	 */
	public void geometries_(Collection geometryCollection) {
		if (geometryCollection instanceof List) {
			geometries = (List) geometryCollection;
		} else {
			geometries = new ArrayList(geometryCollection);
		}
	}

	/**
	 * Set the geometry objects.
	 * 
	 * @param geometryCollection jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category accessing
	 */
	public void geometries_(JunGeometry[] geometryCollection) {
		Collection aCollection = new ArrayList();
		for (int i = 0; i < geometryCollection.length; i++) {
			aCollection.add(geometryCollection[i]);
		}
		this.geometries_(aCollection);
	}

	/**
	 * Answer the size of geometry objects.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int size() {
		return this._geometries().size();
	}

	/**
	 * Add a <code>JunGeometry</code> to the geometries.
	 * 
	 * @param aGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category adding
	 */
	public void add_(JunGeometry aGeometry) {
		if (aGeometry == null) {
			return;
		}
		this._geometries().add(aGeometry);
	}

	/**
	 * Add all of the array elements.
	 * 
	 * @param anArray jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category adding
	 */
	public void addAll_(JunGeometry[] anArray) {
		if (anArray == null) {
			return;
		}
		for (int i = 0; i < anArray.length; i++) {
			this.add_(anArray[i]);
		}
	}

	/**
	 * Add all of the collection elements.
	 * 
	 * @param aCollection java.util.Collection
	 * @category adding
	 */
	public void addAll_(Collection aCollection) {
		if (aCollection == null) {
			return;
		}
		this.addAll_((JunGeometry[]) aCollection.toArray(new JunGeometry[aCollection.size()]));
	}

	/**
	 * Answer true if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunGeometries another = (JunGeometries) anObject;
		int size = this.size();
		if (size != another.size()) {
			return false;
		}

		JunGeometry[] myGeometries = this.geometries();
		JunGeometry[] anotherGeometries = another.geometries();
		for (int i = 0; i < size; i++) {
			if (myGeometries[i].equal_(anotherGeometries[i]) == false) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Answer true if the Object is equal to the receiver, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunGeometries another = (JunGeometries) anObject;
		int size = this.size();
		if (size != another.size()) {
			return false;
		}

		JunGeometry[] myGeometries = this.geometries();
		JunGeometry[] anotherGeometries = another.geometries();
		for (int i = 0; i < size; i++) {
			if (myGeometries[i].equals(anotherGeometries[i]) == false) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Evaluate aBlock with each of the values of the receiver as the argument.
	 * Collect the resulting values into a collection that is like the receiver.
	 * Answer the new collection.
	 * 
	 * @return java.util.Collection
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public Collection collect_(final StBlockClosure aBlock) {
		final ArrayList newBoundingObjects = new ArrayList();
		this.do_(new StBlockClosure() {
			public Object value_(Object boundingObject) {
				newBoundingObjects.add(aBlock.value_(boundingObject));
				return null;
			}
		});
		return newBoundingObjects;
	}

	/**
	 * Enumerate each objects and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating 
	 */
	public Object do_(StBlockClosure aBlock) {
		JunGeometry[] myGeometries = this.geometries();
		for (int i = 0; i < myGeometries.length; i++) {
			Object result = aBlock.value_(myGeometries[i]);
			if (result != null) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument.
	 * Answer the first element for which aBlock evaluates to true.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating 
	 */
	public Object detect_(StBlockClosure aBlock) {
		return this.detect_ifNone_(aBlock, new StBlockClosure() {
			public Object value() {
				return null;
			}
		});
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument.
	 * Answer the first element for which aBlock evaluates to true.
	 * 
	 * @return java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public Object detect_ifNone_(StBlockClosure aBlock, StBlockClosure exceptionBlock) {
		JunGeometry[] myGeometries = this.geometries();
		for (int i = 0; i < myGeometries.length; i++) {
			Object result = aBlock.value_(myGeometries[i]);
			if (result != null && result instanceof Boolean) {
				if (((Boolean) result).booleanValue()) {
					return myGeometries[i];
				}
			}
		}
		return exceptionBlock.value();
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument.
	 * Collect into a new collection like the receiver, only those elements
	 * for which aBlock evaluates to false.  Answer the new collection.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.JunGeometries
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public JunGeometries reject_(final StBlockClosure aBlock) {
		return this.select_(new StBlockClosure() {
			public Object value_(Object boundingObject) {
				Object anObject = aBlock.value_(boundingObject);
				return new Boolean(anObject != null && anObject instanceof Boolean && ((Boolean) anObject).booleanValue() == false);
			}
		});
	}

	/**
	 * Evaluate aBlock with each of the receiver's elements as the argument. 
	 * Collect into a new collection like the receiver, only those elements
	 * for which aBlock evaluates to true.  Answer the new collection.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.JunGeometries
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public JunGeometries select_(final StBlockClosure aBlock) {
		JunGeometries self = null;
		try {
			self = (JunGeometries) this.getClass().newInstance();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}

		final JunGeometries copy = self;
		this.do_(new StBlockClosure() {
			public Object value_(Object aGeometry) {
				Boolean aBoolean = (Boolean) aBlock.value_(aGeometry);
				if (aBoolean != null && aBoolean.booleanValue() == true) {
					copy.add_((JunGeometry) aGeometry);
				}
				return null;
			}
		});
		return copy;
	}

	/**
	 * Convert to an array of <code>JunOpenGL3dObject<code>.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category converting
	 */
	public JunGeometry[] asArray() {
		return this.geometries();
	}

	/**
	 * Convert to a <code>JunOpenGL3dObject<code>.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#asJunOpenGL3dObject()
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject(this.size());
		JunGeometry[] geometries = this.geometries();
		for (int i = 0; i < geometries.length; i++) {
			compoundObject.add_(geometries[i].asJunOpenGL3dObject());
		}
		return compoundObject;
	}

	/**
	 * Print my storable string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.lang.IOException if failed.
	 * @see jp.co.sra.smalltalk.StObject#storeOn_(java.io.Writer)
	 * @category printing
	 */
	public void storeOn_(Writer aWriter) throws IOException {
		aWriter.write("((");
		aWriter.write(this.getClass().getName());
		aWriter.write(" new)");
		aWriter.write("\n");
		aWriter.write("\t");
		aWriter.write("addAll: ((");
		aWriter.write(this._geometries().getClass().getName());
		aWriter.write(" new: ");
		aWriter.write(Integer.toString(this._geometries().size()));
		aWriter.write(")");

		JunGeometry[] geometries = this.geometries();
		for (int i = 0; i < geometries.length; i++) {
			aWriter.write("\n");
			aWriter.write("\t");
			aWriter.write("\t");
			aWriter.write("add: [");
			geometries[i].storeOn_(aWriter);
			aWriter.write("] value;");
		}
		aWriter.write("\n");
		aWriter.write("))");
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		return this._geometries().isEmpty();
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.JunTransformation
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#transform_(jp.co.sra.jun.geometry.transformations.JunTransformation)
	 * @category transforming
	 */
	public JunGeometry transform_(JunTransformation aTransformation) {
		JunGeometries transformedCopy = (JunGeometries) _New(this.getClass());
		JunGeometry[] boundingObjects = this.geometries();
		for (int i = 0; i < boundingObjects.length; i++) {
			this.add_(boundingObjects[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
