package jp.co.sra.jun.geometry.pluralities;

import java.util.Collection;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;

/**
 * Jun2dTriangles class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dTriangles.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun2dTriangles extends JunTriangles {
	/**
	 * Create a new instance of <code>Jun2dTriangles</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun2dTriangles() {
		super();
	}

	/**
	 * Create a new instance of <code>Jun2dTriangles</code> and initialize it.
	 * 
	 * @param triangleCollection java.util.Collection
	 * @category Instance creation
	 */
	public Jun2dTriangles(Collection triangleCollection) {
		super(triangleCollection);
	}

	/**
	 * Create a new instance of <code>Jun2dTriangles</code> and initialize it.
	 * 
	 * @param triangleCollection jp.co.sra.jun.geometry.surfaces.Jun2dTriangle[]
	 * @category Instance creation
	 */
	public Jun2dTriangles(Jun2dTriangle[] triangleCollection) {
		super(triangleCollection);
	}

	/**
	 * Answer my current bounding ball.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall
	 * @category accessing
	 */
	public Jun2dBoundingBall boundingBall() {
		if (this.isEmpty()) {
			return new Jun2dBoundingBall(null);
		}
		Jun2dBoundingBall boundingBall = null;
		JunGeometry[] objects = this.geometries();
		for (int i = 0; i < objects.length; i++) {
			Jun2dTriangle each = (Jun2dTriangle) objects[i];
			if (boundingBall == null) {
				boundingBall = each.boundingBall();
			} else {
				boundingBall = each.boundingBall().merge_(boundingBall);
			}
		}
		return boundingBall;
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox
	 * @category accessing
	 */
	public Jun2dBoundingBox boundingBox() {
		if (this.isEmpty()) {
			return new Jun2dBoundingBox();
		}
		Jun2dBoundingBox boundingBox = null;
		JunGeometry[] objects = this.geometries();
		for (int i = 0; i < objects.length; i++) {
			Jun2dTriangle each = (Jun2dTriangle) objects[i];
			if (boundingBox == null) {
				boundingBox = each.boundingBox();
			} else {
				boundingBox = each.boundingBox().merge_(boundingBox);
			}
		}
		return boundingBox;
	}

	/**
	 * Answer the receiver's triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun2dTriangle[]
	 * @category accessing
	 */
	public Jun2dTriangle[] triangles() {
		return (Jun2dTriangle[]) this._geometries().toArray(new Jun2dTriangle[this._geometries().size()]);
	}

	/**
	 * Answer the receiver's subdivide triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun2dTriangles
	 * @category subdividing
	 */
	public Jun2dTriangles subdivide() {
		Jun2dTriangles copy = new Jun2dTriangles();
		Jun2dTriangle[] triangles = this.triangles();
		for (int i = 0; i < triangles.length; i++) {
			copy.addAll_(triangles[i].subdivide().geometries());
		}
		return copy;
	}

	/**
	 * Answer the receiver's subdivide triangles with specified level.
	 * 
	 * @param anInteger int
	 * @return jp.co.sra.jun.geometry.pluralities.Jun2dTriangles
	 * @category subdividing
	 */
	public Jun2dTriangles subdivideLevel_(int anInteger) {
		Jun2dTriangles copy = new Jun2dTriangles();
		Jun2dTriangle[] triangles = this.triangles();
		for (int i = 0; i < triangles.length; i++) {
			copy.addAll_(triangles[i].subdivideLevel_(anInteger).geometries());
		}
		return copy;
	}

	/**
	 * Answer true if the receiver is a 2d geometry element, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#is2d()
	 * @category testing
	 */
	public boolean is2d() {
		return true;
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun2dTriangles
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun2dTransformation
	 * @category transforming
	 */
	public Jun2dTriangles transform_(Jun2dTransformation aTransformation) {
		Jun2dTriangles transformedCopy = new Jun2dTriangles();
		JunGeometry[] geometries = this.geometries();
		for (int i = 0; i < geometries.length; i++) {
			this.add_(geometries[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
