package jp.co.sra.jun.geometry.boxtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;

/**
 * JunBoundingBoxNode class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/28 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingBoxNode.java,v 8.9 2008/02/20 06:30:56 nisinaka Exp $
 */
public abstract class JunBoundingBoxNode extends JunGeometry {
	protected Collection containedObjects;
	protected List subdividedNodes;
	protected boolean vanishBoolean;
	protected StSymbol messageToSubdivide;
	protected StBlockClosure compareWithBlock;
	protected StSymbol boxSituation;
	protected int levelNumber;

	/**
	 * Create a new instance of <code>JunBoundingBoxNode</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunBoundingBoxNode() {
		super();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		containedObjects = null;
		subdividedNodes = null;
		vanishBoolean = true;
		messageToSubdivide = $("subdivide2");
		boxSituation = $("necessary");
		levelNumber = Integer.MIN_VALUE;
	}

	/**
	 * Answer the receiver's box situation.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public StSymbol boxSituation() {
		return boxSituation;
	}

	/**
	 * Set the receiver's box situation.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public void boxSituation_(StSymbol aSymbol) {
		boxSituation = aSymbol;
	}

	/**
	 * Answer the receiver's compare with block.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public StBlockClosure compareWithBlock() {
		return compareWithBlock;
	}

	/**
	 * Set the receiver's compare with block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void compareWithBlock_(StBlockClosure aBlock) {
		compareWithBlock = aBlock;
	}

	/**
	 * Answer the receiver's contained objects.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category accessing
	 */
	public JunGeometry[] containedObjects() {
		if (containedObjects == null) {
			containedObjects = new ArrayList();
		}
		return (JunGeometry[]) containedObjects.toArray(new JunGeometry[containedObjects.size()]);
	}

	/**
	 * Set the receiver's contained objects.
	 * 
	 * @param objectCollection java.util.Collection
	 * @category accessing
	 */
	public void containedObjects_(Collection objectCollection) {
		containedObjects = objectCollection;
		subdividedNodes = null;
	}

	/**
	 * Answer the receiver's levelNumber.
	 * 
	 * @return int
	 * @category accessing
	 */
	public abstract int levelNumber();

	/**
	 * Answer the receiver's messageToSubdivide.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public StSymbol messageToSubdivide() {
		return messageToSubdivide;
	}

	/**
	 * Set the receiver's message selector of subdivide.
	 * 
	 * @param messageSelector jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public void messageToSubdivide_(StSymbol messageSelector) {
		messageToSubdivide = messageSelector;
	}

	/**
	 * Answer the receiver's vanish as <code>boolean</code>.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean vanishBoolean() {
		return vanishBoolean;
	}

	/**
	 * Set the receiver's vanish as <code>boolean</code>.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void vanishBoolean_(boolean aBoolean) {
		vanishBoolean = aBoolean;
	}

	/**
	 * Answer <code>true</code> if the receiver is equal to the object.
	 * 
	 * @return boolean
	 * @param anObject java.lang.Object
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		return this.equal_(anObject);
	}

	/**
	 * Flush the receiver's subdivided nodes.
	 * 
	 * @category flushing
	 */
	protected void flushSubdividedNodes() {
		subdividedNodes = null;
	}

	/**
	 * Answer the receiver's short print string.
	 * 
	 * @return java.lang.String
	 * @category printing
	 */
	public abstract String shortPrintString();

	/**
	 * Compare the specified geometry object with bounding box.
	 * 
	 * @param object jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @param box jp.co.sra.jun.geometry.boundaries.JunBoundingBox
	 * @return java.lang.Object
	 * @category private
	 */
	protected Object compare_with_(JunGeometry object, JunBoundingBox box) {
		return compareWithBlock.value_value_(object, box);
	}
}
