package jp.co.sra.jun.geometry.boundaries;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.StObject;

import jp.co.sra.jun.geometry.basic.JunPoint;

/**
 * JunBoundingBox class
 * 
 *  @author    nisinaka
 *  @created   1998/10/01 (by nisinaka)
 *  @updated   1999/08/05 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2004/10/18 (by Mitsuhiro Asada)
 *  @updated   2006/10/10 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingBox.java,v 8.14 2008/02/20 06:30:56 nisinaka Exp $
 */
public abstract class JunBoundingBox extends JunBoundingObject {
	protected JunPoint _origin;
	protected JunPoint _corner;

	/**
	 * Answer the width of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double width() {
		return this._corner().x() - this._origin().x();
	}

	/**
	 * Answer the height of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double height() {
		return this._corner().y() - this._origin().y();
	}

	/**
	 * Answer the depth of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public abstract double depth();

	/**
	 * Answer my current origin point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected JunPoint _origin() {
		return _origin;
	}

	/**
	 * Set my new origin point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected void _origin(JunPoint aPoint) {
		_origin = aPoint;
	}

	/**
	 * Answer my current corner point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected JunPoint _corner() {
		return _corner;
	}

	/**
	 * Set my new corner point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected void _corner(JunPoint aPoint) {
		_corner = aPoint;
	}

	/**
	 * Answer true if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunBoundingBox aBoundingBox = (JunBoundingBox) anObject;
		return this._origin().equal_(aBoundingBox._origin()) && this._corner().equal_(aBoundingBox._corner());
	}

	/**
	 * Answer true if the Object is equal to the receiver, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.boundaries.JunBoundingBox#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunBoundingBox aBoundingBox = (JunBoundingBox) anObject;
		return this._origin().equals(aBoundingBox._origin()) && this._corner().equals(aBoundingBox._corner());
	}

	/**
	 * Compute a hash code for this object.
	 * 
	 * @return int
	 * @see java.lang.Object#hashCode()
	 * @category comparing
	 */
	public int hashCode() {
		return this._origin().hashCode() | this._corner().hashCode();
	}

	/**
	 * Convert to a Rectangle.
	 * 
	 * @return java.awt.Rectangle
	 * @category converting
	 */
	public abstract Rectangle asRectangle();

	/**
	 * Convert to an array of Rectangle.
	 * 
	 * @return java.awt.Rectangle[]
	 * @category converting
	 */
	public abstract Rectangle[] asRectangles();

	/**
	 * Do an extra copy of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StObject
	 * @see jp.co.sra.smalltalk.StObject#postCopy()
	 * @category copying
	 */
	public StObject postCopy() {
		super.postCopy();
		_origin = (JunPoint) _origin.copy();
		_corner = (JunPoint) _corner.copy();
		return this;
	}

	/**
	 * Print my storable string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#storeOn_(java.io.Writer)
	 * @category printing
	 */
	public void storeOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		this._origin().printOn_(aWriter);
		aWriter.write(" box:");
		this._corner().printOn_(aWriter);
		aWriter.write(')');
	}

	/**
	 * Answer true if the receiver is a bounding box, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isBoundingBox()
	 * @category testing
	 */
	public boolean isBoundingBox() {
		return true;
	}

}
