package jp.co.sra.jun.geometry.boundaries;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunBorderGeneratorTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/01/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun726 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBorderGeneratorTestExamples.java,v 8.13 2008/02/20 06:30:56 nisinaka Exp $
 */
public class JunBorderGeneratorTestExamples extends JunTestExamples {

	/**
	 * 2D Examples: Circle
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_Circle() {
		final Jun2dPoint center = new Jun2dPoint(0, 0);
		Jun2dPolygonalBoundary circle = JunBorderGenerator.PolygonalBoundaryWith_max_xInterval_yInterval_interim_(new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Double(center.distance_(new Jun2dPoint((Number) x, (Number) y)));
			}
		}, (double) 1, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);

		JunOpenGL3dObject circleObject = circle.asJunOpenGL3dObject();
		circleObject.paint_(Color.blue);
		circleObject.show();

		return true;
	}

	/**
	 * 2D Examples: Eclipse
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_Eclipse() {
		final Jun2dPoint center1 = new Jun2dPoint(-0.4, 0);
		final Jun2dPoint center2 = new Jun2dPoint(0.4, 0);
		Jun2dPolygonalBoundary circle = JunBorderGenerator.PolygonalBoundaryWith_max_xInterval_yInterval_interim_(new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				Jun2dPoint p = new Jun2dPoint((Number) x, (Number) y);
				return new Double(p.distance_(center1) + p.distance_(center2));
			}
		}, (double) 1, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);

		JunOpenGL3dObject circleObject = circle.asJunOpenGL3dObject();
		circleObject.paint_(Color.blue);
		circleObject.show();

		return true;
	}

	/**
	 * 2D Examples: Negative circle
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_NegativeCircle() {
		Jun2dPolygonalBoundary circle = JunBorderGenerator.PolygonalBoundaryWith_min_xInterval_yInterval_interim_(new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				return new Double((new Jun2dPoint((Number) x, (Number) y)).r());
			}
		}, (double) 1, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);

		JunOpenGL3dObject circleObject = circle.asJunOpenGL3dObject();
		circleObject.paint_(Color.blue);
		circleObject.show();

		return true;
	}

	/**
	 * 2D Examples: Image contouring
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_ImageContouring() {
		final StImage anImage = StImage._OfArea(new Rectangle(2, 2, 128, 128));
		int width = anImage.width();
		int height = anImage.height();
		double scale = Math.max(width, height);
		JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
		JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(-width, -height, 0), new Jun3dPoint(width, -height, 0), new Jun3dPoint(width, height, 0), new Jun3dPoint(-width, height, 0), });
		JunOpenGLTexture texture = new JunOpenGLTexture(anImage);
		polygon.texture_(texture);
		texture.zPositiveParameters();
		compound.add_(polygon);

		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(0, scale * -4, scale * 2));
		aMap.put($("sightPoint"), new Jun3dPoint(0, 0, scale / 2));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		aMap.put($("projection"), $("parallelProjection"));
		JunOpenGLDisplayModel viewer = compound.showProjectionTable_(aMap);

		for (int i = 0; i <= 10; i++) {
			double brightness = i * 0.1;
			Jun2dPoint[][] polylines = JunBorderGenerator.ContourPolylinesFrom_at_xInterval_yInterval_interim_(new StBlockClosure() {
				public Object value_value_(Object objX, Object objY) {
					int x = ((Number) objX).intValue();
					int y = ((Number) objY).intValue();
					return new Float(StColorValue._GetBrightness(anImage.valueAtPoint_(new Point(x, y))));
				}
			}, brightness, new StInterval(0, width - 1), new StInterval(0, height - 1), null);

			for (int j = 0; j < polylines.length; j++) {
				Jun2dPoint[] points = polylines[j];
				Jun3dPoint[] vertexes = new Jun3dPoint[points.length];
				for (int k = 0; k < vertexes.length; k++) {
					double x = points[k].x();
					double y = points[k].y();
					vertexes[k] = new Jun3dPoint(x * 2 - width + 3, height - y * 2 - 2, brightness * scale);
				}

				JunOpenGL3dPolyline polyline = new JunOpenGL3dPolyline(vertexes, StColorValue.Brightness_(brightness));
				compound.add_(polyline);
			}
			viewer.resetView();
		}

		return true;
	}

	/**
	 * 2D Examples: Cut figure
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_CutFigure() {
		final StImage anImage = StImage._OfArea(new Rectangle(2, 2, 128, 128));
		int width = anImage.width();
		int height = anImage.height();
		double scale = Math.max(width, height);

		JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(0, scale * -12, scale * 4));
		aMap.put($("sightPoint"), new Jun3dPoint(0, 0, scale));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		aMap.put($("projection"), $("parallelProjection"));
		viewer.defaultProjectionTable_(aMap);
		viewer.open();

		Rectangle box = viewer.getWindow().getBounds();
		JunImageDisplayModel display = JunImageDisplayModel.Show_at_(anImage, new Point(box.x + box.width + 8, box.y));

		for (int i = 0; i <= 9; i++) {
			final double brightness = i * 0.1;
			Jun2dPolygonalBoundary boundary = JunBorderGenerator.PolygonalBoundaryWith_min_max_xInterval_yInterval_interim_(new StBlockClosure() {
				public Object value_value_(Object objX, Object objY) {
					int x = ((Number) objX).intValue();
					int y = ((Number) objY).intValue();
					return new Float(StColorValue._GetBrightness(anImage.valueAtPoint_(new Point(x, y))));
				}
			}, brightness, 1, new StInterval(0, width - 1), new StInterval(0, height - 1), null);

			Graphics aGraphics = null;
			try {
				aGraphics = anImage.image().getGraphics();
				aGraphics.setColor(Color.blue);

				Jun2dPolygon[] polygons = boundary.polygons();
				for (int j = 0; j < polygons.length; j++) {
					polygons[j].displayOn_(aGraphics);
				}
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
					aGraphics = null;
				}
			}
			display.image_(anImage);
			display.redisplay();

			final JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
			boundary.scaledBy_(new Jun2dPoint(2, -2)).translatedBy_(new Jun2dPoint(-width, height)).asJunOpenGL3dObjectsDo_(new StBlockClosure() {
				public Object value_(Object anObject) {
					JunOpenGL3dObject object = (JunOpenGL3dObject) anObject;
					object.paint_(StColorValue.Brightness_(brightness));
					body.add_(object);
					return null;
				}
			});
			JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
			compound.add_(new JunOpenGL3dTransformedObject(body, new Jun3dPoint(0, 0, brightness).multipliedBy_(scale * 2).transformationToTranslate()));
			if (viewer.displayObject() != null) {
				compound = new JunOpenGL3dCompoundObject(viewer.displayObject(), compound);
			}
			viewer.displayObject_(compound);
			viewer.resetView();
		}

		return true;
	}

	/**
	 * 2D Examples: Text
	 * 
	 * @return boolean
	 * @category 2D examples
	 */
	public static boolean Example2D_Text() {
		String string = JunDialog.Request_($String("Type in your favorite phrase."), $String("Be free!"));
		if (string == null || string.length() == 0) {
			return false;
		}
		String weightString = JunDialog.Request_(JunSystem.$String("Enter weight of the font.") + " (0.1 .. 0.9)", "0.5");
		if (weightString == null) {
			return false;
		}
		double weight = 0;
		try {
			weight = Double.parseDouble(weightString);
		} catch (NumberFormatException e) {
			return false;
		}
		weight = Math.max(0.1, Math.min(weight, 0.9));

		Font font = StComposedText.DefaultFont();
		Dimension extent = new StComposedText(string, font).extent();

		JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		viewer.open();

		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(extent.getWidth() / 2, extent.getHeight() / 2, extent.getWidth()));
		aMap.put($("sightPoint"), new Jun3dPoint(extent.getWidth() / 2, extent.getHeight() / 2, 0));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		viewer.defaultProjectionTable_(aMap);

		int offset = 0;
		char[] characters = string.toCharArray();
		for (int i = 0; i < characters.length; i++) {
			StComposedText text = new StComposedText(String.valueOf(characters[i]), font);

			final StImage image = new StImage(text.extent());
			Graphics g = null;
			try {
				g = image.image().getGraphics();
				g.setColor(Color.black);
				g.fillRect(0, 0, image.width(), image.height());
				g.setColor(Color.white);
				text.displayOn_(g);
			} finally {
				if (g != null) {
					g.dispose();
					g = null;
				}
			}

			Jun2dPolygonalBoundary boundary = JunBorderGenerator.PolygonalBoundaryWith_min_max_xInterval_yInterval_interim_(new StBlockClosure() {
				public Object value_value_(Object x, Object y) {
					Point p = new Point(((Number) x).intValue(), ((Number) y).intValue());
					return new Float(StColorValue._GetBrightness(image.valueAtPoint_(p)));
				}
			}, 1 - weight, 1, new StInterval(0, image.width() - 1), new StInterval(0, image.height() - 1), null);

			boundary = boundary.scaledBy_(new Jun2dPoint(1, -1));
			boundary = boundary.translatedBy_(new Jun2dPoint(offset, image.height()));
			offset += image.width();

			JunOpenGL3dCompoundObject displayObject = (JunOpenGL3dCompoundObject) viewer.displayObject();
			if (displayObject == null) {
				displayObject = new JunOpenGL3dCompoundObject();
			}
			displayObject.add_(boundary.asJunOpenGL3dObjectColor_(Color.blue));

			viewer.displayObject_(displayObject);
			viewer.resetView();
		}

		return true;
	}

	/**
	 * 3D Examples: Sphere
	 * 
	 * @return boolean
	 * @category 3D examples
	 */
	public static boolean Example3D_Sphere() {
		final Jun3dPoint center = new Jun3dPoint(0, 0, 0);
		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection aCollection = (Collection) anObject;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				viewer.do_forMilliseconds_(new StBlockClosure() {
					public Object value() {
						JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
						for (int i = 0; i < polygons.length; i++) {
							compound.add_(polygons[i].asJunOpenGL3dObjectColor_(Color.cyan));
						}
						viewer.displayObject_(compound);
						viewer.resetView();
						return null;
					}
				}, 500);
				return null;
			}
		};

		final StValueHolder last = new StValueHolder(0);
		JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
			public Object value_value_value_(Object x, Object y, Object z) {
				return new Double(new Jun3dPoint((Number) x, (Number) y, (Number) z).distance_(center));
			}
		}, 1, -1, new StInterval(-1.2, 1.2, 0.2), new StInterval(-1.2, 1.2, 0.2), new StInterval(-1.2, 1.2, 0.2), new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection polygons = (Collection) anObject;
				if (polygons.size() != last._intValue()) {
					block.value_(polygons);
					last.value_(polygons.size());
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * 3D Examples: Electric field
	 * 
	 * @return boolean
	 * @category 3D examples
	 */
	public static boolean Example3D_ElectricField() {
		final int[] qs = new int[] { 1, 3, -2, -4 };
		final Jun3dPoint[] ps = new Jun3dPoint[] { new Jun3dPoint(1, 0, 0), new Jun3dPoint(-1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, -1, 0) };
		int[] es = new int[] { 1, 0, -1 };
		final Color[] paints = new Color[] { Color.blue, Color.yellow, Color.red };

		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_value_(Object arg0, Object arg1) {
				Collection aCollection = (Collection) arg0;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				final int index = ((Number) arg1).intValue();
				viewer.do_forMilliseconds_(new StBlockClosure() {
					public Object value() {
						JunOpenGL3dCompoundObject compound = (JunOpenGL3dCompoundObject) viewer.displayObject();
						if (compound == null) {
							compound = new JunOpenGL3dCompoundObject();
						}
						for (int i = 0; i < polygons.length; i++) {
							compound.add_(polygons[i].asJunOpenGL3dObjectColor_(paints[index]));
						}
						viewer.displayObject_(compound);
						viewer.resetView();
						return null;
					}
				}, 500);
				return null;
			}
		};

		for (int i = 0; i < es.length; i++) {
			final Integer index = new Integer(i);
			final StValueHolder last = new StValueHolder(0);
			JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
				public Object value_value_value_(Object x, Object y, Object z) {
					Jun3dPoint p = new Jun3dPoint((Number) x, (Number) y, (Number) z);
					double e = 0;
					for (int i = 0; i < qs.length; i++) {
						double d = p.distance_(ps[i]);
						if (d < ps[i].accuracy()) {
							e += qs[i];
						} else {
							e += qs[i] / Math.pow(d, 2);
						}
					}
					return new Double(e);
				}
			}, es[i], 1, new StInterval(-2, 2, 0.3), new StInterval(-2, 2, 0.3), new StInterval(-2, 2, 0.3), new StBlockClosure() {
				public Object value_(Object anObject) {
					Collection polygons = (Collection) anObject;
					if (polygons.size() != last._intValue()) {
						block.value_value_(polygons, index);
						last.value_(polygons.size());
					}
					return null;
				}
			});
		}

		return true;
	}

	/**
	 * 3D Examples: Rugbyball
	 * 
	 * @return boolean
	 * @category 3D examples
	 */
	public static boolean Example3D_Rugbyball() {
		final Jun3dPoint center1 = new Jun3dPoint(-0.5, 0, 0);
		final Jun3dPoint center2 = new Jun3dPoint(0.5, 0, 0);
		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection aCollection = (Collection) anObject;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				viewer.do_forMilliseconds_(new StBlockClosure() {
					public Object value() {
						JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
						for (int i = 0; i < polygons.length; i++) {
							compound.add_(polygons[i].asJunOpenGL3dObjectColor_(Color.green));
						}
						viewer.displayObject_(compound);
						viewer.resetView();
						return null;
					}
				}, 1000);
				return null;
			}
		};

		final StValueHolder last = new StValueHolder(0);
		JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
			public Object value_value_value_(Object x, Object y, Object z) {
				Jun3dPoint p = new Jun3dPoint((Number) x, (Number) y, (Number) z);
				return new Double(p.distance_(center1) + p.distance_(center2));
			}
		}, 1.3, -1, new StInterval(-1, 2, 0.2), new StInterval(-1, 1, 0.1), new StInterval(-1, 1, 0.1), new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection polygons = (Collection) anObject;
				if (polygons.size() != last._intValue()) {
					block.value_(polygons);
					last.value_(polygons.size());
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * 3D Examples: Jun3dLogo
	 * 
	 * @return boolean
	 * @category 3D examples
	 */
	public static boolean Example3D_Jun3dLogo() {
		final StImage image = new StImage(JunSystem.LogoImage());
		final double weight = 3;
		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(image.bounds().getCenterX(), image.bounds().getCenterY(), 1000));
		aMap.put($("sightPoint"), new Jun3dPoint(image.bounds().getCenterX(), image.bounds().getCenterY(), 0));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		viewer.defaultProjectionTable_(aMap);
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection aCollection = (Collection) anObject;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
				for (int i = 0; i < polygons.length; i++) {
					compound.add_(polygons[i].asJunOpenGL3dObjectColor_(Color.blue));
				}
				viewer.displayObject_(compound);
				viewer.resetView();
				return null;
			}
		};

		final StValueHolder last = new StValueHolder(0);
		JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
			public Object value_value_value_(Object x, Object y, Object z) {
				Color color = image.valueAtPoint_(new Point(((Number) x).intValue(), image.height() - ((Number) y).intValue()));
				double brightness = StColorValue._GetBrightness(color);
				return new Double(Math.sqrt(Math.pow(brightness, 2) + Math.pow(((Number) z).doubleValue() / weight, 2)));
			}
		}, 0.5, -1, new StInterval(0, image.width() - 1, 2), new StInterval(1, image.height(), 2), new StInterval(-4, 4, 2), new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection polygons = (Collection) anObject;
				if (polygons.size() != last._intValue()) {
					block.value_(polygons);
					last.value_(polygons.size());
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * 3D Examples: Image landscape
	 * 
	 * @return boolean
	 * @category 3D examples
	 */
	public static boolean Example3D_ImageLandscape() {
		final StImage image = StImage._OfArea(new Rectangle(0, 0, 100, 100));
		int width = image.width();
		int height = image.height();
		final double scale = Math.min(width, height) / 4;

		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(width / 2, -height, height * 2));
		aMap.put($("sightPoint"), new Jun3dPoint(width / 2, height / 2, scale / 2));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		viewer.defaultProjectionTable_(aMap);
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection aCollection = (Collection) anObject;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				viewer.do_forMilliseconds_(new StBlockClosure() {
					public Object value() {
						JunOpenGL3dCompoundObject compound = new JunOpenGL3dCompoundObject();
						for (int i = 0; i < polygons.length; i++) {
							compound.add_(polygons[i].asJunOpenGL3dObjectColor_(Color.red));
						}
						viewer.displayObject_(compound);
						viewer.resetView();
						return null;
					}
				}, 1000);
				return null;
			}
		};

		final StValueHolder last = new StValueHolder(0);
		JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
			public Object value_value_value_(Object x, Object y, Object z) {
				Point p = new Point(((Number) x).intValue() - 1, image.height() - ((Number) y).intValue());
				Color color = image.valueAtPoint_(p);
				double brightness = StColorValue._GetBrightness(color);
				return new Double(brightness * scale - ((Number) z).doubleValue());
			}
		}, 0, 1, new StInterval(1, width, 1), new StInterval(1, height, 1), new StInterval(scale / -4, scale * 5 / 4, scale / 4), new StBlockClosure() {
			public Object value_(Object anObject) {
				Collection polygons = (Collection) anObject;
				if (polygons.size() != last._intValue()) {
					block.value_(polygons);
					last.value_(polygons.size());
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * 3D examples: text
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3D_Text() {
		String string = JunDialog.Request_(JunSystem.$String("Type in your favorite phrase."), JunSystem.$String("Be free!"));
		if (string == null || string.length() == 0) {
			return false;
		}
		String weightString = JunDialog.Request_(JunSystem.$String("Enter weight of the font.") + " (0.1 .. 0.9)", "0.5");
		if (weightString == null) {
			return false;
		}
		double weight = 0;
		try {
			weight = Double.parseDouble(weightString);
		} catch (NumberFormatException e) {
			return false;
		}
		weight = Math.max(0.1, Math.min(weight, 0.9));

		Font font = StComposedText.DefaultFont();
		Dimension extent = new StComposedText(string, font).extent();

		final JunOpenGLDisplayModel viewer = new JunOpenGLDisplayModel();
		HashMap aMap = new HashMap();
		aMap.put($("eyePoint"), new Jun3dPoint(extent.getWidth() / 2, extent.getHeight() / 2, 100));
		aMap.put($("sightPoint"), new Jun3dPoint(extent.getWidth() / 2, extent.getHeight() / 2, 0));
		aMap.put($("upVector"), new Jun3dPoint(0, 1, 0));
		viewer.defaultProjectionTable_(aMap);
		viewer.open();

		final StBlockClosure block = new StBlockClosure() {
			public Object value_value_(Object arg0, Object arg1) {
				Collection aCollection = (Collection) arg0;
				final Jun3dPolygon[] polygons = (Jun3dPolygon[]) aCollection.toArray(new Jun3dPolygon[aCollection.size()]);
				final int x = ((StValueHolder) arg1)._intValue();
				viewer.do_forMilliseconds_(new StBlockClosure() {
					public Object value() {
						JunOpenGL3dCompoundObject compound = (JunOpenGL3dCompoundObject) viewer.displayObject();
						if (compound == null) {
							compound = new JunOpenGL3dCompoundObject();
						}
						for (int i = 0; i < polygons.length; i++) {
							compound.add_(polygons[i].asJunOpenGL3dObjectColor_(Color.magenta).translatedBy_(new Jun3dPoint(x, 0, 0)));
						}
						viewer.displayObject_(compound);
						viewer.resetView();
						return null;
					}
				}, 500);
				return null;
			}
		};

		final StValueHolder offset = new StValueHolder(0);
		char[] characters = string.toCharArray();
		for (int i = 0; i < characters.length; i++) {
			final StValueHolder last = new StValueHolder(0);
			StComposedText text = new StComposedText(String.valueOf(characters[i]), font);

			final StImage image = new StImage(text.extent());
			Graphics g = null;
			try {
				g = image.image().getGraphics();
				g.setColor(Color.black);
				g.fillRect(0, 0, image.width(), image.height());
				g.setColor(Color.white);
				text.displayOn_(g);
			} finally {
				if (g != null) {
					g.dispose();
					g = null;
				}
			}

			JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
				public Object value_value_value_(Object x, Object y, Object z) {
					Point p = new Point(((Number) x).intValue(), image.height() - ((Number) y).intValue());
					double v = 1 - StColorValue._GetBrightness(image.valueAtPoint_(p));
					return new Double(Math.sqrt(Math.pow(v, 2) + Math.pow(((Number) z).doubleValue(), 2)));
				}
			}, weight, -1, new StInterval(0, image.width() - 1), new StInterval(1, image.height()), new StInterval(-1, 1), new StBlockClosure() {
				public Object value_(Object anObject) {
					Collection polygons = (Collection) anObject;
					if (polygons.size() != last._intValue()) {
						block.value_value_(polygons, offset);
					}
					return null;
				}
			});
			offset.value_(offset._intValue() + image.width());
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) throws Exception {
		new JunBorderGeneratorTestExamples();
	}

}
