package jp.co.sra.jun.csg.compound;

import jp.co.sra.jun.csg.abstracts.JunBinaryCSG;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.solid.abstracts.JunSolidModel;

/**
 * JunCSGDifference class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCSGDifference.java,v 8.10 2008/02/20 06:30:54 nisinaka Exp $
 */
public class JunCSGDifference extends JunBinaryCSG {

	/**
	 * Create a new instance of JunCSGDifference.
	 * 
	 * @param aSolid1 jp.co.sra.jun.solid.abstracts.JunSolid
	 * @param aSolid2 jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunCSGDifference(JunSolidModel aSolid1, JunSolidModel aSolid2) {
		super(aSolid1, aSolid2);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return Math.min(solid1.valueAt_(aJun3dPoint), solid2.valueAt_(aJun3dPoint) * -1);
	}
}
