package jp.co.sra.jun.csg.abstracts;

import jp.co.sra.jun.solid.abstracts.JunSolidModel;

/**
 * JunBinaryCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBinaryCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public abstract class JunBinaryCSG extends JunCSG {
	protected JunSolidModel solid1;
	protected JunSolidModel solid2;

	/**
	 * Create a new instance of JunBinaryCSG.
	 * 
	 * @param aSolid1 jp.co.sra.jun.solid.abstracts.JunSolid
	 * @param aSolid2 jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunBinaryCSG(JunSolidModel aSolid1, JunSolidModel aSolid2) {
		this.solid1_(aSolid1);
		this.solid2_(aSolid2);
	}

	/**
	 * A default constructor.
	 */
	protected JunBinaryCSG() {
	}

	/**
	 * Answer the solid1.
	 * 
	 * @return jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunSolidModel solid1() {
		return solid1;
	}

	/**
	 * Set the solid1.
	 * 
	 * @param aSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public void solid1_(JunSolidModel aSolid) {
		solid1 = aSolid;
	}

	/**
	 * Answer the solid2.
	 * 
	 * @return jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunSolidModel solid2() {
		return solid2;
	}

	/**
	 * Set the solid2.
	 * 
	 * @param aSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public void solid2_(JunSolidModel aSolid) {
		solid2 = aSolid;
	}
}
