package jp.co.sra.jun.collections.linkedlist;

import java.io.*;
import jp.co.sra.smalltalk.StObject;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunSingleLink class
 * 
 *  @author    nisinaka
 *  @created   1998/11/09 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSingleLink.java,v 8.11 2008/02/20 06:30:52 nisinaka Exp $
 */
public class JunSingleLink extends JunAbstractObject {
	/** The entity object. */
	protected Object entityObject = null;

	/** The link to the next entity. */
	protected JunSingleLink nextLink = null;

	/**
	 * Create a new instance of JunSingleLink and initialize it with the
	 * Object.
	 * 
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.jun.collections.linkedlist.JunSingleLink
	 */
	public static JunSingleLink Entity_(Object anObject) {
		JunSingleLink newLink = new JunSingleLink();
		newLink.entityObject = anObject;
		newLink.nextLink = null;

		return newLink;
	}

	/**
	 * Create a new instance of JunSingleLink and initialize it with the Object
	 * and the Link.
	 * 
	 * @param anObject java.lang.Object
	 * @param aLink jp.co.sra.jun.collections.linkedlist.JunSingleLink
	 * 
	 * @return jp.co.sra.jun.collections.linkedlist.JunSingleLink
	 */
	public static JunSingleLink Entity_next_(Object anObject, JunSingleLink aLink) {
		JunSingleLink newLink = new JunSingleLink();
		newLink.entityObject = anObject;
		newLink.nextLink = aLink;

		return newLink;
	}

	/**
	 * Answer the entity object.
	 * 
	 * @return java.lang.Object
	 */
	public Object entityObject() {
		return entityObject;
	}

	/**
	 * Set the entity object.
	 * 
	 * @param anObject java.lang.Object
	 */
	public void entityObject_(Object anObject) {
		entityObject = anObject;
	}

	/**
	 * Answer the next link.
	 * 
	 * @return jp.co.sra.jun.collections.linkedlist.JunSingleLink
	 */
	public JunSingleLink nextLink() {
		return nextLink;
	}

	/**
	 * Set the next link.
	 * 
	 * @param aLink jp.co.sra.jun.collections.linkedlist.JunSingleLink
	 */
	public void nextLink_(JunSingleLink aLink) {
		nextLink = aLink;
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		if (entityObject instanceof StObject) {
			((StObject) entityObject).printOn_(aWriter);
		} else {
			aWriter.write(entityObject.toString());
		}

		if (nextLink != null) {
			aWriter.write(" ");
			nextLink.printOn_(aWriter);
		}
	}
}
