package jp.co.sra.jun.breps.basic;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.solid.abstracts.JunSolidModel;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunBreps class
 * 
 *  @author    nisinaka
 *  @created   1998/10/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBreps.java,v 8.11 2008/02/20 06:30:52 nisinaka Exp $
 */
public class JunBreps extends JunSolidModel {
	protected JunBody body;

	/**
	 * Create a new instance of <code>JunBreps</code> and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @category Instance creation
	 */
	public JunBreps(JunBody aJunBody) {
		super();
		this.setBody_(aJunBody);
	}

	/**
	 * Create a new instance of JunBreps.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @return jp.co.sra.jun.breps.basic.JunBreps
	 * @category Instance creation
	 */
	public static JunBreps On_(JunBody aJunBody) {
		return new JunBreps(aJunBody);
	}

	/**
	 * Convert to JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return body.asJunOpenGL3dObject();
	}

	/**
	 * Answer the body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @category accessing
	 */
	public JunBody body() {
		return body;
	}

	/**
	 * Answer true if the receiver contains the specified point, otherwise
	 * false.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return boolean
	 * @see jp.co.sra.jun.solid.abstracts.JunSolidModel#containsPoint_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category testing
	 */
	public boolean containsPoint_(Jun3dPoint aJun3dPoint) {
		return body.containsPoint_(aJun3dPoint);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return double
	 * @see jp.co.sra.jun.solid.abstracts.JunSolidModel#valueAt_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		if (this.containsPoint_(aJun3dPoint)) {
			return 1;
		} else {
			return -1;
		}
	}

	/**
	 * Set the body.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @category private
	 */
	protected void setBody_(JunBody aJunBody) {
		body = aJunBody;
	}
}
