package jp.co.sra.gl4jun.test;

import java.awt.*;
import jp.co.sra.gl4jun.*;

/**
 * GLjImageTest class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/08/19 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: GLjImageTest.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class GLjImageTest extends Canvas {

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		Frame frame = new Frame();
		MenuBar menuBar = new MenuBar();
		frame.setMenuBar(menuBar);

		Menu fileMenu = new Menu("File");
		menuBar.add(fileMenu);
		fileMenu.add(new MenuItem("Exit"));

		GLjImageTest canvas = new GLjImageTest();
		canvas.setSize(256, 256);
		frame.add("Center", canvas);
		frame.add("East", new Button("East"));
		frame.add("West", new Button("West"));
		frame.pack();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param gc java.awt.Graphics
	 */
	public synchronized void paint(Graphics gc) {
		Dimension size = this.getSize();
		GLjImageSource imageSource = new GLjImageSource(size.width, size.height);
		GLjRenderingContext rc = new GLjRenderingContext(imageSource);
		synchronized (rc.OpenGLInterface()) {
			rc.gljInitialize();
			rc.gljCurrent();

			//
			GLjInterface gl = rc.OpenGLInterface();
			gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
			gl.glClear(gl.GL_COLOR_BUFFER_BIT);
			gl.glColor3f(1.0f, 0.0f, 0.0f);
			gl.glPolygonMode(gl.GL_FRONT, gl.GL_LINE);
			gl.glPolygonMode(gl.GL_BACK, gl.GL_FILL);
			gl.glFrontFace(gl.GL_CW);
			gl.glBegin(gl.GL_POLYGON);
			gl.glVertex2f(-0.5f, 0.5f);
			gl.glVertex2f(-0.5f, -0.5f);
			gl.glVertex2f(0.5f, -0.5f);
			gl.glVertex2f(0.5f, 0.5f);
			gl.glEnd();

			//
			rc.gljFlush();
			rc.gljRelease();
		}

		gc.drawImage(imageSource.getImage(), 0, 0, null);
	}
}
