/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessor;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

public class JunVoronoi2dProcessorTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.0, 0.0), new Jun2dPoint(0.1, 1.0), new Jun2dPoint(1.0, 0.1), new Jun2dPoint(1.0, 1.0)};
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        return true;
    }

    public static boolean Example2() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(-1.0709950047146, -1.0), new Jun2dPoint(-1.3616787517522, -0.55623057513983), new Jun2dPoint(-1.4749357023933, 1.1021456892432E-16), new Jun2dPoint(-1.3616787517522, 0.55623057513983), new Jun2dPoint(-1.0329942792654, 1.0580134260987), new Jun2dPoint(-0.83909963117728, 1.2088366880644), new Jun2dPoint(-0.3639702342662, 1.4500662049207), new Jun2dPoint(-0.3290104887271, 1.456230551298), new Jun2dPoint(0.0, 1.4857898683076), new Jun2dPoint(0.3290104887271, 1.456230551298), new Jun2dPoint(0.3639702342662, 1.4500662049207), new Jun2dPoint(0.83909963117728, 1.2088366880644), new Jun2dPoint(1.0, 1.0836784193003), new Jun2dPoint(1.0, 3.0), new Jun2dPoint(-3.0, 3.0), new Jun2dPoint(-3.0, -1.0)};
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles(junVoronoi2dProcessor, new Jun2dPoint(50.0, 50.0), new Jun2dPoint(200.0, 100.0), StRectangle.Origin_extent_((Point)new Point(-3, -1), (Point)new Point(4, 4)));
        return true;
    }

    public static boolean Example3() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[50];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = new Jun2dPoint(Math.random(), Math.random());
        }
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles(junVoronoi2dProcessor, new Jun2dPoint(200.0, 200.0), new Jun2dPoint(50.0, 50.0), StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(1, 1)));
        return true;
    }

    public static boolean Example4() {
        JunAbstractObject junAbstractObject;
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        arrayList.add(new Jun2dPoint(0.0, 0.0));
        for (int i = 0; i <= 360; i += 10) {
            junAbstractObject = JunAngle.FromDeg_(i);
            arrayList.add(new Jun2dPoint(((JunAngle)junAbstractObject).cos(), ((JunAngle)junAbstractObject).sin()));
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        junAbstractObject = new JunVoronoi2dProcessor(jun2dPointArray);
        ((JunVoronoi2dProcessor)junAbstractObject).trace_(true);
        ((JunVoronoi2dProcessor)junAbstractObject).compute();
        System.out.println("area: " + ((JunVoronoi2dProcessor)junAbstractObject).area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles((JunVoronoi2dProcessor)junAbstractObject, new Jun2dPoint(100.0, 100.0), new Jun2dPoint(150.0, 150.0), StRectangle.Origin_corner_((Point)new Point(-1, -1), (Point)new Point(1, 1)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example5() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.20254893600941, 0.30189919471741), new Jun2dPoint(0.90037482976913, 0.97756767272949), new Jun2dPoint(0.37021240592003, 0.7721865773201), new Jun2dPoint(0.73451060056686, 0.66534775495529), new Jun2dPoint(0.83000415563583, 0.35092878341675), new Jun2dPoint(0.20771345496178, 0.23709288239479), new Jun2dPoint(0.13294461369514, 0.44628903269768), new Jun2dPoint(0.585289478302, 0.81525200605392), new Jun2dPoint(0.25862556695938, 0.89500206708908), new Jun2dPoint(0.56111621856689, 0.95084547996521), new Jun2dPoint(0.61521035432816, 0.96237403154373), new Jun2dPoint(0.25764265656471, 0.62346524000168), new Jun2dPoint(0.039433568716049, 0.34228238463402), new Jun2dPoint(0.22588920593262, 0.24127447605133), new Jun2dPoint(0.79660141468048, 0.157176181674), new Jun2dPoint(0.445447742939, 0.64100790023804), new Jun2dPoint(0.58059144020081, 0.95807582139969), new Jun2dPoint(0.32448145747185, 0.087971679866314), new Jun2dPoint(0.51385253667831, 0.72457307577133), new Jun2dPoint(0.69972509145737, 0.27604332566261), new Jun2dPoint(0.14740525186062, 0.86483132839203), new Jun2dPoint(0.83648478984833, 0.32767179608345), new Jun2dPoint(0.46084132790565, 0.21558517217636), new Jun2dPoint(0.42863807082176, 0.79387754201889), new Jun2dPoint(0.86232405900955, 0.042140774428844), new Jun2dPoint(0.59863388538361, 0.654252409935), new Jun2dPoint(0.18858808279037, 0.038375675678253), new Jun2dPoint(0.89749270677567, 0.31695958971977), new Jun2dPoint(0.70493960380554, 0.32673886418343), new Jun2dPoint(0.30480632185936, 0.61873388290405), new Jun2dPoint(0.10525614023209, 0.45825073122978), new Jun2dPoint(0.22873802483082, 0.82488131523132), new Jun2dPoint(0.51198667287827, 0.41250312328339), new Jun2dPoint(0.50602251291275, 0.62927949428558), new Jun2dPoint(0.47615161538124, 0.59765928983688), new Jun2dPoint(0.40196585655212, 0.15437734127045), new Jun2dPoint(0.97734278440475, 0.85045397281647), new Jun2dPoint(0.61044561862946, 0.95119535923004), new Jun2dPoint(0.42372345924377, 0.43619325757027), new Jun2dPoint(0.25391086935997, 0.99932527542114), new Jun2dPoint(0.65202832221985, 0.048754684627056), new Jun2dPoint(0.88338190317154, 0.70693045854568), new Jun2dPoint(0.92756348848343, 0.81058722734451), new Jun2dPoint(0.47845065593719, 0.91074550151825), new Jun2dPoint(0.94420659542084, 0.27271136641502), new Jun2dPoint(0.44728028774261, 0.87607663869858), new Jun2dPoint(0.82440650463104, 0.41471886634827), new Jun2dPoint(0.62660557031631, 0.29680132865906), new Jun2dPoint(0.11918367445469, 0.64477300643921), new Jun2dPoint(0.28173261880875, 0.29536858201027), new Jun2dPoint(0.808129966259, 0.7996084690094), new Jun2dPoint(0.10653894394636, 0.4227988421917), new Jun2dPoint(0.29940858483315, 0.1445314437151), new Jun2dPoint(0.22347354888916, 0.65868389606476), new Jun2dPoint(0.42975425720215, 0.37341940402985), new Jun2dPoint(0.18355685472488, 0.4111869931221), new Jun2dPoint(0.46447312831879, 0.60872137546539), new Jun2dPoint(0.96638065576553, 0.51704287528992), new Jun2dPoint(0.097442731261253, 0.40145772695541), new Jun2dPoint(0.9801082611084, 0.24155768752098), new Jun2dPoint(0.45111203193665, 0.73122030496597), new Jun2dPoint(0.06147438660264, 0.27860891819), new Jun2dPoint(0.076501458883286, 0.0061724283732474), new Jun2dPoint(0.47578507661819, 0.75064557790756), new Jun2dPoint(0.95320284366608, 0.063048727810383), new Jun2dPoint(0.91691797971725, 0.2086880505085), new Jun2dPoint(0.48937943577766, 0.16715535521507), new Jun2dPoint(0.5073219537735, 0.6323282122612), new Jun2dPoint(0.52176594734192, 0.012369845993817), new Jun2dPoint(0.79801750183105, 0.42972928285599), new Jun2dPoint(0.31566846370697, 0.7211412191391), new Jun2dPoint(0.76859641075134, 0.43762597441673), new Jun2dPoint(0.56496459245682, 0.84448981285095), new Jun2dPoint(0.82722198963165, 0.92132443189621), new Jun2dPoint(0.3921032845974, 0.36200749874115), new Jun2dPoint(0.81062889099121, 0.57470220327377), new Jun2dPoint(0.34810495376587, 0.68185758590698), new Jun2dPoint(0.98412328958511, 0.52020823955536), new Jun2dPoint(0.4125614464283, 0.64077466726303), new Jun2dPoint(0.041582673788071, 0.30886298418045), new Jun2dPoint(0.99363601207733, 0.50406497716904), new Jun2dPoint(0.10545606166124, 0.92025822401047), new Jun2dPoint(0.92806333303452, 0.96560597419739), new Jun2dPoint(0.72676384449005, 0.7625572681427), new Jun2dPoint(0.4811495244503, 0.14784672856331), new Jun2dPoint(0.88509786128998, 0.67249476909637), new Jun2dPoint(0.34677216410637, 0.60180759429932), new Jun2dPoint(0.98862141370773, 0.91537690162659), new Jun2dPoint(0.64738023281097, 0.30708038806915), new Jun2dPoint(0.87406915426254, 0.18508121371269), new Jun2dPoint(0.9339941740036, 0.67182838916779), new Jun2dPoint(0.80674719810486, 0.60405665636063), new Jun2dPoint(0.18620574474335, 0.53278630971909), new Jun2dPoint(0.48053312301636, 0.72332364320755), new Jun2dPoint(0.8121782541275, 0.15526030957699), new Jun2dPoint(0.017875885590911, 0.52247399091721), new Jun2dPoint(0.64864641427994, 0.23312786221504), new Jun2dPoint(0.96979594230652, 0.40967097878456), new Jun2dPoint(0.96091628074646, 0.88883799314499), new Jun2dPoint(0.31588503718376, 0.22164931893349), new Jun2dPoint(0.44286546111107, 0.67341107130051), new Jun2dPoint(0.46430653333664, 0.22371511161327), new Jun2dPoint(0.21694293618202, 0.56643897294998), new Jun2dPoint(0.25179508328438, 0.10974594205618), new Jun2dPoint(0.83416908979416, 0.97608494758606), new Jun2dPoint(0.94365680217743, 0.0021907538175583), new Jun2dPoint(0.27413576841354, 0.73908370733261), new Jun2dPoint(0.23376926779747, 0.45206996798515), new Jun2dPoint(0.94500625133514, 0.12074135988951), new Jun2dPoint(0.24458143115044, 0.43897542357445), new Jun2dPoint(0.68351519107819, 0.81493544578552), new Jun2dPoint(0.52711367607117, 0.37107038497925), new Jun2dPoint(0.75496876239777, 0.94411492347717), new Jun2dPoint(0.060957934707403, 0.085089549422264), new Jun2dPoint(0.85324448347092, 0.059300292283297), new Jun2dPoint(0.25427737832069, 0.84633904695511), new Jun2dPoint(0.1007913351059, 0.14008329808712), new Jun2dPoint(0.94380676746368, 0.34869638085365), new Jun2dPoint(0.048629738390446, 0.5946272611618), new Jun2dPoint(0.39485213160515, 0.71461057662964), new Jun2dPoint(0.67635154724121, 0.25966680049896), new Jun2dPoint(0.30129113793373, 0.49510204792023), new Jun2dPoint(0.39211994409561, 0.40050813555717), new Jun2dPoint(0.78557270765305, 0.66976261138916), new Jun2dPoint(0.032669719308615, 0.71102875471115), new Jun2dPoint(0.39871719479561, 0.64675551652908), new Jun2dPoint(0.8633069396019, 0.31367763876915), new Jun2dPoint(0.12031653523445, 0.26281550526619), new Jun2dPoint(0.57790923118591, 0.75947523117065), new Jun2dPoint(0.3585339486599, 0.78324866294861), new Jun2dPoint(0.29892545938492, 0.02801332809031), new Jun2dPoint(0.95010411739349, 0.90193253755569), new Jun2dPoint(0.5773760676384, 0.52745521068573), new Jun2dPoint(0.16033320128918, 0.74131613969803), new Jun2dPoint(0.39285299181938, 0.094535611569881), new Jun2dPoint(0.68309873342514, 0.85241985321045), new Jun2dPoint(0.15351936221123, 0.99456059932709), new Jun2dPoint(0.64084964990616, 0.21483547985554), new Jun2dPoint(0.69610995054245, 0.92140775918961), new Jun2dPoint(0.58460640907288, 0.23672635853291), new Jun2dPoint(0.2859308719635, 0.99752604961395), new Jun2dPoint(0.49396085739136, 0.75482714176178), new Jun2dPoint(0.61685961484909, 0.77393585443497), new Jun2dPoint(0.77707624435425, 0.034443981945515), new Jun2dPoint(0.81134527921677, 0.2302290648222), new Jun2dPoint(0.27068722248077, 0.76945441961288), new Jun2dPoint(0.4204081594944, 0.77456891536713), new Jun2dPoint(0.24009995162487, 0.082307368516922), new Jun2dPoint(0.4236401617527, 0.24369013309479), new Jun2dPoint(0.37919199466705, 0.52402329444885), new Jun2dPoint(0.22920449078083, 0.90289878845215), new Jun2dPoint(0.81041234731674, 0.074194088578224), new Jun2dPoint(0.67383587360382, 0.44607245922089), new Jun2dPoint(0.084781341254711, 0.14098292589188), new Jun2dPoint(0.022840483114123, 0.99566012620926), new Jun2dPoint(0.18189087510109, 0.56112450361252), new Jun2dPoint(0.97009581327438, 0.10268221795559), new Jun2dPoint(0.5099042057991, 0.59992504119873), new Jun2dPoint(0.63805079460144, 0.74673050642014), new Jun2dPoint(0.90555602312088, 0.9512619972229), new Jun2dPoint(0.57772594690323, 0.33596834540367), new Jun2dPoint(0.63415241241455, 0.73758435249329), new Jun2dPoint(0.76871305704117, 0.70713037252426), new Jun2dPoint(0.38957101106644, 0.50991255044937), new Jun2dPoint(0.61917531490326, 0.12552270293236), new Jun2dPoint(0.29426071047783, 0.2478384077549), new Jun2dPoint(0.96584755182266, 0.28502291440964), new Jun2dPoint(0.89924198389053, 0.35952520370483), new Jun2dPoint(0.074035815894604, 0.30807995796204), new Jun2dPoint(0.18410661816597, 0.68170762062073), new Jun2dPoint(0.63761764764786, 0.74571430683136), new Jun2dPoint(0.55701792240143, 0.47969180345535), new Jun2dPoint(0.77904206514359, 0.57751768827438), new Jun2dPoint(0.85471051931381, 0.44735527038574), new Jun2dPoint(0.049329444766045, 0.21165347099304), new Jun2dPoint(0.34249064326286, 0.70714700222015), new Jun2dPoint(0.42807164788246, 0.48485630750656), new Jun2dPoint(0.71423572301865, 0.81008744239807), new Jun2dPoint(0.32343190908432, 0.66243231296539), new Jun2dPoint(0.092394836246967, 0.73576843738556), new Jun2dPoint(0.57214492559433, 0.43825906515121), new Jun2dPoint(0.027988338842988, 0.89235317707062), new Jun2dPoint(0.43951687216759, 0.93478548526764), new Jun2dPoint(0.500608086586, 0.11657642573118), new Jun2dPoint(0.6194252371788, 0.7030320763588), new Jun2dPoint(0.91841733455658, 0.6737442612648), new Jun2dPoint(0.23431903123856, 0.72259056568146), new Jun2dPoint(0.11815077066422, 0.25773426890373), new Jun2dPoint(0.83521866798401, 0.40162432193756), new Jun2dPoint(0.36511453986168, 0.99099540710449), new Jun2dPoint(0.4017159640789, 0.57686799764633), new Jun2dPoint(0.353186160326, 0.42454811930656), new Jun2dPoint(0.34197416901588, 0.51362764835358), new Jun2dPoint(0.20481465756893, 0.53798419237137), new Jun2dPoint(0.49272802472115, 0.90578091144562), new Jun2dPoint(0.47102040052414, 0.73946690559387), new Jun2dPoint(0.11928363144398, 0.87577676773071), new Jun2dPoint(0.13139525055885, 0.86573094129562), new Jun2dPoint(0.91551852226257, 0.97463554143906), new Jun2dPoint(0.59410244226456, 0.18208245933056), new Jun2dPoint(0.0038817159365863, 0.18194918334484), new Jun2dPoint(0.69587671756744, 0.38239899277687), new Jun2dPoint(0.93539357185364, 0.90588086843491), new Jun2dPoint(0.70202416181564, 0.58912950754166), new Jun2dPoint(0.68964600563049, 0.98316532373428), new Jun2dPoint(0.30642232298851, 0.35329446196556), new Jun2dPoint(0.67480218410492, 0.67910867929459), new Jun2dPoint(0.63152021169662, 0.65448564291), new Jun2dPoint(0.72759681940079, 0.68758851289749), new Jun2dPoint(0.22833819687366, 0.90086632966995), new Jun2dPoint(0.11333610862494, 0.13105373084545), new Jun2dPoint(0.076468139886856, 0.92917120456696), new Jun2dPoint(0.52589756250381, 0.56052476167679), new Jun2dPoint(0.58407330513, 0.0047063725069165), new Jun2dPoint(0.08773010969162, 0.95559352636337), new Jun2dPoint(0.5878883600235, 0.82134944200516), new Jun2dPoint(0.34985423088074, 0.72442317008972), new Jun2dPoint(0.35321947932243, 0.50154936313629), new Jun2dPoint(0.29186171293259, 0.70374846458435), new Jun2dPoint(0.57394421100616, 0.59632652997971), new Jun2dPoint(0.32191586494446, 0.15887546539307), new Jun2dPoint(0.37251144647598, 0.085272803902626), new Jun2dPoint(0.27675133943558, 0.78368180990219), new Jun2dPoint(0.29994168877602, 0.37655144929886), new Jun2dPoint(0.42167431116104, 0.70061641931534), new Jun2dPoint(0.33582672476768, 0.30689713358879), new Jun2dPoint(0.45056226849556, 0.46069970726967), new Jun2dPoint(0.88832986354828, 0.14161598682404), new Jun2dPoint(0.48586422204971, 0.043523531407118), new Jun2dPoint(0.79418575763702, 0.57458561658859), new Jun2dPoint(0.078600585460663, 0.85725116729736), new Jun2dPoint(0.31870055198669, 0.72825491428375), new Jun2dPoint(0.20836317539215, 0.7386172413826), new Jun2dPoint(0.15575176477432, 0.15364430844784), new Jun2dPoint(0.28331527113914, 0.95292794704437), new Jun2dPoint(0.42778840661049, 0.8303456902504), new Jun2dPoint(0.14019158482552, 0.19406080245972), new Jun2dPoint(0.68583089113235, 0.16652227938175), new Jun2dPoint(0.044298209249973, 0.58446478843689), new Jun2dPoint(0.90947103500366, 0.9989088177681), new Jun2dPoint(0.68951272964478, 0.67516034841537), new Jun2dPoint(0.50687211751938, 0.59281134605408), new Jun2dPoint(0.19828404486179, 0.44573926925659), new Jun2dPoint(0.31476885080338, 0.64210742712021), new Jun2dPoint(0.12163265049458, 0.30436486005783), new Jun2dPoint(0.59846729040146, 0.26924616098404), new Jun2dPoint(0.43915036320686, 0.087771758437157), new Jun2dPoint(0.051845066249371, 0.025247814133763), new Jun2dPoint(0.5590004324913, 0.061266139149666), new Jun2dPoint(0.79735112190247, 0.88970428705215), new Jun2dPoint(0.31791752576828, 0.91872555017471), new Jun2dPoint(0.38600581884384, 0.27077883481979), new Jun2dPoint(0.98120784759521, 0.78259891271591), new Jun2dPoint(0.79740107059479, 0.0052061639726162), new Jun2dPoint(0.24274885654449, 0.20390670001507), new Jun2dPoint(0.43970012664795, 0.35829237103462), new Jun2dPoint(0.22498959302902, 0.16224072873592), new Jun2dPoint(0.14963765442371, 0.023915035650134), new Jun2dPoint(0.47895044088364, 0.065764263272285), new Jun2dPoint(0.19251978397369, 0.12452311813831), new Jun2dPoint(0.9842232465744, 0.75121200084686), new Jun2dPoint(0.26222407817841, 0.21113702654839), new Jun2dPoint(0.14897125959396, 0.48389005661011), new Jun2dPoint(0.48119950294495, 0.26334860920906), new Jun2dPoint(0.80992919206619, 0.95767599344254), new Jun2dPoint(0.40046647191048, 0.68932110071182), new Jun2dPoint(0.23240315914154, 0.29501873254776), new Jun2dPoint(0.99961680173874, 0.32578924298286), new Jun2dPoint(0.11027072370052, 0.04693877696991), new Jun2dPoint(0.68681383132935, 0.43805915117264), new Jun2dPoint(0.56598085165024, 0.19302789866924), new Jun2dPoint(0.2987921833992, 0.72000831365585), new Jun2dPoint(0.15055394172668, 0.14144939184189), new Jun2dPoint(0.10085797309875, 0.29408580064774), new Jun2dPoint(0.84358185529709, 0.72893792390823), new Jun2dPoint(0.78688877820969, 0.71131193637848), new Jun2dPoint(0.053227823227644, 0.22079966962337), new Jun2dPoint(0.47933360934258, 0.95127862691879), new Jun2dPoint(0.61622655391693, 0.31091213226318), new Jun2dPoint(0.72921282052994, 0.422149091959), new Jun2dPoint(0.79788422584534, 0.12172428518534), new Jun2dPoint(0.51611828804016, 0.96065807342529), new Jun2dPoint(0.29207828640938, 0.20425656437874), new Jun2dPoint(0.24821324646473, 0.83211159706116), new Jun2dPoint(0.22125780582428, 0.53810077905655), new Jun2dPoint(0.76223242282867, 0.73038733005524), new Jun2dPoint(0.13644315302372, 0.53142023086548), new Jun2dPoint(0.32348188757896, 0.77793419361114), new Jun2dPoint(0.017226155847311, 0.02094960398972), new Jun2dPoint(0.62583923339844, 0.52577257156372), new Jun2dPoint(0.27177008986473, 0.27199500799179), new Jun2dPoint(0.79175341129303, 0.95349436998367), new Jun2dPoint(0.73680967092514, 0.97843396663666), new Jun2dPoint(0.37224489450455, 0.46926280856133), new Jun2dPoint(0.67765098810196, 0.2627155482769), new Jun2dPoint(0.34690546989441, 0.90981256961823), new Jun2dPoint(0.78817158937454, 0.67586004734039), new Jun2dPoint(0.1238983720541, 0.54044979810715), new Jun2dPoint(0.19082048535347, 0.197459384799), new Jun2dPoint(0.53995835781097, 0.055052060633898), new Jun2dPoint(0.4366180896759, 0.23567679524422), new Jun2dPoint(0.860391497612, 0.57606828212738), new Jun2dPoint(0.50515615940094, 0.62724697589874), new Jun2dPoint(0.77907538414001, 0.65451896190643), new Jun2dPoint(0.80459809303284, 0.63747602701187), new Jun2dPoint(0.41845896840096, 0.2699958384037), new Jun2dPoint(0.17167846858501, 0.9602415561676), new Jun2dPoint(0.3295626938343, 0.8306622505188), new Jun2dPoint(0.87170344591141, 0.71799248456955), new Jun2dPoint(0.49197834730148, 0.17325280606747), new Jun2dPoint(0.59855061769485, 0.46174928545952), new Jun2dPoint(0.31386920809746, 0.56307369470596), new Jun2dPoint(0.47466889023781, 0.17110370099545), new Jun2dPoint(0.6319699883461, 0.69400250911713), new Jun2dPoint(0.051078718155622, 0.2542190849781), new Jun2dPoint(0.71158683300018, 0.68848812580109), new Jun2dPoint(0.30737191438675, 0.54783004522324), new Jun2dPoint(0.24659724533558, 0.097551017999649), new Jun2dPoint(0.65171176195145, 0.31724280118942), new Jun2dPoint(0.35945022106171, 0.90078300237656), new Jun2dPoint(0.92083299160004, 0.2563348710537), new Jun2dPoint(0.60116618871689, 0.50634735822678), new Jun2dPoint(0.38004165887833, 0.48755517601967), new Jun2dPoint(0.95133692026138, 0.75097876787186), new Jun2dPoint(0.72321534156799, 0.56192421913147), new Jun2dPoint(0.81812578439713, 0.89998334646225), new Jun2dPoint(0.072802998125553, 0.45903372764587), new Jun2dPoint(0.038267388939857, 0.64723867177963), new Jun2dPoint(0.97982507944107, 0.58704704046249), new Jun2dPoint(0.87706786394119, 0.1151936724782), new Jun2dPoint(0.42387339472771, 0.7826988697052), new Jun2dPoint(0.028404831886292, 0.85486882925034), new Jun2dPoint(0.81311118602753, 0.31129530072212), new Jun2dPoint(0.61472719907761, 0.84585589170456), new Jun2dPoint(0.98427319526672, 0.86671388149261), new Jun2dPoint(0.18705539405346, 0.4963181912899), new Jun2dPoint(0.20266555249691, 0.57140356302261), new Jun2dPoint(0.72498124837875, 0.64299041032791), new Jun2dPoint(0.16216576099396, 0.97638481855392), new Jun2dPoint(0.6366680264473, 0.55117869377136), new Jun2dPoint(0.98522281646729, 0.061249479651451), new Jun2dPoint(0.75885045528412, 0.91476052999496), new Jun2dPoint(0.22285714745522, 0.23416076600552), new Jun2dPoint(0.35683465003967, 0.85618489980698), new Jun2dPoint(0.85466057062149, 0.33185338973999), new Jun2dPoint(0.12449812889099, 0.92647230625153), new Jun2dPoint(0.28879633545876, 0.61963349580765), new Jun2dPoint(0.18428987264633, 0.10521449148655), new Jun2dPoint(0.36199915409088, 0.79137861728668), new Jun2dPoint(0.087230317294598, 0.8005747795105), new Jun2dPoint(0.33957517147064, 0.96953767538071), new Jun2dPoint(0.81291127204895, 0.84928780794144), new Jun2dPoint(0.91540193557739, 0.70513117313385), new Jun2dPoint(0.76949602365494, 0.5166597366333), new Jun2dPoint(0.21192836761475, 0.97775095701218), new Jun2dPoint(0.79371929168701, 0.49656808376312), new Jun2dPoint(0.78017491102219, 0.19556018710136), new Jun2dPoint(0.15088713169098, 0.9114618897438), new Jun2dPoint(0.59973347187042, 0.19529362022877), new Jun2dPoint(0.53487712144852, 0.31236150860786), new Jun2dPoint(0.07876718044281, 0.242257386446), new Jun2dPoint(0.068138279020786, 0.67885881662369), new Jun2dPoint(0.054010827094316, 0.030329030007124), new Jun2dPoint(0.30169096589088, 0.4191170334816), new Jun2dPoint(0.79077053070068, 0.68195754289627), new Jun2dPoint(0.21512703597546, 0.36987090110779), new Jun2dPoint(0.98292380571365, 0.74816328287125), new Jun2dPoint(0.21660974621773, 0.79642647504807), new Jun2dPoint(0.75291961431503, 0.20853811502457), new Jun2dPoint(0.14287380874157, 0.39266139268875), new Jun2dPoint(0.65177839994431, 0.4712453186512), new Jun2dPoint(0.25922530889511, 0.28102457523346), new Jun2dPoint(0.65909206867218, 0.37301957607269), new Jun2dPoint(0.25954186916351, 0.012536442838609), new Jun2dPoint(0.18302373588085, 0.17916701734066), new Jun2dPoint(0.26627239584923, 0.56678885221481), new Jun2dPoint(0.060308203101158, 0.58356517553329), new Jun2dPoint(0.83043730258942, 0.35194501280785), new Jun2dPoint(0.55625158548355, 0.70866304636002), new Jun2dPoint(0.93162846565247, 0.20473968982697), new Jun2dPoint(0.36473137140274, 0.10548105090857), new Jun2dPoint(0.97800916433334, 0.3904789686203), new Jun2dPoint(0.60819655656815, 0.75361096858978), new Jun2dPoint(0.80631405115128, 0.60304039716721), new Jun2dPoint(0.8376676440239, 0.061216160655022), new Jun2dPoint(0.68184924125671, 0.96487295627594), new Jun2dPoint(0.032736361026764, 0.86503124237061), new Jun2dPoint(0.29849228262901, 0.026997083798051), new Jun2dPoint(0.60156601667404, 0.43036234378815), new Jun2dPoint(0.77869218587875, 0.76900458335876), new Jun2dPoint(0.38089129328728, 0.45108705759048), new Jun2dPoint(0.6734693646431, 0.59905874729156), new Jun2dPoint(0.63601833581924, 0.049654312431812), new Jun2dPoint(0.96241563558578, 0.35389420390129), new Jun2dPoint(0.060824654996395, 0.77708452939987), new Jun2dPoint(0.053694292902946, 0.29881715774536), new Jun2dPoint(0.77775925397873, 0.61296957731247), new Jun2dPoint(0.78403997421265, 0.12770512700081), new Jun2dPoint(0.33784255385399, 0.96547269821167), new Jun2dPoint(0.41875883936882, 0.96300709247589), new Jun2dPoint(0.72066640853882, 0.67132860422134), new Jun2dPoint(0.65172845125198, 0.35574343800545), new Jun2dPoint(0.33439400792122, 0.99584341049194), new Jun2dPoint(0.60539776086807, 0.28550603985786), new Jun2dPoint(0.015760099515319, 0.6328946352005), new Jun2dPoint(0.83078718185425, 0.16045814752579), new Jun2dPoint(0.030070804059505, 0.70493125915527), new Jun2dPoint(0.30748856067657, 0.81733447313309), new Jun2dPoint(0.071203663945198, 0.76297378540039), new Jun2dPoint(0.4436651468277, 0.52144104242325), new Jun2dPoint(0.26160767674446, 0.78661388158798), new Jun2dPoint(0.076051644980907, 0.96665555238724), new Jun2dPoint(0.15230320394039, 0.18401499092579), new Jun2dPoint(0.4699541926384, 0.27542689442635), new Jun2dPoint(0.7228821516037, 0.79191172122955), new Jun2dPoint(0.31925031542778, 0.99877548217773), new Jun2dPoint(0.38150769472122, 0.87561017274857), new Jun2dPoint(0.74638903141022, 0.11629321426153), new Jun2dPoint(0.96491461992264, 0.1289879232645), new Jun2dPoint(0.3023906648159, 0.036143273115158), new Jun2dPoint(0.73840898275375, 0.67449396848679), new Jun2dPoint(0.96684712171555, 0.59506040811539), new Jun2dPoint(0.39586839079857, 0.063148684799671), new Jun2dPoint(0.14792169630527, 0.058350685983896), new Jun2dPoint(0.059741772711277, 0.27454394102097), new Jun2dPoint(0.68234902620316, 0.1198917105794), new Jun2dPoint(0.28104954957962, 0.71684300899506), new Jun2dPoint(0.83543521165848, 0.90213245153427), new Jun2dPoint(0.039383590221405, 0.22678050398827), new Jun2dPoint(0.30105790495872, 0.95609331130981), new Jun2dPoint(0.74290710687637, 0.069662638008595), new Jun2dPoint(0.20166596770287, 0.26136609911919), new Jun2dPoint(0.22835485637188, 0.93936693668365), new Jun2dPoint(0.088279880583286, 0.22611412405968), new Jun2dPoint(0.76103287935257, 0.95834237337112), new Jun2dPoint(0.94049143791199, 0.68707203865051), new Jun2dPoint(0.034818824380636, 0.67760932445526), new Jun2dPoint(0.166463971138, 0.90954601764679), new Jun2dPoint(0.17216159403324, 0.076759681105614), new Jun2dPoint(0.60293209552765, 0.58741354942322), new Jun2dPoint(0.72408163547516, 0.56395667791367), new Jun2dPoint(0.51520198583603, 0.8431236743927), new Jun2dPoint(0.67017078399658, 0.97593504190445), new Jun2dPoint(0.59715116024017, 0.22769679129124), new Jun2dPoint(0.41859224438667, 0.57800084352493), new Jun2dPoint(0.97122865915298, 0.72072470188141), new Jun2dPoint(0.80608081817627, 0.064031653106213), new Jun2dPoint(0.18845480680466, 0.73037070035934), new Jun2dPoint(0.097942523658276, 0.55647647380829), new Jun2dPoint(0.22842149436474, 0.09336943179369), new Jun2dPoint(0.98805499076843, 0.60635566711426), new Jun2dPoint(0.49929195642471, 0.075027070939541), new Jun2dPoint(0.59886711835861, 0.19326114654541), new Jun2dPoint(0.83780092000961, 0.36922115087509), new Jun2dPoint(0.48139941692352, 0.72535610198975), new Jun2dPoint(0.50925445556641, 0.098400667309761), new Jun2dPoint(0.61524367332458, 0.039375260472298), new Jun2dPoint(0.20753020048141, 0.81358599662781), new Jun2dPoint(0.40856310725212, 0.40062475204468), new Jun2dPoint(0.05507704988122, 0.49436900019646), new Jun2dPoint(0.69809246063232, 0.50298207998276), new Jun2dPoint(0.60291546583176, 0.54891294240952), new Jun2dPoint(0.74913787841797, 0.4688962996006), new Jun2dPoint(0.83063721656799, 0.81395250558853), new Jun2dPoint(0.25557684898376, 0.84938776493073), new Jun2dPoint(0.14640566706657, 0.55479383468628), new Jun2dPoint(0.33985838294029, 0.62404829263687), new Jun2dPoint(0.3869554400444, 0.46531444787979), new Jun2dPoint(0.55300289392471, 0.20104123651981), new Jun2dPoint(0.81759268045425, 0.66796332597733), new Jun2dPoint(0.87460225820541, 0.41710120439529), new Jun2dPoint(0.13219492137432, 0.71376091241837), new Jun2dPoint(0.71281963586807, 0.53753435611725), new Jun2dPoint(0.45321115851402, 0.58229905366898), new Jun2dPoint(0.90438985824585, 0.25621825456619), new Jun2dPoint(0.33166182041168, 0.68174093961716), new Jun2dPoint(0.71461892127991, 0.69560182094574), new Jun2dPoint(0.74713867902756, 0.84882134199142), new Jun2dPoint(0.83738440275192, 0.4067055284977), new Jun2dPoint(0.10780508071184, 0.34884631633759), new Jun2dPoint(0.39513537287712, 0.3691211938858), new Jun2dPoint(0.25039565563202, 0.87569344043732), new Jun2dPoint(0.93889212608337, 0.99101209640503), new Jun2dPoint(0.44021657109261, 0.55181175470352), new Jun2dPoint(0.44824656844139, 0.10911286622286), new Jun2dPoint(0.37114536762238, 0.92822158336639), new Jun2dPoint(0.33136191964149, 0.98872971534729), new Jun2dPoint(0.1656309813261, 0.984514772892), new Jun2dPoint(0.42497292160988, 0.32374009490013), new Jun2dPoint(0.37469387054443, 0.12885464727879), new Jun2dPoint(0.99438565969467, 0.23659308254719), new Jun2dPoint(0.97792583703995, 0.19797584414482), new Jun2dPoint(0.73347771167755, 0.27830904722214), new Jun2dPoint(0.3834902048111, 0.45718449354172), new Jun2dPoint(0.76469802856445, 0.42847979068756), new Jun2dPoint(0.42812162637711, 0.60035818815231), new Jun2dPoint(0.63906705379486, 0.09526863694191), new Jun2dPoint(0.37712618708611, 0.74994587898254), new Jun2dPoint(0.33617660403252, 0.11541024595499), new Jun2dPoint(0.92438149452209, 0.45696792006493)};
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        StImage stImage = new StImage(300, 300);
        Graphics graphics = null;
        try {
            graphics = stImage.image().getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, stImage.width(), stImage.height());
            Jun2dPoint jun2dPoint = new Jun2dPoint(200.0, 200.0);
            Jun2dPoint jun2dPoint2 = new Jun2dPoint(50.0, 50.0);
            StRectangle stRectangle = StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(1, 1));
            stRectangle = stRectangle.scaledBy_(jun2dPoint.x(), jun2dPoint.y());
            stRectangle = stRectangle.translatedBy_((int)jun2dPoint2.x(), (int)jun2dPoint2.y());
            graphics.setColor(Color.red);
            graphics.drawRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            Jun2dPoint[][] jun2dPointArray2 = junVoronoi2dProcessor.triangles();
            for (int i = 0; i < jun2dPointArray2.length; ++i) {
                Jun2dPoint[] jun2dPointArray3 = jun2dPointArray2[i];
                jun2dPointArray = new Jun2dPoint[]{jun2dPointArray3[0], jun2dPointArray3[1], jun2dPointArray3[2], jun2dPointArray3[0]};
                int[] nArray = new int[jun2dPointArray.length];
                int[] nArray2 = new int[jun2dPointArray.length];
                for (int j = 0; j < jun2dPointArray.length; ++j) {
                    jun2dPointArray[j] = jun2dPointArray[j].scaledBy_(jun2dPoint).translatedBy_(jun2dPoint2);
                    nArray[j] = (int)jun2dPointArray[j].x();
                    nArray2[j] = (int)jun2dPointArray[j].y();
                }
                graphics.setColor(Color.black);
                graphics.drawPolyline(nArray, nArray2, jun2dPointArray.length);
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        stImage._display();
        return true;
    }

    public static boolean Example6() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.1, 0.1), new Jun2dPoint(0.1, 0.9), new Jun2dPoint(0.9, 0.1), new Jun2dPoint(0.9, 0.9), new Jun2dPoint(0.5, 0.5), new Jun2dPoint(0.1, 0.5), new Jun2dPoint(0.9, 0.5), new Jun2dPoint(0.5, 0.1), new Jun2dPoint(0.5, 0.9)};
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles(junVoronoi2dProcessor, new Jun2dPoint(200.0, 200.0), new Jun2dPoint(50.0, 50.0), StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(1, 1)));
        return true;
    }

    public static boolean Example7() {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        int n = 0;
        for (int i = 0; i <= 10; ++i) {
            for (int j = 0; j <= 10; ++j) {
                if (n % 2 == 0) {
                    arrayList.add(new Jun2dPoint((double)j / 10.0, (double)i / 10.0));
                }
                ++n;
            }
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles(junVoronoi2dProcessor, new Jun2dPoint(200.0, 200.0), new Jun2dPoint(50.0, 50.0), StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(1, 1)));
        return true;
    }

    public static boolean Example8() {
        JunAbstractObject junAbstractObject;
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        arrayList.add(new Jun2dPoint(0.0, 0.0));
        int n = 10;
        for (int i = 0; i <= 360; i += n) {
            junAbstractObject = JunAngle.FromDeg_(i);
            arrayList.add(new Jun2dPoint(((JunAngle)junAbstractObject).cos(), ((JunAngle)junAbstractObject).sin()));
            junAbstractObject = JunAngle.FromDeg_(i + n / 2);
            arrayList.add(new Jun2dPoint(((JunAngle)junAbstractObject).cos() * 0.5, ((JunAngle)junAbstractObject).sin() * 0.5));
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        junAbstractObject = new JunVoronoi2dProcessor(jun2dPointArray);
        ((JunVoronoi2dProcessor)junAbstractObject).trace_(true);
        ((JunVoronoi2dProcessor)junAbstractObject).compute();
        System.out.println("area: " + ((JunVoronoi2dProcessor)junAbstractObject).area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles((JunVoronoi2dProcessor)junAbstractObject, new Jun2dPoint(100.0, 100.0), new Jun2dPoint(150.0, 150.0), StRectangle.Origin_corner_((Point)new Point(-1, -1), (Point)new Point(1, 1)));
        return true;
    }

    public static boolean Example9() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.0, 0.0), new Jun2dPoint(0.5, 0.0), new Jun2dPoint(0.43301270189222, 0.25), new Jun2dPoint(0.86602540378444, 0.0), new Jun2dPoint(0.75, 0.43301270189222), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(0.86602540378444, 0.5), new Jun2dPoint(0.25, 0.43301270189222), new Jun2dPoint(0.43301270189222, 0.75), new Jun2dPoint(0.5, 0.86602540378444), new Jun2dPoint(0.0, 0.5), new Jun2dPoint(0.0, 0.86602540378444), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(-0.25, 0.43301270189222), new Jun2dPoint(-0.43301270189222, 0.75), new Jun2dPoint(-0.5, 0.86602540378444), new Jun2dPoint(-0.43301270189222, 0.25), new Jun2dPoint(-0.75, 0.43301270189222), new Jun2dPoint(-0.86602540378444, 0.5), new Jun2dPoint(-0.5, 0.0), new Jun2dPoint(-0.86602540378444, 0.0), new Jun2dPoint(-1.0, 0.0), new Jun2dPoint(-0.43301270189222, -0.25), new Jun2dPoint(-0.75, -0.43301270189222), new Jun2dPoint(-0.86602540378444, -0.5), new Jun2dPoint(-0.25, -0.43301270189222), new Jun2dPoint(-0.43301270189222, -0.75), new Jun2dPoint(-0.5, -0.86602540378444), new Jun2dPoint(0.0, -0.5), new Jun2dPoint(0.0, -0.86602540378444), new Jun2dPoint(0.0, -1.0), new Jun2dPoint(0.25, -0.43301270189222), new Jun2dPoint(0.43301270189222, -0.75), new Jun2dPoint(0.5, -0.86602540378444), new Jun2dPoint(0.43301270189222, -0.25), new Jun2dPoint(0.75, -0.43301270189222), new Jun2dPoint(0.86602540378444, -0.5)};
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(jun2dPointArray);
        junVoronoi2dProcessor.trace_(true);
        junVoronoi2dProcessor.compute();
        System.out.println("area: " + junVoronoi2dProcessor.area());
        JunVoronoi2dProcessorTestExamples.ShowTriangles(junVoronoi2dProcessor, new Jun2dPoint(100.0, 100.0), new Jun2dPoint(150.0, 150.0), StRectangle.Origin_corner_((Point)new Point(-1, -1), (Point)new Point(1, 1)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ShowTriangles(JunVoronoi2dProcessor junVoronoi2dProcessor, Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, StRectangle stRectangle) {
        stRectangle = stRectangle.scaledBy_(jun2dPoint.x(), jun2dPoint.y());
        stRectangle = stRectangle.translatedBy_((int)jun2dPoint2.x(), (int)jun2dPoint2.y());
        StImage stImage = new StImage(300, 300);
        Graphics graphics = null;
        try {
            graphics = stImage.image().getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, stImage.width(), stImage.height());
            graphics.setColor(Color.red);
            graphics.drawRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            Jun2dPoint[][] jun2dPointArray = junVoronoi2dProcessor.triangles();
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                Jun2dPoint[] jun2dPointArray2 = jun2dPointArray[i];
                Jun2dPoint[] jun2dPointArray3 = new Jun2dPoint[]{jun2dPointArray2[0], jun2dPointArray2[1], jun2dPointArray2[2], jun2dPointArray2[0]};
                int[] nArray = new int[jun2dPointArray3.length];
                int[] nArray2 = new int[jun2dPointArray3.length];
                for (int j = 0; j < jun2dPointArray3.length; ++j) {
                    jun2dPointArray3[j] = jun2dPointArray3[j].scaledBy_(jun2dPoint).translatedBy_(jun2dPoint2);
                    nArray[j] = (int)jun2dPointArray3[j].x();
                    nArray2[j] = (int)jun2dPointArray3[j].y();
                }
                graphics.setColor(Color.black);
                graphics.drawPolyline(nArray, nArray2, jun2dPointArray3.length);
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        stImage._display();
    }

    public static void main(String[] stringArray) {
        new JunVoronoi2dProcessorTestExamples();
    }
}

