/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDiagram;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessor;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StValueHolder;

public class JunDelaunay2dDiagram
extends JunVoronoi2dDiagram {
    public JunDelaunay2dDiagram(int n, int n2) {
        super(n, n2);
    }

    public JunDelaunay2dDiagram(Dimension dimension) {
        super(dimension);
    }

    public JunVoronoi2dDiagram asVoronoiDiagram() {
        JunVoronoi2dDiagram junVoronoi2dDiagram = new JunVoronoi2dDiagram(this.extent());
        junVoronoi2dDiagram.addAll_(this.points());
        return junVoronoi2dDiagram;
    }

    public Jun2dPolygon convexHull() {
        int n = this.points().length;
        if (n >= 3) {
            LineSegment[] lineSegmentArray = this.convexHullEdges();
            Jun2dPoint[] jun2dPointArray = this.lineupVertexSet_(lineSegmentArray);
            return new Jun2dPolygon(jun2dPointArray);
        }
        if (n > 0) {
            return new Jun2dPolygon(this.points());
        }
        return null;
    }

    public Jun2dCircle minimalEnclosingCircle() {
        Jun2dPoint[] jun2dPointArray = this.points();
        if (jun2dPointArray.length >= 3) {
            return this.mecByChrystal();
        }
        if (jun2dPointArray.length == 2) {
            Jun2dPoint jun2dPoint = jun2dPointArray[0];
            Jun2dPoint jun2dPoint2 = jun2dPointArray[1];
            Jun2dPoint jun2dPoint3 = jun2dPoint.plus_(jun2dPoint2).dividedBy_(2.0);
            double d = jun2dPoint2.distance_(jun2dPoint) / 2.0;
            return new Jun2dCircle(jun2dPoint3, d);
        }
        if (jun2dPointArray.length == 1) {
            Jun2dPoint jun2dPoint = jun2dPointArray[0];
            return new Jun2dCircle(jun2dPoint, 0.0);
        }
        return null;
    }

    public JunDelaunay2dDiagram asDelaunayDiagram() {
        return this;
    }

    protected String labelString() {
        return "Delaunay Diagram";
    }

    protected Jun2dCircle assureEnclosureOf_in_(Jun2dPoint[] jun2dPointArray, Jun2dCircle jun2dCircle) {
        Jun2dPoint jun2dPoint = jun2dCircle.center();
        double d = 0.0;
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d2 = jun2dPointArray[i].distance_(jun2dPoint);
            d = Math.max(d, d2);
        }
        return new Jun2dCircle(jun2dPoint, d);
    }

    protected Color borderColor() {
        return Color.cyan;
    }

    protected LineSegment[] convexHullEdges() {
        Jun2dPoint[][] jun2dPointArray = this.processor().triangles();
        ArrayList<LineSegment> arrayList = new ArrayList<LineSegment>();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dPointArray[i][0];
            Jun2dPoint jun2dPoint2 = jun2dPointArray[i][1];
            Jun2dPoint jun2dPoint3 = jun2dPointArray[i][2];
            LineSegment lineSegment = this._createLineSegmentWith_with_(jun2dPoint, jun2dPoint2);
            LineSegment lineSegment2 = this._createLineSegmentWith_with_(jun2dPoint2, jun2dPoint3);
            LineSegment lineSegment3 = this._createLineSegmentWith_with_(jun2dPoint3, jun2dPoint);
            if (arrayList.contains(lineSegment)) {
                arrayList.remove(lineSegment);
            } else {
                arrayList.add(lineSegment);
            }
            if (arrayList.contains(lineSegment2)) {
                arrayList.remove(lineSegment2);
            } else {
                arrayList.add(lineSegment2);
            }
            if (arrayList.contains(lineSegment3)) {
                arrayList.remove(lineSegment3);
                continue;
            }
            arrayList.add(lineSegment3);
        }
        return arrayList.toArray(new LineSegment[arrayList.size()]);
    }

    protected Jun2dPoint[] lineupVertexSet_(LineSegment[] lineSegmentArray) {
        Set<LineSegment> set;
        int n;
        Object object;
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>(lineSegmentArray.length);
        HashMap<Double, HashSet<LineSegment>> hashMap = new HashMap<Double, HashSet<LineSegment>>();
        for (int i = 0; i < lineSegmentArray.length; ++i) {
            object = new Jun2dPoint[]{lineSegmentArray[i].start(), lineSegmentArray[i].end()};
            for (n = 0; n < ((Jun2dPoint[])object).length; ++n) {
                set = (Set)hashMap.get(new Double(object[n].x()));
                if (set == null) {
                    set = new HashSet<LineSegment>();
                    hashMap.put(new Double(((Jun2dPoint)((Object)object[n])).x()), (HashSet<LineSegment>)set);
                }
                set.add(lineSegmentArray[i]);
            }
        }
        Jun2dPoint[] jun2dPointArray = lineSegmentArray[0];
        object = jun2dPointArray;
        arrayList.add(((LineSegment)object).start());
        for (n = 1; n < lineSegmentArray.length - 1; ++n) {
            set = (HashSet<LineSegment>)hashMap.get(new Double(((Line2D.Double)object).getX2()));
            object = this.polylineGrowFrom_branches_((LineSegment)object, set);
            arrayList.add(((LineSegment)object).start());
        }
        arrayList.add(((LineSegment)object).end());
        return arrayList.toArray(new Jun2dPoint[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage makeImage() {
        this.voronoiProcessor = new JunVoronoi2dProcessor(this.points());
        this.processingCondition = this.voronoiProcessor.compute();
        StImage stImage = new StImage(this.extent());
        Graphics2D graphics2D = null;
        try {
            Jun2dPoint[] jun2dPointArray;
            graphics2D = (Graphics2D)stImage.image().getGraphics();
            graphics2D.setBackground(Color.white);
            Rectangle rectangle = this.bounds();
            double d = (double)rectangle.width / (double)(rectangle.width + 1);
            double d2 = (double)rectangle.height / (double)(rectangle.height + 1);
            Jun2dPoint jun2dPoint = new Jun2dPoint(d, d2);
            graphics2D.setColor(this.borderColor());
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics2D.setColor(this.triangleColor());
            Jun2dPoint[][] jun2dPointArray2 = this.voronoiProcessor.triangles();
            if (jun2dPointArray2.length == 0 && (jun2dPointArray = this.voronoiProcessor.dots()).length == 2) {
                this.voronoiProcessor.displayLineOn_from_to_clip_(graphics2D, jun2dPointArray[0]._toPoint(), jun2dPointArray[1]._toPoint(), rectangle);
            }
            for (int i = 0; i < jun2dPointArray2.length; ++i) {
                Jun2dPoint[] jun2dPointArray3 = jun2dPointArray2[i];
                Point[] pointArray = new Point[]{jun2dPointArray3[0].translatedBy_(jun2dPoint)._toPoint(), jun2dPointArray3[1].translatedBy_(jun2dPoint)._toPoint(), jun2dPointArray3[2].translatedBy_(jun2dPoint)._toPoint()};
                this.voronoiProcessor.displayLoopOn_points_clip_(graphics2D, pointArray, rectangle);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return stImage;
    }

    protected LineSegment polylineGrowFrom_branches_(LineSegment lineSegment, Set set) {
        Jun2dPoint jun2dPoint = lineSegment.end();
        LineSegment[] lineSegmentArray = set.toArray(new LineSegment[set.size()]);
        for (int i = 0; i < lineSegmentArray.length; ++i) {
            Jun2dPoint jun2dPoint2 = lineSegmentArray[i].start();
            Jun2dPoint jun2dPoint3 = lineSegmentArray[i].end();
            if (jun2dPoint2.equals((Object)jun2dPoint)) {
                if (jun2dPoint3.equals((Object)lineSegment.start())) continue;
                return new LineSegment(jun2dPoint2, jun2dPoint3);
            }
            if (!jun2dPoint3.equals((Object)jun2dPoint) || jun2dPoint2.equals((Object)lineSegment.start())) continue;
            return new LineSegment(jun2dPoint3, jun2dPoint2);
        }
        return null;
    }

    protected Jun2dCircle mecByChrystal() {
        final Jun2dPoint[] jun2dPointArray = this.convexHull().points();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object3);
                Jun2dPoint jun2dPoint4 = jun2dPoint2.minus_(jun2dPoint);
                Jun2dPoint jun2dPoint5 = jun2dPoint3.minus_(jun2dPoint);
                double d = jun2dPoint4.dotProduct_(jun2dPoint5);
                double d2 = jun2dPoint4.dotProduct_(jun2dPoint4);
                double d3 = jun2dPoint5.dotProduct_(jun2dPoint5);
                return new Double(d / Math.sqrt(d2 * d3));
            }
        };
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                stValueHolder.value_(-99.99);
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    double d;
                    Jun2dPoint jun2dPoint3 = jun2dPointArray[i];
                    if (jun2dPoint3.equals((Object)jun2dPoint) || jun2dPoint3.equals((Object)jun2dPoint2) || !((d = ((Number)stBlockClosure.value_value_value_((Object)jun2dPoint3, (Object)jun2dPoint, (Object)jun2dPoint2)).doubleValue()) > stValueHolder._doubleValue())) continue;
                    stValueHolder.value_(d);
                    stValueHolder2.value_((Object)jun2dPoint3);
                }
                return null;
            }
        };
        Jun2dPoint jun2dPoint = jun2dPointArray[0];
        Jun2dPoint jun2dPoint2 = jun2dPointArray[1];
        ArrayList<Object> arrayList = null;
        while (arrayList == null) {
            stBlockClosure2.value_value_((Object)jun2dPoint, (Object)jun2dPoint2);
            if (stValueHolder._doubleValue() <= 0.0) {
                arrayList = new ArrayList<Object>();
                arrayList.add((Object)jun2dPoint);
                arrayList.add((Object)jun2dPoint2);
                continue;
            }
            double d = ((Number)stBlockClosure.value_value_value_((Object)jun2dPoint, (Object)((Jun2dPoint)((Object)stValueHolder2.value())), (Object)jun2dPoint2)).doubleValue();
            if (d >= 0.0) {
                d = ((Number)stBlockClosure.value_value_value_((Object)jun2dPoint2, (Object)((Jun2dPoint)((Object)stValueHolder2.value())), (Object)jun2dPoint)).doubleValue();
                if (d >= 0.0) {
                    arrayList = new ArrayList();
                    arrayList.add(stValueHolder2.value());
                    arrayList.add((Object)jun2dPoint);
                    arrayList.add((Object)jun2dPoint2);
                    continue;
                }
                jun2dPoint2 = (Jun2dPoint)((Object)stValueHolder2.value());
                continue;
            }
            jun2dPoint = (Jun2dPoint)((Object)stValueHolder2.value());
        }
        Jun2dCircle jun2dCircle = null;
        if (arrayList.size() == 2) {
            Jun2dPoint jun2dPoint3 = jun2dPoint.plus_(jun2dPoint2).dividedBy_(2.0);
            double d = jun2dPoint2.distance_(jun2dPoint) / 2.0;
            jun2dCircle = new Jun2dCircle(jun2dPoint3, d);
        } else {
            Jun2dPoint[] jun2dPointArray2 = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
            Jun2dTriangle jun2dTriangle = new Jun2dTriangle(jun2dPointArray2[0], jun2dPointArray2[1], jun2dPointArray2[2]);
            jun2dCircle = jun2dTriangle.circumcircle();
        }
        return this.assureEnclosureOf_in_(jun2dPointArray, jun2dCircle);
    }

    protected Color triangleColor() {
        return Color.magenta;
    }

    protected LineSegment _createLineSegmentWith_with_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dPoint jun2dPoint3 = jun2dPoint;
        Jun2dPoint jun2dPoint4 = jun2dPoint2;
        if (jun2dPoint3.x() > jun2dPoint4.x() || jun2dPoint3.x() == jun2dPoint4.x() && jun2dPoint3.y() > jun2dPoint4.y()) {
            jun2dPoint3 = jun2dPoint2;
            jun2dPoint4 = jun2dPoint;
        }
        return new LineSegment(jun2dPoint3, jun2dPoint4);
    }

    class LineSegment
    extends Line2D.Double {
        public LineSegment(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
            super(jun2dPoint.x(), jun2dPoint.y(), jun2dPoint2.x(), jun2dPoint2.y());
        }

        public Jun2dPoint start() {
            return new Jun2dPoint(this.getX1(), this.getY1());
        }

        public Jun2dPoint end() {
            return new Jun2dPoint(this.getX2(), this.getY2());
        }

        public boolean equals(Object object) {
            if (!(object instanceof LineSegment)) {
                return false;
            }
            LineSegment lineSegment = (LineSegment)object;
            return this.x1 == lineSegment.x1 && this.y1 == lineSegment.y1 && this.x2 == lineSegment.x2 && this.y2 == lineSegment.y2;
        }

        public String toString() {
            return "LineSegment((" + this.x1 + ", " + this.y1 + ")->(" + this.x2 + ", " + this.y2 + "))";
        }
    }
}

