/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.graph.JunElementalGraph;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

public class JunElementalGraphTestExamples
extends JunTestExamples {
    public static boolean Example00() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        System.out.println(junElementalGraph.printString());
        return true;
    }

    public static boolean Example01() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        junElementalGraph.beUndirectedGraph();
        System.out.println(junElementalGraph.printString());
        return true;
    }

    public static boolean Example02() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        System.out.println((Object)junElementalGraph.toLispList());
        junElementalGraph = new JunElementalGraph(junElementalGraph.toLispList());
        System.out.println((Object)junElementalGraph.toLispList());
        System.out.println(junElementalGraph.printString());
        return true;
    }

    public static boolean Example10() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        junElementalGraph.nodesDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        System.out.println();
        junElementalGraph.arcsDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        return true;
    }

    public static boolean Example11() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleCycle();
        junElementalGraph.nodesDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        System.out.println();
        junElementalGraph.arcsDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        return true;
    }

    public static boolean Example12() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        junElementalGraph.nodesBreadthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        System.out.println();
        junElementalGraph.arcsBreadthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        return true;
    }

    public static boolean Example13() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        junElementalGraph.nodesTopologicalSortDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print('\t');
                }
                System.out.print(object3);
                System.out.print(": ");
                System.out.print(object);
                System.out.println();
                return null;
            }
        });
        System.out.println();
        JunElementalNode[] junElementalNodeArray = junElementalGraph.nodesTopologicalSort();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            System.out.println(junElementalNodeArray[i].toString());
        }
        return true;
    }

    public static boolean Example14() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        Map map = junElementalGraph.shortestPaths();
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                JunElementalNode junElementalNode = (JunElementalNode)((Object)((Map.Entry)object).getKey());
                JunElementalNode junElementalNode2 = (JunElementalNode)((Object)((Map.Entry)object2).getKey());
                return junElementalNode.labelString().compareTo(junElementalNode2.labelString());
            }
        });
        treeSet.addAll(map.entrySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Map map2 = (Map)entry.getValue();
            TreeSet treeSet2 = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    JunElementalNode junElementalNode = (JunElementalNode)((Object)((Map.Entry)object).getKey());
                    JunElementalNode junElementalNode2 = (JunElementalNode)((Object)((Map.Entry)object2).getKey());
                    return junElementalNode.labelString().compareTo(junElementalNode2.labelString());
                }
            });
            treeSet2.addAll(map2.entrySet());
            Iterator iterator2 = treeSet2.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator2.next();
                Object k2 = entry2.getKey();
                Number number = (Number)entry2.getValue();
                System.out.print(k);
                System.out.print(" -- ");
                System.out.print(number);
                System.out.print(" -> ");
                System.out.print(k2);
                System.out.println();
            }
        }
        return true;
    }

    public static boolean Example15() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleCycle();
        Map map = junElementalGraph.shortestPaths();
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                JunElementalNode junElementalNode = (JunElementalNode)((Object)((Map.Entry)object).getKey());
                JunElementalNode junElementalNode2 = (JunElementalNode)((Object)((Map.Entry)object2).getKey());
                return junElementalNode.labelString().compareTo(junElementalNode2.labelString());
            }
        });
        treeSet.addAll(map.entrySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Map map2 = (Map)entry.getValue();
            TreeSet treeSet2 = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    JunElementalNode junElementalNode = (JunElementalNode)((Object)((Map.Entry)object).getKey());
                    JunElementalNode junElementalNode2 = (JunElementalNode)((Object)((Map.Entry)object2).getKey());
                    return junElementalNode.labelString().compareTo(junElementalNode2.labelString());
                }
            });
            treeSet2.addAll(map2.entrySet());
            Iterator iterator2 = treeSet2.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator2.next();
                Object k2 = entry2.getKey();
                Number number = (Number)entry2.getValue();
                System.out.print(k);
                System.out.print(" -- ");
                System.out.print(number);
                System.out.print(" -> ");
                System.out.print(k2);
                System.out.println();
            }
        }
        return true;
    }

    public static boolean Example16() {
        JunElementalNode junElementalNode = JunElementalGraph.DefaultNewNode("a");
        JunElementalNode junElementalNode2 = JunElementalGraph.DefaultNewNode("b");
        JunElementalNode junElementalNode3 = JunElementalGraph.DefaultNewNode("c");
        JunElementalNode junElementalNode4 = JunElementalGraph.DefaultNewNode("d");
        JunElementalNode junElementalNode5 = JunElementalGraph.DefaultNewNode("e");
        JunElementalNode junElementalNode6 = JunElementalGraph.DefaultNewNode("f");
        JunElementalGraph junElementalGraph = JunElementalGraph.DefaultNewGraph();
        junElementalGraph.connect_with_(junElementalNode, junElementalNode2);
        junElementalGraph.connect_with_(junElementalNode, junElementalNode3);
        junElementalGraph.connect_with_(junElementalNode2, junElementalNode3);
        JunElementalGraph junElementalGraph2 = JunElementalGraph.DefaultNewGraph();
        junElementalGraph2.connect_with_(junElementalNode6, junElementalNode4);
        junElementalGraph2.connect_with_(junElementalNode5, junElementalNode4);
        junElementalGraph2.connect_with_(junElementalNode5, junElementalNode6);
        boolean bl = junElementalGraph.isIsomorphicTo_(junElementalGraph2);
        System.out.println(bl);
        return bl;
    }

    public static boolean Example17() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        JunElementalGraph junElementalGraph2 = JunElementalGraph.ExampleCycle();
        boolean bl = junElementalGraph.isIsomorphicTo_(junElementalGraph2);
        System.out.println(bl);
        return !bl;
    }

    public static boolean Example20() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTree();
        junElementalGraph.nodesDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print("|-- ");
                }
                System.out.println(object);
                return null;
            }
        });
        return true;
    }

    public static boolean Example21() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleForest();
        junElementalGraph.nodesDepthFirstDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                for (int i = 0; i < ((Number)object2).intValue(); ++i) {
                    System.out.print("|-- ");
                }
                System.out.println(object);
                return null;
            }
        });
        return true;
    }

    public static boolean Example22() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleDirectory_withFiles_(3, true);
        if (junElementalGraph == null) {
            return false;
        }
        junElementalGraph.visitDepthFirst_nodeDo_arcDo_(null, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                String string = ((JunElementalNode)((Object)object)).labelString();
                int n = ((Number)object2).intValue();
                if (n > 0) {
                    for (int i = 1; i < n; ++i) {
                        System.out.print("|  ");
                    }
                    if (string.endsWith("/")) {
                        System.out.print("+- ");
                    } else {
                        System.out.print("|- ");
                    }
                }
                System.out.println(string);
                return null;
            }
        }, new StBlockClosure());
        return true;
    }

    public static boolean Example30() {
        JunElementalNode[] junElementalNodeArray;
        Object object;
        Object object2;
        final JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTree();
        JunAttributeTable junAttributeTable = junElementalGraph.arrangeTree();
        int n = 100;
        HashMap hashMap = new HashMap();
        Dimension dimension = new Dimension();
        Iterator iterator = ((Map)junAttributeTable.at_(JunElementalGraphTestExamples.$((String)"nodeOriginTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (JunElementalNode)((Object)object2.getKey());
            junElementalNodeArray = (JunElementalNode[])object2.getValue();
            ArrayList<Point> arrayList = new ArrayList<Point>(n + 1);
            for (int i = 0; i <= n; ++i) {
                int n2 = ((JunElementalNode)((Object)object)).origin().x + (junElementalNodeArray.x - ((JunElementalNode)((Object)object)).origin().x) * i / n;
                int n3 = ((JunElementalNode)((Object)object)).origin().y + (junElementalNodeArray.y - ((JunElementalNode)((Object)object)).origin().y) * i / n;
                arrayList.add(new Point(n2, n3));
            }
            hashMap.put(object, arrayList);
            dimension.width = Math.max(dimension.width, junElementalNodeArray.x + ((JunElementalNode)((Object)object)).width());
            dimension.height = Math.max(dimension.height, junElementalNodeArray.y + ((JunElementalNode)((Object)object)).height());
        }
        object2 = new JPanel(){

            public void paint(Graphics graphics) {
                junElementalGraph.displayOn_(graphics);
            }
        };
        ((JComponent)object2).setPreferredSize(dimension);
        object = new JFrame();
        ((JFrame)object).getContentPane().add((Component)object2);
        ((Window)object).pack();
        JunElementalGraphTestExamples._ShowAtCenterPoint((Window)object);
        junElementalNodeArray = junElementalGraph.nodes();
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j < junElementalNodeArray.length; ++j) {
                junElementalNodeArray[j].origin_((Point)((ArrayList)hashMap.get((Object)junElementalNodeArray[j])).get(i));
            }
            ((JComponent)object2).paintImmediately(((Component)object2).getBounds());
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example31() {
        int n;
        JunElementalNode[] junElementalNodeArray;
        Serializable serializable;
        Object object;
        Object object2;
        final JunElementalGraph junElementalGraph = JunElementalGraph.ExampleForest();
        JunAttributeTable junAttributeTable = junElementalGraph.arrangeForest();
        int n2 = 100;
        HashMap<Object, JunElementalNode[]> hashMap = new HashMap<Object, JunElementalNode[]>();
        Dimension dimension = new Dimension();
        Iterator iterator = ((Map)junAttributeTable.at_(JunElementalGraphTestExamples.$((String)"nodeOriginTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (JunElementalNode)((Object)object2.getKey());
            serializable = (Point)object2.getValue();
            junElementalNodeArray = new ArrayList(n2 + 1);
            for (n = 0; n <= n2; ++n) {
                int n3 = ((JunElementalNode)((Object)object)).origin().x + (((Point)serializable).x - ((JunElementalNode)((Object)object)).origin().x) * n / n2;
                int n4 = ((JunElementalNode)((Object)object)).origin().y + (((Point)serializable).y - ((JunElementalNode)((Object)object)).origin().y) * n / n2;
                junElementalNodeArray.add(new Point(n3, n4));
            }
            hashMap.put(object, junElementalNodeArray);
            dimension.width = Math.max(dimension.width, ((Point)serializable).x + ((JunElementalNode)((Object)object)).width());
            dimension.height = Math.max(dimension.height, ((Point)serializable).y + ((JunElementalNode)((Object)object)).height());
        }
        object2 = new Point();
        object = new JPanel((Point)object2){
            private final /* synthetic */ Point val$aPoint;
            {
                this.val$aPoint = point;
            }

            public void paint(Graphics graphics) {
                junElementalGraph.displayOn_at_(graphics, this.val$aPoint);
            }
        };
        ((JComponent)object).setPreferredSize(new Dimension(dimension.width, dimension.height / 2));
        serializable = new JFrame();
        ((JFrame)serializable).getContentPane().add((Component)object);
        ((Window)serializable).pack();
        JunElementalGraphTestExamples._ShowAtCenterPoint((Window)serializable);
        junElementalNodeArray = junElementalGraph.nodes();
        for (n = 0; n <= n2; ++n) {
            for (int i = 0; i < junElementalNodeArray.length; ++i) {
                junElementalNodeArray[i].origin_((Point)((ArrayList)hashMap.get((Object)junElementalNodeArray[i])).get(n));
            }
            ((JComponent)object).paintImmediately(((Component)object).getBounds());
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Graphics graphics = null;
        try {
            graphics = ((JComponent)object).getGraphics();
            int n5 = Math.max(dimension.height / 250, 10);
            ((Point)object2).y = 0;
            while (((Point)object2).y > ((JComponent)object).getHeight() - dimension.height) {
                ((JComponent)object).paintImmediately(((Component)object).getBounds());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ((Point)object2).y -= n5;
            }
            while (((Point)object2).y < 0) {
                ((JComponent)object).paintImmediately(((Component)object).getBounds());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                ((Point)object2).y += n5;
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        ((Point)object2).x = 0;
        ((Point)object2).y = 0;
        ((Component)object).repaint();
        return true;
    }

    public static boolean Example40() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTree();
        junElementalGraph.arrangeFormat_(JunElementalGraphTestExamples.$((String)"tree"));
        junElementalGraph.arrange();
        junElementalGraph.show();
        return true;
    }

    public static boolean Example41() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleForest();
        junElementalGraph.arrangeFormat_(JunElementalGraphTestExamples.$((String)"forest"));
        junElementalGraph.arrange();
        junElementalGraph.show();
        return true;
    }

    public static boolean Example42() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleForest();
        junElementalGraph.arrangeFormat_(JunElementalGraphTestExamples.$((String)"forest"));
        junElementalGraph.arrangeForestInterval_(150);
        junElementalGraph.arrangeForestMargin_(1);
        junElementalGraph.arrange();
        junElementalGraph.show();
        return true;
    }

    public static boolean Example43() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTokyo();
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                String[] stringArray = JunStringUtility.Separate_dividers_((String)object, new char[]{'/'});
                double d = Double.parseDouble(stringArray[1]);
                d += Double.parseDouble(stringArray[2]) / 60.0;
                d += Double.parseDouble(stringArray[3]) / 3600.0;
                if ("W".equals(stringArray[0]) || "S".equals(stringArray[0])) {
                    d *= -1.0;
                }
                return new Double(d);
            }
        };
        double d = ((Number)stBlockClosure.value_((Object)"E/139/44/40.9")).doubleValue();
        double d2 = ((Number)stBlockClosure.value_((Object)"N/35/39/16.0")).doubleValue();
        JunElementalNode[] junElementalNodeArray = junElementalGraph.nodes();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            double d3 = ((Number)stBlockClosure.value_(junElementalNodeArray[i].attributeAt_(JunElementalGraphTestExamples.$((String)"longitude")))).doubleValue();
            double d4 = ((Number)stBlockClosure.value_(junElementalNodeArray[i].attributeAt_(JunElementalGraphTestExamples.$((String)"latitude")))).doubleValue();
            double d5 = 7000.0;
            int n = (int)Math.round((d3 - d) * d5);
            int n2 = (int)Math.round((d4 - d2) * d5);
            junElementalNodeArray[i].center_(new Point(n, -n2));
        }
        junElementalGraph.flushBoundingBox();
        StRectangle stRectangle = junElementalGraph.boundingBox();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            Point point = junElementalNodeArray[i].origin();
            junElementalNodeArray[i].origin_(new Point(point.x - stRectangle.originX(), point.y - stRectangle.originY()));
        }
        junElementalGraph.flushBoundingBox();
        junElementalGraph.show();
        return true;
    }

    public static boolean Example44() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTokyo();
        junElementalGraph.arrangeFormat_(JunElementalGraphTestExamples.$((String)"concentric"));
        junElementalGraph.arrangeAttributeSymbol_(JunElementalGraphTestExamples.$((String)"distance"));
        junElementalGraph.arrangeConcentricRadius_(400);
        junElementalGraph.arrangeConcentricSpiral_(3.0f);
        junElementalGraph.arrange();
        junElementalGraph.show();
        return true;
    }

    public static void main(String[] stringArray) {
        new JunElementalGraphTestExamples();
    }
}

