/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.roughsketch;

import java.awt.Color;
import java.awt.Point;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation2;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchController;
import jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchViewAwt;
import jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchViewSwing;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StView;

public class JunOpenGLRoughSketch
extends JunOpenGLDisplayModel {
    public static final Color NibColor = Color.red;
    public static final float NibWidth = 1.0f;
    public static final double MinimumDistance = 4.0;

    public JunButtonModel pencilButton() {
        if (!this.pushButtons().containsKey(JunOpenGLRoughSketch.$((String)"pencil"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.PencilCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                    JunOpenGLRoughSketch.this.setButtonState(1.$((String)"pencil"), !junButtonModel.value());
                    return null;
                }
            });
            this.pushButtons().put(JunOpenGLRoughSketch.$((String)"pencil"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLRoughSketch.$((String)"pencil")));
    }

    public StView defaultView() {
        if (JunOpenGLRoughSketch.GetDefaultViewMode() == 0) {
            return new JunOpenGLRoughSketchViewAwt(this);
        }
        return new JunOpenGLRoughSketchViewSwing(this);
    }

    protected String windowTitle() {
        return JunOpenGLRoughSketch.$String((String)"Rough Sketch");
    }

    protected void pencilOpenedPoints(Point[] pointArray, JunOpenGLRoughSketchController junOpenGLRoughSketchController) {
        if (pointArray == null || pointArray.length < 3) {
            return;
        }
        if (junOpenGLRoughSketchController == null) {
            return;
        }
    }

    protected void pencilClosedPoints(Point[] pointArray, JunOpenGLRoughSketchController junOpenGLRoughSketchController) {
        Object object;
        if (pointArray == null || pointArray.length < 3) {
            return;
        }
        if (junOpenGLRoughSketchController == null) {
            return;
        }
        JunFormTriangulation2 junFormTriangulation2 = null;
        try {
            junFormTriangulation2 = this.createFormTriangulation(pointArray);
        }
        catch (Exception exception) {
            JunDialog.Warn_(JunOpenGLRoughSketch.$String((String)"Could not perform triangulation."));
            return;
        }
        Jun3dPoint[] jun3dPointArray = null;
        Jun3dTriangle[] jun3dTriangleArray = null;
        try {
            object = this.convert(pointArray, junFormTriangulation2.triangles(), junOpenGLRoughSketchController);
            jun3dPointArray = (Jun3dPoint[])object[0];
            jun3dTriangleArray = (Jun3dTriangle[])object[1];
        }
        catch (Exception exception) {
            JunDialog.Warn_(JunOpenGLRoughSketch.$String((String)"Could not perform conversion.."));
            return;
        }
        object = this.polyline_triangles_from_(jun3dPointArray, jun3dTriangleArray);
        if (this.displayObject() != null) {
            object = new JunOpenGL3dCompoundObject(this.displayObject(), (JunOpenGL3dObject)((Object)object));
        }
        this.displayObject_((JunOpenGL3dObject)((Object)object));
        this.changed_(JunOpenGLRoughSketch.$((String)"object"));
    }

    protected JunFormTriangulation2 createFormTriangulation(Point[] pointArray) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            jun2dPointArray[i] = new Jun2dPoint(pointArray[i]);
        }
        return new JunFormTriangulation2(jun2dPointArray);
    }

    protected Object[] convert(Point[] pointArray, Jun2dTriangle[] jun2dTriangleArray, JunOpenGLRoughSketchController junOpenGLRoughSketchController) {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            jun3dPointArray[i] = this.convertPoint(junOpenGLRoughSketchController.regularizePoint_(pointArray[i]));
        }
        Jun3dTriangle[] jun3dTriangleArray = new Jun3dTriangle[jun2dTriangleArray.length];
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun3dPoint jun3dPoint;
            Jun3dPoint jun3dPoint2;
            Jun3dPoint jun3dPoint3 = this.convertPoint(junOpenGLRoughSketchController.regularizePoint_(jun2dTriangleArray[i].p1()._toPoint()));
            Jun3dTriangle jun3dTriangle = Jun3dTriangle.First_second_third_(jun3dPoint3, jun3dPoint2 = this.convertPoint(junOpenGLRoughSketchController.regularizePoint_(jun2dTriangleArray[i].p2()._toPoint())), jun3dPoint = this.convertPoint(junOpenGLRoughSketchController.regularizePoint_(jun2dTriangleArray[i].p3()._toPoint())));
            if (jun3dTriangle.asPlane().valueF_(this.eyePoint()) < 0.0) {
                jun3dTriangle = jun3dTriangle.reversed();
            }
            jun3dTriangleArray[i] = jun3dTriangle;
        }
        return new Object[]{jun3dPointArray, jun3dTriangleArray};
    }

    private Jun3dPoint convertPoint(Jun2dPoint jun2dPoint) {
        return this.displayProjection().translateTo3dPointFromPoint_(jun2dPoint).minus_(this.sightPoint());
    }

    protected JunOpenGL3dObject polyline_triangles_from_(Jun3dPoint[] jun3dPointArray, Jun3dTriangle[] jun3dTriangleArray) {
        Jun3dLine jun3dLine = this.sightPoint().to_(this.eyePoint()).normalized();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Translate_(jun3dLine.atT_(0.0));
        Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Translate_(jun3dLine.atT_(0.001));
        Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.Translate_(jun3dLine.atT_(0.002));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            JunOpenGL3dObject junOpenGL3dObject = jun3dTriangleArray[i].asJunOpenGL3dObject();
            junOpenGL3dObject.paint_(StColorValue.Blend((Color)StColorValue.Blend((Color)NibColor, (Color)Color.white), (Color)Color.white));
            junOpenGL3dCompoundObject.add_(junOpenGL3dObject.transform_(jun3dTransformation));
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(new Jun3dPoint[]{jun3dTriangleArray[i].p1(), jun3dTriangleArray[i].p2(), jun3dTriangleArray[i].p3()});
            junOpenGL3dPolylineLoop.lineWidth_(1.0f);
            junOpenGL3dPolylineLoop.paint_(StColorValue.Blend((Color)NibColor, (Color)Color.white));
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop.transform_(jun3dTransformation2));
            junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray);
            junOpenGL3dPolylineLoop.lineWidth_(1.0f);
            junOpenGL3dPolylineLoop.paint_(NibColor);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop.transform_(jun3dTransformation3));
        }
        return junOpenGL3dCompoundObject;
    }
}

