/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.projection;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGLPerspectiveProjection
extends JunOpenGLProjection {
    protected JunAngle fovy;
    protected double zoomHeight;
    public static StSymbol Type = JunOpenGLPerspectiveProjection.$((String)"perspectiveProjection");
    public static JunAngle DefaultFovy = JunAngle.FromDeg_(15.0);

    public JunOpenGLPerspectiveProjection() {
        this.setEyePoint_sightPoint_upVector_fovy_near_far_(DefaultEyePoint, DefaultSightPoint, DefaultUpVector, DefaultFovy, DefaultNear, DefaultFar);
    }

    public JunOpenGLPerspectiveProjection(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, JunAngle junAngle, double d, double d2) {
        this.setEyePoint_sightPoint_upVector_fovy_near_far_(jun3dPoint, jun3dPoint2, jun3dPoint3, junAngle, d, d2);
    }

    public JunOpenGLPerspectiveProjection(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        this.setEyePoint_sightPoint_upVector_fovy_near_far_(jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, d3);
    }

    public static JunOpenGLPerspectiveProjection EyePoint_sightPoint_upVector_fovy_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, JunAngle junAngle, double d, double d2) {
        return new JunOpenGLPerspectiveProjection(jun3dPoint, jun3dPoint2, jun3dPoint3, junAngle, d, d2);
    }

    public static JunOpenGLPerspectiveProjection EyePoint_sightPoint_upVector_fovy_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        return new JunOpenGLPerspectiveProjection(jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, d3);
    }

    public static JunOpenGLProjection Default() {
        return new JunOpenGLPerspectiveProjection();
    }

    protected void initialize() {
        super.initialize();
        this.zoomHeight = Double.NaN;
    }

    public StSymbol type() {
        return Type;
    }

    public JunAngle fovy() {
        return this.fovy;
    }

    public double regularHeight() {
        return this.fovy().div_(2.0).tan() * this.distance() * 2.0;
    }

    public JunOpenGLParallelProjection asParallelProjection() {
        double d = this.fovy().div_(2.0).tan() * this.distance() * 2.0;
        return new JunOpenGLParallelProjection(this.eyePoint(), this.sightPoint(), this.upVector(), d, this.near(), this.far());
    }

    public JunOpenGLPerspectiveProjection asPerspectiveProjection() {
        return (JunOpenGLPerspectiveProjection)this.copy();
    }

    public Jun3dTransformation asTransformation() {
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, 0.0, -1.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, 1.0, 0.0);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(1.0, 0.0, 0.0);
        double d = this.distance() * Math.abs(this.fovy().div_(2.0).tan());
        Jun3dPoint[][] jun3dPointArray = new Jun3dPoint[][]{{this.sightPoint(), jun3dPoint}, {this.eyePoint(), jun3dPoint2}, {this.sightPoint().plus_(this.unitUpVector().multipliedBy_(d)), jun3dPoint3}, {this.sightPoint().plus_(this.unitRightVector().multipliedBy_(d)), jun3dPoint4}};
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.AlignPoints_(jun3dPointArray);
        return jun3dTransformation.product_(Jun3dTransformation.Perspective_(jun3dPoint2));
    }

    public Jun3dTransformation asEyeTransformation() {
        return this.asParallelProjection().asEyeTransformation();
    }

    public void projectOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.perspective_(this);
    }

    public boolean isPerspective() {
        return true;
    }

    public void pan_(double d) {
        this.zoom_(1.0 / d);
    }

    public void zoom_(double d) {
        this.fovy = this.fovy.div_(d);
        double d2 = 0.001;
        double d3 = 180.0 - d2;
        if (this.fovy.deg() > d3) {
            this.fovy = JunAngle.FromDeg_(d3);
        }
        if (this.fovy.deg() < d2) {
            this.fovy = JunAngle.FromDeg_(d2);
        }
        this.zoomHeight = this.fovy.dividedBy_(2.0).tan() * this.distance() * 2.0;
    }

    public double zoomHeight() {
        if (Double.isNaN(this.zoomHeight)) {
            this.zoom_(1.0);
        }
        return this.zoomHeight;
    }

    public void zoomHeight_(double d) {
        this.setZoomHeight_(d);
        this.fovy = JunAngle.FromRad_(Math.atan(this.zoomHeight() / 2.0 / this.distance()) * 2.0);
        double d2 = 0.001;
        double d3 = 180.0 - d2;
        if (this.fovy.deg() > d3) {
            this.fovy = JunAngle.FromDeg_(d3);
        }
        if (this.fovy.deg() < d2) {
            this.fovy = JunAngle.FromDeg_(d2);
        }
    }

    public Jun3dPoint translateTo3dPointFromPoint_depth_(Jun2dPoint jun2dPoint, double d) {
        double d2 = d * Math.abs(this.fovy().div_(2.0).tan());
        Jun3dPoint jun3dPoint = this.unitSightVector().multipliedBy_(d);
        Jun3dPoint jun3dPoint2 = this.unitRightVector().multipliedBy_(jun2dPoint.x() * d2);
        Jun3dPoint jun3dPoint3 = this.unitUpVector().multipliedBy_(jun2dPoint.y() * d2);
        return this.eyePoint.plus_(jun3dPoint).plus_(jun3dPoint2).plus_(jun3dPoint3);
    }

    protected void setEyePoint_sightPoint_upVector_fovy_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, JunAngle junAngle, double d, double d2) {
        this.eyePoint = jun3dPoint;
        this.sightPoint = jun3dPoint2;
        this.upVector = jun3dPoint3;
        this.fovy = junAngle;
        this.near = d;
        this.far = d2;
        this.normalizeUpVector();
    }

    protected void setEyePoint_sightPoint_upVector_fovy_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        this.setEyePoint_sightPoint_upVector_fovy_near_far_(jun3dPoint, jun3dPoint2, jun3dPoint3, JunAngle.FromDeg_(d), d2, d3);
    }

    protected void setZoomHeight_(double d) {
        this.zoomHeight = Math.max(d, 0.0);
    }
}

