/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.io.PrintWriter;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dCone
extends JunOpenGL3dCompoundObject {
    protected static final Jun3dPoint DefaultApex = new Jun3dPoint(0.0, 0.0, 2.0);
    protected static final Jun3dPoint DefaultBottomCenter = new Jun3dPoint(0.0, 0.0, 0.0);
    protected static final double DefaultBottomRadius = 1.0;
    protected static final int DefaultSlices = 20;
    protected Jun3dPoint apex;
    protected Jun3dPoint bottomCenter;
    protected double bottomRadius;
    protected int slices;

    public JunOpenGL3dCone() {
        this.flushComponents();
    }

    public JunOpenGL3dCone(double d, double d2) {
        this(new Jun3dPoint(0.0, d2 / 2.0, 0.0), new Jun3dPoint(0.0, -d2 / 2.0, 0.0), d, 20);
    }

    public JunOpenGL3dCone(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, int n) {
        this.apex_(jun3dPoint);
        this.bottomCenter_(jun3dPoint2);
        this.bottomRadius_(d);
        this.slices_(n);
    }

    public JunOpenGL3dCone(JunLispList junLispList) {
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.apex = null;
        this.bottomCenter = null;
        this.bottomRadius = Double.NaN;
        this.slices = 20;
    }

    public Jun3dPoint apex() {
        if (this.apex == null) {
            this.apex = DefaultApex;
        }
        return this.apex;
    }

    public void apex_(Jun3dPoint jun3dPoint) {
        this.apex = jun3dPoint;
        this.flushComponents();
    }

    public Jun3dPoint bottomCenter() {
        if (this.bottomCenter == null) {
            this.bottomCenter = DefaultBottomCenter;
        }
        return this.bottomCenter;
    }

    public void bottomCenter_(Jun3dPoint jun3dPoint) {
        this.bottomCenter = jun3dPoint;
        this.flushComponents();
    }

    public double bottomRadius() {
        if (Double.isNaN(this.bottomRadius)) {
            this.bottomRadius = 1.0;
        }
        return this.bottomRadius;
    }

    public void bottomRadius_(double d) {
        this.bottomRadius = Math.max(d, 0.001);
        this.flushComponents();
    }

    public int slices() {
        return this.slices;
    }

    public void slices_(int n) {
        this.slices = Math.max(n, 4);
        this.flushComponents();
    }

    public double height() {
        return this.apex().distance_(this.bottomCenter());
    }

    protected ArrayList _components() {
        if (this.components == null) {
            this.components = new ArrayList();
            this.flushBounds();
            Jun3dTransformation jun3dTransformation = this.basicTransformation();
            int n = this.slices();
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
            double d = Math.PI * 2 / (double)this.slices();
            for (int i = 0; i < n; ++i) {
                double d2;
                double d3 = d * (double)i;
                double d4 = this.bottomRadius() * Math.sin(d3);
                if (Math.abs(d4) < 1.0E-12) {
                    d4 = 0.0;
                }
                if (Math.abs(d2 = this.bottomRadius() * Math.cos(d3)) < 1.0E-12) {
                    d2 = 0.0;
                }
                jun3dPointArray[i] = jun3dTransformation.applyTo_(new Jun3dPoint(d4, d2, 0.0));
            }
            JunOpenGL3dPolygon[] junOpenGL3dPolygonArray = new JunOpenGL3dPolygon[n];
            Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[n];
            int n2 = 0;
            int n3 = n - 1;
            while (n2 < n) {
                junOpenGL3dPolygonArray[n2] = new JunOpenGL3dPolygon(new Jun3dPoint[]{this.apex(), jun3dPointArray[n2], jun3dPointArray[n3]});
                junOpenGL3dPolygonArray[n2].paint_(null);
                this.components.add(junOpenGL3dPolygonArray[n2]);
                jun3dPointArray2[n2] = junOpenGL3dPolygonArray[n2].preferredNormalVector();
                n3 = n2++;
            }
            Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[n];
            n3 = 0;
            int n4 = n - 1;
            while (n3 < n) {
                jun3dPointArray3[n4] = jun3dPointArray2[n3].plus_(jun3dPointArray2[n4]).unitVector();
                n4 = n3++;
            }
            n3 = 0;
            n4 = n - 1;
            while (n3 < n) {
                junOpenGL3dPolygonArray[n3].normalVectors_(new Jun3dPoint[]{jun3dPointArray2[n3], jun3dPointArray3[n3], jun3dPointArray3[n4]});
                n4 = n3++;
            }
            JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
            junOpenGL3dPolygon.paint_(null);
            junOpenGL3dPolygon.normalVectors();
            this.components.add(junOpenGL3dPolygon);
        }
        return this.components;
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dCone junOpenGL3dCone = (JunOpenGL3dCone)this.copy();
        Jun3dPoint jun3dPoint = this.basicTransformation().applyTo_(new Jun3dPoint(this.bottomRadius(), 0.0, 0.0));
        Jun3dPoint jun3dPoint2 = jun3dPoint.transform_(jun3dTransformation);
        Jun3dPoint jun3dPoint3 = this.bottomCenter().transform_(jun3dTransformation);
        double d = jun3dPoint3.distance_(jun3dPoint2);
        junOpenGL3dCone.apex_(this.apex().transform_(jun3dTransformation));
        junOpenGL3dCone.bottomCenter_(jun3dPoint3);
        junOpenGL3dCone.bottomRadius_(d);
        return junOpenGL3dCone;
    }

    protected Jun3dTransformation basicTransformation() {
        Jun3dTransformation jun3dTransformation;
        Jun3dPoint jun3dPoint = this.apex().minus_(this.bottomCenter());
        if (jun3dPoint.x() == 0.0 && jun3dPoint.y() == 0.0 && jun3dPoint.z() < 0.0) {
            jun3dPoint = new Jun3dPoint(0.0, 0.0, -jun3dPoint.z());
            jun3dTransformation = Jun3dTransformation.MirrorY();
            jun3dTransformation = jun3dTransformation.product_(Jun3dTransformation.AlignVector_to_(new Jun3dPoint(0.0, 0.0, this.height()), jun3dPoint));
        } else {
            jun3dTransformation = Jun3dTransformation.AlignVector_to_(new Jun3dPoint(0.0, 0.0, this.height()), jun3dPoint);
        }
        jun3dTransformation = jun3dTransformation.product_(Jun3dTransformation.Translate_(this.bottomCenter()));
        return jun3dTransformation;
    }

    public StObject postCopy() {
        super.postCopy();
        if (this.apex != null) {
            this.apex = new Jun3dPoint(this.apex.x(), this.apex.y(), this.apex.z());
        }
        if (this.bottomCenter != null) {
            this.bottomCenter = new Jun3dPoint(this.bottomCenter.x(), this.bottomCenter.y(), this.bottomCenter.z());
        }
        return this;
    }

    public StSymbol kindName() {
        return JunOpenGL3dCone.$((String)"Cone");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.apexToLispList());
        junLispCons.add_((Object)this.bottomCenterToLispList());
        junLispCons.add_((Object)this.bottomRadiusToLispList());
        junLispCons.add_((Object)this.slicesToLispList());
        return junLispCons;
    }

    protected JunLispList apexToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCone.$((String)"apex"));
        junLispCons.tail_((Object)this.apex());
        return junLispCons;
    }

    protected JunLispList bottomCenterToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCone.$((String)"bottomCenter"));
        junLispCons.tail_((Object)this.bottomCenter());
        return junLispCons;
    }

    protected JunLispList bottomRadiusToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCone.$((String)"bottomRadius"));
        junLispCons.tail_(new Double(this.bottomRadius()));
        return junLispCons;
    }

    protected JunLispList slicesToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCone.$((String)"slices"));
        junLispCons.tail_(new Integer(this.slices()));
        return junLispCons;
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.apexFromLispList(junLispList);
        this.bottomCenterFromLispList(junLispList);
        this.bottomRadiusFromLispList(junLispList);
        this.slicesFromLispList(junLispList);
    }

    protected void apexFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"apex"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.apex_((Jun3dPoint)((Object)junLispCons.tail()));
    }

    protected void bottomCenterFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"bottomCenter"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.bottomCenter_((Jun3dPoint)((Object)junLispCons.tail()));
    }

    protected void bottomRadiusFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"bottomRadius"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.bottomRadius_(((Number)junLispCons.tail()).doubleValue());
    }

    protected void slicesFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"slices"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.slices_(((Number)junLispCons.tail()).intValue());
    }

    public void vrml20On_(PrintWriter printWriter, String string) {
        Jun3dLine jun3dLine = new Jun3dLine(this.apex(), this.bottomCenter());
        Jun3dPoint jun3dPoint = jun3dLine.center();
        jun3dLine = jun3dLine.translatedBy_(jun3dPoint.negated());
        Jun3dLine jun3dLine2 = new Jun3dLine(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        Jun3dPoint jun3dPoint2 = new JunPlane(jun3dLine2.to(), jun3dLine2.from(), jun3dLine.from()).normalVector();
        JunAngle junAngle = jun3dLine2.angleWithLine_(jun3dLine);
        printWriter.println(string + "Transform {");
        printWriter.println(string + "\t" + "rotation " + jun3dPoint2.x() + ' ' + jun3dPoint2.y() + ' ' + jun3dPoint2.z() + ' ' + junAngle.rad());
        printWriter.println(string + "\t" + "translation " + jun3dPoint.x() + ' ' + jun3dPoint.y() + ' ' + jun3dPoint.z());
        printWriter.println(string + "\t" + "children [");
        this.vrml20ShapeOn_(printWriter, string + "\t" + "\t");
        printWriter.println(string + "\t" + "] # children");
        printWriter.println(string + "} #Transform");
        printWriter.flush();
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "geometry Cone {");
        printWriter.println(string + "\t" + "bottomRadius " + this.bottomRadius());
        printWriter.println(string + "\t" + "height " + this.height());
        printWriter.println(string + "} #Cone");
    }
}

