/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.illusion;

import java.util.ArrayList;
import java.util.List;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.colors.JunColorBarCMY;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxObject;
import jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

public class JunOpenGLIllusion02
extends JunOpenGLIllusion {
    protected int numberOfParts;
    protected JunColorBarCMY colorBar;

    protected void initialize() {
        super.initialize();
        this.numberOfParts = this.defaultNumberOfParts();
        this.colorBar = null;
    }

    public int numberOfParts() {
        return this.numberOfParts;
    }

    public void numberOfParts_(int n) {
        this.numberOfParts = n;
        this.fluxModel = null;
    }

    public JunColorBarCMY colorBar() {
        if (this.colorBar == null) {
            this.colorBar = this.makeColorBar();
        }
        return this.colorBar;
    }

    protected int defaultNumberOfParts() {
        return 11;
    }

    protected List defaultFramesOfStages() {
        int n = this.numberOfParts() * 3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(this.defaultFramesOfStage()));
        }
        return arrayList;
    }

    protected int defaultFramesOfStage() {
        return 10;
    }

    protected Jun3dPoint defaultEyePoint() {
        return new Jun3dPoint(0.0, (double)this.numberOfParts() / Math.sqrt(2.0), this.numberOfParts() * 100);
    }

    protected Jun3dPoint defaultSightPoint() {
        return new Jun3dPoint(0.0, (double)this.numberOfParts() / Math.sqrt(2.0), 0.0);
    }

    protected double defaultZoomHeight() {
        return (double)this.numberOfParts() * 5.0;
    }

    protected JunOpenGLFluxModel makeFluxModel() {
        JunOpenGLFluxObject junOpenGLFluxObject = new JunOpenGLFluxObject();
        for (int i = 1; i <= this.numberOfParts(); ++i) {
            junOpenGLFluxObject.addMutable_(this.cube_(i));
        }
        return new JunOpenGLFluxModel(junOpenGLFluxObject);
    }

    protected JunColorBarCMY makeColorBar() {
        JunColorBarCMY junColorBarCMY = new JunColorBarCMY();
        junColorBarCMY.firstMarker_(0.0);
        junColorBarCMY.lastMarker_(1.0);
        junColorBarCMY.value_(0.0);
        junColorBarCMY.cyanBounds_(new double[]{0.0, 1.0});
        junColorBarCMY.magentaBounds_(new double[]{0.0, 1.0});
        junColorBarCMY.yellowBounds_(new double[]{0.0, 1.0});
        return junColorBarCMY;
    }

    protected JunOpenGLFluxMutableObject cube_(int n) {
        JunOpenGL3dObject junOpenGL3dObject = this.baseCube();
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(new Jun3dPoint(n, n, 1 + this.numberOfParts() - n));
        this.colorBar().value_((double)n / (double)this.numberOfParts());
        junOpenGL3dObject.paint_(this.colorBar().color());
        JunOpenGLFluxMutableObject junOpenGLFluxMutableObject = new JunOpenGLFluxMutableObject(junOpenGL3dObject);
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, (double)this.numberOfParts() * Math.sqrt(2.0) * 4.0, 0.0);
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, (double)this.numberOfParts() * Math.sqrt(2.0) - 1.0, 0.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, 0.0, 0.0);
        int n2 = 1 + this.numberOfParts() - n;
        Jun3dTransformation[] jun3dTransformationArray = null;
        for (int i = 1; i <= this.numberOfStages(); ++i) {
            int n3 = (i - 1) / 3 + 1;
            int n4 = i % 3;
            if (n3 < n2) {
                jun3dTransformationArray = this.transformationsFrom_to_step_(jun3dPoint, jun3dPoint, this.framesOfStageAt_(i));
            } else if (n3 == n2) {
                if (n4 == 1) {
                    jun3dTransformationArray = this.transformationsFrom_to_step_(jun3dPoint, jun3dPoint2, this.framesOfStageAt_(i));
                } else if (n4 == 2) {
                    jun3dTransformationArray = this.transformationsFrom_to_step_(jun3dPoint2, jun3dPoint2, this.framesOfStageAt_(i));
                } else if (n4 == 0) {
                    jun3dTransformationArray = this.transformationsFrom_to_step_(jun3dPoint2, jun3dPoint3, this.framesOfStageAt_(i));
                }
            } else if (n3 > n2) {
                jun3dTransformationArray = this.transformationsFrom_to_step_(jun3dPoint3, jun3dPoint3, this.framesOfStageAt_(i));
            }
            for (int j = 0; j < jun3dTransformationArray.length; ++j) {
                junOpenGLFluxMutableObject.add_(jun3dTransformationArray[j]);
            }
        }
        return junOpenGLFluxMutableObject;
    }

    protected JunOpenGL3dObject baseCube() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Cube();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(45.0));
        junOpenGL3dObject = junOpenGL3dObject.transform_(jun3dTransformation);
        return junOpenGL3dObject;
    }
}

