/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.flux;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.goodies.animation.JunCartoonMovie;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.track.JunTrackerModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxObject;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxViewAwt;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxViewSwing;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunOpenGLFluxModel
extends JunOpenGLDisplayModel {
    protected JunOpenGLFluxObject fluxObject;
    protected JunTrackerModel trackerModel;
    protected int framesPerSecond;

    public JunOpenGLFluxModel() {
    }

    public JunOpenGLFluxModel(JunOpenGLFluxObject junOpenGLFluxObject) {
        this();
        this.fluxObject_(junOpenGLFluxObject);
    }

    protected void initialize() {
        super.initialize();
        this.fluxObject = null;
        this.trackerModel = null;
        this.framesPerSecond = this.defaultFramesPerSecond();
    }

    public void release() {
        this.trackerModel().end();
    }

    public JunOpenGLFluxObject fluxObject() {
        return this.fluxObject;
    }

    public void fluxObject_(JunOpenGLFluxObject junOpenGLFluxObject) {
        this.fluxObject = junOpenGLFluxObject;
        if (this.fluxObject.size() - 1 <= 0) {
            this.trackerModel().step_(0.0);
        } else {
            this.trackerModel().step_(1.0 / (double)(this.fluxObject.size() - 1));
        }
        this.trackerModel().first();
    }

    public int framesPerSecond() {
        return this.framesPerSecond;
    }

    public void framesPerSecond_(int n) {
        this.framesPerSecond = n;
    }

    public JunOpenGL3dCompoundObject compoundObject() {
        return this.fluxObject().compoundObject();
    }

    public int tickTime() {
        return Math.round(1000.0f / (float)this.framesPerSecond());
    }

    public JunTrackerModel trackerModel() {
        if (this.trackerModel == null) {
            this.trackerModel = new JunTrackerModel();
            this.trackerModel.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    final double d = ((Number)object).doubleValue();
                    if (JunOpenGLFluxModel.this.fluxObject() != null) {
                        JunOpenGLFluxModel.this.do_framesPerSecond_(new StBlockClosure(){

                            public Object value() {
                                JunOpenGLFluxModel.this.displayObject_((this).JunOpenGLFluxModel.this.fluxObject.at_(d));
                                JunOpenGLFluxModel.this.changed_(1.$((String)"object"));
                                return null;
                            }
                        }, JunOpenGLFluxModel.this.framesPerSecond());
                        Thread.yield();
                    }
                    return null;
                }
            });
        }
        return this.trackerModel;
    }

    public void start() {
        this.trackerModel().start();
    }

    public void end() {
        this.trackerModel().end();
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.fluxObject() == null) {
            return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        }
        return this.fluxObject().boundingBox();
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        if (this.fluxObject() == null) {
            super.pointsDo_(stBlockClosure);
        } else {
            this.fluxObject().pointsDo_(stBlockClosure);
        }
    }

    protected String windowTitle() {
        return JunOpenGLFluxModel.$String((String)"Flux");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        this.release();
    }

    public void updateFileMenuIndication() {
        super.updateFileMenuIndication();
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGLFluxModel.$((String)"fileMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunOpenGLFluxModel.$((String)"saveMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLFluxModel.$((String)"saveAsImagesMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLFluxModel.$((String)"saveAsMovieMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void updateMiscMenuIndication() {
        super.updateMiscMenuIndication();
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGLFluxModel.$((String)"miscMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunOpenGLFluxModel.$((String)"convertToAnimationMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void openLFT() {
        this.openLFT10();
    }

    public void openLFT10() {
        JunOpenGLFluxObject junOpenGLFluxObject;
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLFluxModel.$String((String)"<1p> files", null, (Object)"LFT"), new String[]{"*.lft", "*.LFT"})};
        File file = JunFileRequesterDialog.Request(JunOpenGLFluxModel.$String((String)"Select an <1p> file.", null, (Object)"LFT"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            junOpenGLFluxObject = this.readFromLFT10_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        if (junOpenGLFluxObject == null) {
            return;
        }
        this.fluxObject_(junOpenGLFluxObject);
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void saveLFT() {
        this.saveLFT10();
    }

    public void saveLFT10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLFluxModel.$String((String)"<1p> files", null, (Object)"LFT"), new String[]{"*.lft", "*.LFT"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLFluxModel.$String((String)"Input an <1p> file.", null, (Object)"LFT"), new File(this.fluxObject().name() + ".lft"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToLFT10_object_(file, this.fluxObject());
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveAsImages() {
        if (this.fluxObject() == null) {
            return;
        }
        this.end();
        File file = JunFileRequesterDialog.RequestNewDirectory(JunOpenGLFluxModel.$String((String)"Input a directory name."), new File(this.displayObject().name()));
        if (file == null) {
            return;
        }
        this.saveAsImagesTo_(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAsImagesTo_(File file) {
        if (!file.exists()) {
            file.mkdir();
        }
        Thread.yield();
        StSymbol stSymbol = this.trackerModel().loopCondition();
        double d = this.trackerModel().doubleValue();
        this.trackerModel().loopCondition_(JunOpenGLFluxModel.$((String)"oneWay"));
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            this.trackerModel().playButtonVisual_(true);
            this.trackerModel().first();
            int n = 1;
            while (this.trackerModel().playButton().value()) {
                String string = "0000" + n;
                string = string.substring(string.length() - 4);
                File file2 = new File(file, string + ".jpg");
                StImage stImage = this.asImage();
                JunCursors junCursors2 = new JunCursors(JunCursors.WriteCursor());
                JunImageStream junImageStream = null;
                try {
                    junCursors2._show();
                    junImageStream = JunJpegImageStream.On_(new FileOutputStream(file2));
                    junImageStream.nextPutImage_(stImage);
                }
                catch (IOException iOException) {
                    throw new SmalltalkException((Exception)iOException);
                }
                finally {
                    if (junImageStream != null) {
                        try {
                            junImageStream.flush();
                            junImageStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            junImageStream = null;
                        }
                    }
                    junCursors2._restore();
                }
                this.trackerModel().next();
                Thread.yield();
                ++n;
            }
            this.trackerModel().playButtonVisual_(false);
        }
        finally {
            this.trackerModel().loopCondition_(stSymbol);
            this.trackerModel().value_(d);
            junCursors._restore();
        }
    }

    public void saveAsMovie() {
        JunMoviePlayer junMoviePlayer;
        if (this.fluxObject() == null) {
            return;
        }
        this.end();
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLFluxModel.$String((String)"<1p> files", null, (Object)JunOpenGLFluxModel.$String((String)"Movie")), new String[]{"*.mov", "*.MOV"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLFluxModel.$String((String)"Input a <1p> file.", null, (Object)JunOpenGLFluxModel.$String((String)"Movie")), new File(this.displayObject().name() + ".mov"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        if (this.saveAsMovieTo_(file) && (junMoviePlayer = new JunMoviePlayer(file)) != null) {
            junMoviePlayer.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveAsMovieTo_(File file) {
        if (file == null) {
            return false;
        }
        Thread.yield();
        StSymbol stSymbol = this.trackerModel().loopCondition();
        double d = this.trackerModel().doubleValue();
        this.trackerModel().loopCondition_(JunOpenGLFluxModel.$((String)"oneWay"));
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            this.trackerModel().playButtonVisual_(true);
            this.trackerModel().first();
            Dimension dimension = this.defaultImageExtent();
            JunImagesToMovie.File_extent_do_(file, dimension, new StBlockClosure(){

                public Object value_(Object object) {
                    while (JunOpenGLFluxModel.this.trackerModel().playButton().value()) {
                        StImage stImage = JunOpenGLFluxModel.this.asImage();
                        ((JunImagesToMovie)((Object)object)).add_milliseconds_(stImage, JunOpenGLFluxModel.this.tickTime());
                        JunOpenGLFluxModel.this.trackerModel().next();
                        Thread.yield();
                    }
                    return null;
                }
            });
            this.trackerModel().playButtonVisual_(false);
        }
        finally {
            this.trackerModel().loopCondition_(stSymbol);
            this.trackerModel().value_(d);
            junCursors._restore();
        }
        return true;
    }

    public void spawnObject() {
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel(this.spawningObject());
        junOpenGLDisplayModel.displayProjection_((JunOpenGLProjection)this.displayProjection().copy());
        StView stView = this.getView();
        if (stView == null) {
            junOpenGLDisplayModel.open();
        } else {
            StRectangle stRectangle = new StRectangle(stView.topComponent().getBounds());
            StRectangle stRectangle2 = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
            stRectangle2 = stRectangle2.align_with_(stRectangle2.topLeft(), new Point(stRectangle.right() + 5, stRectangle.top()));
            junOpenGLDisplayModel.openIn_(stRectangle2.toRectangle());
        }
        junOpenGLDisplayModel.changed_(JunOpenGLFluxModel.$((String)"object"));
    }

    public void convertToAnimation() {
        String string = JunDialog.Request_(JunOpenGLFluxModel.$String((String)"Input the interval milliseconds."), String.valueOf(100));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            this.convertToAnimation_(n);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunOpenGLFluxModel.$String((String)" is invalid value."));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertToAnimation_(int n) {
        JunCartoonMovie junCartoonMovie = new JunCartoonMovie();
        int n2 = Math.max(n, junCartoonMovie.tickTime());
        File file = new File(this.defaultBaseName());
        this.saveAsImagesTo_(file);
        File[] fileArray = file.listFiles();
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                JunImageStream junImageStream = null;
                try {
                    junImageStream = JunJpegImageStream.On_(new FileInputStream(fileArray[i]));
                    StImage stImage = junImageStream.nextImage();
                    junCartoonMovie.addImage_keepTime_(stImage, n2);
                    continue;
                }
                finally {
                    if (junImageStream != null) {
                        junImageStream.close();
                        junImageStream = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        finally {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
            file.delete();
        }
        junCartoonMovie.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGLFluxObject readFromLFT10_(File file) throws IOException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        JunOpenGLFluxObject junOpenGLFluxObject = null;
        try {
            junOpenGLFluxObject = this.loadFromLFT10_(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
        return junOpenGLFluxObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGLFluxObject loadFromLFT10_(BufferedReader bufferedReader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JunOpenGLFluxObject junOpenGLFluxObject = null;
        try {
            int n;
            while ((n = bufferedReader.read()) > 0) {
                stringWriter.write(n);
            }
            stringWriter.flush();
            junOpenGLFluxObject = JunOpenGLFluxObject.LoadFrom_(stringWriter.toString());
        }
        finally {
            stringWriter.close();
        }
        return junOpenGLFluxObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToLFT10_object_(File file, JunOpenGLFluxObject junOpenGLFluxObject) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToLFT10_object_(bufferedWriter, junOpenGLFluxObject);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    public void saveToLFT10_object_(BufferedWriter bufferedWriter, JunOpenGLFluxObject junOpenGLFluxObject) throws IOException {
        bufferedWriter.write(this.defaultStampForLFT10());
        junOpenGLFluxObject.saveOn_(bufferedWriter);
    }

    public StView defaultView() {
        if (JunOpenGLFluxModel.GetDefaultViewMode() == 0) {
            return new JunOpenGLFluxViewAwt(this);
        }
        return new JunOpenGLFluxViewSwing(this);
    }

    public String defaultStampForLFT10() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("% LFT V1.0 List Flux Transmission (Lisp S Expression)");
        printWriter.println("% This file was created by " + JunSystem.System() + JunSystem.Version());
        printWriter.println("% " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    protected int defaultFramesPerSecond() {
        return 15;
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGLFluxModel.$String((String)"File"), JunOpenGLFluxModel.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"New"), (MenuListener)new MenuPerformer((StObject)this, "newModel")));
        stMenu.add(new StMenuItem((Object)(JunOpenGLFluxModel.$String((String)"Open") + "..."), (MenuListener)new MenuPerformer((StObject)this, "openLFT")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)(JunOpenGLFluxModel.$String((String)"Save") + "..."), (MenuListener)new MenuPerformer((StObject)this, "saveLFT")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Save as image..."), JunOpenGLFluxModel.$((String)"saveAsImageMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveAsImage")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Save as images..."), JunOpenGLFluxModel.$((String)"saveAsImagesMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveAsImages")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Save as movie..."), JunOpenGLFluxModel.$((String)"saveAsMovieMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveAsMovie")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGLFluxModel.$String((String)"Misc"), JunOpenGLFluxModel.$((String)"miscMenu"));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Spawn"), JunOpenGLFluxModel.$((String)"spawnMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnObject")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Viewport"), JunOpenGLFluxModel.$((String)"viewportMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnViewport")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Bounds"), JunOpenGLFluxModel.$((String)"boundsMenu"), (MenuListener)new MenuPerformer((StObject)this, "showBounds")));
        stMenu.add(new StMenuItem((Object)JunOpenGLFluxModel.$String((String)"Convert to animation..."), JunOpenGLFluxModel.$((String)"convertToAnimationMenu"), (MenuListener)new MenuPerformer((StObject)this, "convertToAnimation")));
        return stMenu;
    }

    protected Jun3dPoint computeSightPoint() {
        if (this.selectedObjects().isEmpty()) {
            if (StInputState.Default().altDown()) {
                return this.displayObject().boundingBox().center();
            }
            return this.fluxObject().boundingBox().center();
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.selectedObjects().toArray(new JunOpenGL3dObject[this.selectedObjects().size()]);
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            jun3dPoint = jun3dPoint.plus_(junOpenGL3dObjectArray[i].boundingBox().center());
        }
        return jun3dPoint.dividedBy_(junOpenGL3dObjectArray.length);
    }

    protected double computeZoomHeight() {
        final double[] dArray = new double[2];
        double d = this.displayProjection().distance();
        Jun3dPoint jun3dPoint = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, -1.0), d);
        Jun3dPoint jun3dPoint2 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, 1.0), d);
        Jun3dPoint jun3dPoint3 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(1.0, 0.0), d);
        Jun3dPoint jun3dPoint4 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(-1.0, 0.0), d);
        final JunPlane junPlane = new JunPlane(this.displayProjection().eyePoint(), jun3dPoint4, jun3dPoint3);
        final JunPlane junPlane2 = new JunPlane(this.displayProjection().eyePoint(), jun3dPoint, jun3dPoint2);
        this.displayObject().pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                dArray[0] = Math.max(dArray[0], junPlane2.distanceFromPoint_(jun3dPoint));
                dArray[1] = Math.max(dArray[1], junPlane.distanceFromPoint_(jun3dPoint));
                return null;
            }
        });
        double d2 = Math.max(dArray[0], dArray[1]);
        StView stView = this.getView();
        if (stView != null && dArray[0] != 0.0 && dArray[1] != 0.0) {
            Rectangle rectangle = stView.toComponent().getBounds();
            if (rectangle.height != 0) {
                d2 = dArray[1] * (double)rectangle.width / (double)rectangle.height < dArray[0] ? dArray[0] * (double)rectangle.height / (double)rectangle.width : dArray[1];
            }
        }
        return d2 *= this.defaultZoomHeightFactor();
    }
}

