/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.chart.JunChartAbstract;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

public abstract class JunChartWithSymbolicKeys
extends JunChartAbstract {
    public static final double DefaultLeftMargin = 0.05;
    public static final double DefaultRightMargin = 0.05;
    public static final double DefaultInterval = 0.05;
    protected double leftMargin;
    protected double rightMargin;
    protected double interval;

    protected JunChartWithSymbolicKeys() {
    }

    protected JunChartWithSymbolicKeys(Vector vector) {
        super(vector);
    }

    protected JunChartWithSymbolicKeys(Vector vector, int n) {
        super(vector, n);
    }

    protected JunChartWithSymbolicKeys(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.leftMargin = 0.05;
        this.rightMargin = 0.05;
        this.interval = 0.05;
    }

    public double leftMargin() {
        return this.leftMargin;
    }

    public void leftMargin_(double d) {
        this.leftMargin = d;
    }

    public double rightMargin() {
        return this.rightMargin;
    }

    public void rightMargin_(double d) {
        this.rightMargin = d;
    }

    public double interval() {
        return this.interval;
    }

    public void interval_(double d) {
        this.interval = d;
    }

    protected void _copyAttributes(JunChartWithSymbolicKeys junChartWithSymbolicKeys) {
        super._copyAttributes(junChartWithSymbolicKeys);
        junChartWithSymbolicKeys.leftMargin_(this.leftMargin);
        junChartWithSymbolicKeys.rightMargin_(this.rightMargin);
        junChartWithSymbolicKeys.interval_(this.interval);
    }

    protected JunOpenGL3dObject createXAxisLabels() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        int n = this.data().sheet().rowSize();
        double d = (1.0 - this.leftMargin() - this.rightMargin() - this.interval() * (double)(n - 1)) / (double)n;
        double d2 = this.leftMargin() + d / 2.0;
        for (int i = 0; i < n; ++i) {
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(d2, 0.0, 0.0), new Jun3dPoint(d2, -0.05, 0.0)};
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(jun3dPointArray, this.axisColor()));
            junOpenGL3dCompoundObject.add_(this.label_topCenterAt_(this.xAxisLabels()[i], new Jun3dPoint(d2, -0.05, 0.0)));
            d2 += d + this.interval();
        }
        return junOpenGL3dCompoundObject;
    }
}

