/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.chart.JunChartAbstract;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.smalltalk.SmalltalkException;

public abstract class JunChartWithRoundShape
extends JunChartAbstract {
    public static final double DefaultRadius = 0.5;
    protected double radius;
    protected JunOpenGL3dObject axes;

    protected JunChartWithRoundShape() {
    }

    protected JunChartWithRoundShape(Vector vector) {
        super(vector);
    }

    protected JunChartWithRoundShape(Vector vector, int n) {
        super(vector, n);
    }

    protected JunChartWithRoundShape(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.radius = 0.5;
        this.axes = null;
    }

    public double radius() {
        return this.radius;
    }

    public void radius_(double d) {
        this.radius = d;
    }

    public JunOpenGL3dObject axes() {
        return this.axes;
    }

    public void hideAxes() {
        this.axes = null;
        this.flushDisplayObject();
        this.changed_(JunChartWithRoundShape.$((String)"object"));
    }

    public void showAxes() {
        this.axes = this.createAxes();
        this.flushDisplayObject();
        this.changed_(JunChartWithRoundShape.$((String)"object"));
    }

    public void showAxesWithLabels() {
        this.axes = new JunOpenGL3dCompoundObject(this.createAxes(), this.createAxesLabels());
        this.flushDisplayObject();
        this.changed_(JunChartWithRoundShape.$((String)"object"));
    }

    public void showXAxis() {
    }

    public void showXAxisWithLabels() {
    }

    public void showYAxis() {
    }

    public void showYAxisWithLabels() {
    }

    public void showZAxis() {
    }

    public boolean hasAxes() {
        return this.axes() != null;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = this.createChart3dObject();
        if (this.hasZAxis()) {
            junOpenGL3dCompoundObject.add_(this.zAxis());
        }
        if (this.hasAxes()) {
            junOpenGL3dCompoundObject.add_(this.axes());
        }
        if (this.extra3dObjects() != null) {
            junOpenGL3dCompoundObject.addAll_(this.extra3dObjects());
        }
        return junOpenGL3dCompoundObject;
    }

    protected void _copyAttributes(JunChartWithRoundShape junChartWithRoundShape) {
        super._copyAttributes(junChartWithRoundShape);
        junChartWithRoundShape.radius_(this.radius);
        if (this.hasAxes()) {
            junChartWithRoundShape.showAxes();
        } else {
            junChartWithRoundShape.hideAxes();
        }
    }

    protected Color[] defaultColors() {
        if (this.samples() == null) {
            return super.defaultColors();
        }
        return this.defaultColors_(this.data().sheet().rowSize());
    }

    protected void flushAxes() {
        super.flushAxes();
        this.axes = null;
    }

    protected JunOpenGL3dObject createAxes() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.name_("round axes");
        int n = this.data().sheet().rowSize();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0)};
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dPolyline(jun3dPointArray).asCompoundObject();
        for (int i = 0; i < n; ++i) {
            junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2.rotatedBy_(JunAngle.FromRad_(Math.PI * 2 * (double)i / (double)n)));
        }
        junOpenGL3dCompoundObject.paint_(this.axisColor());
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createAxesLabels() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dObject junOpenGL3dObject = super.createYAxisLabels();
        int n = this.data().sheet().rowSize();
        for (int i = 0; i < n; ++i) {
            junOpenGL3dCompoundObject.add_(junOpenGL3dObject.rotatedBy_(JunAngle.FromRad_(Math.PI * 2 * (double)i / (double)n)));
        }
        junOpenGL3dCompoundObject.paint_(this.axisColor());
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createXAxis() {
        throw new SmalltalkException("should not implement");
    }

    protected JunOpenGL3dObject createXAxisLabels() {
        throw new SmalltalkException("should not implement");
    }

    protected JunOpenGL3dObject createYAxis() {
        throw new SmalltalkException("should not implement");
    }

    protected JunOpenGL3dObject createYAxisLabels() {
        throw new SmalltalkException("should not implement");
    }
}

