/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.awt.Point;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.icon.JunOpaqueImageIcons;
import jp.co.sra.jun.goodies.utilities.JunFileUtility;
import jp.co.sra.jun.graphics.framework.JunGraphicModel;
import jp.co.sra.jun.graphics.framework.JunGraphicView;
import jp.co.sra.jun.graphics.list.JunFileList;
import jp.co.sra.jun.graphics.navigator.JunEmbeddedCenterFileList;
import jp.co.sra.jun.graphics.navigator.JunEmbeddedLeftFileList;
import jp.co.sra.jun.graphics.navigator.JunEmbeddedRightFileList;
import jp.co.sra.jun.graphics.navigator.JunFileNavigatorViewAwt;
import jp.co.sra.jun.graphics.navigator.JunFileNavigatorViewSwing;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunFileNavigator
extends JunGraphicModel {
    protected JunEmbeddedCenterFileList centerList;
    protected JunEmbeddedLeftFileList leftList;
    protected JunEmbeddedRightFileList rightList;
    protected LinkedList accessHistory;
    protected StValueHolder currentFileHolder;
    protected File homeDirectory;
    protected JunButtonModel homeButton;
    protected StBlockClosure computeBlock;
    protected static Map Icon16x16Table;
    protected static Map Icon64x64Table;

    public static void FlushIconTables() {
        Icon16x16Table = null;
        Icon64x64Table = null;
    }

    public static Map Icon16x16Table() {
        if (Icon16x16Table == null) {
            int n;
            Icon16x16Table = new HashMap();
            String[] stringArray = JunSystem.DefaultTextExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon16x16Table.put(stringArray[n], JunOpaqueImageIcons.Text16x16());
            }
            stringArray = JunSystem.DefaultImageExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon16x16Table.put(stringArray[n], JunOpaqueImageIcons.Image16x16());
            }
            stringArray = JunSystem.DefaultMovieExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon16x16Table.put(stringArray[n], JunOpaqueImageIcons.Movie16x16());
            }
            stringArray = JunSystem.DefaultSoundExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon16x16Table.put(stringArray[n], JunOpaqueImageIcons.Sound16x16());
            }
            stringArray = JunSystem.DefaultBodyExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon16x16Table.put(stringArray[n], JunOpaqueImageIcons.Body16x16());
            }
        }
        return Icon16x16Table;
    }

    public static Map Icon64x64Table() {
        if (Icon64x64Table == null) {
            int n;
            Icon64x64Table = new HashMap();
            String[] stringArray = JunSystem.DefaultTextExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon64x64Table.put(stringArray[n], JunOpaqueImageIcons.Text64x64());
            }
            stringArray = JunSystem.DefaultImageExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon64x64Table.put(stringArray[n], JunOpaqueImageIcons.Image64x64());
            }
            stringArray = JunSystem.DefaultMovieExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon64x64Table.put(stringArray[n], JunOpaqueImageIcons.Movie64x64());
            }
            stringArray = JunSystem.DefaultSoundExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon64x64Table.put(stringArray[n], JunOpaqueImageIcons.Sound64x64());
            }
            stringArray = JunSystem.DefaultBodyExtensions();
            for (n = 0; n < stringArray.length; ++n) {
                Icon64x64Table.put(stringArray[n], JunOpaqueImageIcons.Body64x64());
            }
        }
        return Icon64x64Table;
    }

    public static StOpaqueImage ImageFileIconFromFile_(File file) {
        StOpaqueImage stOpaqueImage = null;
        if (file.getParentFile() == null) {
            stOpaqueImage = JunOpaqueImageIcons.Drive16x16();
        } else if (file.isDirectory()) {
            stOpaqueImage = JunOpaqueImageIcons.FolderClose16x16();
        } else {
            String string = JunFileUtility.ExtensionStringOf_(file);
            string = string == null ? "" : string.toLowerCase();
            stOpaqueImage = (StOpaqueImage)JunFileNavigator.Icon16x16Table().get(string);
            if (stOpaqueImage == null) {
                stOpaqueImage = JunOpaqueImageIcons.Other16x16();
            }
        }
        return stOpaqueImage;
    }

    public static StOpaqueImage ImageInfoIconFromFile_(File file) {
        StOpaqueImage stOpaqueImage = null;
        if (file.isDirectory()) {
            stOpaqueImage = JunOpaqueImageIcons.FolderClose64x64();
        } else {
            String string = JunFileUtility.ExtensionStringOf_(file);
            string = string == null ? "" : string.toLowerCase();
            stOpaqueImage = (StOpaqueImage)JunFileNavigator.Icon64x64Table().get(string);
            if (stOpaqueImage == null) {
                stOpaqueImage = JunOpaqueImageIcons.Other64x64();
            }
        }
        return stOpaqueImage;
    }

    public JunFileNavigator() {
    }

    public JunFileNavigator(File file) {
        this();
        this.currentFile_(file);
    }

    protected void initialize() {
        super.initialize();
        this.centerList = null;
        this.leftList = null;
        this.rightList = null;
        this.accessHistory = null;
        this.currentFileHolder = null;
        this.homeDirectory = null;
        this.homeButton = null;
        this.computeBlock = null;
    }

    public JunEmbeddedCenterFileList centerList() {
        if (this.centerList == null) {
            JunEmbeddedCenterFileList junEmbeddedCenterFileList = new JunEmbeddedCenterFileList();
            junEmbeddedCenterFileList.currentFile_(null);
            junEmbeddedCenterFileList.nullItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.centerNullItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedCenterFileList.fileItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.centerFileItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedCenterFileList.directoryItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.centerDirectoryItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedCenterFileList.fileNavigator_(this);
            this.centerList = junEmbeddedCenterFileList;
        }
        return this.centerList;
    }

    public JunEmbeddedLeftFileList leftList() {
        if (this.leftList == null) {
            JunEmbeddedLeftFileList junEmbeddedLeftFileList = new JunEmbeddedLeftFileList();
            junEmbeddedLeftFileList.nullItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.leftNullItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedLeftFileList.fileItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.leftFileItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedLeftFileList.directoryItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.leftDirectoryItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedLeftFileList.fileNavigator_(this);
            this.leftList = junEmbeddedLeftFileList;
        }
        return this.leftList;
    }

    public JunEmbeddedRightFileList rightList() {
        if (this.rightList == null) {
            JunEmbeddedRightFileList junEmbeddedRightFileList = new JunEmbeddedRightFileList();
            junEmbeddedRightFileList.currentFile_(JunFileList._RootFile);
            junEmbeddedRightFileList.nullItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.rightNullItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedRightFileList.fileItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.rightFileItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedRightFileList.directoryItemBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.rightDirectoryItemPressed_((File)object);
                    return null;
                }
            });
            junEmbeddedRightFileList.fileNavigator_(this);
            this.rightList = junEmbeddedRightFileList;
        }
        return this.rightList;
    }

    public File currentFile() {
        return (File)this.currentFileHolder().value();
    }

    protected String currentFileAsString() {
        if (this.currentFile() == null) {
            return "";
        }
        String string = this.currentFile().getPath();
        if (this.currentFile().isDirectory() && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public void currentFile_(File file) {
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7;
        if (file == null || !file.exists()) {
            return;
        }
        if (JunFileList._RootFile.equals(file)) {
            file7 = null;
            file6 = null;
            file5 = null;
            file4 = null;
            file3 = JunFileList._RootFile;
            file2 = null;
        } else if (Arrays.asList(JunFileList._RootFiles()).contains(file)) {
            file7 = null;
            file6 = null;
            file5 = JunFileList._RootFile;
            file4 = file;
            file3 = file;
            file2 = null;
        } else {
            file7 = file.getParentFile().getParentFile();
            if (file7 == null) {
                file7 = JunFileList._RootFile;
            }
            file6 = file.getParentFile();
            file5 = file.getParentFile();
            file4 = file;
            file3 = file;
            file2 = null;
        }
        this.leftListFile_selectedFile_scrollOffset_(file7, file6, new Point(0, 0));
        this.centerListFile_selectedFile_scrollOffset_(file5, file4, new Point(0, 0));
        this.rightListFile_selectedFile_scrollOffset_(file3, file2, new Point(0, 0));
        this.checkFile_(null);
        this.centerDirectoryItemPressed_(this.centerList().selectedFile());
        this.fixScrollingOffset();
    }

    protected String currentStatus() {
        if (this.currentFile() != null && this.currentFile().isFile()) {
            return "";
        }
        if (this.isCurrentFileInaccessibleDirectory()) {
            return "access denied";
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        File[] fileArray = this.rightList().currentContents();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getParent() == null) {
                ++n;
                continue;
            }
            if (fileArray[i].isDirectory()) {
                ++n2;
                continue;
            }
            if (!fileArray[i].isFile()) continue;
            ++n3;
        }
        String string = "";
        if (n > 0) {
            string = string + n;
            string = string + (n == 1 ? " drive" : " drives");
        }
        if (n2 > 0) {
            if (string.length() > 0) {
                string = string + " and ";
            }
            string = string + n2;
            string = string + (n2 == 1 ? " directory" : " directories");
        }
        if (n3 > 0) {
            if (string.length() > 0) {
                string = string + " and ";
            }
            string = string + n3;
            string = string + (n3 == 1 ? " file" : " files");
        }
        return string;
    }

    public boolean isLeftEnd() {
        return this.centerList().isNull() && this.rightList().isRoot();
    }

    public boolean isCurrentFileInaccessibleDirectory() {
        File file = this.currentFile();
        return file != null && file.isDirectory() && file.listFiles() == null;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return this.currentFileHolder().compute_(stBlockClosure);
    }

    public void distinctFolder_(boolean bl) {
        this.leftList().distinctFolder_(bl);
        this.centerList().distinctFolder_(bl);
        this.rightList().distinctFolder_(bl);
    }

    public void filePatterns_(String[] stringArray) {
        this.leftList().filePatterns_(stringArray);
        this.centerList().filePatterns_(stringArray);
        this.rightList().filePatterns_(stringArray);
    }

    public void sortKey_(StSymbol stSymbol) {
        this.leftList().sortKey_(stSymbol);
        this.centerList().sortKey_(stSymbol);
        this.rightList().sortKey_(stSymbol);
    }

    protected void centerNullItemPressed_(File file) {
    }

    protected void centerFileItemPressed_(File file) {
    }

    protected void centerDirectoryItemPressed_(File file) {
        if (file == null) {
            this.rightListFile_selectedFile_scrollOffset_(JunFileList._RootFile, null, new Point(0, 0));
            this.checkFile_(null);
            return;
        }
        this.memorizeIntoHistory();
        this.rightListFile_selectedFile_scrollOffset_(file, file.isDirectory() ? this.rightList().selectedFile() : null, new Point(0, 0));
        this.checkFile_(null);
    }

    protected void centerListFile_selectedFile_scrollOffset_(File file, File file2, Point point) {
        State state = this.recallFromHistory_(file, file2, point);
        this.centerList().currentFile_selectedFile_scrollOffset_(state.currentFile, state.selectedFile, state.scrollOffset);
    }

    protected void leftNullItemPressed_(File file) {
        this.rightListFile_selectedFile_scrollOffset_(this.centerList().currentFile(), this.centerList().selectedFile(), this.centerList().scrollOffset());
        this.centerListFile_selectedFile_scrollOffset_(null, null, new Point(0, 0));
        this.checkFile_(null);
    }

    protected void leftFileItemPressed_(File file) {
    }

    protected void leftDirectoryItemPressed_(File file) {
        State state;
        State state2;
        State state3;
        if (file == null) {
            this.centerListFile_selectedFile_scrollOffset_(null, null, new Point(0, 0));
            this.rightListFile_selectedFile_scrollOffset_(null, null, new Point(0, 0));
            this.checkFile_(null);
            return;
        }
        this.memorizeIntoHistory();
        if (file.isDirectory()) {
            if (this.leftList().isRoot()) {
                state3 = new State(null, null, new Point(0, 0));
                state2 = new State(this.leftList.currentFile(), file, this.leftList().scrollOffset());
                state = new State(file, this.centerList().selectedFile(), this.centerList().scrollOffset());
            } else {
                state = new State(file, this.centerList().selectedFile(), this.centerList().scrollOffset());
                state2 = new State(this.leftList().currentFile(), file, this.leftList().scrollOffset());
                state3 = new State(this.leftList().currentFile().getParentFile(), state2.currentFile, new Point(0, 0));
                if (Arrays.asList(JunFileList._RootFiles()).contains(file.getParentFile())) {
                    state3.currentFile = JunFileList._RootFile;
                }
            }
        } else {
            state = new State(file, null, this.centerList().scrollOffset());
            state2 = new State(file.getParentFile(), file, this.leftList().scrollOffset());
            state3 = new State(state2.currentFile.getParentFile(), state2.currentFile, new Point(0, 0));
            if (Arrays.asList(JunFileList._RootFiles()).contains(file.getParentFile())) {
                state3.currentFile = JunFileList._RootFile;
            }
        }
        this.leftListFile_selectedFile_scrollOffset_(state3.currentFile, state3.selectedFile, state3.scrollOffset);
        this.centerListFile_selectedFile_scrollOffset_(state2.currentFile, state2.selectedFile, state2.scrollOffset);
        this.rightListFile_selectedFile_scrollOffset_(state.currentFile, state.selectedFile, state.scrollOffset);
        this.checkFile_(null);
    }

    protected void leftListFile_selectedFile_scrollOffset_(File file, File file2, Point point) {
        State state = this.recallFromHistory_(file, file2, point);
        this.leftList().currentFile_selectedFile_scrollOffset_(state.currentFile, state.selectedFile, state.scrollOffset);
    }

    protected void rightNullItemPressed_(File file) {
    }

    protected void rightFileItemPressed_(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        this.rightList().currentFile_(file);
        this.rightList().changed_(JunFileNavigator.$((String)"redisplay"));
        this.checkFile_(file);
        if (this.computeBlock != null) {
            this.computeBlock.value_((Object)this.currentFile());
        }
    }

    protected void rightDirectoryItemPressed_(File file) {
        State state;
        State state2;
        State state3;
        if (file == null) {
            return;
        }
        this.memorizeIntoHistory();
        if (file.isDirectory()) {
            state3 = new State(file, null, new Point(0, 0));
            state2 = new State(this.rightList().currentFile(), file, this.rightList.scrollOffset());
            state = new State(null, this.centerList().selectedFile(), this.centerList().scrollOffset());
            state.currentFile = this.leftList() == null ? this.centerList().currentFile() : (state2.currentFile == null ? null : (Arrays.asList(JunFileList._RootFiles()).contains(state2.currentFile) ? JunFileList._RootFile : state2.currentFile.getParentFile()));
        } else {
            state3 = new State(file, null, new Point(0, 0));
            state2 = new State(file.getParentFile(), state3.currentFile, this.rightList().scrollOffset());
            state = new State(null, state2.currentFile, this.centerList().scrollOffset());
            state.currentFile = this.leftList() == null ? this.centerList().currentFile() : (Arrays.asList(JunFileList._RootFiles()).contains(state2.currentFile) ? JunFileList._RootFile : state2.currentFile.getParentFile());
        }
        this.leftListFile_selectedFile_scrollOffset_(state.currentFile, state.selectedFile, state.scrollOffset);
        this.centerListFile_selectedFile_scrollOffset_(state2.currentFile, state2.selectedFile, state2.scrollOffset);
        this.rightListFile_selectedFile_scrollOffset_(state3.currentFile, state3.selectedFile, state3.scrollOffset);
        this.checkFile_(null);
    }

    protected void rightListFile_selectedFile_scrollOffset_(File file, File file2, Point point) {
        State state = this.recallFromHistory_(file, file2, point);
        this.rightList().currentFile_selectedFile_scrollOffset_(state.currentFile, state.selectedFile, state.scrollOffset);
    }

    public JunButtonModel homeButton() {
        if (this.homeButton == null) {
            this.homeButton = new JunButtonModel(false, JunCursors.HomeCursorImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileNavigator.this.homeButtonAction();
                    return null;
                }
            });
        }
        return this.homeButton;
    }

    protected void homeButtonAction() {
        this.currentFile_(JunFileModel.DefaultDirectory());
    }

    protected LinkedList accessHistory() {
        if (this.accessHistory == null) {
            this.accessHistory = new LinkedList();
        }
        return this.accessHistory;
    }

    protected void memorizeIntoHistory() {
        this.memorizeIntoHistory_(new State(this.leftList().currentFile(), this.leftList().selectedFile(), this.leftList().scrollOffset()));
        this.memorizeIntoHistory_(new State(this.centerList().currentFile(), this.centerList().selectedFile(), this.centerList().scrollOffset()));
        this.memorizeIntoHistory_(new State(this.rightList().currentFile(), this.rightList().selectedFile(), this.rightList().scrollOffset()));
    }

    protected void memorizeIntoHistory_(State state) {
        if (state == null) {
            return;
        }
        if (state.currentFile == null) {
            return;
        }
        if (this.accessHistory().size() >= this.defaultHistorySize()) {
            this.accessHistory().removeLast();
        }
        this.accessHistory().addFirst(state);
    }

    protected State recallFromHistory_(File file, File file2, Point point) {
        State state;
        if ((file2 == null || new Point(0, 0).equals(point)) && (state = this.recallFromHistoryByKey_(file)) != null) {
            if (file2 == null) {
                file2 = state.selectedFile;
            }
            if (new Point(0, 0).equals(point)) {
                point = state.scrollOffset;
            }
        }
        return new State(file, file2, point);
    }

    protected State recallFromHistoryByKey_(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        State state = null;
        State[] stateArray = this.accessHistory().toArray(new State[this.accessHistory().size()]);
        for (int i = 0; i < stateArray.length; ++i) {
            if (!file.equals(stateArray[i].currentFile)) continue;
            state = stateArray[i];
            break;
        }
        if (state == null || state.selectedFile == null || !state.selectedFile.exists()) {
            return null;
        }
        return state;
    }

    protected StValueHolder currentFileHolder() {
        if (this.currentFileHolder == null) {
            this.currentFileHolder = new StValueHolder();
        }
        return this.currentFileHolder;
    }

    protected void updateCurrentFile() {
        File file;
        File file2 = this.centerList().currentFile();
        if (file2 != null && this.centerList().selectedFile() != null) {
            file2 = this.centerList().selectedFile();
        }
        if ((file = (File)this.currentFileHolder().value()) == null ? file2 == null : file.equals(file2)) {
            return;
        }
        this.currentFileHolder().value_((Object)file2);
        this.changed_with_(JunFileNavigator.$((String)"current file"), file2);
    }

    protected void checkFile_(File file) {
        this.updateCurrentFile();
    }

    public void fixScrollingOffset() {
        this.centerList().fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.centerList().getView(), false);
        this.leftList().fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.leftList().getView(), false);
        this.rightList().fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.rightList().getView(), false);
    }

    protected int defaultHistorySize() {
        return 256;
    }

    public StView defaultView() {
        if (JunFileNavigator.GetDefaultViewMode() == 0) {
            return new JunFileNavigatorViewAwt(this);
        }
        return new JunFileNavigatorViewSwing(this);
    }

    protected String windowTitle() {
        return JunFileNavigator.$String((String)"File Navigator");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        this.release();
    }

    class State {
        File currentFile;
        File selectedFile;
        Point scrollOffset;

        protected State(File file, File file2, Point point) {
            this.currentFile = file;
            this.selectedFile = file2;
            this.scrollOffset = point;
        }

        public String toString() {
            return "current:[" + this.currentFile + "] selected: [" + this.selectedFile + "] offset: " + this.scrollOffset;
        }
    }
}

