/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.list;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.goodies.calendar.JunCalendarModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.icon.JunOpaqueImageIcons;
import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.goodies.utilities.JunFileUtility;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.graphics.framework.JunGraphicView;
import jp.co.sra.jun.graphics.item.JunCompositeItem;
import jp.co.sra.jun.graphics.item.JunPrimitiveItem;
import jp.co.sra.jun.graphics.list.JunSequenceList;
import jp.co.sra.jun.graphics.map.JunSequenceMap;
import jp.co.sra.jun.graphics.navigator.JunFileListDispenser;
import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.SystemResourceSupport;
import jp.co.sra.smalltalk.menu.MenuDispatcher;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunFileList
extends JunSequenceList {
    protected File currentFile;
    protected long lastModified;
    protected String[] filePatterns;
    protected boolean showContents;
    protected File[] currentContents;
    protected StSymbol sortKey;
    protected boolean distinctFolder;
    protected StValueHolder selectedIndexHolder;
    protected StBlockClosure nullItemBlock;
    protected StBlockClosure fileItemBlock;
    protected StBlockClosure directoryItemBlock;
    protected JunAbstractItem.LookPreferences lookPreferences;
    protected StPopupMenu yellowButtonMenuForFile;
    protected StBlockClosure selectBlock;
    protected KeyListener _keyListener;
    public static final File _RootFile = new File(File.separator);
    protected static File[] _RootFiles = null;
    protected static HashMap _ComparatorTable;

    public JunFileList(File file) {
        this.currentFile_(file);
    }

    public static JunFileList Root() {
        return new JunFileList(_RootFile);
    }

    public static JunFileList Current() {
        return new JunFileList(new File("."));
    }

    public static JunFileList Null() {
        return new JunFileList(null);
    }

    public static File[] _RootFiles() {
        if (_RootFiles == null) {
            File[] fileArray = File.listRoots();
            if (fileArray.length == 1 && fileArray[0].isDirectory()) {
                fileArray = fileArray[0].listFiles();
            }
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].exists()) continue;
                arrayList.add(fileArray[i]);
            }
            _RootFiles = arrayList.toArray(new File[arrayList.size()]);
        }
        return _RootFiles;
    }

    protected static Map _ComparatorTable() {
        if (_ComparatorTable == null) {
            HashMap<StSymbol, Comparator> hashMap = new HashMap<StSymbol, Comparator>(8);
            hashMap.put(JunFileList.$((String)"nameUp"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((File)object).getName().compareTo(((File)object2).getName());
                }
            });
            hashMap.put(JunFileList.$((String)"nameDown"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((File)object2).getName().compareTo(((File)object).getName());
                }
            });
            hashMap.put(JunFileList.$((String)"dateUp"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return (int)(((File)object).lastModified() - ((File)object2).lastModified());
                }
            });
            hashMap.put(JunFileList.$((String)"dateDown"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return (int)(((File)object2).lastModified() - ((File)object).lastModified());
                }
            });
            hashMap.put(JunFileList.$((String)"sizeUp"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return (int)(((File)object).length() - ((File)object2).length());
                }
            });
            hashMap.put(JunFileList.$((String)"sizeDown"), new Comparator(){

                public int compare(Object object, Object object2) {
                    return (int)(((File)object2).length() - ((File)object).length());
                }
            });
            hashMap.put(JunFileList.$((String)"extensionUp"), new Comparator(){

                public int compare(Object object, Object object2) {
                    String string;
                    String string2 = JunFileUtility.ExtensionStringOf_((File)object);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = JunFileUtility.ExtensionStringOf_((File)object2)) == null) {
                        string = "";
                    }
                    return string2.compareTo(string);
                }
            });
            hashMap.put(JunFileList.$((String)"extensionDown"), new Comparator(){

                public int compare(Object object, Object object2) {
                    String string;
                    String string2 = JunFileUtility.ExtensionStringOf_((File)object);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = JunFileUtility.ExtensionStringOf_((File)object2)) == null) {
                        string = "";
                    }
                    return string.compareTo(string2);
                }
            });
            _ComparatorTable = hashMap;
        }
        return _ComparatorTable;
    }

    protected void initialize() {
        super.initialize();
        this.currentFile = null;
        this.lastModified = 0L;
        this.filePatterns = null;
        this.showContents = true;
        this.currentContents = null;
        this.sortKey = null;
        this.distinctFolder = true;
        this.selectedIndexHolder = null;
        this.nullItemBlock = null;
        this.fileItemBlock = null;
        this.directoryItemBlock = null;
        this.lookPreferences = null;
        this.yellowButtonMenuForFile = null;
        this.selectBlock = null;
        this._keyListener = null;
    }

    public File currentFile() {
        return this.currentFile;
    }

    public void currentFile_(File file) {
        if (file == null) {
            this.currentFile = null;
        } else if (file.exists()) {
            this.currentFile = file;
            this.lastModified = this.currentFile.lastModified();
        }
        JunFileList junFileList = JunFileListDispenser.Default().at_(this);
        if (junFileList == null) {
            this.sequenceMap = null;
            this.currentContents = null;
        } else {
            this.sequenceMap = junFileList.sequenceMap();
            this.currentContents = junFileList.currentContents();
            if (this.sequenceMap != null) {
                this.sequenceMap.allItemsDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        JunAbstractItem junAbstractItem = (JunAbstractItem)((Object)object);
                        junAbstractItem.emphasisState_(false);
                        junAbstractItem.lookPreferences_(JunFileList.this.lookPreferences());
                        return null;
                    }
                });
            }
        }
    }

    public File[] currentContents() {
        if (this.currentContents == null) {
            this.currentContents = this.privateCurrentContents();
            JunFileListDispenser.Default().add_(this);
        }
        return this.currentContents;
    }

    public File fileAt_(int n) {
        if (n < 0 || this.currentContents().length <= n) {
            return null;
        }
        return this.currentContents()[n];
    }

    public String[] filePatterns() {
        if (this.filePatterns == null) {
            this.filePatterns = new String[]{"*"};
        }
        return this.filePatterns;
    }

    public void filePatterns_(String[] stringArray) {
        if (Arrays.equals(this.filePatterns(), stringArray)) {
            return;
        }
        this.filePatterns = stringArray;
        this.resetAll();
    }

    public int indexOfFile_(File file) {
        if (file == null) {
            return 0;
        }
        if (!file.exists()) {
            return 0;
        }
        File[] fileArray = this.currentContents();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].equals(file)) continue;
            return i;
        }
        return -1;
    }

    public boolean showContents() {
        return this.showContents;
    }

    public void showContents_(boolean bl) {
        if (this.showContents() != bl) {
            this.showContents = bl;
            this.resetAll();
        }
    }

    public StSymbol sortKey() {
        if (this.sortKey == null) {
            this.sortKey = JunFileList.$((String)"nameUp");
        }
        return this.sortKey;
    }

    public void sortKey_(StSymbol stSymbol) {
        if (!Arrays.asList(JunFileList.$((String)"nameUp"), JunFileList.$((String)"nameDown"), JunFileList.$((String)"dateUp"), JunFileList.$((String)"dateDown"), JunFileList.$((String)"sizeUp"), JunFileList.$((String)"sizeDown"), JunFileList.$((String)"extensionUp"), JunFileList.$((String)"extensionDown")).contains(stSymbol)) {
            return;
        }
        if (this.sortKey() != stSymbol) {
            this.sortKey = stSymbol;
            this.resetAll();
        }
    }

    public boolean distinctFolder() {
        return this.distinctFolder;
    }

    public void distinctFolder_(boolean bl) {
        if (this.distinctFolder() != bl) {
            this.distinctFolder = bl;
            this.resetAll();
        }
    }

    public void currentFile_selectedFile_scrollOffset_(File file, File file2, Point point) {
        this.currentFile_(file);
        this.selectedFile_(file2);
        this.changed_(JunFileList.$((String)"redisplay"));
        this.scrollOffset_(point);
    }

    public boolean isNull() {
        return this.currentFile() == null;
    }

    public boolean isRoot() {
        if (this.isNull()) {
            return false;
        }
        return _RootFile.equals(this.currentFile());
    }

    public boolean isDirectory() {
        if (this.isNull()) {
            return false;
        }
        if (this.isRoot()) {
            return true;
        }
        if (!this.currentFile().exists()) {
            return false;
        }
        return this.currentFile().isDirectory();
    }

    public boolean isFile() {
        if (this.isNull()) {
            return false;
        }
        if (this.isRoot()) {
            return false;
        }
        if (!this.currentFile().exists()) {
            return false;
        }
        return this.currentFile().isFile();
    }

    public boolean filePatternsMatch_(File file) {
        String[] stringArray = this.filePatterns();
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"*".equals(stringArray[i])) continue;
            return true;
        }
        String string = file.getPath();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!JunStringUtility.StringMatch_and_(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunSequenceMap makeSequenceMap() {
        JunSequenceMap junSequenceMap = new JunSequenceMap();
        if (!this.isNull()) {
            if (this.isDirectory() && this.showContents()) {
                JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
                try {
                    junCursors._show();
                    File[] fileArray = this.currentContents();
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (!fileArray[i].exists()) continue;
                        JunCompositeItem junCompositeItem = this.makeFileItemFromFile_(fileArray[i]);
                        junSequenceMap.add_(junCompositeItem);
                    }
                }
                finally {
                    junCursors._restore();
                }
            } else {
                JunCompositeItem junCompositeItem = this.makeInfoItemFromFile_(this.currentFile());
                junSequenceMap.add_(junCompositeItem);
            }
            junSequenceMap.arrange();
        }
        junSequenceMap.allItemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunAbstractItem)((Object)object)).lookPreferences_(JunFileList.this.lookPreferences());
                return null;
            }
        });
        return junSequenceMap;
    }

    protected JunCompositeItem makeFileItemFromFile_(File file) {
        JunCompositeItem junCompositeItem = new JunCompositeItem(new Point(0, 0), new Point(200, this.lineGrid()));
        junCompositeItem.borderWidth_(1);
        junCompositeItem.borderColor_(junCompositeItem.BackgroundColor());
        junCompositeItem.emphasisState_(false);
        JunPrimitiveItem junPrimitiveItem = this.makeFileIconItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem2 = this.makeFileNameItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem3 = this.makeFileImageItemFromFile_(file);
        junCompositeItem.add_alignment_(junPrimitiveItem, JunFileList.$((String)"leftCenter"));
        junCompositeItem.add_alignment_with_alignment_offset_(junPrimitiveItem2, JunFileList.$((String)"leftCenter"), junPrimitiveItem, JunFileList.$((String)"rightCenter"), new Point(2, 0));
        junCompositeItem.add_alignment_(junPrimitiveItem3, JunFileList.$((String)"rightCenter"));
        return junCompositeItem;
    }

    protected JunPrimitiveItem makeFileIconItemFromFile_(File file) {
        StOpaqueImage stOpaqueImage = JunFileNavigator.ImageFileIconFromFile_(file);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), new Point(stOpaqueImage.figure().width() + 4, stOpaqueImage.figure().height()), (StDisplayable)stOpaqueImage);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"center"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    protected JunPrimitiveItem makeFileNameItemFromFile_(File file) {
        String string = file.getName();
        if (string.length() == 0) {
            string = file.getParentFile() == null ? file.getPath() : file.getParentFile().getName();
        }
        StComposedText stComposedText = new StComposedText(string, this.defaultListFont());
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stComposedText.extent(), (StDisplayable)stComposedText);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    protected JunPrimitiveItem makeFileImageItemFromFile_(File file) {
        StOpaqueImage stOpaqueImage = null;
        stOpaqueImage = file.isDirectory() ? JunOpaqueImageIcons.Triangle16x16() : JunOpaqueImageIcons.Empty16x16();
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stOpaqueImage.extent(), (StDisplayable)stOpaqueImage);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    protected JunCompositeItem makeInfoItemFromFile_(File file) {
        JunCompositeItem junCompositeItem = new JunCompositeItem(new Point(0, 0), new Point(0, 0));
        junCompositeItem.borderWidth_(0);
        junCompositeItem.borderColor_(junCompositeItem.BackgroundColor());
        junCompositeItem.emphasisState_(false);
        if (!file.exists()) {
            return junCompositeItem;
        }
        JunPrimitiveItem junPrimitiveItem = this.makeInfoIconItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem2 = this.makeInfoNameItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem3 = this.makeInfoCreatedItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem4 = this.makeInfoModifiedItemFromFile_(file);
        JunPrimitiveItem junPrimitiveItem5 = this.makeInfoSizeItemFromFile_(file);
        junCompositeItem.add_alignment_(junPrimitiveItem, JunFileList.$((String)"topLeft"));
        junCompositeItem.add_alignment_with_alignment_offset_(junPrimitiveItem2, JunFileList.$((String)"topLeft"), junPrimitiveItem, JunFileList.$((String)"bottomLeft"), new Point(0, 12));
        junCompositeItem.add_alignment_with_alignment_offset_(junPrimitiveItem3, JunFileList.$((String)"topLeft"), junPrimitiveItem2, JunFileList.$((String)"bottomLeft"), new Point(0, 2));
        junCompositeItem.add_alignment_with_alignment_offset_(junPrimitiveItem4, JunFileList.$((String)"topLeft"), junPrimitiveItem3, JunFileList.$((String)"bottomLeft"), new Point(0, 2));
        junCompositeItem.add_alignment_with_alignment_offset_(junPrimitiveItem5, JunFileList.$((String)"topLeft"), junPrimitiveItem4, JunFileList.$((String)"bottomLeft"), new Point(0, 2));
        Rectangle rectangle = junPrimitiveItem.bounds();
        int n = rectangle.x + rectangle.width;
        rectangle = junPrimitiveItem2.bounds();
        n = Math.max(n, rectangle.x + rectangle.width);
        rectangle = junPrimitiveItem3.bounds();
        n = Math.max(n, rectangle.x + rectangle.width);
        rectangle = junPrimitiveItem4.bounds();
        n = Math.max(n, rectangle.x + rectangle.width);
        rectangle = junPrimitiveItem5.bounds();
        n = Math.max(n, rectangle.x + rectangle.width);
        rectangle = junPrimitiveItem5.bounds();
        int n2 = rectangle.y + rectangle.height;
        junCompositeItem.extentPoint_(new Point(n, n2));
        return junCompositeItem;
    }

    protected JunPrimitiveItem makeInfoIconItemFromFile_(File file) {
        StOpaqueImage stOpaqueImage = JunFileNavigator.ImageInfoIconFromFile_(file);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stOpaqueImage.extent(), (StDisplayable)stOpaqueImage);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"center"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunPrimitiveItem makeInfoNameItemFromFile_(File file) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            printWriter.println("Name:");
            printWriter.print(file.getName());
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        String string = stringWriter.toString();
        StComposedText stComposedText = new StComposedText(string);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stComposedText.extent(), (StDisplayable)stComposedText);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunPrimitiveItem makeInfoCreatedItemFromFile_(File file) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            printWriter.println("Created:");
            printWriter.print("unknown");
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        String string = stringWriter.toString();
        StComposedText stComposedText = new StComposedText(string);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stComposedText.extent(), (StDisplayable)stComposedText);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunPrimitiveItem makeInfoModifiedItemFromFile_(File file) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            printWriter.println("Modified:");
            printWriter.print(JunCalendarModel.StringFromDateAndTime_(new Date(file.lastModified())));
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        String string = stringWriter.toString();
        StComposedText stComposedText = new StComposedText(string);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stComposedText.extent(), (StDisplayable)stComposedText);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunPrimitiveItem makeInfoSizeItemFromFile_(File file) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            if (file.isDirectory()) {
                printWriter.println("Contents:");
                printWriter.print(file.list().length);
                printWriter.print(" items");
            } else {
                long l = file.length();
                printWriter.println("Size:");
                printWriter.print(NumberFormat.getInstance().format(l));
                printWriter.println(" bytes");
                printWriter.print('(');
                long l2 = 1024L;
                long l3 = l2 * l2;
                long l4 = l3 * l2;
                if (l / l4 > 0L) {
                    printWriter.print((float)(l * 1000L / l4) / 1000.0f);
                    printWriter.print(" GB");
                } else if (l / l3 > 0L) {
                    printWriter.print((float)(l * 1000L / l3) / 1000.0f);
                    printWriter.print(" MB");
                } else {
                    printWriter.print((float)(l * 1000L / l2) / 1000.0f);
                    printWriter.print(" KB");
                }
                printWriter.print(')');
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        String string = stringWriter.toString();
        StComposedText stComposedText = new StComposedText(string);
        JunPrimitiveItem junPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), stComposedText.extent(), (StDisplayable)stComposedText);
        junPrimitiveItem.visualAlignment_(JunFileList.$((String)"leftCenter"));
        junPrimitiveItem.emphasisState_(false);
        return junPrimitiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File[] sortedCurrentContents_sortSymbol_(File[] fileArray, StSymbol stSymbol) {
        if (fileArray == null) {
            return new File[0];
        }
        File[] fileArray2 = (File[])fileArray.clone();
        JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
        try {
            junCursors._show();
            Arrays.sort(fileArray2, (Comparator)JunFileList._ComparatorTable().get(stSymbol));
        }
        finally {
            junCursors._restore();
        }
        ArrayList<File> arrayList = new ArrayList<File>(fileArray2.length);
        junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            if (this.distinctFolder()) {
                int n;
                for (n = 0; n < fileArray2.length; ++n) {
                    if (!fileArray2[n].isDirectory()) continue;
                    arrayList.add(fileArray2[n]);
                }
                for (n = 0; n < fileArray2.length; ++n) {
                    if (fileArray2[n].isDirectory() || !this.filePatternsMatch_(fileArray2[n])) continue;
                    arrayList.add(fileArray2[n]);
                }
            } else {
                for (int i = 0; i < fileArray2.length; ++i) {
                    if (!fileArray2[i].isDirectory() && !this.filePatternsMatch_(fileArray2[i])) continue;
                    arrayList.add(fileArray2[i]);
                }
            }
        }
        finally {
            junCursors._restore();
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File[] privateCurrentContents() {
        File[] fileArray = null;
        if (this.isNull() || this.isFile()) {
            fileArray = new File[]{};
        } else {
            JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
            try {
                junCursors._show();
                fileArray = this.isRoot() ? JunFileList._RootFiles() : this.currentFile().listFiles();
            }
            finally {
                junCursors._restore();
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!((Boolean)this.selectBlock().value_((Object)fileArray[i])).booleanValue()) continue;
                    arrayList.add(fileArray[i]);
                }
            }
            fileArray = arrayList.toArray(new File[arrayList.size()]);
            fileArray = this.sortedCurrentContents_sortSymbol_(fileArray, this.sortKey());
        }
        return fileArray;
    }

    public StPopupMenu _popupMenu() {
        if (this.isNull()) {
            return null;
        }
        if (this.isFile()) {
            return this._popupMenuForFile();
        }
        return this._popupMenuForDirectory();
    }

    public StPopupMenu _popupMenuForDirectory() {
        if (this.yellowButtonMenu == null) {
            StPopupMenu stPopupMenu = new StPopupMenu();
            stPopupMenu.add(new StMenuItem((Object)JunFileList.$String((String)"Update contents"), JunFileList.$((String)"updateContents"), (MenuListener)new MenuDispatcher((StObject)this, "updateContents")));
            this.yellowButtonMenu = stPopupMenu;
        }
        return this.yellowButtonMenu;
    }

    public StPopupMenu _popupMenuForFile() {
        if (this.yellowButtonMenuForFile == null) {
            StPopupMenu stPopupMenu = new StPopupMenu();
            stPopupMenu.add(new StMenuItem((Object)JunFileList.$String((String)"Open"), JunFileList.$((String)"openFile"), (MenuListener)new MenuPerformer((StObject)this, "openFile")));
            stPopupMenu.add(new StMenuItem((Object)JunFileList.$String((String)"Update contents"), JunFileList.$((String)"updateContents"), (MenuListener)new MenuDispatcher((StObject)this, "updateContents")));
            this.yellowButtonMenuForFile = stPopupMenu;
        }
        return this.yellowButtonMenuForFile;
    }

    public File selectedFile() {
        if (this.showContents()) {
            return this.fileAt_(this.selectedIndex());
        }
        return this.currentFile();
    }

    public void selectedFile_(File file) {
        if (this.isNull()) {
            this.selectedIndex_(-1);
            return;
        }
        if (this.isFile()) {
            this.selectedIndex_(-1);
            return;
        }
        this.selectedIndex_(this.indexOfFile_(file));
    }

    public int selectedIndex() {
        return this.selectedIndexHolder()._intValue();
    }

    public void selectedIndex_(int n) {
        if (this.isNull()) {
            this.selectedIndexHolder().value_(-1);
            return;
        }
        if (this.isFile()) {
            this.selectedIndexHolder().value_(-1);
            return;
        }
        JunAbstractItem junAbstractItem = this.itemAt_(n);
        if (junAbstractItem == null) {
            this.selectedIndexHolder().value_(-1);
            return;
        }
        junAbstractItem.withAllItemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunAbstractItem)((Object)object)).emphasisState_(true);
                return null;
            }
        });
        Rectangle rectangle = junAbstractItem.bounds();
        this.selectedIndexHolder().value_(n);
        this.changed_with_(JunFileList.$((String)"selection"), rectangle);
    }

    protected StValueHolder selectedIndexHolder() {
        if (this.selectedIndexHolder == null) {
            this.selectedIndexHolder = new StValueHolder(-1);
        }
        return this.selectedIndexHolder;
    }

    public JunAbstractItem selectedItem() {
        return this.itemAt_(this.selectedIndex());
    }

    public void selectedItem_(JunAbstractItem junAbstractItem) {
        if (this.isNull()) {
            this.selectedIndex_(-1);
            return;
        }
        if (this.isFile()) {
            this.selectedIndex_(-1);
            return;
        }
        this.selectedIndex_(this.indexOfItem_(junAbstractItem));
    }

    public void selectFirstItem() {
        if (!this.showContents()) {
            return;
        }
        if (this.isDirectory() && !this.isEmpty() && this.selectedItem() == null) {
            this.selectedItem_(this.itemAt_(0));
        }
    }

    public JunAbstractItem selectItemAt_(Point point) {
        if (this.isNull()) {
            return null;
        }
        if (this.isFile()) {
            return null;
        }
        JunAbstractItem junAbstractItem = this.whichItemAt_(point);
        JunAbstractItem junAbstractItem2 = this.selectedItem();
        if (junAbstractItem2 == null ? junAbstractItem == null : ((Object)((Object)junAbstractItem2)).equals((Object)junAbstractItem)) {
            return null;
        }
        this.deselectItem_(junAbstractItem2);
        this.selectedItem_(junAbstractItem);
        return junAbstractItem;
    }

    public JunAbstractItem deselectItem() {
        JunAbstractItem junAbstractItem = this.selectedItem();
        if (junAbstractItem == null) {
            return null;
        }
        return this.deselectItem_(junAbstractItem);
    }

    public JunAbstractItem deselectItem_(JunAbstractItem junAbstractItem) {
        if (junAbstractItem == null) {
            return null;
        }
        junAbstractItem.withAllItemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunAbstractItem)((Object)object)).emphasisState_(false);
                return null;
            }
        });
        Rectangle rectangle = junAbstractItem.bounds();
        this.selectedIndex_(-1);
        this.changed_with_(JunFileList.$((String)"selection"), rectangle);
        return junAbstractItem;
    }

    public JunAbstractItem whichItemAt_(final Point point) {
        return (JunAbstractItem)((Object)this.itemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                return ((JunAbstractItem)((Object)object)).containsPoint_(point) ? object : null;
            }
        }));
    }

    public void fixScrollingOffsetFrom_keepPosition_(JunGraphicView junGraphicView, boolean bl) {
        if (junGraphicView == null) {
            return;
        }
        if (bl) {
            super.fixScrollingOffsetFrom_(junGraphicView);
        } else {
            JunAbstractItem junAbstractItem = this.selectedItem();
            if (junAbstractItem == null) {
                junGraphicView.scrollTo_(new Point(0, 0));
            } else {
                junGraphicView.makeVisible(junAbstractItem.bounds());
            }
        }
    }

    public int lineGrid() {
        int n = this.getView() == null ? SystemResourceSupport.getFontMetrics((Font)this.defaultListFont()).getHeight() : this.getView().toComponent().getFontMetrics(this.defaultListFont()).getHeight();
        return Math.max(n, 18);
    }

    public void redButtonPressedAt_(Point point) {
        Point point2 = point;
        File file = this.currentFile();
        if (file != null) {
            while (!file.exists()) {
                String string = file.getParent();
                if (string == null || string.length() == 0) {
                    return;
                }
                file = new File(string);
            }
            if (this.currentFile() != file) {
                this.currentFile = file;
                this.updateContents();
                point2 = new Point(-1, -1);
            }
        }
        if (this.isNull()) {
            this.nullItemAt_(point2);
        } else if (this.isFile()) {
            this.fileItemAt_(point2);
        } else if (this.isDirectory()) {
            this.directoryItemAt_(point2);
        }
    }

    protected void nullItemAt_(Point point) {
        StBlockClosure stBlockClosure = this.nullItemBlock();
        switch (stBlockClosure.numArgs()) {
            case 0: {
                stBlockClosure.value();
                return;
            }
            case 1: {
                stBlockClosure.value_(null);
                return;
            }
        }
    }

    protected StBlockClosure nullItemBlock() {
        if (this.nullItemBlock == null) {
            this.nullItemBlock = new StBlockClosure();
        }
        return this.nullItemBlock;
    }

    public void nullItemBlock_(StBlockClosure stBlockClosure) {
        this.nullItemBlock = stBlockClosure;
    }

    protected void fileItemAt_(Point point) {
        StBlockClosure stBlockClosure = this.fileItemBlock();
        switch (stBlockClosure.numArgs()) {
            case 0: {
                stBlockClosure.value();
                return;
            }
            case 1: {
                stBlockClosure.value_((Object)this.currentFile());
                return;
            }
        }
    }

    protected StBlockClosure fileItemBlock() {
        if (this.fileItemBlock == null) {
            this.fileItemBlock = new StBlockClosure();
        }
        return this.fileItemBlock;
    }

    public void fileItemBlock_(StBlockClosure stBlockClosure) {
        this.fileItemBlock = stBlockClosure;
    }

    protected void directoryItemAt_(Point point) {
        File file;
        if (point == new Point(-1, -1)) {
            file = null;
        } else {
            if (this.showContents() && this.selectItemAt_(point) == null) {
                return;
            }
            file = this.selectedFile();
        }
        StBlockClosure stBlockClosure = this.directoryItemBlock();
        switch (stBlockClosure.numArgs()) {
            case 0: {
                stBlockClosure.value();
                return;
            }
            case 1: {
                stBlockClosure.value_((Object)file);
                return;
            }
        }
    }

    public StBlockClosure directoryItemBlock() {
        if (this.directoryItemBlock == null) {
            this.directoryItemBlock = new StBlockClosure();
        }
        return this.directoryItemBlock;
    }

    public void directoryItemBlock_(StBlockClosure stBlockClosure) {
        this.directoryItemBlock = stBlockClosure;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return this.selectedIndexHolder().compute_(stBlockClosure);
    }

    public Font defaultListFont() {
        return StComposedText.DefaultFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openFile() {
        File file = this.currentFile();
        JunCursors junCursors = new JunCursors(new Cursor(3));
        try {
            junCursors._show();
            URL uRL = new URL("file", null, file.getAbsolutePath());
            JunURL.Browse_(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.print(malformedURLException.getMessage());
            malformedURLException.printStackTrace();
        }
        finally {
            junCursors._restore();
        }
    }

    public synchronized void updateContents() {
        JunFileListDispenser.Default().remove_(this);
        File file = this.selectedFile();
        this.selectedIndex_(-1);
        this.currentFile_(this.currentFile());
        int n = this.indexOfFile_(file);
        if (n >= 0) {
            this.selectedIndex_(n);
        } else {
            this.selectFirstItem();
        }
        this.changed_(JunFileList.$((String)"redisplay"));
        this.fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.getView(), false);
    }

    public JunAbstractItem.LookPreferences lookPreferences() {
        return this.lookPreferences;
    }

    public KeyListener _keyListener() {
        if (this._keyListener == null) {
            this._keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (JunFileList.this._keyboardEvent(keyEvent)) {
                        keyEvent.consume();
                    }
                }
            };
        }
        return this._keyListener;
    }

    protected boolean _keyboardEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: {
                this.keyStrokePressENTER();
                return true;
            }
            case 32: {
                this.keyStrokePressSPACE();
                return true;
            }
            case 37: {
                this.keyStrokePressLEFT();
                return true;
            }
            case 39: {
                this.keyStrokePressRIGHT();
                return true;
            }
            case 38: {
                this.keyStrokePressUP();
                return true;
            }
            case 40: {
                this.keyStrokePressDOWN();
                return true;
            }
        }
        return false;
    }

    protected boolean keyStrokePressENTER() {
        return true;
    }

    protected boolean keyStrokePressSPACE() {
        return true;
    }

    protected boolean keyStrokePressLEFT() {
        return true;
    }

    protected boolean keyStrokePressRIGHT() {
        return true;
    }

    protected boolean keyStrokePressUP() {
        int n = this.selectedIndex();
        if (n == 0) {
            return false;
        }
        --n;
        JunAbstractItem junAbstractItem = this.itemAt_(n = Math.max(0, n));
        if (junAbstractItem != null) {
            JunAbstractItem junAbstractItem2 = this.selectedItem();
            if (junAbstractItem2 == null ? junAbstractItem == null : ((Object)((Object)junAbstractItem2)).equals((Object)junAbstractItem)) {
                return false;
            }
            this.deselectItem_(junAbstractItem2);
            this.selectedItem_(junAbstractItem);
            this.fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.getView(), false);
        }
        return true;
    }

    protected boolean keyStrokePressDOWN() {
        int n = this.selectedIndex();
        if (n == this.sequenceMap().componentItems().size() - 1) {
            return false;
        }
        ++n;
        JunAbstractItem junAbstractItem = this.itemAt_(n = Math.min(n, this.sequenceMap().componentItems().size() - 1));
        if (junAbstractItem != null) {
            JunAbstractItem junAbstractItem2 = this.selectedItem();
            if (junAbstractItem2 == null ? junAbstractItem == null : ((Object)((Object)junAbstractItem2)).equals((Object)junAbstractItem)) {
                return false;
            }
            this.deselectItem_(junAbstractItem2);
            this.selectedItem_(junAbstractItem);
            this.fixScrollingOffsetFrom_keepPosition_((JunGraphicView)this.getView(), false);
        }
        return true;
    }

    protected String windowTitle() {
        return JunFileList.$String((String)"File List");
    }

    protected void resetAll() {
        JunFileListDispenser.Default().remove_(this);
        File file = this.selectedFile();
        this.selectedIndex_(-1);
        this.sequenceMap = null;
        this.currentContents = null;
        if (this.isFile()) {
            if (!this.filePatternsMatch_(this.currentFile())) {
                this.currentFile_(null);
            }
        } else {
            int n = this.indexOfFile_(file);
            if (n > 0) {
                this.selectedIndex_(n);
            } else {
                this.selectFirstItem();
            }
        }
        this.updateContents();
    }

    public void recomposeIn_(Rectangle rectangle) {
        if (this.isNull()) {
            return;
        }
        if (this.isDirectory() && this.showContents()) {
            JunSequenceMap junSequenceMap = this.sequenceMap();
            JunCompositeItem[] junCompositeItemArray = new JunCompositeItem[junSequenceMap.componentItems().size()];
            junSequenceMap.componentItems().toArray(junCompositeItemArray);
            for (int i = 0; i < junCompositeItemArray.length; ++i) {
                File file = this.fileAt_(i);
                if (!file.exists()) {
                    this.updateContents();
                    return;
                }
                JunPrimitiveItem junPrimitiveItem = (JunPrimitiveItem)junCompositeItemArray[i].itemAt_(0);
                JunPrimitiveItem junPrimitiveItem2 = (JunPrimitiveItem)junCompositeItemArray[i].itemAt_(1);
                JunPrimitiveItem junPrimitiveItem3 = (JunPrimitiveItem)junCompositeItemArray[i].itemAt_(2);
                junCompositeItemArray[i].extentPoint_(new Point(rectangle.width, junCompositeItemArray[i].bounds().height));
                junCompositeItemArray[i].arrange_alignment_(junPrimitiveItem3, JunFileList.$((String)"rightCenter"));
                StRectangle stRectangle = StRectangle.Origin_corner_((Point)new Point(junPrimitiveItem.originPoint().x + junPrimitiveItem.extentPoint().x, 0), (Point)new Point(junPrimitiveItem3.originPoint().x, junCompositeItemArray[i].extentPoint().y - 1));
                junCompositeItemArray[i].arrange_in_(junPrimitiveItem2, stRectangle.toRectangle());
            }
            junSequenceMap.arrange();
        } else {
            JunCompositeItem junCompositeItem = (JunCompositeItem)this.itemAt_(0);
            StRectangle stRectangle = new StRectangle(junCompositeItem.bounds());
            stRectangle = rectangle.width >= stRectangle.width() && rectangle.height >= stRectangle.height() ? stRectangle.align_with_(stRectangle.center(), new StRectangle(rectangle).center()) : (rectangle.width >= stRectangle.width() ? stRectangle.align_with_(stRectangle.topCenter(), new StRectangle(rectangle).topCenter()) : (rectangle.height >= stRectangle.height() ? stRectangle.align_with_(stRectangle.leftCenter(), new StRectangle(rectangle).leftCenter()) : stRectangle.align_with_(stRectangle.topLeft(), new StRectangle(rectangle).topLeft())));
            junCompositeItem.originPoint_(new Point(10, 10));
            junCompositeItem.extentPoint_(new Point(stRectangle.width(), stRectangle.height()));
            this.sequenceMap().flushBounds();
        }
    }

    protected StBlockClosure selectBlock() {
        if (this.selectBlock == null) {
            this.selectBlock = new StBlockClosure(){

                public Object value_(Object object) {
                    return Boolean.TRUE;
                }
            };
        }
        return this.selectBlock;
    }

    protected void selectBlock_(final StBlockClosure stBlockClosure) {
        this.selectBlock = new StBlockClosure(){

            public Object value_(Object object) {
                Boolean bl;
                try {
                    Object object2 = stBlockClosure.value_(object);
                    bl = object2 instanceof Boolean && (Boolean)object2 != false;
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                }
                return bl;
            }
        };
    }
}

