/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.item;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunPrimitiveItem
extends JunAbstractItem {
    protected StDisplayable visualComponent;
    protected StSymbol visualAlignment;

    public JunPrimitiveItem(Point point, Dimension dimension, StDisplayable stDisplayable) {
        super(point, new Point(dimension.width, dimension.height));
        this.visualComponent_(stDisplayable);
    }

    public JunPrimitiveItem(Point point, Point point2, StDisplayable stDisplayable) {
        super(point, point2);
        this.visualComponent_(stDisplayable);
    }

    protected void initialize() {
        super.initialize();
        this.visualComponent = null;
        this.visualAlignment = null;
    }

    public StSymbol visualAlignment() {
        if (this.visualAlignment == null) {
            this.visualAlignment = JunPrimitiveItem.$((String)"topLeft");
        }
        return this.visualAlignment;
    }

    public void visualAlignment_(StSymbol stSymbol) {
        this.visualAlignment = stSymbol;
    }

    public StDisplayable visualComponent() {
        return this.visualComponent;
    }

    public void visualComponent_(StDisplayable stDisplayable) {
        this.visualComponent = stDisplayable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayBackgroundOn_insetBox_(Graphics graphics, Rectangle rectangle) {
        Graphics graphics2 = graphics.create();
        try {
            if (this.isEmphasis()) {
                graphics2.setColor(this.selectionBackgroundColor());
            } else {
                graphics2.setColor(this.backgroundColor());
            }
            graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayBorderOn_insetBox_(Graphics graphics, Rectangle rectangle) {
        Graphics graphics2 = graphics.create();
        try {
            graphics2.setColor(this.borderColor());
            StRectangle[] stRectangleArray = new StRectangle(this.bounds()).areasOutside_(new StRectangle(rectangle));
            for (int i = 0; i < stRectangleArray.length; ++i) {
                Rectangle rectangle2 = stRectangleArray[i].toRectangle();
                graphics2.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null || rectangle.intersects(this.bounds())) {
            Rectangle rectangle2 = this.insideBounds();
            this.displayBorderOn_insetBox_(graphics, rectangle2);
            this.displayBackgroundOn_insetBox_(graphics, rectangle2);
            this.displayVisualOn_insetBox_(graphics, rectangle2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayVisualOn_insetBox_(Graphics graphics, Rectangle rectangle) {
        Graphics graphics2 = graphics.create();
        try {
            Serializable serializable;
            Object object;
            Rectangle rectangle2;
            StDisplayable stDisplayable = this.visualComponent();
            if (stDisplayable == null) {
                return;
            }
            Rectangle rectangle3 = graphics2.getClipBounds();
            if (rectangle3 != null) {
                rectangle2 = rectangle3.intersection(rectangle);
                graphics2.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            if (this.isEmphasis()) {
                graphics2.setColor(this.selectionForegroundColor());
            } else {
                graphics2.setColor(this.foregroundColor());
            }
            rectangle2 = stDisplayable.bounds();
            if (stDisplayable instanceof StComposedText && rectangle2.width > rectangle.width) {
                object = (StComposedText)stDisplayable;
                serializable = object.font();
                FontMetrics fontMetrics = graphics2.getFontMetrics((Font)serializable);
                String string = JunPrimitiveItem.ContractString_compositionWidth_textStyle_(object.string(), rectangle.width, fontMetrics);
                stDisplayable = (StDisplayable)StObject._New(stDisplayable.getClass(), (Object[])new Object[]{string, serializable});
                rectangle2 = stDisplayable.bounds();
            }
            try {
                object = (Point)new StRectangle(rectangle2).perform_(this.visualAlignment().toString());
                serializable = (Point)new StRectangle(rectangle).perform_(this.visualAlignment().toString());
                rectangle2 = new StRectangle(rectangle2).align_with_((Point)object, (Point)serializable).toRectangle();
                stDisplayable.displayOn_at_(graphics2, rectangle2.getLocation());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    public Object itemsDo_(StBlockClosure stBlockClosure) {
        return stBlockClosure.value_((Object)this);
    }

    public boolean isPrimitive() {
        return true;
    }
}

