/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.abstracts;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.jun.graphics.abstracts.JunAbstractVisual;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

public class JunAbstractItem
extends JunAbstractVisual {
    protected Point originPoint;
    protected Point extentPoint;
    protected int borderWidth;
    protected Color borderColor;
    protected boolean emphasisState;
    protected boolean hiddenState;
    protected LookPreferences lookPreferences;

    public JunAbstractItem(Point point, Point point2) {
        this.originPoint_(point);
        this.extentPoint_(point2);
    }

    protected JunAbstractItem() {
    }

    protected void initialize() {
        super.initialize();
        this.originPoint = null;
        this.extentPoint = null;
        this.borderWidth = 0;
        this.borderColor = null;
        this.emphasisState = false;
        this.hiddenState = false;
        this.lookPreferences = null;
    }

    public Point originPoint() {
        if (this.originPoint == null) {
            this.originPoint = new Point(0, 0);
        }
        return this.originPoint;
    }

    public void originPoint_(Point point) {
        this.originPoint = point;
    }

    public Point extentPoint() {
        if (this.extentPoint == null) {
            this.extentPoint = new Point(0, 0);
        }
        return this.extentPoint;
    }

    public void extentPoint_(Point point) {
        this.extentPoint = point;
    }

    public boolean emphasisState() {
        return this.emphasisState;
    }

    public void emphasisState_(boolean bl) {
        this.emphasisState = bl;
    }

    public JunAbstractItem[] items() {
        final ArrayList arrayList = new ArrayList();
        this.itemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new JunAbstractItem[arrayList.size()]);
    }

    public JunAbstractItem[] allItems() {
        final ArrayList arrayList = new ArrayList();
        this.allItemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new JunAbstractItem[arrayList.size()]);
    }

    public JunAbstractItem[] withAllItems() {
        final ArrayList arrayList = new ArrayList();
        this.withAllItemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new JunAbstractItem[arrayList.size()]);
    }

    public Rectangle insideBounds() {
        return new StRectangle(this.bounds()).insetBy_(this.borderWidth()).toRectangle();
    }

    public Rectangle preferredBounds() {
        return StRectangle.Origin_extent_((Point)this.originPoint(), (Point)this.extentPoint()).toRectangle();
    }

    public void displayOn_(Graphics graphics) {
    }

    public boolean containsPoint_(Point point) {
        return this.bounds().contains(point);
    }

    public boolean isEmphasis() {
        return this.emphasisState();
    }

    public boolean isItem() {
        return true;
    }

    public int borderWidth() {
        return this.borderWidth;
    }

    public void borderWidth_(int n) {
        this.borderWidth = n;
    }

    public Color borderColor() {
        if (this.borderColor == null) {
            this.borderColor = Color.black;
        }
        return this.borderColor;
    }

    public void borderColor_(Color color) {
        this.borderColor = color;
    }

    public LookPreferences lookPreferences() {
        return this.lookPreferences;
    }

    public void lookPreferences_(LookPreferences lookPreferences) {
        this.lookPreferences = lookPreferences;
    }

    public Color foregroundColor() {
        if (this.lookPreferences() == null) {
            return super.foregroundColor();
        }
        return this.lookPreferences().foregroundColor();
    }

    public void foregroundColor_(Color color) {
        if (this.lookPreferences() == null) {
            return;
        }
        this.lookPreferences().setForegroundColor(color);
    }

    public Color backgroundColor() {
        if (this.lookPreferences() == null) {
            return super.backgroundColor();
        }
        return this.lookPreferences().backgroundColor();
    }

    public void backgroundColor_(Color color) {
        if (this.lookPreferences() == null) {
            return;
        }
        this.lookPreferences().setBackgroundColor(color);
    }

    public Color selectionForegroundColor() {
        if (this.lookPreferences() == null) {
            return super.selectionForegroundColor();
        }
        return this.lookPreferences().selectionForegroundColor();
    }

    public void selectionSelectionForegroundColor_(Color color) {
        if (this.lookPreferences() == null) {
            return;
        }
        this.lookPreferences().setSelectionForegroundColor(color);
    }

    public Color selectionBackgroundColor() {
        if (this.lookPreferences() == null) {
            return super.selectionBackgroundColor();
        }
        return this.lookPreferences().selectionBackgroundColor();
    }

    public void selectionBackgroundColor_(Color color) {
        if (this.lookPreferences() == null) {
            return;
        }
        this.lookPreferences().setSelectionBackgroundColor(color);
    }

    public static class LookPreferences {
        protected Color foregroundColor;
        protected Color backgroundColor;
        protected Color selectionForegroundColor;
        protected Color selectionBackgroundColor;

        public Color foregroundColor() {
            return this.foregroundColor;
        }

        public void setForegroundColor(Color color) {
            this.foregroundColor = color;
        }

        public Color backgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
        }

        public Color selectionForegroundColor() {
            return this.selectionForegroundColor;
        }

        public void setSelectionForegroundColor(Color color) {
            this.selectionForegroundColor = color;
        }

        public Color selectionBackgroundColor() {
            return this.selectionBackgroundColor;
        }

        public void setSelectionBackgroundColor(Color color) {
            this.selectionBackgroundColor = color;
        }
    }
}

