/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.streams.JunBmpImageStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

public class JunImageUtility
extends JunAbstractObject {
    public static BufferedImage FromDisplay() {
        return JunImageUtility.FromDisplay_(new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize()));
    }

    public static BufferedImage FromDisplay_(Rectangle rectangle) {
        return StImage._OfArea((Rectangle)rectangle).image();
    }

    public static BufferedImage FromUser() {
        return StImage._FromUser().image();
    }

    public static BufferedImage ImageExtent_(Dimension dimension) {
        return JunImageUtility.ImageExtent_displayBlock_(dimension, new StBlockClosure(){

            public Object value_(Object object) {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage ImageExtent_displayBlock_(Dimension dimension, StBlockClosure stBlockClosure) {
        BufferedImage bufferedImage = null;
        Graphics graphics = null;
        try {
            bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            if (stBlockClosure != null) {
                stBlockClosure.value_((Object)graphics);
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return bufferedImage;
    }

    public static float DefaultImageQuality() {
        return 0.95f;
    }

    public static StImage RequestImage() {
        File file = JunImageUtility.RequestImageFile();
        if (file == null) {
            return null;
        }
        JunMultiMediaImageModel junMultiMediaImageModel = new JunMultiMediaImageModel(file);
        if (junMultiMediaImageModel == null) {
            return null;
        }
        StImage stImage = junMultiMediaImageModel.visual().asImage();
        return stImage;
    }

    public static File RequestImageFile() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)JunSystem.$String((String)"Image")), JunSystem.DefaultImageExtensionPatterns()), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)JunSystem.$String((String)"All")), new String[]{"*"})};
        String string = JunSystem.$String((String)"Select a <1p> file.", null, (Object)JunSystem.$String((String)"Image"));
        File file = JunFileRequesterDialog.Request(string, fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        return file;
    }

    public static JunImageDisplayModel Show_(Image image) {
        return JunImageDisplayModel.Show_(image);
    }

    public static JunImageDisplayModel Show_(StDisplayable stDisplayable) {
        return JunImageDisplayModel.Show_(stDisplayable);
    }

    public static JunImageDisplayModel Show_at_(Image image, Point point) {
        return JunImageDisplayModel.Show_at_(image, point);
    }

    public static JunImageDisplayModel Show_at_(StDisplayable stDisplayable, Point point) {
        return JunImageDisplayModel.Show_at_(stDisplayable, point);
    }

    public static JunImageDisplayModel Show_in_(Image image, Rectangle rectangle) {
        return JunImageDisplayModel.Show_in_(image, rectangle);
    }

    public static JunImageDisplayModel Show_in_(StDisplayable stDisplayable, Rectangle rectangle) {
        return JunImageDisplayModel.Show_in_(stDisplayable, rectangle);
    }

    public static File RequestNewImageFile() {
        String[] stringArray = new String[]{"*.jpg", "*.jpeg", "*.bmp", "*.png", "*.JPG", "*.JPEG", "*.BMP", "*.PNG"};
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)JunSystem.$String((String)"Image")), stringArray)};
        String string = JunSystem.$String((String)"Input a <1p> file.", null, (Object)JunSystem.$String((String)"Image"));
        File file = JunFileRequesterDialog.RequestNewFile(string, new File(JunSystem.DefaultBaseName() + ".jpg"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        return file;
    }

    public static File RequestNewImageFileThenWriteImage_(Image image) throws IOException {
        return JunImageUtility.RequestNewImageFileThenWriteImage_(new StImage(image));
    }

    public static File RequestNewImageFileThenWriteImage_(StImage stImage) throws IOException {
        File file = JunImageUtility.RequestNewImageFile();
        if (file == null) {
            return null;
        }
        return JunImageUtility.WriteImage_to_(stImage, file);
    }

    public static File WriteImage_to_(Image image, File file) throws IOException {
        return JunImageUtility.WriteImage_to_(new StImage(image), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File WriteImage_to_(StImage stImage, File file) throws IOException {
        File file2 = file;
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        JunImageStream junImageStream = null;
        try {
            junCursors._show();
            Class clazz = JunImageStream.ImageStreamClassForFileName_(file);
            if (clazz == null) {
                clazz = JunBmpImageStream.class;
                file2 = new File(file.getAbsoluteFile() + ".bmp");
            }
            if ((junImageStream = (JunImageStream)((Object)StObject._PerformWith((Class)clazz, (String)"On_", (Object)new FileOutputStream(file2)))).respondsTo_("quality_")) {
                junImageStream.perform_with_("quality_", new Float(JunImageUtility.DefaultImageQuality()));
            }
            junImageStream.nextPutImage_(stImage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException.getMessage());
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.getMessage());
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException.getMessage());
            invocationTargetException.printStackTrace();
        }
        finally {
            if (junImageStream != null) {
                junImageStream.flush();
                junImageStream.close();
            }
            junCursors._restore();
        }
        return file2;
    }
}

