/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.texteditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;
import jp.co.sra.jun.goodies.texteditor.JunTextEditorView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunTextEditorViewAwt
extends JunAbstractViewPanel
implements JunTextEditorView,
ClipboardOwner {
    protected TextArea textArea;

    public JunTextEditorViewAwt() {
    }

    public JunTextEditorViewAwt(JunTextEditor junTextEditor) {
        super(junTextEditor);
    }

    protected void initialize() {
        super.initialize();
        this.textArea = null;
    }

    protected StModel defaultModel() {
        return new JunTextEditor();
    }

    public JunTextEditor getModel() {
        return (JunTextEditor)this.model();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected void buildComponent() {
        this.getTextArea().setText(this.getModel().text());
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.getTextArea(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
        this.setSize(new Dimension(480, 300));
    }

    protected void rebuildComponent(StModel stModel, StModel stModel2) {
        JunTextEditor junTextEditor = (JunTextEditor)stModel2;
        this.getTextArea().setText(junTextEditor.text());
    }

    public TextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new TextArea("", 0, 0, 1);
            this.textArea.setFont(JunTextEditor.DefaultTextFont());
            this.textArea.setBackground(Color.white);
            this.textArea.setEditable(this.getModel().isEditable());
            this.textArea.add(this.popupMenuView());
            this.textArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
                        JunTextEditorViewAwt.this._showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.textArea.addTextListener(new TextListener(){

                public void textValueChanged(TextEvent textEvent) {
                    String string = JunTextEditorViewAwt.this.textArea.getText();
                    if (!string.equals(JunTextEditorViewAwt.this.getModel().text())) {
                        JunTextEditorViewAwt.this.getModel().text_(string);
                    }
                }
            });
        }
        return this.textArea;
    }

    public String getText() {
        return this.getTextArea().getText();
    }

    public String getSelectedText() {
        String string = null;
        try {
            string = this.getTextArea().getSelectedText();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public void copyText() {
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
        }
    }

    public void cutText() {
        if (!this.getModel().isEditable()) {
            return;
        }
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            this.copyText();
            int n = this.getTextArea().getSelectionStart();
            int n2 = this.getTextArea().getSelectionEnd();
            String string2 = this.getText();
            this.getTextArea().setText(string2.substring(0, n) + string2.substring(n2));
        }
    }

    public void pasteText() {
        Object object;
        Object object2;
        if (!this.getModel().isEditable()) {
            return;
        }
        String string = null;
        try {
            object2 = Toolkit.getDefaultToolkit().getSystemClipboard();
            object = ((Clipboard)object2).getContents(this);
            string = (String)object.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        if (string != null && string.length() > 0) {
            object2 = this.getTextArea();
            object = this.getText();
            String string2 = this.getSelectedText();
            if (string2 != null && string2.length() > 0) {
                int n = ((TextComponent)object2).getSelectionStart();
                int n2 = ((TextComponent)object2).getSelectionEnd();
                ((TextComponent)object2).setText(((String)object).substring(0, n) + string + ((String)object).substring(n2));
                ((TextComponent)object2).setCaretPosition(n + string.length() - 1);
            } else {
                int n = ((TextComponent)object2).getCaretPosition();
                ((TextComponent)object2).setText(((String)object).substring(0, n) + string + ((String)object).substring(n));
                ((TextComponent)object2).setCaretPosition(n + string.length() - 1);
            }
        }
    }

    public void clearText() {
        if (!this.getModel().isEditable()) {
            return;
        }
        String string = this.getText();
        if (string != null && string.length() > 0) {
            this.getTextArea().setText("");
        }
    }

    public void undoText() {
    }

    public void redoText() {
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunTextEditorViewAwt.$((String)"text")) {
            if (!this.getModel().text().equals(this.getTextArea().getText())) {
                this.getTextArea().setText(this.getModel().text());
                this.getTextArea().setCaretPosition(0);
            }
            return;
        }
        if (stSymbol == JunTextEditorViewAwt.$((String)"editable")) {
            this.getTextArea().setEditable(this.getModel().isEditable());
            return;
        }
        super.update_(dependentEvent);
    }
}

