/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroObject;

public class JunSpiroCircle
extends JunSpiroObject {
    protected Jun2dPoint circleCenter;
    protected double circleRadius;
    protected double circleAngle;

    public JunSpiroCircle() {
    }

    public JunSpiroCircle(Jun2dPoint jun2dPoint, double d) {
        this.center_(jun2dPoint);
        this.radius_(d);
    }

    public JunSpiroCircle(Jun2dPoint jun2dPoint, double d, Color color, int n) {
        this.center_(jun2dPoint);
        this.radius_(d);
        this.color_(color);
        this.width_(n);
    }

    protected void initialize() {
        super.initialize();
        this.circleCenter = null;
        this.circleRadius = Double.NaN;
        this.circleAngle = Double.NaN;
    }

    public double angle() {
        if (Double.isNaN(this.circleAngle)) {
            this.circleAngle = this.defaultAngle();
        }
        return this.circleAngle;
    }

    public void angle_(double d) {
        this.circleAngle = d;
    }

    public Jun2dPoint center() {
        if (this.circleCenter == null) {
            this.circleCenter = this.defaultCenter();
        }
        return this.circleCenter;
    }

    public void center_(Jun2dPoint jun2dPoint) {
        this.circleCenter = jun2dPoint;
    }

    public double circumference() {
        return Math.PI * 2 * this.radius();
    }

    public Rectangle mark() {
        Rectangle rectangle = new Rectangle(0, 0, Math.max(this.defaultMarkExtent().width, this.width()), Math.max(this.defaultMarkExtent().height, this.width()));
        rectangle.translate((int)Math.round(this.center().x() - rectangle.getCenterX()), (int)Math.round(this.center().y() - rectangle.getCenterY()));
        return rectangle;
    }

    public Rectangle[] marks() {
        Rectangle rectangle = new Rectangle(0, 0, Math.max(this.defaultMarkExtent().width, this.width()), Math.max(this.defaultMarkExtent().height, this.width()));
        Jun2dPoint[] jun2dPointArray = this.points();
        Rectangle[] rectangleArray = new Rectangle[5];
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i] = new Rectangle(rectangle);
            rectangleArray[i].translate((int)Math.round(jun2dPointArray[i].x() - rectangle.getCenterX()), (int)Math.round(jun2dPointArray[i].y() - rectangle.getCenterY()));
        }
        return rectangleArray;
    }

    public Jun2dPoint[] points() {
        Rectangle rectangle = this.boundingBox();
        JunAngle junAngle = JunAngle.FromDeg_(this.angle());
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(rectangle.getCenterX(), rectangle.getCenterY()), new Jun2dPoint(rectangle.x + rectangle.width, rectangle.getCenterY()), new Jun2dPoint(rectangle.getCenterX(), rectangle.y + rectangle.height), new Jun2dPoint(rectangle.x, rectangle.getCenterY()), new Jun2dPoint(rectangle.getCenterX(), rectangle.y)};
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(jun2dPointArray[i]);
            jun2dPointArray[i] = jun2dPoint = jun2dPoint.transform_(Jun2dTransformation.Rotate_around_(junAngle, this.center()));
        }
        return jun2dPointArray;
    }

    public double radius() {
        if (Double.isNaN(this.circleRadius)) {
            this.circleRadius = this.defaultRadius();
        }
        return this.circleRadius;
    }

    public void radius_(double d) {
        this.circleRadius = Math.max(d, 0.0);
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = new Rectangle(this.center()._toPoint(), new Dimension(1, 1));
        rectangle.grow((int)Math.ceil(this.radius()), (int)Math.ceil(this.radius()));
        return rectangle;
    }

    public double defaultAngle() {
        return 0.0;
    }

    public Jun2dPoint defaultCenter() {
        return new Jun2dPoint(0.0, 0.0);
    }

    public int defaultRadius() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_with_Marks_(Graphics graphics, Point point, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle = this.boundingBox();
            this.applyAttributesToGraphicsContext_(graphics2D);
            graphics2D.translate(point.x, point.y);
            graphics2D.drawArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 360);
            if (bl) {
                Rectangle[] rectangleArray = this.marks();
                for (int i = 0; i < rectangleArray.length; ++i) {
                    Rectangle rectangle2 = rectangleArray[i];
                    graphics2D.setColor(this.color());
                    graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics2D.setColor(Color.white);
                    Rectangle rectangle3 = new Rectangle(rectangle2);
                    rectangle3.grow(-1, -1);
                    graphics2D.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }
}

