/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.prolog;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import jp.co.sra.jun.goodies.prolog.JunPrologCharMap;
import jp.co.sra.jun.goodies.prolog.JunPrologEntity;
import jp.co.sra.jun.goodies.prolog.JunPrologString;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StReadStream;

public class JunPrologSymbol
extends JunPrologString {
    protected static Hashtable JunPrologSymbolTable;
    protected static JunPrologSymbol JunPrologCut;
    protected static JunPrologSymbol JunPrologTrue;
    protected static JunPrologSymbol JunPrologFail;
    protected static JunPrologSymbol JunPrologSend;
    protected static JunPrologSymbol JunPrologVar;
    protected static JunPrologSymbol JunPrologSelf;

    protected JunPrologSymbol(String string) {
        super(string);
    }

    public static JunPrologSymbol Cut() {
        return JunPrologCut;
    }

    public static JunPrologSymbol Install_(String string) {
        JunPrologSymbol junPrologSymbol = (JunPrologSymbol)((Object)JunPrologSymbolTable.get(string));
        if (junPrologSymbol == null) {
            junPrologSymbol = new JunPrologSymbol(string);
            JunPrologSymbolTable.put(string, junPrologSymbol);
        }
        return junPrologSymbol;
    }

    public static JunPrologEntity ReadFrom_(StReadStream stReadStream) {
        boolean[] blArray = JunPrologCharMap.SymbolMap();
        StringBuffer stringBuffer = new StringBuffer(20);
        char c = stReadStream.peek();
        if (c == '\'') {
            stReadStream.next();
            while ((c = stReadStream.peek()) != '\u0000') {
                if (c == '\'') {
                    stReadStream.next();
                    c = stReadStream.peek();
                    if (c != '\'') {
                        return JunPrologSymbol.Install_(stringBuffer.toString());
                    }
                }
                stringBuffer.append(stReadStream.next());
            }
            throw SmalltalkException.Error((String)"Syntax error near $' unmatched $'\n-- end of file --");
        }
        if (JunPrologSymbol.Expect_on_("=..", stReadStream)) {
            return JunPrologSymbol.Install_("=..");
        }
        while (c != '\u0000' && blArray[c]) {
            stringBuffer.append(stReadStream.next());
            c = stReadStream.peek();
        }
        return JunPrologSymbol.Install_(stringBuffer.toString());
    }

    protected static boolean Expect_on_(String string, StReadStream stReadStream) {
        int n = stReadStream.position();
        if (string.equals(stReadStream.nextAvailable_(string.length()))) {
            return true;
        }
        stReadStream.position_(n);
        return false;
    }

    protected static void Initialize() {
        JunPrologSymbolTable = new Hashtable();
        JunPrologCut = JunPrologSymbol.Install_("!");
        JunPrologTrue = JunPrologSymbol.Install_("true");
        JunPrologFail = JunPrologSymbol.Install_("fail");
        JunPrologSend = JunPrologSymbol.Install_("send");
        JunPrologVar = JunPrologSymbol.Install_("var");
        JunPrologSelf = JunPrologSymbol.Install_("self");
    }

    public boolean isBuiltInPredicate() {
        if (this.isJunPrologCut()) {
            return true;
        }
        if (this.isJunPrologTrue()) {
            return true;
        }
        if (this.isJunPrologFail()) {
            return true;
        }
        if (this.isJunPrologSend()) {
            return true;
        }
        return this.isJunPrologVar();
    }

    public boolean isJunPrologCut() {
        return this.equals((Object)JunPrologCut);
    }

    public boolean isJunPrologFail() {
        return this.equals((Object)JunPrologFail);
    }

    public boolean isJunPrologSelf() {
        return this.equals((Object)JunPrologSelf);
    }

    public boolean isJunPrologSend() {
        return this.equals((Object)JunPrologSend);
    }

    public boolean isJunPrologTrue() {
        return this.equals((Object)JunPrologTrue);
    }

    public boolean isJunPrologVar() {
        return this.equals((Object)JunPrologVar);
    }

    public void printJunPrologOn_(Writer writer) throws IOException {
        int n;
        boolean[] blArray = JunPrologCharMap.SymbolMap();
        boolean bl = false;
        for (n = 0; n < this.string.length(); ++n) {
            if (blArray[this.string.charAt(n)]) continue;
            bl = true;
            break;
        }
        if (this.string.length() == 0) {
            writer.write("''");
        } else {
            n = this.string.charAt(0);
            if (65 <= n && n <= 90 || bl) {
                writer.write(39);
                int n2 = this.string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = this.string.charAt(i);
                    writer.write(c);
                    if (c != '\'') continue;
                    writer.write(c);
                }
                writer.write(39);
            } else {
                int n3 = this.string.length();
                for (int i = 0; i < n3; ++i) {
                    char c = this.string.charAt(i);
                    writer.write(c);
                    if (c != '\'') continue;
                    writer.write(c);
                }
            }
        }
    }

    static {
        JunPrologSymbol.Initialize();
    }
}

