/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.gauge.JunSimpleGaugeModel;
import jp.co.sra.jun.goodies.movie.framework.JunMovieHandle;
import jp.co.sra.jun.goodies.movie.framework.JunMovieView;
import jp.co.sra.jun.goodies.movie.framework.JunMovieViewAwt;
import jp.co.sra.jun.goodies.movie.framework.JunMovieViewSwing;
import jp.co.sra.jun.goodies.sound.JunSoundMeterModel;
import jp.co.sra.jun.goodies.track.JunTrackSliderModel;
import jp.co.sra.jun.goodies.track.JunTrackSliderView;
import jp.co.sra.jun.goodies.track.JunTrackerModel;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.qt4jun.JunQTMovieFactory;
import jp.co.sra.qt4jun.JunQTPort;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunMoviePlayer
extends JunApplicationModel {
    protected static final int DefaultSoundMeterTimeStep = 20;
    protected static final int MinimumSoundLevelTimeStep = 50;
    protected static final int CalculateSoundWaveTimeStep = 600;
    protected JunMovieHandle movieHandle;
    protected JunQTPort moviePort;
    protected JunTrackerModel trackerModel;
    protected Thread trackingProcess;
    protected boolean trackingFlag;
    protected boolean playingFlag;
    protected double startTime;
    protected JunTrackSliderModel trackerModel2;
    protected int soundMeterTimeStep = 20;
    protected StValueHolder soundValueHolder;
    protected JunSoundMeterModel soundSpectrum;
    protected JunSimpleGaugeModel volumeGauge;
    protected boolean keepAspect;
    protected StPopupMenu _popupMenu;

    public JunMoviePlayer() {
    }

    public JunMoviePlayer(File file) {
        this(JunMovieHandle.Filename_(file));
    }

    public JunMoviePlayer(JunMovieHandle junMovieHandle) {
        if (junMovieHandle != null) {
            this.movieHandle_(junMovieHandle);
        }
    }

    public static JunMoviePlayer Filename_(String string) {
        JunMovieHandle junMovieHandle = JunMovieHandle.Filename_(string);
        if (junMovieHandle == null) {
            return null;
        }
        JunMoviePlayer junMoviePlayer = JunMoviePlayer.MovieHandle_(junMovieHandle);
        return junMoviePlayer;
    }

    public static JunMoviePlayer MovieHandle_(JunMovieHandle junMovieHandle) {
        return new JunMoviePlayer(junMovieHandle);
    }

    public static JunMoviePlayer OpenMovie() {
        JunMovieHandle junMovieHandle = JunMovieHandle.OpenMovie();
        if (junMovieHandle == null) {
            return null;
        }
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(junMovieHandle);
        junMoviePlayer.open();
        return junMoviePlayer;
    }

    public static JunMoviePlayer Request() {
        return JunMoviePlayer.Request_("Select a movie file.");
    }

    public static JunMoviePlayer Request_(String string) {
        File file = JunMoviePlayer.RequestFile();
        if (file == null) {
            return null;
        }
        JunMoviePlayer junMoviePlayer = JunMoviePlayer.Filename_(file.getPath());
        return junMoviePlayer;
    }

    public static File RequestFile() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunMoviePlayer.$String((String)"movie files"), JunSystem.DefaultMovieExtensionPatterns())};
        File file = JunFileRequesterDialog.Request(JunMoviePlayer.$String((String)"Select a movie file"), fileTypeArray, fileTypeArray[0]);
        return file;
    }

    public static JunMoviePlayer RequestOpen() {
        JunMoviePlayer junMoviePlayer = JunMoviePlayer.Request();
        if (junMoviePlayer == null) {
            return null;
        }
        junMoviePlayer.open();
        return junMoviePlayer;
    }

    public static JunMoviePlayer RequestOpenAndPlay() {
        JunMoviePlayer junMoviePlayer = JunMoviePlayer.Request();
        if (junMoviePlayer == null) {
            return null;
        }
        junMoviePlayer.openAndPlay();
        return junMoviePlayer;
    }

    public static Rectangle AlignRectangle_withRectangle_(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle2.width;
        int n2 = rectangle.height * rectangle2.width / rectangle.width;
        Point point = new StRectangle(rectangle2).center();
        StRectangle stRectangle = new StRectangle(0, 0, n, n2);
        if ((stRectangle = stRectangle.align_with_(stRectangle.center(), point)).height() <= rectangle2.height) {
            return stRectangle.toRectangle();
        }
        n = rectangle.width * rectangle2.height / rectangle.height;
        n2 = rectangle2.height;
        stRectangle = new StRectangle(0, 0, n, n2);
        stRectangle = stRectangle.align_with_(stRectangle.center(), point);
        return stRectangle.toRectangle();
    }

    protected void initialize() {
        super.initialize();
        this.movieHandle = null;
        this.moviePort = null;
        this.trackerModel = null;
        this.trackingProcess = null;
        this.trackingFlag = false;
        this.playingFlag = false;
        this.startTime = -1.0;
        this.trackerModel2 = null;
        this.soundValueHolder = null;
        this.soundSpectrum = null;
        this.volumeGauge = null;
        this.keepAspect = true;
        this._popupMenu = null;
    }

    public void release() {
        this.releaseMovie();
        super.release();
    }

    protected void releaseMovie() {
        this.trackerModel().end();
        this.stop();
        this.releaseMovieHandle();
        this.releaseMoviePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseMovieHandle() {
        if (this.movieHandle == null) {
            return;
        }
        JunMovieHandle junMovieHandle = this.movieHandle;
        synchronized (junMovieHandle) {
            this.movieHandle.release();
            this.movieHandle = null;
        }
    }

    protected void releaseGrafPtr() {
        if (this.moviePort != null) {
            this.moviePort.destroyPortAssociation();
            this.moviePort = null;
        }
    }

    protected void releaseMoviePort() {
        this.releaseGrafPtr();
    }

    protected void finalize() {
        this.release();
    }

    public Component movieComponent() {
        if (JunQTMovieFactory.portCreatesComponent()) {
            return this.moviePort(false).getComponent();
        }
        return this.getMovieView().toComponent();
    }

    public JunMovieHandle movieHandle() {
        return this.movieHandle;
    }

    public void movieHandle_(JunMovieHandle junMovieHandle) {
        if (this.movieHandle != null) {
            this.movieHandle.removeDependent_((DependentListener)this);
            this.releaseMovieHandle();
        }
        this.movieHandle = junMovieHandle;
        if (this.movieHandle != null) {
            this.movieHandle.addDependent_((DependentListener)this);
        }
        if (this.hasMovie()) {
            this.trackerModel().step_(1.0 / (double)this.movieHandle.duration());
            if (this.volumeGauge != null) {
                this.movieHandle.volume_(this.volumeGauge.doubleValue());
            }
        }
    }

    public JunTrackerModel trackerModel() {
        if (this.trackerModel == null) {
            this.trackerModel = this._newTrackerModel();
            this.trackerModel.addDependent_((DependentListener)this);
            this.trackerModel.playButton().action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.playAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            this.trackerModel.loopButton().action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.loopAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            this.trackerModel.nextButton().action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.nextAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            this.trackerModel.previousButton().action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.previousAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            this.trackerModel.speakerButton().selectedMenuItemHolder().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    StMenuItem stMenuItem = (StMenuItem)object;
                    if (stMenuItem == null) {
                        System.out.println();
                    }
                    JunMoviePlayer.this.speakerAction_((Number)stMenuItem.value());
                    return null;
                }
            });
            this.trackerModel.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.setTime_((Double)object);
                    return null;
                }
            });
        }
        return this.trackerModel;
    }

    public JunTrackSliderModel trackerModel2() {
        if (this.trackerModel2 == null) {
            this.trackerModel2 = this._newTrackerModel2();
            this.trackerModel2.parentTracker_(this.trackerModel());
            this.trackerModel2.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMoviePlayer.this.setTime2_((Double)object);
                    return null;
                }
            });
        }
        return this.trackerModel2;
    }

    public JunSoundMeterModel soundSpectrum() {
        if (this.soundSpectrum == null) {
            this.soundSpectrum = new JunSoundMeterModel();
            this.soundSpectrum.soundValueHolder_(this.soundValueHolder());
        }
        return this.soundSpectrum;
    }

    public JunSimpleGaugeModel volumeGauge() {
        if (this.volumeGauge == null) {
            this.volumeGauge = new JunSimpleGaugeModel(this.hasMovie() ? this.movieHandle().volume() : 1.0, 0.0, 1.0, 0.01);
            this.volumeGauge.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    double d = ((Number)object).doubleValue();
                    if (JunMoviePlayer.this.hasMovie()) {
                        JunMoviePlayer.this.movieHandle().volume_(d);
                    }
                    String string = String.valueOf(Math.round((double)Math.round(d / 0.1) * 0.1 * 100.0));
                    StMenuItem stMenuItem = JunMoviePlayer.this.trackerModel().speakerButton().menu().atNameKey_(8.$((String)string));
                    JunMoviePlayer.this.trackerModel().speakerButton().selectedMenuItem_(stMenuItem);
                    return null;
                }
            });
            this.volumeGauge.valueStringBlock_(new StBlockClosure(){

                public Object value_(Object object) {
                    return Long.toString(Math.round((Double)object * 100.0));
                }
            });
        }
        return this.volumeGauge;
    }

    public boolean keepAspect() {
        return this.keepAspect;
    }

    public void keepAspect_(boolean bl) {
        JunMovieView junMovieView;
        boolean bl2 = this.keepAspect;
        this.keepAspect = bl;
        if (bl2 != this.keepAspect && (junMovieView = this.getMovieView()) != null) {
            junMovieView.setMovieView();
            junMovieView.toComponent().repaint();
        }
    }

    protected JunTrackerModel _newTrackerModel() {
        return new JunTrackerModel();
    }

    protected JunTrackSliderModel _newTrackerModel2() {
        return new JunTrackSliderModel();
    }

    public StView defaultView() {
        return this.defaultViewWithTracker();
    }

    public StView defaultViewWithDoubleTracker() {
        if (JunMoviePlayer.GetDefaultViewMode() == 0) {
            return JunMovieViewAwt.WithDoubleTracker(this);
        }
        return JunMovieViewSwing.WithDoubleTracker(this);
    }

    public StView defaultViewWithoutTracker() {
        if (JunMoviePlayer.GetDefaultViewMode() == 0) {
            return JunMovieViewAwt.WithoutTracker(this);
        }
        return JunMovieViewSwing.WithoutTracker(this);
    }

    public StView defaultViewWithTracker() {
        if (JunMoviePlayer.GetDefaultViewMode() == 0) {
            return JunMovieViewAwt.WithTracker(this);
        }
        return JunMovieViewSwing.WithTracker(this);
    }

    public StObject copy() {
        JunMoviePlayer junMoviePlayer = this.hasMovie() ? new JunMoviePlayer(this.movieHandle().filename()) : new JunMoviePlayer();
        junMoviePlayer.goto_(this.now());
        junMoviePlayer.trackerModel().lastMarker_(this.trackerModel().lastMarker());
        junMoviePlayer.trackerModel().fixLastMarker_(this.trackerModel().fixLastMarker());
        junMoviePlayer.trackerModel().firstMarker_(this.trackerModel().firstMarker());
        junMoviePlayer.trackerModel().fixFirstMarker_(this.trackerModel().fixFirstMarker());
        junMoviePlayer.trackerModel().loopCondition_(this.trackerModel().loopCondition());
        if (this.trackerModel().areMarkersActive()) {
            junMoviePlayer.trackerModel().enableMarkers();
        } else {
            junMoviePlayer.trackerModel().disableMarkers();
        }
        junMoviePlayer.keepAspect_(this.keepAspect);
        return junMoviePlayer;
    }

    public boolean areMarkersActive() {
        return this.trackerModel().areMarkersActive();
    }

    public boolean atStart() {
        return this.now() <= 0.0;
    }

    public boolean atEnd() {
        if (this.isIntervalNotEmpty() && this.startTime <= this.trackerModel().lastMarker() && this.trackerModel().lastMarker() <= this.now()) {
            return true;
        }
        return this.now() >= 1.0;
    }

    public boolean hasMovie() {
        return this.movieHandle() != null && this.movieHandle().hasMovie();
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isIntervalNotEmpty() {
        return this.trackerModel().isIntervalNotEmpty();
    }

    public boolean isPlay() {
        return this.trackerModel().playButton().value();
    }

    public boolean isSound() {
        if (this.movieHandle() == null) {
            return false;
        }
        return this.movieHandle().isSound();
    }

    public boolean viewHasTracker() {
        JunMovieView junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return false;
        }
        return junMovieView.hasTracker();
    }

    public boolean viewHasTracker2() {
        JunMovieView junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return false;
        }
        return junMovieView.hasTracker2();
    }

    public void start() {
        if (this.hasMovie()) {
            this.trackingProcess = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread.yield();
                    JunTrackerModel junTrackerModel = JunMoviePlayer.this.trackerModel();
                    junTrackerModel.playButtonVisual_(true);
                    try {
                        if (JunMoviePlayer.this.movieHandle().done()) {
                            JunMoviePlayer.this.movieHandle().goToBeginning();
                        }
                        if (JunMoviePlayer.this.isIntervalNotEmpty() && JunMoviePlayer.this.now() >= junTrackerModel.lastMarker()) {
                            JunMoviePlayer.this.goto_(junTrackerModel.firstMarker());
                        }
                        JunMoviePlayer.this.startTime = JunMoviePlayer.this.now();
                        JunMoviePlayer.this.movieHandle.timeValue_((int)Math.round(JunMoviePlayer.this.startTime * (double)JunMoviePlayer.this.movieHandle.duration()));
                        JunMoviePlayer.this.movieHandle().start();
                        while (JunMoviePlayer.this.isPlay()) {
                            JunMoviePlayer.this.next();
                            Thread.yield();
                        }
                    }
                    finally {
                        junTrackerModel.playButtonVisual_(false);
                    }
                }
            };
            this.trackingProcess.setPriority(5);
            this.trackingProcess.start();
        }
    }

    public void stop() {
        this.trackerModel().playButtonVisual_(false);
        if (this.hasMovie()) {
            this.movieHandle.stop();
        }
        this.startTime = -1.0;
        if (this.trackingProcess != null) {
            try {
                this.trackingProcess.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.trackingProcess = null;
        }
    }

    public synchronized void next() {
        if (this.hasMovie()) {
            this.startTime = this.now();
            this.movieHandle.doMovieTask();
            this.setTrackerValue_((double)this.movieHandle.timeValue() / (double)this.movieHandle.duration());
            if (this.atEnd()) {
                if (this.movieHandle.done()) {
                    this.setTrackerValue_(1.0);
                } else if (this.isIntervalNotEmpty()) {
                    this.setTrackerValue_(this.trackerModel().lastMarker());
                }
                if (this.trackerModel().loopCondition() == JunMoviePlayer.$((String)"loop")) {
                    this.movieHandle.stop();
                    if (this.isIntervalNotEmpty()) {
                        this.goto_(this.trackerModel().firstMarker());
                    } else {
                        this.prologue();
                    }
                    this.movieHandle.start();
                } else {
                    this.stop();
                }
            }
        } else {
            this.stop();
        }
    }

    public void go_(double d) {
        this.goto_(this.now() + d);
    }

    public void goInMilliseconds_(double d) {
        this.gotoInMilliseconds_(this.nowInMilliseconds() + d);
    }

    public void goInSeconds_(double d) {
        this.gotoInSeconds_(this.nowInSeconds() + d);
    }

    public void goto_(double d) {
        this.trackerModel().value_(Math.max(0.0, Math.min(d, 1.0)));
    }

    public void gotoInMilliseconds_(double d) {
        double d2 = this.howLongInMilliseconds();
        double d3 = Math.max(0.0, Math.min(d, d2));
        this.goto_(d3 / d2);
    }

    public void gotoInSeconds_(double d) {
        double d2 = this.howLongInSeconds();
        double d3 = Math.max(0.0, Math.min(d, d2));
        this.goto_(d3 / d2);
    }

    public void gotoNextInterestingTime() {
        if (this.hasMovie()) {
            this.trackerModel().value_((double)this.movieHandle.nextInterestingTime() / (double)this.movieHandle.duration());
        }
    }

    public void gotoPreviousInterestingTime() {
        if (this.hasMovie()) {
            this.trackerModel().value_((double)this.movieHandle.previousInterestingTime() / (double)this.movieHandle.duration());
        }
    }

    public void prologue() {
        this.goto_(0.0);
    }

    public void epilogue() {
        this.goto_(1.0);
    }

    public double now() {
        return this.trackerModel().doubleValue();
    }

    public double nowInMilliseconds() {
        return this.now() * this.howLongInMilliseconds();
    }

    public double nowInSeconds() {
        return this.now() * this.howLongInSeconds();
    }

    public double howLongInMilliseconds() {
        return this.howLongInSeconds() * 1000.0;
    }

    public double howLongInSeconds() {
        return this.movieHandle().durationInSeconds();
    }

    public StImage asImage() {
        Image image = this.toImage();
        return image == null ? null : new StImage(image);
    }

    public Image toImage() {
        if (!this.hasMovie()) {
            return null;
        }
        return this.movieHandle().toImage();
    }

    public Frame open() {
        Frame frame = super.open();
        this.normalSize();
        return frame;
    }

    public void openAndPlay() {
        this.open();
        this.start();
    }

    public void openAndPlayAndClose() {
        this.open();
        this.start();
        Thread thread = new Thread(){

            public void run() {
                while (JunMoviePlayer.this.hasMovie() && !JunMoviePlayer.this.atEnd()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                JunMoviePlayer.this.closeRequest();
            }
        };
        thread.start();
    }

    public void openAndPlayAndCloseWithoutTracker() {
        this.openView_(this.defaultViewWithoutTracker());
        this.start();
        Thread thread = new Thread(){

            public void run() {
                while (JunMoviePlayer.this.hasMovie() && !JunMoviePlayer.this.atEnd()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                JunMoviePlayer.this.closeRequest();
            }
        };
        thread.start();
    }

    protected String windowTitle() {
        return JunMoviePlayer.$String((String)"Movie Player");
    }

    public void loopAction_(JunButtonModel junButtonModel) {
        if (this.trackerModel().loopCondition() == JunMoviePlayer.$((String)"oneWay")) {
            this.trackerModel().loop();
        } else {
            this.trackerModel().oneWay();
        }
    }

    public void nextAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.trackerModel().last();
        } else if (this.isSound()) {
            this.go_(0.005);
        } else {
            this.gotoNextInterestingTime();
        }
    }

    public void playAction_(JunButtonModel junButtonModel) {
        if (junButtonModel.value()) {
            this.stop();
        } else {
            if (junButtonModel._isPressedWithShiftDown()) {
                this.trackerModel().first();
            }
            this.start();
        }
    }

    public void previousAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.trackerModel().first();
        } else if (this.isSound()) {
            this.go_(-0.005);
        } else {
            this.gotoPreviousInterestingTime();
        }
    }

    public void speakerAction_(Number number) {
        float f = number.floatValue();
        if (f == (float)Math.round(this.volumeGauge().doubleValue() * 10.0) / 10.0f) {
            return;
        }
        if (this.movieHandle() != null) {
            this.volumeGauge().value_(f);
        }
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Open") + "..."), JunMoviePlayer.$((String)"openMovie"), (MenuListener)new MenuPerformer((StObject)this, "openMovie")));
            this._popupMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Open URL") + "..."), JunMoviePlayer.$((String)"openMovieFromURL"), (MenuListener)new MenuPerformer((StObject)this, "openMovieFromURL")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Start"), JunMoviePlayer.$((String)"start"), (MenuListener)new MenuPerformer((StObject)this, "start")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Stop"), JunMoviePlayer.$((String)"stop"), (MenuListener)new MenuPerformer((StObject)this, "stop")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Half size"), JunMoviePlayer.$((String)"halfSize"), (MenuListener)new MenuPerformer((StObject)this, "halfSize")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Normal size"), JunMoviePlayer.$((String)"normalSize"), (MenuListener)new MenuPerformer((StObject)this, "normalSize")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Double size"), JunMoviePlayer.$((String)"doubleSize"), (MenuListener)new MenuPerformer((StObject)this, "doubleSize")));
            this._popupMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Keep aspect"), JunMoviePlayer.$((String)"toggleKeepAspect"), this.keepAspect(), (MenuListener)new MenuPerformer((StObject)this, "toggleKeepAspect")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Show tracker"), JunMoviePlayer.$((String)"showTracker"), (MenuListener)new MenuPerformer((StObject)this, "showTracker")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Hide tracker"), JunMoviePlayer.$((String)"hideTracker"), (MenuListener)new MenuPerformer((StObject)this, "hideTracker")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Sound volume"), JunMoviePlayer.$((String)"soundVolume"), (MenuListener)new MenuPerformer((StObject)this, "soundVolume")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Sound meter"), JunMoviePlayer.$((String)"soundMeter"), (MenuListener)new MenuPerformer((StObject)this, "soundMeter")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Calculate sound wave"), JunMoviePlayer.$((String)"calculateSoundWave"), (MenuListener)new MenuPerformer((StObject)this, "calculateSoundWave")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Spawn"), JunMoviePlayer.$((String)"spawnMovie"), (MenuListener)new MenuPerformer((StObject)this, "spawnMovie")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Spawn image"), JunMoviePlayer.$((String)"spawnImage"), (MenuListener)new MenuPerformer((StObject)this, "spawnImage")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Save selection") + "..."), JunMoviePlayer.$((String)"saveSelection"), (MenuListener)new MenuPerformer((StObject)this, "saveSelection")));
            this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"openMovieFromURL")).disable();
        }
        return this._popupMenu;
    }

    protected void _updatePopupMenu() {
        StMenuItem stMenuItem = this._popupMenu().atNameKey_(JunMoviePlayer.$((String)"start"));
        if (stMenuItem != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(!this.isPlay());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"stop"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(this.isPlay());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"halfSize"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(!this.isEmbedded());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"normalSize"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(!this.isEmbedded());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"doubleSize"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(!this.isEmbedded());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"toggleKeepAspect"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.enable();
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.keepAspect());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"showTracker"))) != null) {
            if (this.viewHasTracker()) {
                stMenuItem.disable();
            } else {
                stMenuItem.beEnabled(!this.isEmbedded());
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"hideTracker"))) != null) {
            if (this.viewHasTracker()) {
                stMenuItem.beEnabled(!this.isEmbedded());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"soundVolume"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"soundMeter"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"calculateSoundWave"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"spawnImage"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.beEnabled(!this.isSound());
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = this._popupMenu.atNameKey_(JunMoviePlayer.$((String)"saveSelection"))) != null) {
            if (this.hasMovie()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
            if (this.isIntervalNotEmpty()) {
                stMenuItem.label_((Object)(JunSystem.$String((String)"Save selection") + "..."));
            } else {
                stMenuItem.label_((Object)(JunSystem.$String((String)"Save whole") + "..."));
            }
        }
    }

    public void doubleSize() {
        if (this.hasMovie()) {
            Dimension dimension = this.movieHandle.originalExtent();
            Dimension dimension2 = new Dimension(dimension.width * 2, dimension.height * 2);
            this.setSize_(dimension2);
        }
    }

    public void halfSize() {
        if (this.hasMovie()) {
            Dimension dimension = this.movieHandle.originalExtent();
            Dimension dimension2 = new Dimension(dimension.width / 2, dimension.height / 2);
            this.setSize_(dimension2);
        }
    }

    public void hideTracker() {
        JunMovieView junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return;
        }
        Window window = junMovieView.topComponent();
        if (window == null) {
            return;
        }
        if (!junMovieView.hasTracker()) {
            return;
        }
        int n = junMovieView.hasTracker2() ? -38 : -19;
        Rectangle rectangle = window.getBounds();
        rectangle.height += n;
        boolean bl = this.isPlay();
        if (bl) {
            this.stop();
        }
        JunMoviePlayer junMoviePlayer = (JunMoviePlayer)this.copy();
        junMoviePlayer.openViewIn_(junMoviePlayer.defaultViewWithoutTracker(), rectangle);
        this.closeRequest();
        if (bl) {
            junMoviePlayer.start();
        }
    }

    public void normalSize() {
        if (this.hasMovie()) {
            this.setSize_(this.movieHandle.originalExtent());
        }
    }

    public void openMovie() {
        JunMovieHandle junMovieHandle = JunMovieHandle.OpenMovie();
        if (junMovieHandle.hasMovie()) {
            if (this.movieHandle != null) {
                JunMoviePlayer junMoviePlayer = JunMoviePlayer.MovieHandle_(junMovieHandle);
                junMoviePlayer.open();
            } else {
                this.movieHandle_(junMovieHandle);
                this.normalSize();
            }
        }
    }

    public void saveSelection() {
        if (!this.hasMovie()) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)JunSystem.$String((String)"Movie")), new String[]{"*.mov", "*.MOV"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunSystem.$String((String)"Input a <1p> file.", null, (Object)"MOV"), new File(this.defaultBaseName() + ".mov"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        this.saveSelectionTo_(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSelectionTo_(File file) {
        int n;
        int n2;
        if (this.isIntervalNotEmpty()) {
            n2 = (int)Math.round(this.trackerModel().firstMarker() * (double)this.movieHandle().duration());
            n = (int)Math.round((this.trackerModel().lastMarker() - this.trackerModel().firstMarker()) * (double)this.movieHandle().duration());
        } else {
            n2 = 0;
            n = this.movieHandle().duration();
        }
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        JunQTMovie junQTMovie = null;
        try {
            junCursors._show();
            this.movieHandle().selection_duration_(n2, n);
            junQTMovie = this.movieHandle().copyMovie();
        }
        finally {
            junCursors._restore();
        }
        if (junQTMovie == null) {
            return;
        }
        JunCursors junCursors2 = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors2._show();
            junQTMovie.flattenToFile(file);
        }
        finally {
            junQTMovie.release();
            junCursors2._restore();
        }
    }

    public void showTracker() {
        int n;
        JunMovieView junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return;
        }
        Window window = junMovieView.topComponent();
        if (window == null) {
            return;
        }
        if (junMovieView.hasTracker()) {
            if (junMovieView.hasTracker2()) {
                if (this.areMarkersActive()) {
                    return;
                }
                n = -19;
            } else {
                if (!this.areMarkersActive()) {
                    return;
                }
                n = 19;
            }
        } else {
            n = this.areMarkersActive() ? 38 : 19;
        }
        Rectangle rectangle = window.getBounds();
        rectangle.height += n;
        boolean bl = this.isPlay();
        if (bl) {
            this.stop();
        }
        JunMoviePlayer junMoviePlayer = (JunMoviePlayer)this.copy();
        if (this.areMarkersActive()) {
            junMoviePlayer.openViewIn_(junMoviePlayer.defaultViewWithDoubleTracker(), rectangle);
        } else {
            junMoviePlayer.openViewIn_(junMoviePlayer.defaultViewWithTracker(), rectangle);
        }
        this.closeRequest();
        if (bl) {
            junMoviePlayer.start();
        }
    }

    public void soundMeter() {
        JunSoundMeterModel junSoundMeterModel = this.soundSpectrum();
        if (junSoundMeterModel.builder().windows().length > 0) {
            junSoundMeterModel._windowExpandAndRaise();
        } else {
            Frame[] frameArray;
            StView stView = this.getView();
            if (stView == null) {
                junSoundMeterModel.open();
            } else {
                frameArray = new StRectangle(stView.topComponent().getBounds());
                StRectangle stRectangle = new StRectangle(0, 0, 190, 45);
                stRectangle = stRectangle.expandedBy_(new StRectangle(0, 0, 8, 27));
                stRectangle = stRectangle.align_with_(stRectangle.bottomLeft(), new Point(frameArray.left(), frameArray.top() - 5));
                junSoundMeterModel.openIn_(stRectangle.toRectangle());
            }
            frameArray = junSoundMeterModel.builder().frames();
            for (int i = 0; i < frameArray.length; ++i) {
                frameArray[i].setTitle(JunSystem.$String((String)"Sound meter", (String)"Meter"));
            }
        }
    }

    public void soundVolume() {
        JunSimpleGaugeModel junSimpleGaugeModel = this.volumeGauge();
        if (junSimpleGaugeModel.builder().windows().length > 0) {
            junSimpleGaugeModel._windowExpandAndRaise();
        } else {
            Frame[] frameArray;
            StView stView = this.getView();
            if (stView == null) {
                junSimpleGaugeModel.open();
            } else {
                frameArray = new StRectangle(stView.topComponent().getBounds());
                StRectangle stRectangle = new StRectangle(0, 0, 124, 45);
                stRectangle = stRectangle.expandedBy_(new StRectangle(0, 0, 8, 27));
                stRectangle = stRectangle.align_with_(stRectangle.bottomRight(), new Point(frameArray.right(), frameArray.top() - 5));
                junSimpleGaugeModel.openIn_(stRectangle.toRectangle());
            }
            frameArray = junSimpleGaugeModel.builder().frames();
            for (int i = 0; i < frameArray.length; ++i) {
                frameArray[i].setTitle(JunSystem.$String((String)"Sound volume", (String)"Volume"));
            }
        }
    }

    public void spawnImage() {
        StImage stImage = this.asImage();
        if (stImage == null) {
            return;
        }
        JunImageUtility.Show_((StDisplayable)stImage);
    }

    public void spawnMovie() {
        if (!this.hasMovie()) {
            return;
        }
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(this.movieHandle().filename());
        junMoviePlayer.goto_(this.now());
        junMoviePlayer.open();
    }

    public void toggleKeepAspect() {
        this.keepAspect_(!this.keepAspect());
    }

    public double[] soundLevelFrom_to_length_(double d, double d2, int n) {
        int n2 = this.movieHandle().duration();
        int n3 = Math.max(0, Math.min((int)(d * (double)n2), n2));
        int n4 = Math.min(Math.max(n3 + Math.max(this.soundMeterTimeStep, 50), (int)(d2 * (double)n2)), n2);
        byte[] byArray = this.movieHandle().asSoundDataFrom_duration_(n3, n4 - n3);
        if (byArray == null) {
            return null;
        }
        int n5 = byArray.length;
        if (n4 - n3 > this.soundMeterTimeStep) {
            n5 = n5 * this.soundMeterTimeStep / (n4 - n3);
        }
        double[] dArray = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            int n6 = 128;
            int n7 = 128;
            int n8 = Math.min((i + 1) * n5, byArray.length);
            for (int j = i * n5; j < n8; ++j) {
                int n9 = byArray[j] & 0xFF;
                if (n9 < n6) {
                    n6 = n9;
                    continue;
                }
                if (n9 <= n7) continue;
                n7 = n9;
            }
            dArray[i * 2] = (double)n6 / 255.0;
            dArray[i * 2 + 1] = (double)n7 / 255.0;
        }
        return dArray;
    }

    public int soundMeterTimeStep() {
        return this.soundMeterTimeStep;
    }

    public void soundMeterTimeStep_(int n) {
        this.soundMeterTimeStep = n;
    }

    public StValueHolder soundValueHolder() {
        if (this.soundValueHolder == null) {
            this.soundValueHolder = new StValueHolder();
        }
        return this.soundValueHolder;
    }

    public void calculateSoundWave() {
        this.soundMeter();
        Thread thread = new Thread(){

            public void run() {
                int n = JunMoviePlayer.this.movieHandle().duration();
                int n2 = 0;
                int n3 = n;
                if (JunMoviePlayer.this.isIntervalNotEmpty()) {
                    n2 = (int)Math.round(JunMoviePlayer.this.trackerModel().firstMarker() * (double)n / (double)JunMoviePlayer.this.soundMeterTimeStep) * JunMoviePlayer.this.soundMeterTimeStep;
                    n3 = (int)(JunMoviePlayer.this.trackerModel().lastMarker() * (double)n);
                }
                int n4 = (600 + JunMoviePlayer.this.soundMeterTimeStep - 1) / JunMoviePlayer.this.soundMeterTimeStep;
                JunSoundMeterModel junSoundMeterModel = JunMoviePlayer.this.soundSpectrum;
                for (int i = n2; i < n3; i += JunMoviePlayer.this.soundMeterTimeStep * n4) {
                    if (JunMoviePlayer.this.soundSpectrum == null) continue;
                    double[] dArray = JunMoviePlayer.this.soundLevelFrom_to_length_((double)i / (double)n, (double)(i + JunMoviePlayer.this.soundMeterTimeStep * n4) / (double)n, n4);
                    if (dArray != null) {
                        for (int j = 0; j < n4; ++j) {
                            double d = (double)(i + JunMoviePlayer.this.soundMeterTimeStep * j) / (double)n;
                            if (!(d < 1.0)) continue;
                            junSoundMeterModel.soundLevelData().put(new Double(d), new double[]{dArray[j * 2], dArray[j * 2 + 1]});
                        }
                    }
                    junSoundMeterModel.changed();
                }
            }
        };
        thread.start();
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        if (this.soundSpectrum != null) {
            this.soundSpectrum.closeRequest();
            this.soundSpectrum = null;
        }
        if (this.volumeGauge != null) {
            this.volumeGauge.closeRequest();
            this.volumeGauge = null;
        }
        this.release();
        super.noticeOfWindowClose(windowEvent);
    }

    public KeyListener _keyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (JunMoviePlayer.this._keyboardEvent(keyEvent)) {
                    keyEvent.consume();
                }
            }
        };
    }

    protected boolean _keyboardEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (!this.hasMovie()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: 
            case 32: {
                if (this.isPlay()) {
                    this.stop();
                } else {
                    this.start();
                }
                return true;
            }
            case 37: {
                this.previousAction_(this.trackerModel().previousButton());
                return true;
            }
            case 39: {
                this.nextAction_(this.trackerModel().nextButton());
                return true;
            }
            case 84: {
                if (this.trackerModel().loopCondition() == JunMoviePlayer.$((String)"oneWay")) {
                    this.trackerModel().loopCondition_(JunMoviePlayer.$((String)"loop"));
                } else {
                    this.trackerModel().loopCondition_(JunMoviePlayer.$((String)"oneWay"));
                }
                return true;
            }
            case 91: {
                this.trackerModel().firstMarker_(this.now());
                return true;
            }
            case 93: {
                this.trackerModel().lastMarker_(this.now());
                return true;
            }
            case 80: {
                this.prologue();
                return true;
            }
            case 69: {
                this.epilogue();
                return true;
            }
            case 70: {
                this.trackerModel().first();
                return true;
            }
            case 76: {
                this.trackerModel().last();
                return true;
            }
        }
        return false;
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunMoviePlayer.$((String)"releasing")) {
            this.playingFlag = this.isPlay();
            if (this.playingFlag) {
                this.stop();
            }
        } else if (stSymbol == JunMoviePlayer.$((String)"recovered")) {
            if (this.hasMovie()) {
                this.trackerModel().step_(1.0 / (double)this.movieHandle.duration());
                this.movieHandle.timeValue_((int)Math.round(this.trackerModel().doubleValue() * (double)this.movieHandle.duration()));
                JunMovieView junMovieView = this.getMovieView();
                if (junMovieView != null) {
                    junMovieView.setMovieView();
                }
                if (this.playingFlag) {
                    this.start();
                }
            }
        } else if (stSymbol == JunMoviePlayer.$((String)"useMarkers")) {
            this.showTracker();
        } else if (stSymbol == JunMoviePlayer.$((String)"originalExtent")) {
            this.normalSize();
        }
    }

    public JunQTPort moviePort(boolean bl) {
        if (this.moviePort == null) {
            Component component = (Component)((Object)this.getMovieView());
            this.moviePort = JunQTMovieFactory.createPort(component);
            this.moviePort.createPortAssociation1();
            if (JunQTMovieFactory.portCreatesComponent()) {
                Component component2 = this.moviePort.getComponent();
                component2.addMouseListener((MouseListener)this.getMovieView().controller());
            }
        }
        if (bl) {
            this.moviePort.createPortAssociation2();
        }
        return this.moviePort;
    }

    protected JunMovieView getMovieView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunMovieView)) continue;
            return (JunMovieView)dependentListenerArray[i];
        }
        return null;
    }

    protected double[] markerMargins() {
        return new double[]{0.1, 0.1};
    }

    protected void setSize_(Dimension dimension) {
        if (!this.hasMovie()) {
            return;
        }
        JunMovieView junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return;
        }
        Window window = junMovieView.topComponent();
        if (window == null) {
            return;
        }
        Dimension dimension2 = junMovieView.toComponent().getSize();
        Dimension dimension3 = dimension;
        int n = window.getWidth() - dimension2.width + dimension3.width;
        int n2 = window.getHeight() - dimension2.height + dimension3.height;
        window.setSize(n, n2);
        window.validate();
        junMovieView = this.getMovieView();
        if (junMovieView == null) {
            return;
        }
        junMovieView.setMovieView();
    }

    protected void setSoundValue_(double d) {
        if (this.soundSpectrum != null) {
            int n = this.movieHandle().duration();
            int n2 = (int)Math.round(d * (double)n / (double)this.soundMeterTimeStep) * this.soundMeterTimeStep;
            Double d2 = new Double(d = (double)n2 / (double)n);
            double[] dArray = this.soundSpectrum.soundLevelDataAt_(d2);
            if (dArray == null) {
                dArray = this.soundLevelFrom_to_length_(d, d, 1);
            }
            if (dArray != null) {
                this.soundValueHolder().value_((Object)new Object[]{d2, dArray});
            }
        }
    }

    protected synchronized void setTime_(double d) {
        if (!this.trackingFlag && this.hasMovie()) {
            this.movieHandle.timeValue_((int)Math.round(d * (double)this.movieHandle.duration()));
            this.movieHandle.doMovieTask();
        }
        this.setTime1_(d);
    }

    protected void setTime1_(double d) {
        double d2;
        boolean bl = this.trackerModel2().areMarkersActive();
        if (this.trackerModel().isIntervalNotEmpty()) {
            this.trackerModel2().enableMarkers();
        } else {
            this.trackerModel2().disableMarkers();
        }
        if (bl != this.trackerModel2().areMarkersActive()) {
            DependentListener[] dependentListenerArray = this.trackerModel2().dependents();
            for (int i = 0; i < dependentListenerArray.length; ++i) {
                if (!(dependentListenerArray[i] instanceof JunTrackSliderView)) continue;
                dependentListenerArray[i].update_(new DependentEvent((Object)dependentListenerArray[i], JunMoviePlayer.$((String)"interval"), null));
            }
        }
        double[] dArray = this.markerMargins();
        if (this.trackerModel().isIntervalNotEmpty()) {
            d2 = (this.now() - this.trackerModel().firstMarker()) / (this.trackerModel().lastMarker() - this.trackerModel().firstMarker());
            d2 = d2 * (1.0 - dArray[0] - dArray[1]) + dArray[0];
            d2 = Math.max(0.0, Math.min(d2, 1.0));
        } else {
            d2 = this.now();
        }
        this.trackerModel2().intervalHolder().value_((Object)new double[]{dArray[0], 1.0 - dArray[1]});
        this.trackerModel2().valueHolder().value_(d2);
        DependentListener[] dependentListenerArray = this.trackerModel2().dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunTrackSliderView)) continue;
            dependentListenerArray[i].update_(new DependentEvent((Object)dependentListenerArray[i], JunMoviePlayer.$((String)"value"), null));
        }
    }

    protected synchronized void setTime2_(double d) {
        if (!this.trackingFlag && this.hasMovie()) {
            if (this.trackerModel().isIntervalNotEmpty()) {
                double[] dArray = this.markerMargins();
                double d2 = (d - dArray[0]) / (1.0 - dArray[0] - dArray[1]);
                d2 = (this.trackerModel().lastMarker() - this.trackerModel().firstMarker()) * d2 + this.trackerModel().firstMarker();
                this.goto_(d2);
            } else {
                this.goto_(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTrackerValue_(double d) {
        this.trackingFlag = true;
        try {
            this.trackerModel().value_(d);
        }
        finally {
            this.trackingFlag = false;
        }
        this.setSoundValue_(d);
    }
}

