/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.itemlist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.itemlist.JunOrderListController;
import jp.co.sra.jun.goodies.itemlist.JunOrderListModel;
import jp.co.sra.jun.goodies.itemlist.JunOrderListObject;
import jp.co.sra.jun.goodies.itemlist.JunOrderListView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunOrderListViewSwing
extends JunAbstractViewJPanel
implements JunOrderListView {
    protected Vector itemVisualRectangles;
    protected Vector itemRowRectangles;
    protected Rectangle boundingBox;
    protected JunButtonViewSwing upButtonView;
    protected JunButtonViewSwing downButtonView;

    public JunOrderListViewSwing(JunOrderListModel junOrderListModel) {
        super(junOrderListModel);
    }

    public static StView OnScrollPaneWithButtons(JunOrderListModel junOrderListModel) {
        return new StViewJPanel((StModel)junOrderListModel){
            protected JunOrderListViewSwing orderListView;

            protected void buildComponent() {
                this.orderListView = new JunOrderListViewSwing((JunOrderListModel)this.model());
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.orderListView), 22, 32){

                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, n2, n3, n4);
                        this.doLayout();
                        orderListView.setBounds(0, 0, this.getViewport().getExtentSize().width, this.getViewport().getExtentSize().height);
                    }
                };
                this.setLayout((LayoutManager)new WindowSpecLayout());
                this.add(jScrollPane, WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)1.0f, (int)-20, (float)1.0f, (int)-1));
                this.add((Component)((Object)this.orderListView.upButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.5f, (int)-19, (float)1.0f, (int)-1, (float)0.5f, (int)-1));
                this.add((Component)((Object)this.orderListView.downButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.5f, (int)1, (float)1.0f, (int)-1, (float)0.5f, (int)19));
                this.setPreferredSize(new Dimension(150, 150));
            }
        };
    }

    protected void initialize() {
        super.initialize();
        this.flushCachedInformation();
    }

    public JunOrderListModel getModel() {
        return (JunOrderListModel)this.model();
    }

    public JunOrderListController getController() {
        return (JunOrderListController)this.controller();
    }

    protected StController defaultController() {
        return new JunOrderListController();
    }

    public Vector checkMarkRectangles() {
        return this.itemVisualRectangles();
    }

    public Rectangle[] _checkMarkRectangleArray() {
        Object[] objectArray = new Rectangle[this.checkMarkRectangles().size()];
        this.checkMarkRectangles().copyInto(objectArray);
        return objectArray;
    }

    public JunOrderListObject itemObjectAt_(int n) {
        return this.getModel().itemObjectAt_(n);
    }

    public Rectangle[] itemObjectRectangles() {
        Rectangle[] rectangleArray = this._checkMarkRectangleArray();
        Rectangle[] rectangleArray2 = this._itemVisualRectangleArray();
        Rectangle[] rectangleArray3 = new Rectangle[rectangleArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = new Rectangle(rectangleArray[i]);
            rectangle.add(rectangleArray2[i]);
            rectangleArray3[i] = rectangle;
        }
        return rectangleArray3;
    }

    public Vector itemRowRectangles() {
        if (this.itemRowRectangles == null) {
            this.computeCachedInformation();
        }
        return this.itemRowRectangles;
    }

    public Rectangle[] _itemRowRectangleArray() {
        Object[] objectArray = new Rectangle[this.itemRowRectangles().size()];
        this.itemRowRectangles().copyInto(objectArray);
        return objectArray;
    }

    public Vector itemVisualRectangles() {
        if (this.itemVisualRectangles == null) {
            this.computeCachedInformation();
        }
        return this.itemVisualRectangles;
    }

    public Rectangle[] _itemVisualRectangleArray() {
        return this._itemVisualRectangleArray();
    }

    public int leftMargin() {
        return 0;
    }

    public int textMargin() {
        return 2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.getBounds());
        super.setBounds(n, n2, n3, n4);
        if (n3 != rectangle.width || n4 != rectangle.height) {
            this.flushCachedInformation();
        }
    }

    public Rectangle getPreferredBounds() {
        if (this.boundingBox == null) {
            this.computeCachedInformation();
        }
        return this.boundingBox;
    }

    public Dimension getPreferredSize() {
        return this.getPreferredBounds().getSize();
    }

    public Rectangle rowBoundsAt_(int n) {
        return (Rectangle)this.itemRowRectangles().get(n);
    }

    protected void buildComponent() {
        this.setBackground(UIManager.getColor("Tree.background"));
        this.setForeground(UIManager.getColor("Tree.foreground"));
    }

    protected JunOrderListView itemListView() {
        return this;
    }

    protected JunButtonViewSwing upButtonView() {
        if (this.upButtonView == null) {
            this.upButtonView = new JunButtonViewSwing(this.getModel().upButton());
        }
        return this.upButtonView;
    }

    protected JunButtonViewSwing downButtonView() {
        if (this.downButtonView == null) {
            this.downButtonView = new JunButtonViewSwing(this.getModel().downButton());
        }
        return this.downButtonView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = this.getBounds();
        }
        Graphics graphics2 = graphics.create();
        try {
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.getModel().isEmpty()) {
                super.displayOn_(graphics2);
                return;
            }
            for (int i = 0; i < this.getModel().size(); ++i) {
                JunOrderListObject junOrderListObject = this.itemObjectAt_(i);
                Rectangle rectangle2 = this.rowBoundsAt_(i);
                rectangle2 = new Rectangle(rectangle2.x + this.leftMargin(), rectangle2.y, rectangle2.width - this.leftMargin(), rectangle2.height);
                if (this.getModel().isSelected_(i)) {
                    graphics2.setColor(this.selectionBackgroundColor());
                    graphics2.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                StComposedText stComposedText = new StComposedText(junOrderListObject.itemString());
                if (this.getModel().isSelected_(i)) {
                    graphics2.setColor(this.selectionForegroundColor());
                } else {
                    graphics2.setColor(this.getForeground());
                }
                stComposedText.displayOn_at_(graphics2, new Point(rectangle2.x + this.textMargin(), rectangle2.y + rectangle2.height / 2 - stComposedText.height() / 2));
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    public void makeVisibleBottom_(int n) {
        Window window = this.topComponent();
        if (window != null) {
            window.repaint();
        }
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.rowBoundsAt_(n);
        Rectangle rectangle2 = new Rectangle(jViewport.getViewPosition().x, jViewport.getViewPosition().y, jViewport.getWidth(), jViewport.getHeight());
        if (rectangle2.y <= rectangle.y && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height) {
            return;
        }
        int n2 = rectangle.y + this.getModel().lineGrid() - rectangle2.height;
        jViewport.setViewPosition(new Point(jViewport.getViewPosition().x, n2));
    }

    public void makeVisibleTop_(int n) {
        Window window = this.topComponent();
        if (window != null) {
            window.repaint();
        }
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.rowBoundsAt_(n);
        Rectangle rectangle2 = new Rectangle(jViewport.getViewPosition().x, jViewport.getViewPosition().y, jViewport.getWidth(), jViewport.getHeight());
        if (rectangle2.y < rectangle.y && rectangle.y + rectangle.height < rectangle2.y + rectangle2.height) {
            return;
        }
        int n2 = rectangle.y;
        jViewport.setViewPosition(new Point(jViewport.getViewPosition().x, n2));
    }

    public Color selectionBackgroundColor() {
        return this.isEnabled() ? UIManager.getColor("Tree.selectionBackground") : Color.darkGray;
    }

    public Color selectionForegroundColor() {
        return this.isEnabled() ? UIManager.getColor("Tree.selectionForeground") : new Color(212, 208, 200);
    }

    public void update_(DependentEvent dependentEvent) {
        Vector vector;
        Vector vector2;
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunOrderListViewSwing.$((String)"list")) {
            this.flushCachedInformation();
        }
        if (stSymbol == JunOrderListViewSwing.$((String)"grid")) {
            this.flushCachedInformation();
        }
        if (stSymbol == JunOrderListViewSwing.$((String)"selections")) {
            vector2 = (Vector)((Object[])dependentEvent.getParameter())[0];
            vector = (Vector)((Object[])dependentEvent.getParameter())[1];
            this.newSelectedIndexes_oldSelectedIndexes_(vector2, vector);
        }
        if (stSymbol == JunOrderListViewSwing.$((String)"marks")) {
            vector2 = (Vector)((Object[])dependentEvent.getParameter())[0];
            vector = (Vector)((Object[])dependentEvent.getParameter())[1];
            this.newSelectedIndexes_oldSelectedIndexes_(vector2, vector);
        }
        if (stSymbol == JunOrderListViewSwing.$((String)"makeVisibleBottom")) {
            this.makeVisibleBottom_((Integer)dependentEvent.getParameter());
        }
        if (stSymbol == JunOrderListViewSwing.$((String)"makeVisibleTop")) {
            this.makeVisibleTop_((Integer)dependentEvent.getParameter());
        }
        super.update_(dependentEvent);
    }

    public void newSelectedIndexes_oldSelectedIndexes_(Vector vector, Vector vector2) {
        Rectangle rectangle;
        Integer n;
        int n2;
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            n = (Integer)vector2.get(n2);
            if (vector.contains(n)) continue;
            rectangle = this.rowBoundsAt_(n);
            this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = (Integer)vector.get(n2);
            if (vector2.contains(n)) continue;
            rectangle = this.rowBoundsAt_(n);
            this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public int whichOfItemRowsAt_(Point point) {
        Rectangle[] rectangleArray = this._itemRowRectangleArray();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangleArray[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    protected void flushCachedInformation() {
        this.itemVisualRectangles = null;
        this.itemRowRectangles = null;
        this.boundingBox = null;
    }

    protected void computeCachedInformation() {
        this.itemVisualRectangles = new Vector();
        this.itemRowRectangles = new Vector();
        this.boundingBox = new Rectangle(0, 0, 0, 0);
        if (this.getModel().isEmpty()) {
            return;
        }
        final int n = this.getModel().lineGrid();
        final int n2 = this.leftMargin();
        final Point point = new Point(0, 0);
        this.getModel().do_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOrderListObject junOrderListObject = (JunOrderListObject)((Object)object);
                Rectangle rectangle = new Rectangle(point.x + n2, point.y, JunOrderListViewSwing.this.getBounds().width - n2, n);
                StComposedText stComposedText = new StComposedText(junOrderListObject.itemString());
                rectangle = new Rectangle(rectangle.x + JunOrderListViewSwing.this.textMargin() * 2, rectangle.y + rectangle.height / 2 - stComposedText.height() / 2, stComposedText.width(), stComposedText.height());
                JunOrderListViewSwing.this.itemVisualRectangles.add(rectangle);
                JunOrderListViewSwing.this.boundingBox.add(rectangle);
                rectangle = new Rectangle(point.x, point.y, JunOrderListViewSwing.this.getBounds().width, n);
                JunOrderListViewSwing.this.itemRowRectangles.add(rectangle);
                JunOrderListViewSwing.this.boundingBox.add(rectangle);
                point.translate(0, n);
                return null;
            }
        });
        Rectangle[] rectangleArray = this._itemRowRectangleArray();
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i].width = this.boundingBox.width;
        }
    }
}

