/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.itemlist;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Vector;
import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.itemlist.JunItemListController;
import jp.co.sra.jun.goodies.itemlist.JunItemListModel;
import jp.co.sra.jun.goodies.itemlist.JunItemListObject;
import jp.co.sra.jun.goodies.itemlist.JunItemListView;
import jp.co.sra.jun.goodies.itemlist.JunOrderListViewAwt;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunItemListViewAwt
extends JunOrderListViewAwt
implements JunItemListView {
    protected Vector checkMarkRectangles;
    protected JunButtonViewAwt checkOffButtonView;
    protected JunButtonViewAwt checkOnButtonView;

    public JunItemListViewAwt(JunItemListModel junItemListModel) {
        super(junItemListModel);
    }

    public static StView OnScrollPaneWithButtons(JunItemListModel junItemListModel) {
        return new StViewPanel((StModel)junItemListModel){
            protected JunItemListViewAwt itemListView;

            protected void buildComponent() {
                this.itemListView = new JunItemListViewAwt((JunItemListModel)this.model());
                ScrollPane scrollPane = new ScrollPane(1){

                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, n2, n3, n4);
                        itemListView.setSize(this.getViewportSize().width, this.getViewportSize().height);
                    }
                };
                scrollPane.add((Component)((Object)this.itemListView));
                this.setLayout((LayoutManager)new WindowSpecLayout());
                this.add(scrollPane, WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)1.0f, (int)-20, (float)1.0f, (int)-1));
                this.add((Component)((Object)this.itemListView.upButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.3f, (int)-19, (float)1.0f, (int)-1, (float)0.3f, (int)-1));
                this.add((Component)((Object)this.itemListView.downButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.3f, (int)1, (float)1.0f, (int)-1, (float)0.3f, (int)19));
                this.add((Component)((Object)this.itemListView.checkOnButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.7f, (int)-19, (float)1.0f, (int)-1, (float)0.7f, (int)-1));
                this.add((Component)((Object)this.itemListView.checkOffButtonView()), WindowSpecLayout.Position((float)1.0f, (int)-19, (float)0.7f, (int)1, (float)1.0f, (int)-1, (float)0.7f, (int)19));
                this.setSize(150, 150);
            }
        };
    }

    public Vector checkMarkRectangles() {
        if (this.checkMarkRectangles == null) {
            this.checkMarkRectangles = new Vector();
        }
        return this.checkMarkRectangles;
    }

    public int leftMargin() {
        return 23;
    }

    protected StController defaultController() {
        return new JunItemListController();
    }

    public JunItemListModel getItemListModel() {
        return (JunItemListModel)this.model();
    }

    protected JunButtonViewAwt checkOffButtonView() {
        if (this.checkOffButtonView == null) {
            this.checkOffButtonView = new JunButtonViewAwt(this.getItemListModel().checkOffButton());
        }
        return this.checkOffButtonView;
    }

    protected JunButtonViewAwt checkOnButtonView() {
        if (this.checkOnButtonView == null) {
            this.checkOnButtonView = new JunButtonViewAwt(this.getItemListModel().checkOnButton());
        }
        return this.checkOnButtonView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = this.getBounds();
        }
        Graphics graphics2 = graphics.create();
        try {
            graphics2.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.getModel().isEmpty()) {
                super.displayOn_(graphics2);
                return;
            }
            for (int i = 0; i < this.getModel().size(); ++i) {
                JunItemListObject junItemListObject = (JunItemListObject)this.itemObjectAt_(i);
                Rectangle rectangle2 = this.rowBoundsAt_(i);
                rectangle2 = new Rectangle(rectangle2.x + this.leftMargin(), rectangle2.y, rectangle2.width - this.leftMargin(), rectangle2.height);
                if (this.getModel().isSelected_(i)) {
                    graphics2.setColor(this.selectionBackgroundColor());
                    graphics2.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                Rectangle rectangle3 = (Rectangle)this.checkMarkRectangles().get(i);
                BufferedImage bufferedImage = junItemListObject.checkMark() ? JunCursors.CheckOnCursorImage() : JunCursors.CheckOffCursorImage();
                graphics2.drawImage(bufferedImage, rectangle3.x, rectangle3.y, (ImageObserver)((Object)this));
                StComposedText stComposedText = new StComposedText(junItemListObject.itemString());
                if (this.getModel().isSelected_(i)) {
                    graphics2.setColor(this.selectionForegroundColor());
                } else {
                    graphics2.setColor(this.getForeground());
                }
                stComposedText.displayOn_at_(graphics2, new Point(rectangle2.x + this.textMargin(), rectangle2.y + rectangle2.height / 2 - stComposedText.height() / 2));
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    public int whichOfCheckMarksAt_(Point point) {
        Rectangle[] rectangleArray = this._checkMarkRectangleArray();
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangleArray[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    protected void flushCachedInformation() {
        super.flushCachedInformation();
        this.checkMarkRectangles = null;
    }

    protected void computeCachedInformation() {
        this.checkMarkRectangles = new Vector();
        this.itemVisualRectangles = new Vector();
        this.itemRowRectangles = new Vector();
        this.boundingBox = new Rectangle(0, 0, 0, 0);
        if (this.getModel().isEmpty()) {
            return;
        }
        final int n = this.getModel().lineGrid();
        final int n2 = this.leftMargin();
        final Point point = new Point(0, 0);
        this.getModel().do_(new StBlockClosure(){

            public Object value_(Object object) {
                JunItemListObject junItemListObject = (JunItemListObject)((Object)object);
                Rectangle rectangle = new Rectangle(point.x, point.y, n2, n);
                BufferedImage bufferedImage = junItemListObject.checkMark() ? JunCursors.CheckOnCursorImage() : JunCursors.CheckOffCursorImage();
                rectangle = new Rectangle(rectangle.x + rectangle.width / 2 - bufferedImage.getWidth() / 2, rectangle.y + rectangle.height / 2 - bufferedImage.getHeight() / 2, bufferedImage.getWidth(), bufferedImage.getHeight());
                JunItemListViewAwt.this.checkMarkRectangles.add(rectangle);
                JunItemListViewAwt.this.boundingBox.add(rectangle);
                rectangle = new Rectangle(point.x + n2, point.y, JunItemListViewAwt.this.getBounds().width - n2, n);
                StComposedText stComposedText = new StComposedText(junItemListObject.itemString());
                rectangle = new Rectangle(rectangle.x + JunItemListViewAwt.this.textMargin() * 2, rectangle.y + rectangle.height / 2 - stComposedText.height() / 2, stComposedText.width(), stComposedText.height());
                JunItemListViewAwt.this.itemVisualRectangles.add(rectangle);
                JunItemListViewAwt.this.boundingBox.add(rectangle);
                rectangle = new Rectangle(point.x, point.y, JunItemListViewAwt.this.getBounds().width, n);
                JunItemListViewAwt.this.itemRowRectangles.add(rectangle);
                JunItemListViewAwt.this.boundingBox.add(rectangle);
                point.translate(0, n);
                return null;
            }
        });
        Rectangle[] rectangleArray = this._itemRowRectangleArray();
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i].width = this.boundingBox.width - this.boundingBox.x;
        }
    }
}

