/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.support;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.co.sra.jun.collections.support.JunCorrelation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.image.support.JunImageToAsciiViewAwt;
import jp.co.sra.jun.goodies.image.support.JunImageToAsciiViewSwing;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemResourceSupport;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunImageToAscii
extends JunApplicationModel {
    protected Dimension divisionPoint;
    protected Font font;
    protected int asciiLength;
    protected StValueHolder progressValue;
    protected String baseName;
    protected StValueHolder textModel;
    protected JunProgress _progress;
    protected StMenuBar _menuBar;

    protected static void About() {
        int n;
        int n2 = 0;
        int n3 = 0;
        final StImage stImage = new StImage(JunImageToAscii.LogoImage());
        int n4 = stImage.width();
        int n5 = stImage.height();
        n2 = Math.max(n2, n4);
        n3 += n5;
        final Font font = new Font("dialog", 0, 16);
        final FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics((Font)font);
        final String[] stringArray = JunImageToAscii.LogoText();
        for (n = 0; n < stringArray.length; ++n) {
            n2 = Math.max(n2, fontMetrics.stringWidth(stringArray[n]));
            n3 += fontMetrics.getAscent();
        }
        n3 += 48;
        n = (n2 += 48) / 2;
        Frame frame = new Frame();
        frame.setTitle(JunImageToAscii.$String((String)"Image to Ascii Picture"));
        frame.setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                int n3 = n - stImage.width() / 2;
                stImage.displayOn_at_(graphics, new Point(n3, 24));
                graphics.setFont(font);
                int n2 = 24 + stImage.height();
                for (int i = 0; i < stringArray.length; ++i) {
                    n3 = n - fontMetrics.stringWidth(stringArray[i]) / 2;
                    graphics.drawString(stringArray[i], n3, n2 += fontMetrics.getAscent());
                }
            }
        };
        canvas.setBounds(0, 0, n2, n3);
        canvas.setBackground(Color.white);
        frame.add(canvas);
        frame.pack();
        Rectangle rectangle = frame.getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n6 = Math.max(0, (dimension.width - rectangle.width) / 2);
        int n7 = Math.max(0, (dimension.height - rectangle.height) / 2);
        frame.setLocation(n6, n7);
        frame.setVisible(true);
    }

    protected static Image LogoImage() {
        return SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/image/support/JunImageToAsciiLogoImage.jpg");
    }

    protected static String[] LogoText() {
        String[] stringArray = new String[]{"(1999.12.07)", "", "", JunImageToAscii.$String((String)"AOKI Atsushi"), "", "aoki@sra.co.jp", "", "http://www.sra.co.jp/people/aoki/"};
        return stringArray;
    }

    protected static int AsciiLength() {
        return 78;
    }

    protected static Dimension DivisionPoint() {
        Point point = SystemResourceSupport._getStringExtentFor_((String)"A", (Font)JunImageToAscii.Font());
        int n = Math.max(point.x / 2, 1);
        int n2 = Math.max(point.y / 2, 1);
        return new Dimension(n, n2);
    }

    protected static String FontName() {
        return "Courier New";
    }

    protected static int FontSize() {
        return 12;
    }

    protected static Font Font() {
        return new Font(JunImageToAscii.FontName(), 0, JunImageToAscii.FontSize());
    }

    public static String Convert_(StImage stImage) {
        return JunImageToAscii.Convert_length_(stImage, JunImageToAscii.AsciiLength());
    }

    public static String Convert_length_(StImage stImage, int n) {
        JunImageToAscii junImageToAscii = new JunImageToAscii();
        junImageToAscii.asciiLength_(n);
        return junImageToAscii.convert_(stImage);
    }

    protected void initialize() {
        super.initialize();
        this.divisionPoint();
        this.font();
        this.asciiLength();
        this.progressValue_(new StValueHolder(0.0f));
    }

    public Dimension divisionPoint() {
        if (this.divisionPoint == null) {
            this.divisionPoint = JunImageToAscii.DivisionPoint();
        }
        return this.divisionPoint;
    }

    public void divisionPoint_(int n, int n2) {
        this.divisionPoint = new Dimension(Math.max(n, 3), Math.max(n2, 6));
    }

    public void divisionPoint_(Dimension dimension) {
        this.divisionPoint_(dimension.width, dimension.height);
    }

    public void divisionPoint_(Point point) {
        this.divisionPoint_(point.x, point.y);
    }

    public Font font() {
        if (this.font == null) {
            this.font = JunImageToAscii.Font();
        }
        return this.font;
    }

    public void font_(Font font) {
        this.font = font;
    }

    public int asciiLength() {
        if (this.asciiLength <= 0) {
            this.asciiLength = JunImageToAscii.AsciiLength();
        }
        return this.asciiLength;
    }

    public void asciiLength_(int n) {
        this.asciiLength = Math.max(1, n);
    }

    public String _getText() {
        return this.textModel().value().toString();
    }

    protected String baseName() {
        return this.baseName;
    }

    protected StValueHolder textModel() {
        if (this.textModel == null) {
            this.textModel = new StValueHolder((Object)new String());
        }
        return this.textModel;
    }

    protected float[][] characterFeatures() {
        StImage[] stImageArray = this.characterImages();
        float[][] fArrayArray = new float[stImageArray.length][];
        for (int i = 0; i < stImageArray.length; ++i) {
            StImage stImage = stImageArray[i];
            StImage stImage2 = JunImageAdjuster.Adjust_extent_(stImage, this.divisionPoint());
            float[] fArray = this.imageFeature_(stImage2);
            fArrayArray[i] = fArray;
        }
        return fArrayArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage[] characterImages() {
        char[] cArray = this.printableCharacters();
        int n = cArray.length;
        StImage[] stImageArray = new StImage[n];
        for (int i = 0; i < n; ++i) {
            String string = String.valueOf(cArray[i]);
            Point point = SystemResourceSupport._getStringExtentFor_((String)string, (Font)JunImageToAscii.Font());
            StImage stImage = new StImage(point.x, point.y);
            Graphics graphics = null;
            try {
                graphics = stImage.image().getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, point.x, point.y);
                graphics.setColor(Color.black);
                int n2 = SystemResourceSupport.getFontMetrics((Font)JunImageToAscii.Font()).getAscent();
                graphics.drawString(string, 0, n2);
                stImage.image().flush();
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
            stImageArray[i] = this.convertToWhiteBlackPalette_(stImage);
        }
        return stImageArray;
    }

    protected float[] characterLuminances() {
        float f = Float.NaN;
        float f2 = Float.NaN;
        StImage[] stImageArray = this.characterImages();
        int n = stImageArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            StImage stImage = stImageArray[i];
            float f3 = this.imageLuminance_(stImage);
            f = Float.isNaN(f) ? f3 : Math.max(f, f3);
            f2 = Float.isNaN(f2) ? f3 : Math.min(f2, f3);
            fArray[i] = f3;
        }
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = (fArray[i] - f2) / (f - f2);
        }
        return fArray2;
    }

    protected Map.Entry[] characterTable() {
        List list;
        Object object;
        Object object2;
        Object object3;
        char[] cArray = this.printableCharacters();
        float[] fArray = this.characterLuminances();
        float[][] fArray2 = this.characterFeatures();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < cArray.length; ++i) {
            object3 = new Character(cArray[i]);
            object2 = new Float(fArray[i]);
            object = fArray2[i];
            if (!hashMap.containsKey(object2)) {
                hashMap.put(object2, new ArrayList());
            }
            list = (List)hashMap.get(object2);
            list.add(new Object[]{object3, object});
        }
        TreeMap<float[], Object[]> treeMap = new TreeMap<float[], Object[]>(new Comparator(){

            public int compare(Object object, Object object2) {
                float f;
                float f2 = ((Number)object).floatValue();
                return f2 < (f = ((Number)object2).floatValue()) ? -1 : (f < f2 ? 1 : 0);
            }
        });
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (Number)object2.getKey();
            list = (List)object2.getValue();
            treeMap.put((float[])object, list.toArray());
        }
        return treeMap.entrySet().toArray(new Map.Entry[treeMap.size()]);
    }

    protected float[] imageFeature_(StImage stImage) {
        int n = stImage.width();
        int n2 = stImage.height();
        float[] fArray = new float[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Color color = stImage.valueAtPoint_(new Point(j, i));
                fArray[j + i * n] = (float)StColorValue._GetLuminance((Color)color);
            }
        }
        return fArray;
    }

    protected float imageLuminance_(StImage stImage) {
        float[] fArray = this.imageFeature_(stImage);
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        float f2 = f / (float)fArray.length;
        return f2;
    }

    protected char[] printableCharacters() {
        int n;
        boolean[] blArray = new boolean[256];
        for (n = 0; n < 256; ++n) {
            blArray[n] = false;
        }
        blArray[32] = true;
        blArray[33] = true;
        blArray[34] = true;
        blArray[35] = true;
        blArray[36] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[39] = true;
        blArray[40] = true;
        blArray[41] = true;
        blArray[42] = true;
        blArray[43] = true;
        blArray[44] = true;
        blArray[45] = true;
        blArray[46] = true;
        blArray[47] = true;
        blArray[58] = true;
        blArray[59] = true;
        blArray[61] = true;
        blArray[63] = true;
        blArray[64] = true;
        blArray[91] = true;
        blArray[93] = true;
        blArray[94] = true;
        blArray[95] = true;
        blArray[96] = true;
        blArray[123] = true;
        blArray[124] = true;
        blArray[125] = true;
        blArray[126] = true;
        n = 0;
        char[] cArray = new char[256];
        for (int i = 0; i < 256; ++i) {
            if (48 <= i && i <= 57 || 65 <= i && i <= 90 || 97 <= i && i <= 122) {
                blArray[i] = true;
            }
            if (!blArray[i]) continue;
            cArray[n] = (char)i;
            ++n;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    protected int search_in_(float f, float[] fArray) {
        int n = 0;
        int n2 = fArray.length - 1;
        int n3 = (n + n2) / 2;
        float f2 = fArray[n3];
        while (f != f2 && n <= n2) {
            if (f < f2) {
                n2 = n3 - 1;
            } else {
                n = n3 + 2;
            }
            n3 = (n + n2) / 2;
            f2 = fArray[n3];
        }
        if (f != f2) {
            n3 = Math.max(1, Math.min(Math.max(n, n2), fArray.length - 1));
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert_(StImage stImage) {
        this.progress_(0.0f);
        int n = this.divisionPoint().width;
        int n2 = this.divisionPoint().height;
        int n3 = this.asciiLength() * n;
        float f = (float)(stImage.height() * n3) / (float)(stImage.width() * n2);
        int n4 = Math.round(f) * n2;
        JunImageAdjuster junImageAdjuster = new JunImageAdjuster();
        junImageAdjuster.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                JunImageToAscii.this.progress_(((Number)object).floatValue() / 2.0f);
                return null;
            }
        });
        StImage stImage2 = junImageAdjuster.adjust_extent_(stImage, new Dimension(n3, n4));
        Map.Entry[] entryArray = this.characterTable();
        float[] fArray = new float[entryArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Number)entryArray[i].getKey()).floatValue();
        }
        this.progress_(0.5f);
        StringWriter stringWriter = new StringWriter(1024);
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        try {
            for (int i = 0; i < stImage2.height(); i += n2) {
                for (int j = 0; j < stImage2.width(); j += n) {
                    int n5;
                    StImage stImage3 = new StImage(n, n2);
                    stImage3.copy_from_in_rule_(stImage3.bounds(), new Point(j, i), stImage2, 3);
                    float f2 = this.imageLuminance_(stImage3);
                    Map.Entry entry = entryArray[this.search_in_(f2, fArray)];
                    Object[] objectArray = (Object[])entry.getValue();
                    float[] fArray2 = this.imageFeature_(stImage3);
                    TreeMap<Float, Character> treeMap = new TreeMap<Float, Character>(new Comparator(){

                        public int compare(Object object, Object object2) {
                            float f;
                            float f2 = ((Number)object).floatValue();
                            return f2 < (f = ((Number)object2).floatValue()) ? -1 : (f < f2 ? 1 : 0);
                        }
                    });
                    for (n5 = 0; n5 < objectArray.length; ++n5) {
                        Object[] objectArray2 = (Object[])objectArray[n5];
                        Character c = (Character)objectArray2[0];
                        float[] fArray3 = (float[])objectArray2[1];
                        float f3 = (float)new JunCorrelation(fArray2, fArray3).coefficient();
                        treeMap.put(new Float(f3), c);
                    }
                    n5 = ((Character)treeMap.get(treeMap.lastKey())).charValue();
                    bufferedWriter.write(n5);
                }
                bufferedWriter.newLine();
                bufferedWriter.flush();
                this.progress_(0.5f + (float)i / (float)(stImage2.height() - 1) / 2.0f);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.progress_(1.0f);
        return stringWriter.toString();
    }

    public void compute_(StBlockClosure stBlockClosure) {
        this.progressValue().compute_(stBlockClosure);
    }

    protected float progress() {
        return this.progressValue()._floatValue();
    }

    protected void progress_(float f) {
        if (0.0f <= f && f <= 1.0f) {
            float f2 = (float)Math.round((double)f / 0.005) * 0.005f;
            if (this.progressValue()._floatValue() != f2) {
                this.progressValue().value_(f2);
            }
        }
    }

    protected StValueHolder progressValue() {
        return this.progressValue;
    }

    protected void progressValue_(StValueHolder stValueHolder) {
        this.progressValue = stValueHolder;
    }

    public StView defaultView() {
        if (JunImageToAscii.GetDefaultViewMode() == 0) {
            return new JunImageToAsciiViewAwt(this);
        }
        return new JunImageToAsciiViewSwing(this);
    }

    protected String windowTitle() {
        return JunImageToAscii.$String((String)"Image to Ascii Picture");
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            StMenu stMenu = new StMenu((Object)JunImageToAscii.$String((String)"File"));
            stMenu.add(new StMenuItem((Object)(JunImageToAscii.$String((String)"Open") + "..."), (MenuListener)new MenuPerformer((StObject)this, "openImageToAscii")));
            stMenu.addSeparator();
            stMenu.add(new StMenuItem((Object)(JunImageToAscii.$String((String)"Save") + "..."), (MenuListener)new MenuPerformer((StObject)this, "saveImageToAscii")));
            stMenu.addSeparator();
            stMenu.add(new StMenuItem((Object)JunImageToAscii.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitImageToAscii")));
            this._menuBar.add(stMenu);
            StMenu stMenu2 = new StMenu((Object)JunImageToAscii.$String((String)"Misc"));
            stMenu2.add(new StMenuItem((Object)(JunImageToAscii.$String((String)"About <1p>", null, (Object)"ImageToAscii") + "..."), (MenuListener)new MenuPerformer((StObject)this, "aboutImageToAscii")));
            this._menuBar.add(stMenu2);
        }
        return this._menuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openImageToAscii() throws FileNotFoundException, IOException {
        Window[] windowArray;
        Object object;
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunImageToAscii.$String((String)"<1p> files", null, (Object)"JPEG") + " (*.jpg)", new String[]{"*.jpg", "*.JPG", "*.jpeg", "*.JPEG"})};
        File file = JunFileRequesterDialog.Request(JunImageToAscii.$String((String)"Select a <1p> file.", null, (Object)"JPEG"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        Window[] windowArray2 = null;
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            object = null;
            try {
                object = JunJpegImageStream.On_(new FileInputStream(file));
                windowArray2 = object.nextImage();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        finally {
            junCursors._restore();
        }
        if (windowArray2 == null) {
            System.err.println("Failed to open a JPEG file - " + file);
            return null;
        }
        this.lengthImageToAscii();
        object = null;
        junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            this._progress = new JunProgress();
            this.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunImageToAscii.this._progress.value_(((Number)object).floatValue());
                    return null;
                }
            });
            this._progress.message_(JunImageToAscii.$String((String)"converting <1p>...", null, (Object)"JPEG"));
            windowArray = windowArray2;
            object = (String)this._progress.do_(new StBlockClosure((StImage)windowArray){
                private final /* synthetic */ StImage val$_image;
                {
                    this.val$_image = stImage;
                }

                public Object value() {
                    return JunImageToAscii.this.convert_(this.val$_image);
                }
            });
        }
        finally {
            junCursors._restore();
        }
        this.textModel().value_(object);
        windowArray = this.builder().windows();
        if (windowArray != null) {
            this.baseName = file.getName();
            int n = this.baseName.lastIndexOf(46);
            if (n >= 0) {
                this.baseName = this.baseName.substring(0, n);
            }
            for (int i = 0; i < windowArray.length; ++i) {
                ((Frame)windowArray[i]).setTitle(this.baseName);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImageToAscii() throws IOException {
        String string = this._getText();
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(this.baseName == null ? "filename.txt" : this.baseName + ".txt");
        file = JunFileRequesterDialog.RequestNewFile(JunImageToAscii.$String((String)"Input a <1p> file.", null, (Object)JunImageToAscii.$String((String)"Text")), file);
        if (file == null) {
            return;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(string);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.flush();
                fileWriter.close();
            }
        }
    }

    public void quitImageToAscii() {
        this.closeRequest();
    }

    public void aboutImageToAscii() {
        JunImageToAscii.About();
    }

    public void lengthImageToAscii() {
        String string = String.valueOf(this.asciiLength());
        string = JunDialog.Request_(JunImageToAscii.$String((String)"Ascii Length?"), string);
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            this.asciiLength_(Math.max(10, Math.min(n, 1000)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected StImage convertToWhiteBlackPalette_(StImage stImage) {
        int n = stImage.width();
        int n2 = stImage.height();
        StImage stImage2 = new StImage(n, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Point point = new Point(j, i);
                Color color = stImage.valueAtPoint_(point);
                if (StColorValue._GetLuminance((Color)color) > 0.5) {
                    stImage2.valueAtPoint_put_(point, Color.white);
                    continue;
                }
                stImage2.valueAtPoint_put_(point, Color.black);
            }
        }
        return stImage2;
    }
}

