/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.support;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

public class JunImageProcessor
extends JunAbstractObject {
    private static int[] Stipples;
    private static StImage[] Masks;
    private static IndexColorModel ColorPalette256;
    private static IndexColorModel GrayPalette256;
    private static IndexColorModel _WhiteBlackPalette;
    private static IndexColorModel _BlackWhitePalette;

    public static final IndexColorModel _BlackWhitePalette() {
        if (_BlackWhitePalette == null) {
            byte[] byArray = new byte[]{0, -1};
            _BlackWhitePalette = new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        return _BlackWhitePalette;
    }

    public static StImage _MakeImage_Shape_(StImage stImage, StImage stImage2) {
        if (stImage.extent().equals(stImage2.extent())) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            int n = stImage.width();
            int n2 = stImage.height();
            int[] nArray = new int[n * n2];
            int[] nArray2 = stImage.getPixels();
            int[] nArray3 = stImage2.getPixels();
            for (int i = 0; i < n * n2; ++i) {
                if (nArray2[i] != 0xFFFFFF) {
                    int n3 = colorModel.getRed(nArray2[i]);
                    int n4 = colorModel.getGreen(nArray2[i]);
                    int n5 = colorModel.getBlue(nArray2[i]);
                    int n6 = colorModel.getAlpha(nArray3[i]);
                    nArray[i] = n6 << 24 | n3 << 16 | n4 << 8 | n5 << 0;
                    continue;
                }
                nArray[i] = nArray3[i] != 0xFFFFFF ? nArray3[i] : 0xFFFFFF;
            }
            return new StImage(n, n2, nArray);
        }
        return null;
    }

    public static final IndexColorModel _WhiteBlackPalette() {
        if (_WhiteBlackPalette == null) {
            byte[] byArray = new byte[]{-1, 0};
            _WhiteBlackPalette = new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        return _WhiteBlackPalette;
    }

    public static StAssociation[] BorderFollowing_(StImage stImage) {
        StImage stImage2 = stImage.convertToPalette_(JunImageProcessor._WhiteBlackPalette());
        StImage stImage3 = new StImage(stImage2.width() + 2, stImage2.height() + 2);
        stImage3.copy_from_in_rule_(new Rectangle(1, 1, stImage2.width(), stImage2.height()), new Point(0, 0), stImage2, 3);
        Vector<StAssociation> vector = new Vector<StAssociation>();
        int n = Color.black.getRGB();
        int n2 = Color.white.getRGB();
        for (int i = 0; i < stImage3.width(); ++i) {
            for (int j = 0; j < stImage3.height(); ++j) {
                Point[] pointArray;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                if (stImage3.getPixel(i, j) != n || ((n7 = stImage3.getPixel(i, j + 1)) | (n6 = stImage3.getPixel(i - 1, j)) | (n5 = stImage3.getPixel(i, j - 1)) | (n4 = stImage3.getPixel(i + 1, j))) != n2 || (n3 = n4 == n2 ? 6 : (n5 == n2 ? 4 : (n6 == n2 ? 2 : (n7 == n2 ? 0 : -1)))) <= 0 || (pointArray = JunImageProcessor.BorderFollowingPoint_direction_image_(new Point(i, j), n3, stImage3)).length <= 0) continue;
                vector.addElement(new StAssociation((Object)new Integer(n3), (Object)pointArray));
            }
        }
        Object[] objectArray = new StAssociation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Point[] BorderFollowingPoint_direction_image_(Point point, int n, StImage stImage) {
        int[] nArray = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        int[] nArray2 = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int n2 = Color.gray.getRGB();
        int n3 = Color.white.getRGB();
        Vector<Point> vector = new Vector<Point>();
        int n4 = point.x;
        int n5 = point.x;
        int n6 = point.x;
        int n7 = point.y;
        int n8 = point.y;
        int n9 = point.y;
        int n10 = n;
        int n11 = n10 + 4 & 7;
        n10 = -1;
        int n12 = -1;
        int n13 = 0;
        n13 = n13 + stImage.getPixel(n4 - 1, n7 - 1) + 1;
        n13 = n13 + stImage.getPixel(n4 - 1, n7) + 1;
        n13 = n13 + stImage.getPixel(n4 - 1, n7 + 1) + 1;
        n13 = n13 + stImage.getPixel(n4, n7 - 1) + 1;
        n13 = n13 + stImage.getPixel(n4, n7 + 1) + 1;
        n13 = n13 + stImage.getPixel(n4 + 1, n7 - 1) + 1;
        n13 = n13 + stImage.getPixel(n4 + 1, n7) + 1;
        if ((n13 = n13 + stImage.getPixel(n4 + 1, n7 + 1) + 1) < 0) {
            boolean bl = true;
            while (bl) {
                n4 = n5;
                n7 = n8;
                stImage.setPixel(n5, n8, n2);
                Point point2 = new Point(n5 - 1, n8 - 1);
                vector.addElement(point2);
                n11 = n11 + 4 & 7;
                boolean bl2 = true;
                while (bl2) {
                    n5 = n4 + nArray[n11 = n11 + 1 & 7];
                    n8 = n7 + nArray2[n11];
                    bl2 = stImage.getPixel(n5, n8) == n3;
                }
                if (n10 < 0) {
                    if (n12 < 0) {
                        n12 = n11;
                    } else {
                        n10 = n12;
                    }
                }
                bl = n4 != n6 || n7 != n9 || n11 != n10;
            }
        } else {
            stImage.setPixel(n4, n7, n2);
        }
        Object[] objectArray = new Point[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Map.Entry[] ColorHistogram_(StImage stImage) {
        Object object;
        StImage stImage2 = null;
        stImage2 = JunImageProcessor.ColorPalette256().equals(stImage.image().getColorModel()) ? stImage : stImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < stImage2.height(); ++i) {
            for (int j = 0; j < stImage2.width(); ++j) {
                object = new Integer(stImage2.getPixel(j, i) & 0xFFFFFF);
                if (hashMap.containsKey(object)) {
                    hashMap.put(object, new Integer(1 + (Integer)hashMap.get(object)));
                    continue;
                }
                hashMap.put(object, new Integer(1));
            }
        }
        TreeMap<Color, Float> treeMap = new TreeMap<Color, Float>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                Color color = (Color)object;
                Color color2 = (Color)object2;
                if (color.equals(color2)) {
                    return 0;
                }
                double d2 = StColorValue._DistanceFrom((Color)color, (Color)Color.black);
                return d2 < (d = StColorValue._DistanceFrom((Color)color2, (Color)Color.black)) ? -1 : 1;
            }
        });
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Color color = new Color((Integer)object.getKey());
            float f = ((Integer)object.getValue()).floatValue() / (float)(stImage2.width() * stImage2.height());
            treeMap.put(color, new Float(f));
        }
        return treeMap.entrySet().toArray(new Map.Entry[treeMap.size()]);
    }

    public static final IndexColorModel ColorPalette256() {
        if (ColorPalette256 == null) {
            Color[] colorArray = new Color[]{new Color(0, 0, 0), new Color(16, 16, 16), new Color(33, 33, 33), new Color(67, 67, 67), new Color(84, 84, 84), new Color(118, 118, 118), new Color(136, 136, 136), new Color(170, 170, 170), new Color(187, 187, 187), new Color(221, 221, 221), new Color(238, 238, 238), new Color(0, 0, 16), new Color(0, 0, 33), new Color(0, 0, 67), new Color(0, 0, 84), new Color(0, 0, 118), new Color(0, 0, 136), new Color(0, 0, 170), new Color(0, 0, 187), new Color(0, 0, 221), new Color(0, 0, 238), new Color(0, 16, 0), new Color(0, 33, 0), new Color(0, 67, 0), new Color(0, 84, 0), new Color(0, 118, 0), new Color(0, 136, 0), new Color(0, 170, 0), new Color(0, 187, 0), new Color(0, 221, 0), new Color(0, 238, 0), new Color(16, 0, 0), new Color(33, 0, 0), new Color(67, 0, 0), new Color(84, 0, 0), new Color(118, 0, 0), new Color(136, 0, 0), new Color(170, 0, 0), new Color(187, 0, 0), new Color(221, 0, 0), new Color(238, 0, 0), new Color(0, 0, 50), new Color(0, 0, 101), new Color(0, 0, 153), new Color(0, 0, 204), new Color(0, 0, 255), new Color(0, 50, 0), new Color(0, 50, 50), new Color(0, 50, 101), new Color(0, 50, 153), new Color(0, 50, 204), new Color(0, 50, 255), new Color(0, 101, 0), new Color(0, 101, 50), new Color(0, 101, 101), new Color(0, 101, 153), new Color(0, 101, 204), new Color(0, 101, 255), new Color(0, 153, 0), new Color(0, 153, 50), new Color(0, 153, 101), new Color(0, 153, 153), new Color(0, 153, 204), new Color(0, 153, 255), new Color(0, 204, 0), new Color(0, 204, 50), new Color(0, 204, 101), new Color(0, 204, 153), new Color(0, 204, 204), new Color(0, 204, 255), new Color(0, 255, 0), new Color(0, 255, 50), new Color(0, 255, 101), new Color(0, 255, 153), new Color(0, 255, 204), new Color(0, 255, 255), new Color(50, 0, 0), new Color(50, 0, 50), new Color(50, 0, 101), new Color(50, 0, 153), new Color(50, 0, 204), new Color(50, 0, 255), new Color(50, 50, 0), new Color(50, 50, 50), new Color(50, 50, 101), new Color(50, 50, 153), new Color(50, 50, 204), new Color(50, 50, 255), new Color(50, 101, 0), new Color(50, 101, 50), new Color(50, 101, 101), new Color(50, 101, 153), new Color(50, 101, 204), new Color(50, 101, 255), new Color(50, 153, 0), new Color(50, 153, 50), new Color(50, 153, 101), new Color(50, 153, 153), new Color(50, 153, 204), new Color(50, 153, 255), new Color(50, 204, 0), new Color(50, 204, 50), new Color(50, 204, 101), new Color(50, 204, 153), new Color(50, 204, 204), new Color(50, 204, 255), new Color(50, 255, 0), new Color(50, 255, 50), new Color(50, 255, 101), new Color(50, 255, 153), new Color(50, 255, 204), new Color(50, 255, 255), new Color(101, 0, 0), new Color(101, 0, 50), new Color(101, 0, 101), new Color(101, 0, 153), new Color(101, 0, 204), new Color(101, 0, 255), new Color(101, 50, 0), new Color(101, 50, 50), new Color(101, 50, 101), new Color(101, 50, 153), new Color(101, 50, 204), new Color(101, 50, 255), new Color(101, 101, 0), new Color(101, 101, 50), new Color(101, 101, 101), new Color(101, 101, 153), new Color(101, 101, 204), new Color(101, 101, 255), new Color(101, 153, 0), new Color(101, 153, 50), new Color(101, 153, 101), new Color(101, 153, 153), new Color(101, 153, 204), new Color(101, 153, 255), new Color(101, 204, 0), new Color(101, 204, 50), new Color(101, 204, 101), new Color(101, 204, 153), new Color(101, 204, 204), new Color(101, 204, 255), new Color(101, 255, 0), new Color(101, 255, 50), new Color(101, 255, 101), new Color(101, 255, 153), new Color(101, 255, 204), new Color(101, 255, 255), new Color(153, 0, 0), new Color(153, 0, 50), new Color(153, 0, 101), new Color(153, 0, 153), new Color(153, 0, 204), new Color(153, 0, 255), new Color(153, 50, 0), new Color(153, 50, 50), new Color(153, 50, 101), new Color(153, 50, 153), new Color(153, 50, 204), new Color(153, 50, 255), new Color(153, 101, 0), new Color(153, 101, 50), new Color(153, 101, 101), new Color(153, 101, 153), new Color(153, 101, 204), new Color(153, 101, 255), new Color(153, 153, 0), new Color(153, 153, 50), new Color(153, 153, 101), new Color(153, 153, 153), new Color(153, 153, 204), new Color(153, 153, 255), new Color(153, 204, 0), new Color(153, 204, 50), new Color(153, 204, 101), new Color(153, 204, 153), new Color(153, 204, 204), new Color(153, 204, 255), new Color(153, 255, 0), new Color(153, 255, 50), new Color(153, 255, 101), new Color(153, 255, 153), new Color(153, 255, 204), new Color(153, 255, 255), new Color(204, 0, 0), new Color(204, 0, 50), new Color(204, 0, 101), new Color(204, 0, 153), new Color(204, 0, 204), new Color(204, 0, 255), new Color(204, 50, 0), new Color(204, 50, 50), new Color(204, 50, 101), new Color(204, 50, 153), new Color(204, 50, 204), new Color(204, 50, 255), new Color(204, 101, 0), new Color(204, 101, 50), new Color(204, 101, 101), new Color(204, 101, 153), new Color(204, 101, 204), new Color(204, 101, 255), new Color(204, 153, 0), new Color(204, 153, 50), new Color(204, 153, 101), new Color(204, 153, 153), new Color(204, 153, 204), new Color(204, 153, 255), new Color(204, 204, 0), new Color(204, 204, 50), new Color(204, 204, 101), new Color(204, 204, 153), new Color(204, 204, 204), new Color(204, 204, 255), new Color(204, 255, 0), new Color(204, 255, 50), new Color(204, 255, 101), new Color(204, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(255, 0, 0), new Color(255, 0, 50), new Color(255, 0, 101), new Color(255, 0, 153), new Color(255, 0, 204), new Color(255, 0, 255), new Color(255, 50, 0), new Color(255, 50, 50), new Color(255, 50, 101), new Color(255, 50, 153), new Color(255, 50, 204), new Color(255, 50, 255), new Color(255, 101, 0), new Color(255, 101, 50), new Color(255, 101, 101), new Color(255, 101, 153), new Color(255, 101, 204), new Color(255, 101, 255), new Color(255, 153, 0), new Color(255, 153, 50), new Color(255, 153, 101), new Color(255, 153, 153), new Color(255, 153, 204), new Color(255, 153, 255), new Color(255, 204, 0), new Color(255, 204, 50), new Color(255, 204, 101), new Color(255, 204, 153), new Color(255, 204, 204), new Color(255, 204, 255), new Color(255, 255, 0), new Color(255, 255, 50), new Color(255, 255, 101), new Color(255, 255, 153), new Color(255, 255, 204), new Color(255, 255, 255)};
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)colorArray[i].getRed();
                byArray2[i] = (byte)colorArray[i].getGreen();
                byArray3[i] = (byte)colorArray[i].getBlue();
            }
            ColorPalette256 = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        return ColorPalette256;
    }

    public static StImage ColorPalette256Image_(Point point) {
        StImage stImage = new StImage(point.x * 32, point.y * 8);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        IndexColorModel indexColorModel = JunImageProcessor.ColorPalette256();
        int n = 0;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 0;
        int n5 = n2;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 32; ++j) {
                int[] nArray = new int[n2 * n3];
                for (int k = 0; k < nArray.length; ++k) {
                    nArray[k] = n;
                }
                MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)indexColorModel, nArray, n4, n5);
                Image image = toolkit.createImage(memoryImageSource);
                stImage.copy_from_in_rule_(new Rectangle(j * n2, i * n3, n2, n3), new Point(0, 0), new StImage(image), 3);
                image.flush();
                ++n;
            }
        }
        return stImage;
    }

    public static StImage Fill_(StImage stImage) {
        return JunImageProcessor.Fill_rectangle_color_(stImage, stImage.bounds(), Color.black);
    }

    public static StImage Fill_color_(StImage stImage, Color color) {
        return JunImageProcessor.Fill_rectangle_color_(stImage, stImage.bounds(), color);
    }

    public static StImage Fill_rectangle_(StImage stImage, Rectangle rectangle) {
        return JunImageProcessor.Fill_rectangle_color_(stImage, rectangle, Color.black);
    }

    public static StImage Fill_rectangle_color_(StImage stImage, Rectangle rectangle, Color color) {
        StImage stImage2 = new StImage(16, 16);
        int n = color.getRGB();
        for (int i = 0; i < stImage2.width(); ++i) {
            for (int j = 0; j < stImage2.height(); ++j) {
                stImage2.setPixel(i, j, n);
            }
        }
        return stImage.tile_from_in_rule_(rectangle, new Point(0, 0), stImage2, 3);
    }

    public static StImage Fill_seed_(StImage stImage, Point point) {
        return JunImageProcessor.Fill_seed_color_(stImage, point, Color.black);
    }

    public static StImage Fill_seed_color_(StImage stImage, Point point, Color color) {
        int n = color.getRGB();
        if (n == stImage.getPixel(point.x, point.y)) {
            return stImage;
        }
        int n2 = Color.white.getRGB();
        int n3 = stImage.width();
        int n4 = stImage.height();
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(JunImageProcessor.LastOn_before_after_index_(stImage, point, -1, n2) + 1));
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.addElement(new Integer(JunImageProcessor.FirstOn_after_before_index_(stImage, point, n3, n2) - 1));
        Vector<Integer> vector3 = new Vector<Integer>();
        vector3.addElement(new Integer(point.y));
        Vector<Integer> vector4 = new Vector<Integer>();
        vector4.addElement(new Integer(0));
        while (vector3.size() > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = (Integer)vector.lastElement();
            vector.removeElementAt(vector.size() - 1);
            int n9 = (Integer)vector2.lastElement();
            vector2.removeElementAt(vector2.size() - 1);
            int n10 = (Integer)vector3.lastElement();
            vector3.removeElementAt(vector3.size() - 1);
            int n11 = (Integer)vector4.lastElement();
            vector4.removeElementAt(vector4.size() - 1);
            int n12 = Math.min(n9, n3 - 1);
            Point point2 = new Point(n8, n10);
            while (point2.x <= n12) {
                stImage.setPixel(point2.x, point2.y, n);
                point2 = new Point(point2.x + 1, point2.y);
            }
            if (n11 != 1 && n10 > 0) {
                n7 = n2 == stImage.getPixel(n8, n10 - 1) ? JunImageProcessor.LastOn_before_after_index_(stImage, new Point(n8, n10 - 1), -1, n2) + 1 : JunImageProcessor.FirstOff_after_before_index_(stImage, new Point(n8, n10 - 1), n9 + 1, n2);
                while (n7 <= n9) {
                    n6 = JunImageProcessor.FirstOn_after_before_index_(stImage, new Point(n7, n10 - 1), n3, n2) - 1;
                    vector.addElement(new Integer(n7));
                    vector2.addElement(new Integer(n6));
                    vector3.addElement(new Integer(n10 - 1));
                    n5 = n8 - 1 > n7 || n9 + 1 < n6 ? 0 : 2;
                    vector4.addElement(new Integer(n5));
                    if (n6 >= n9) {
                        n7 = n6 + 1;
                        continue;
                    }
                    n7 = JunImageProcessor.FirstOff_after_before_index_(stImage, new Point(n6 + 1, n10 - 1), n9 + 1, n2);
                }
            }
            if (n11 == 2 || n10 >= n4 - 1) continue;
            n7 = n2 == stImage.getPixel(n8, n10 + 1) ? JunImageProcessor.LastOn_before_after_index_(stImage, new Point(n8, n10 + 1), -1, n2) + 1 : JunImageProcessor.FirstOff_after_before_index_(stImage, new Point(n8, n10 + 1), n9 + 1, n2);
            while (n7 <= n9) {
                n6 = JunImageProcessor.FirstOn_after_before_index_(stImage, new Point(n7, n10 + 1), n3, n2) - 1;
                vector.addElement(new Integer(n7));
                vector2.addElement(new Integer(n6));
                vector3.addElement(new Integer(n10 + 1));
                n5 = n8 - 1 > n7 || n9 + 1 < n6 ? 0 : 1;
                vector4.addElement(new Integer(n5));
                if (n6 > n9) {
                    n7 = n6;
                    continue;
                }
                n7 = JunImageProcessor.FirstOff_after_before_index_(stImage, new Point(n6 + 1, n10 + 1), n9 + 1, n2);
            }
        }
        return stImage;
    }

    public static Map.Entry[] GrayHistogram_(StImage stImage) {
        Object object;
        StImage stImage2 = null;
        stImage2 = JunImageProcessor.GrayPalette256().equals(stImage.image().getColorModel()) ? stImage : stImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.GrayPalette256());
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < stImage2.height(); ++i) {
            for (int j = 0; j < stImage2.width(); ++j) {
                object = new Integer(stImage2.getPixel(j, i) & 0xFFFFFF);
                if (hashMap.containsKey(object)) {
                    hashMap.put(object, new Integer(1 + (Integer)hashMap.get(object)));
                    continue;
                }
                hashMap.put(object, new Integer(1));
            }
        }
        TreeMap<Color, Float> treeMap = new TreeMap<Color, Float>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                Color color = (Color)object;
                Color color2 = (Color)object2;
                if (color.equals(color2)) {
                    return 0;
                }
                double d2 = StColorValue._DistanceFrom((Color)color, (Color)Color.black);
                return d2 < (d = StColorValue._DistanceFrom((Color)color2, (Color)Color.black)) ? -1 : 1;
            }
        });
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Color color = new Color((Integer)object.getKey());
            float f = ((Integer)object.getValue()).floatValue() / (float)(stImage2.width() * stImage2.height());
            treeMap.put(color, new Float(f));
        }
        return treeMap.entrySet().toArray(new Map.Entry[treeMap.size()]);
    }

    public static final IndexColorModel GrayPalette256() {
        if (GrayPalette256 == null) {
            Color[] colorArray = new Color[]{new Color(0, 0, 0), new Color(0, 0, 0), new Color(1, 1, 1), new Color(2, 2, 2), new Color(3, 3, 3), new Color(5, 5, 5), new Color(6, 6, 6), new Color(7, 7, 7), new Color(8, 8, 8), new Color(8, 8, 8), new Color(9, 9, 9), new Color(10, 10, 10), new Color(11, 11, 11), new Color(13, 13, 13), new Color(14, 14, 14), new Color(15, 15, 15), new Color(16, 16, 16), new Color(16, 16, 16), new Color(17, 17, 17), new Color(18, 18, 18), new Color(19, 19, 19), new Color(21, 21, 21), new Color(22, 22, 22), new Color(23, 23, 23), new Color(24, 24, 24), new Color(24, 24, 24), new Color(25, 25, 25), new Color(26, 26, 26), new Color(27, 27, 27), new Color(29, 29, 29), new Color(30, 30, 30), new Color(31, 31, 31), new Color(32, 32, 32), new Color(32, 32, 32), new Color(33, 33, 33), new Color(34, 34, 34), new Color(35, 35, 35), new Color(36, 36, 36), new Color(38, 38, 38), new Color(39, 39, 39), new Color(40, 40, 40), new Color(41, 41, 41), new Color(41, 41, 41), new Color(42, 42, 42), new Color(43, 43, 43), new Color(44, 44, 44), new Color(46, 46, 46), new Color(47, 47, 47), new Color(48, 48, 48), new Color(49, 49, 49), new Color(49, 49, 49), new Color(50, 50, 50), new Color(51, 51, 51), new Color(52, 52, 52), new Color(54, 54, 54), new Color(55, 55, 55), new Color(56, 56, 56), new Color(57, 57, 57), new Color(57, 57, 57), new Color(58, 58, 58), new Color(59, 59, 59), new Color(60, 60, 60), new Color(62, 62, 62), new Color(63, 63, 63), new Color(64, 64, 64), new Color(65, 65, 65), new Color(65, 65, 65), new Color(66, 66, 66), new Color(67, 67, 67), new Color(68, 68, 68), new Color(70, 70, 70), new Color(71, 71, 71), new Color(72, 72, 72), new Color(73, 73, 73), new Color(74, 74, 74), new Color(74, 74, 74), new Color(75, 75, 75), new Color(76, 76, 76), new Color(77, 77, 77), new Color(79, 79, 79), new Color(80, 80, 80), new Color(81, 81, 81), new Color(82, 82, 82), new Color(82, 82, 82), new Color(83, 83, 83), new Color(84, 84, 84), new Color(85, 85, 85), new Color(87, 87, 87), new Color(88, 88, 88), new Color(89, 89, 89), new Color(90, 90, 90), new Color(90, 90, 90), new Color(91, 91, 91), new Color(92, 92, 92), new Color(93, 93, 93), new Color(95, 95, 95), new Color(96, 96, 96), new Color(97, 97, 97), new Color(98, 98, 98), new Color(98, 98, 98), new Color(99, 99, 99), new Color(100, 100, 100), new Color(101, 101, 101), new Color(103, 103, 103), new Color(104, 104, 104), new Color(105, 105, 105), new Color(106, 106, 106), new Color(106, 106, 106), new Color(107, 107, 107), new Color(108, 108, 108), new Color(109, 109, 109), new Color(110, 110, 110), new Color(112, 112, 112), new Color(113, 113, 113), new Color(114, 114, 114), new Color(115, 115, 115), new Color(115, 115, 115), new Color(116, 116, 116), new Color(117, 117, 117), new Color(118, 118, 118), new Color(120, 120, 120), new Color(121, 121, 121), new Color(122, 122, 122), new Color(123, 123, 123), new Color(123, 123, 123), new Color(124, 124, 124), new Color(125, 125, 125), new Color(126, 126, 126), new Color(128, 128, 128), new Color(129, 129, 129), new Color(130, 130, 130), new Color(131, 131, 131), new Color(131, 131, 131), new Color(132, 132, 132), new Color(133, 133, 133), new Color(134, 134, 134), new Color(136, 136, 136), new Color(137, 137, 137), new Color(138, 138, 138), new Color(139, 139, 139), new Color(139, 139, 139), new Color(140, 140, 140), new Color(141, 141, 141), new Color(142, 142, 142), new Color(144, 144, 144), new Color(145, 145, 145), new Color(146, 146, 146), new Color(147, 147, 147), new Color(148, 148, 148), new Color(148, 148, 148), new Color(149, 149, 149), new Color(150, 150, 150), new Color(151, 151, 151), new Color(153, 153, 153), new Color(154, 154, 154), new Color(155, 155, 155), new Color(156, 156, 156), new Color(156, 156, 156), new Color(157, 157, 157), new Color(158, 158, 158), new Color(159, 159, 159), new Color(161, 161, 161), new Color(162, 162, 162), new Color(163, 163, 163), new Color(164, 164, 164), new Color(164, 164, 164), new Color(165, 165, 165), new Color(166, 166, 166), new Color(167, 167, 167), new Color(169, 169, 169), new Color(170, 170, 170), new Color(171, 171, 171), new Color(172, 172, 172), new Color(172, 172, 172), new Color(173, 173, 173), new Color(174, 174, 174), new Color(175, 175, 175), new Color(177, 177, 177), new Color(178, 178, 178), new Color(179, 179, 179), new Color(180, 180, 180), new Color(180, 180, 180), new Color(181, 181, 181), new Color(182, 182, 182), new Color(183, 183, 183), new Color(184, 184, 184), new Color(186, 186, 186), new Color(187, 187, 187), new Color(188, 188, 188), new Color(189, 189, 189), new Color(189, 189, 189), new Color(190, 190, 190), new Color(191, 191, 191), new Color(192, 192, 192), new Color(194, 194, 194), new Color(195, 195, 195), new Color(196, 196, 196), new Color(197, 197, 197), new Color(197, 197, 197), new Color(198, 198, 198), new Color(199, 199, 199), new Color(200, 200, 200), new Color(202, 202, 202), new Color(203, 203, 203), new Color(204, 204, 204), new Color(205, 205, 205), new Color(205, 205, 205), new Color(206, 206, 206), new Color(207, 207, 207), new Color(208, 208, 208), new Color(210, 210, 210), new Color(211, 211, 211), new Color(212, 212, 212), new Color(213, 213, 213), new Color(213, 213, 213), new Color(214, 214, 214), new Color(215, 215, 215), new Color(216, 216, 216), new Color(218, 218, 218), new Color(219, 219, 219), new Color(220, 220, 220), new Color(221, 221, 221), new Color(222, 222, 222), new Color(222, 222, 222), new Color(223, 223, 223), new Color(224, 224, 224), new Color(225, 225, 225), new Color(227, 227, 227), new Color(228, 228, 228), new Color(229, 229, 229), new Color(230, 230, 230), new Color(230, 230, 230), new Color(231, 231, 231), new Color(232, 232, 232), new Color(233, 233, 233), new Color(235, 235, 235), new Color(236, 236, 236), new Color(237, 237, 237), new Color(238, 238, 238), new Color(238, 238, 238), new Color(239, 239, 239), new Color(240, 240, 240), new Color(241, 241, 241), new Color(243, 243, 243), new Color(244, 244, 244), new Color(245, 245, 245), new Color(246, 246, 246), new Color(246, 246, 246), new Color(247, 247, 247), new Color(248, 248, 248), new Color(249, 249, 249), new Color(251, 251, 251), new Color(252, 252, 252), new Color(253, 253, 253), new Color(254, 254, 254), new Color(255, 255, 255)};
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)colorArray[i].getRed();
                byArray2[i] = (byte)colorArray[i].getGreen();
                byArray3[i] = (byte)colorArray[i].getBlue();
            }
            GrayPalette256 = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        return GrayPalette256;
    }

    public static StImage GrayPalette256Image_(Point point) {
        StImage stImage = new StImage(point.x * 32, point.y * 8);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        IndexColorModel indexColorModel = JunImageProcessor.GrayPalette256();
        int n = 0;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 0;
        int n5 = n2;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 32; ++j) {
                int[] nArray = new int[n2 * n3];
                for (int k = 0; k < nArray.length; ++k) {
                    nArray[k] = n;
                }
                MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)indexColorModel, nArray, n4, n5);
                Image image = toolkit.createImage(memoryImageSource);
                stImage.copy_from_in_rule_(new Rectangle(j * n2, i * n3, n2, n3), new Point(0, 0), new StImage(image), 3);
                image.flush();
                ++n;
            }
        }
        return stImage;
    }

    public static StImage Halftone_(double d) {
        double d2 = d;
        d2 = Math.max(d2, 0.0);
        d2 = Math.min(d2, 1.0);
        int n = new Double((double)JunImageProcessor.Masks().length * d2).intValue() + 1;
        return JunImageProcessor.MaskAt_(n);
    }

    public static StImage Icon_size_(StImage stImage, int n) {
        double d = (double)n / (double)Math.max(stImage.width(), stImage.height());
        StImage stImage2 = JunImageProcessor.Scale_factor_(stImage, new Jun2dPoint(d, d));
        int n2 = Math.max(stImage2.width(), stImage2.height());
        Point point = new Point(n2, n2);
        Rectangle rectangle = stImage2.bounds();
        rectangle.translate((int)((double)point.x / 2.0 - (double)stImage2.bounds().width / 2.0), (int)((double)point.y / 2.0 - (double)stImage2.bounds().height / 2.0));
        int[] nArray = new int[n2 * n2];
        for (int i = 0; i < n2 * n2; ++i) {
            nArray[i] = 0xFFFFFF;
        }
        StImage stImage3 = new StImage(point.x, point.y, (int[])nArray.clone());
        stImage3.copy_from_in_rule_(rectangle, new Point(0, 0), stImage2, 3);
        StImage stImage4 = new StImage(point.x, point.y, (int[])nArray.clone());
        stImage4 = JunImageProcessor.Fill_rectangle_color_(stImage4, rectangle, Color.black);
        return JunImageProcessor._MakeImage_Shape_(stImage3, stImage4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage Image_halftone_(StImage stImage, double d) {
        int n = stImage.width();
        int n2 = stImage.height();
        StImage stImage2 = new StImage((Image)new BufferedImage(n, n2, 2));
        Graphics2D graphics2D = (Graphics2D)stImage2.image().getGraphics();
        try {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
            graphics2D.drawImage((Image)stImage.image(), 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return stImage2;
    }

    public static StImage ImageFromFile_(File file) {
        return JunImageProcessor.ImageFromFile_(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage ImageFromFile_(String string) {
        JunImageStream junImageStream = null;
        StImage stImage = null;
        try {
            Class clazz = JunImageStream.ImageStreamClassForFileName_(string);
            if (clazz == null) {
                JunDialog.Warn_("'" + string + "'" + JunSystem.$String((String)" is not an image file."));
                StImage stImage2 = null;
                return stImage2;
            }
            junImageStream = (JunImageStream)((Object)StObject._PerformWith((Class)clazz, (String)"On_", (Object)new FileInputStream(new File(string))));
            stImage = junImageStream.nextImage();
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.close();
                    junImageStream = null;
                }
                catch (IOException iOException) {
                    System.out.println("IOException: " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
        }
        return stImage;
    }

    public static StImage ImageFromFileDialog() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{JunFileModel.FileType.All(JunSystem.$String((String)"All files")), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)JunSystem.$String((String)"Image")), JunSystem.DefaultImageExtensionPatterns()), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"GIF"), new String[]{"*.gif", "*.GIF", "*.giff", "*.GIFF"}), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"JPEG"), new String[]{"*.jpg", "*.JPG", "*.jpeg", "*.JPEG"}), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"PNG"), new String[]{"*.png", "*.PNG"}), new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"BMP"), new String[]{"*.bmp", "*.BMP"})};
        File file = JunFileRequesterDialog.RequestFile(JunSystem.$String((String)"Select an <1p> file.", null, (Object)JunSystem.$String((String)"Image")), fileTypeArray, fileTypeArray[1]);
        if (file == null) {
            return null;
        }
        return JunImageProcessor.ImageFromFile_(file.getPath());
    }

    public static StImage Juice_strongly_color_(StImage stImage, double d, Color color) {
        return JunImageProcessor.Juice_strongly_color_interim_(stImage, d, color, new StBlockClosure());
    }

    public static StImage Juice_strongly_color_interim_(StImage stImage, double d, Color color, StBlockClosure stBlockClosure) {
        StImage stImage2 = new StImage(stImage.width(), stImage.height(), (ColorModel)JunImageProcessor._WhiteBlackPalette());
        int n = (int)((1.0 - Math.max(0.0, Math.min(d, 1.0))) * 255.0);
        int n2 = 1;
        for (int i = 0; i < stImage.height(); ++i) {
            for (int j = 0; j < stImage.width(); ++j) {
                Color color2 = stImage.valueAtPoint_(new Point(j, i));
                boolean bl = Math.abs(color2.getRed() - color.getRed()) <= n;
                bl &= Math.abs(color2.getGreen() - color.getGreen()) <= n;
                if (bl &= Math.abs(color2.getBlue() - color.getBlue()) <= n) {
                    stImage2.setPixel(j, i, Color.black.getRGB());
                } else {
                    stImage2.setPixel(j, i, Color.white.getRGB());
                }
                if (stBlockClosure == null) continue;
                if (n2 % 16 == 0) {
                    stBlockClosure.value_((Object)stImage2);
                }
                ++n2;
            }
        }
        if (stBlockClosure != null) {
            stBlockClosure.value_((Object)stImage2);
        }
        return stImage2;
    }

    public static StImage MakeThin_(StImage stImage) {
        return JunImageProcessor.MakeThin_interim_(stImage, new StBlockClosure(){

            public Object value_(Object object) {
                return null;
            }
        });
    }

    public static StImage MakeThin_interim_(StImage stImage, StBlockClosure stBlockClosure) {
        int n = Color.white.getRGB();
        int n2 = Color.black.getRGB();
        int n3 = Color.gray.getRGB();
        int n4 = Color.darkGray.getRGB();
        int n5 = Color.lightGray.getRGB();
        StImage stImage2 = stImage.convertToPalette_(JunImageProcessor._WhiteBlackPalette());
        byte[] byArray = new byte[]{(byte)Color.white.getRed(), (byte)Color.black.getRed(), 100, (byte)Color.gray.getRed(), 100, (byte)Color.darkGray.getRed(), 100, (byte)Color.lightGray.getRed()};
        IndexColorModel indexColorModel = new IndexColorModel(8, byArray.length, byArray, byArray, byArray);
        StImage stImage3 = stImage2.convertToPalette_(indexColorModel);
        int n6 = stImage3.width() - 1;
        int n7 = stImage3.height() - 1;
        int n8 = stBlockClosure != null ? 0 : -1;
        boolean bl = true;
        while (bl) {
            int n9;
            int n10;
            for (n10 = 1; n10 < n6 - 1; ++n10) {
                for (n9 = 1; n9 < n7 - 1; ++n9) {
                    if (stImage3.getPixel(n10, n9) != n2) continue;
                    if (stImage3.getPixel(n10 - 1, n9) == n) {
                        stImage3.setPixel(n10, n9, n3);
                        continue;
                    }
                    if (stImage3.getPixel(n10, n9 - 1) == n) {
                        stImage3.setPixel(n10, n9, n4);
                        continue;
                    }
                    if (stImage3.getPixel(n10 + 1, n9) == n) {
                        stImage3.setPixel(n10, n9, n3);
                        continue;
                    }
                    if (stImage3.getPixel(n10, n9 + 1) != n) continue;
                    stImage3.setPixel(n10, n9, n4);
                }
            }
            n10 = 0;
            for (n9 = 1; n9 >= -1; n9 -= 2) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                if (n9 == 1) {
                    n15 = 0;
                    n14 = n6;
                    n13 = 0;
                    n12 = n7;
                    n11 = n3;
                } else {
                    n15 = n6 - 1;
                    n14 = -1;
                    n13 = n7 - 1;
                    n12 = -1;
                    n11 = n4;
                }
                for (int i = n15; i != n14; i += n9) {
                    int n16 = i - 1;
                    int n17 = i + 1;
                    for (int j = n13; j != n12; j += n9) {
                        int n18;
                        int n19 = j - 1;
                        int n20 = j + 1;
                        if (stImage3.getPixel(i, j) != n11) continue;
                        n10 = 1;
                        int n21 = stImage3.getPixel(i, n20) == n ? 1 : 0;
                        int n22 = stImage3.getPixel(n16, n20) == n ? 1 : 0;
                        int n23 = stImage3.getPixel(n16, j) == n ? 1 : 0;
                        int n24 = stImage3.getPixel(n16, n19) == n ? 1 : 0;
                        int n25 = stImage3.getPixel(i, n19) == n ? 1 : 0;
                        int n26 = stImage3.getPixel(n17, n19) == n ? 1 : 0;
                        int n27 = stImage3.getPixel(n17, j) == n ? 1 : 0;
                        int n28 = n21 + n23 + n25 + n27;
                        if (n28 + n22 + n24 + n26 + (n18 = stImage3.getPixel(n17, n20) == n ? 1 : 0) <= 6) {
                            int n29 = n28 - (n21 & n22 & n23) - (n23 & n24 & n25) - (n25 & n26 & n27) - (n27 & n18 & n21);
                            if (n29 == 1) {
                                stImage3.setPixel(i, j, n);
                                stImage2.setPixel(i, j, n);
                                if (stBlockClosure == null) continue;
                                if (n8 % 16 == 0) {
                                    stBlockClosure.value_((Object)stImage2);
                                }
                                ++n8;
                                continue;
                            }
                            stImage3.setPixel(i, j, n5);
                            continue;
                        }
                        stImage3.setPixel(i, j, n5);
                    }
                }
            }
            bl = n10 > 0;
        }
        if (stBlockClosure != null) {
            stBlockClosure.value_((Object)stImage2);
        }
        return stImage2;
    }

    public static StImage Mask_halftone_(Point point, double d) {
        StImage stImage = JunImageProcessor.Halftone_(d);
        StImage stImage2 = new StImage(point);
        stImage2.tile_from_in_rule_(stImage2.bounds(), new Point(0, 0), stImage, 3);
        return stImage2;
    }

    public static StImage MaskAt_(int n) {
        int n2 = n;
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, JunImageProcessor.Masks().length);
        return JunImageProcessor.Masks()[n2 - 1];
    }

    public static StImage[] Masks() {
        if (Masks != null) {
            return Masks;
        }
        int[] nArray = new int[]{1, 33, 9, 41, 3, 35, 11, 43, 59, 17, 49, 25, 57, 19, 51, 27, 13, 45, 5, 37, 15, 47, 7, 39, 55, 29, 61, 21, 53, 31, 63, 23, 4, 36, 12, 44, 2, 34, 10, 42, 58, 20, 52, 28, 60, 18, 50, 26, 16, 48, 8, 40, 14, 46, 6, 38, 54, 32, 64, 24, 56, 30, 62, 22};
        int n = Color.black.getRGB();
        StImage[] stImageArray = new StImage[65];
        for (int i = 0; i < 65; ++i) {
            StImage stImage = new StImage(16, 16);
            if (i != 0) {
                int n2 = 0;
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    if (n3 <= i) {
                        int n4 = n2 % 8;
                        int n5 = n2 / 8;
                        stImage.setPixel(n4, n5, n);
                        stImage.setPixel(n4 + 8, n5, n);
                        stImage.setPixel(n4, n5 + 8, n);
                        stImage.setPixel(n4 + 8, n5 + 8, n);
                    }
                    ++n2;
                }
            }
            stImageArray[i] = stImage;
        }
        Masks = stImageArray;
        return Masks;
    }

    public static StImage Scale_factor_(StImage stImage, Jun2dPoint jun2dPoint) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(jun2dPoint.x(), jun2dPoint.y()), 1);
        return new StImage((Image)affineTransformOp.filter(stImage.image(), null));
    }

    public static StImage Shape_(StImage stImage) {
        return JunImageProcessor.Shape_color_(stImage, Color.black);
    }

    public static StImage Shape_color_(StImage stImage, Color color) {
        StImage stImage2 = (StImage)stImage.clone();
        StImage stImage3 = new StImage(stImage2.width() + 2, stImage2.height() + 2);
        stImage3.copy_from_in_rule_(new Rectangle(1, 1, stImage2.width(), stImage2.height()), new Point(0, 0), stImage2, 3);
        JunImageProcessor.Fill_seed_color_(stImage3, new Point(0, 0), color);
        int n = stImage2.width();
        int n2 = stImage2.height();
        int n3 = color.getRGB();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (n3 == stImage2.getPixel(j, i) || n3 == stImage3.getPixel(j + 1, i + 1)) continue;
                stImage2.setPixel(j, i, n3);
            }
        }
        return stImage2;
    }

    public static int Stipple_(double d) {
        double d2 = d;
        d2 = Math.max(d2, 0.0);
        d2 = Math.min(d2, 1.0);
        int n = new Double((double)(JunImageProcessor.Stipples().length - 1) * d2).intValue() + 1;
        return JunImageProcessor.StippleAt_(n);
    }

    public static int StippleAt_(int n) {
        int n2 = n;
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, JunImageProcessor.Stipples().length);
        return JunImageProcessor.Stipples()[n2 - 1];
    }

    public static int[] Stipples() {
        if (Stipples != null) {
            return Stipples;
        }
        int[] nArray = new int[]{Integer.parseInt("0000", 16), Integer.parseInt("8080", 16), Integer.parseInt("8888", 16), Integer.parseInt("A8A8", 16), Integer.parseInt("AAAA", 16), Integer.parseInt("EAEA", 16), Integer.parseInt("EEEE", 16), Integer.parseInt("FEFE", 16), Integer.parseInt("FFFF", 16)};
        Stipples = nArray;
        return Stipples;
    }

    public static Object[] TraceBorder_(StImage stImage) {
        StAssociation[] stAssociationArray = JunImageProcessor.BorderFollowing_(stImage);
        Object[] objectArray = new Object[stAssociationArray.length];
        for (int i = 0; i < stAssociationArray.length; ++i) {
            objectArray[i] = stAssociationArray[i].value();
        }
        return objectArray;
    }

    public static float[] XSpectrum_(StImage stImage) {
        StImage stImage2 = null;
        stImage2 = JunImageProcessor.ColorPalette256().equals(stImage.image().getColorModel()) ? stImage : stImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
        int n = stImage2.width();
        int n2 = stImage2.height();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                Color color = stImage2.valueAtPoint_(new Point(i, j));
                d += (double)(1.0f - StColorValue._GetBrightness((Color)color));
            }
            fArray[i] = (float)(d / (double)n2);
        }
        return fArray;
    }

    public static float[] YSpectrum_(StImage stImage) {
        StImage stImage2 = null;
        stImage2 = JunImageProcessor.ColorPalette256().equals(stImage.image().getColorModel()) ? stImage : stImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
        int n = stImage2.width();
        int n2 = stImage2.height();
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                Color color = stImage2.valueAtPoint_(new Point(j, i));
                d += (double)(1.0f - StColorValue._GetBrightness((Color)color));
            }
            fArray[i] = (float)(d / (double)n);
        }
        return fArray;
    }

    private static int FirstOff_after_before_index_(StImage stImage, Point point, int n, int n2) {
        int n3;
        if (point.x >= n) {
            return n;
        }
        Rectangle rectangle = stImage.bounds();
        int n4 = Math.min(Math.max(point.x, 0), rectangle.width - 1);
        if (n2 != stImage.getPixel(n4, n3 = Math.min(Math.max(point.y, 0), rectangle.height - 1))) {
            ++n4;
            while (n4 < n && n2 != stImage.getPixel(n4, n3)) {
                ++n4;
            }
        }
        return Math.min(n4, n);
    }

    private static int FirstOn_after_before_index_(StImage stImage, Point point, int n, int n2) {
        int n3;
        Rectangle rectangle = stImage.bounds();
        int n4 = Math.min(Math.max(point.x, 0), rectangle.width - 1);
        if (n2 == stImage.getPixel(n4, n3 = Math.min(Math.max(point.y, 0), rectangle.height - 1))) {
            ++n4;
            while (n4 < n && n2 == stImage.getPixel(n4, n3)) {
                ++n4;
            }
        }
        return Math.min(n4, n);
    }

    private static void FlushMasks() {
        Masks = null;
    }

    private static void FlushPalettes() {
        ColorPalette256 = null;
        GrayPalette256 = null;
        _WhiteBlackPalette = null;
        _BlackWhitePalette = null;
    }

    private static void Initialize() {
        JunImageProcessor.FlushPalettes();
        JunImageProcessor.FlushMasks();
    }

    private static int LastOn_before_after_index_(StImage stImage, Point point, int n, int n2) {
        int n3;
        Rectangle rectangle = stImage.bounds();
        int n4 = Math.min(Math.max(point.y, 0), rectangle.height - 1);
        for (n3 = Math.min(Math.max(point.x, 0), rectangle.width - 1); n3 > n && n2 == stImage.getPixel(n3, n4); --n3) {
        }
        return n3;
    }

    static {
        JunImageProcessor.Initialize();
    }
}

