/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.framework;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.StView;

public class JunImageDisplayController
extends JunAbstractController {
    protected Jun2dPoint oldPoint;
    protected Image oldImage;
    protected Rectangle oldRectangle;
    protected Cursor _cursor;

    public void initialize() {
        super.initialize();
        this.oldPoint = null;
        this.oldImage = null;
        this.oldRectangle = null;
    }

    protected void buildListener(StView stView) {
        this.getView()._canvasComponent().addMouseListener((MouseListener)((Object)this));
        this.getView()._canvasComponent().addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void release() {
        super.release();
        this.getView()._canvasComponent().addMouseListener((MouseListener)((Object)this));
        this.getView()._canvasComponent().removeMouseListener((MouseListener)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCursorPoint_(MouseEvent mouseEvent) {
        if (this.getModel().image() == null) {
            return;
        }
        String string = null;
        Component component = this.getView()._canvasComponent();
        Graphics graphics = component.getGraphics();
        try {
            Rectangle rectangle = this.getModel().image().bounds();
            rectangle.setSize(rectangle.width + 1, rectangle.height + 1);
            Jun2dPoint jun2dPoint = this.normalizedCursorPoint_(mouseEvent);
            if (!jun2dPoint.equals((Object)this.oldPoint)) {
                string = this.displayStringForPoint_(jun2dPoint, mouseEvent);
                if (this.oldImage != null) {
                    graphics.drawImage(this.oldImage, this.oldRectangle.x, this.oldRectangle.y, this.oldRectangle.width, this.oldRectangle.height, component);
                }
                this.oldRectangle = this.displayRectangleForString_(string, mouseEvent);
                this.oldImage = new BufferedImage(this.oldRectangle.width, this.oldRectangle.height, 5);
                Graphics graphics2 = this.oldImage.getGraphics();
                try {
                    graphics2.translate(-this.oldRectangle.x, -this.oldRectangle.y);
                    component.paint(graphics2);
                }
                finally {
                    if (graphics2 != null) {
                        graphics2.dispose();
                        graphics2 = null;
                    }
                }
                if (rectangle.contains(mouseEvent.getPoint())) {
                    graphics.setColor(Color.white);
                    graphics.fillRect(this.oldRectangle.x, this.oldRectangle.y, this.oldRectangle.width, this.oldRectangle.height);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, this.oldRectangle.x + 2, this.oldRectangle.y + graphics.getFontMetrics().getAscent());
                }
            }
            this.oldPoint = jun2dPoint;
            if (string != null && string.length() > 0) {
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            System.out.println(string);
            this.oldImage = null;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
    }

    public Rectangle displayRectangleForString_(String string, MouseEvent mouseEvent) {
        this.oldRectangle = null;
        Point point = mouseEvent.getPoint();
        Rectangle rectangle = this.getView()._getViewportBounds();
        FontMetrics fontMetrics = this.getView()._canvasComponent().getFontMetrics(this.getView()._canvasComponent().getFont());
        Rectangle rectangle2 = new Rectangle(0, 0, fontMetrics.stringWidth(string) + 4, fontMetrics.getHeight());
        if ((double)point.x <= rectangle.getCenterX() && (double)point.y <= rectangle.getCenterY()) {
            rectangle2.translate(point.x - rectangle2.x, point.y - rectangle2.y);
            rectangle2.translate(3, 3);
        }
        if ((double)point.x > rectangle.getCenterX() && (double)point.y > rectangle.getCenterY()) {
            rectangle2.translate(point.x - (rectangle2.x + rectangle2.width), point.y - (rectangle2.y + rectangle2.height));
            rectangle2.translate(-2, -2);
        }
        if ((double)point.x <= rectangle.getCenterX() && (double)point.y > rectangle.getCenterY()) {
            rectangle2.translate(point.x - rectangle2.x, point.y - (rectangle2.y + rectangle2.height));
            rectangle2.translate(3, -2);
        }
        if ((double)point.x > rectangle.getCenterX() && (double)point.y <= rectangle.getCenterY()) {
            rectangle2.translate(point.x - (rectangle2.x + rectangle2.width), point.y - rectangle2.y);
            rectangle2.translate(-2, 3);
        }
        return rectangle2;
    }

    public String displayStringForPoint_(Jun2dPoint jun2dPoint, MouseEvent mouseEvent) {
        String string = null;
        string = mouseEvent.isShiftDown() ? String.valueOf(Math.round(jun2dPoint.x() * (double)this.getModel().image().bounds().width)) + " , " + String.valueOf(Math.round(jun2dPoint.y() * (double)this.getModel().image().bounds().height)) : new Float(jun2dPoint.x()).toString() + " , " + new Float(jun2dPoint.y()).toString();
        return string;
    }

    public Jun2dPoint normalizedCursorPoint_(MouseEvent mouseEvent) {
        StDisplayable stDisplayable = this.getModel().image();
        if (stDisplayable instanceof StOpaqueImage) {
            stDisplayable = ((StOpaqueImage)stDisplayable).figure();
        }
        Point point = mouseEvent.getPoint();
        point.x = Math.min(Math.max(point.x, 0), stDisplayable.bounds().width);
        point.y = Math.min(Math.max(point.y, 0), stDisplayable.bounds().height);
        return new Jun2dPoint((double)point.x / (double)stDisplayable.bounds().width, (double)point.y / (double)stDisplayable.bounds().height);
    }

    public JunImageDisplayModel getModel() {
        return (JunImageDisplayModel)this.view().model();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mousePressed(mouseEvent);
            return;
        }
        this._cursor = this.getView().toComponent().getCursor();
        this.getView().toComponent().setCursor(JunCursors.CrossCursor());
        this.oldPoint = null;
        this.oldImage = null;
        this.oldRectangle = null;
        this.displayCursorPoint_(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mouseReleased(mouseEvent);
            return;
        }
        if (this.oldImage != null) {
            this.getView()._canvasComponent().getGraphics().drawImage(this.oldImage, this.oldRectangle.x, this.oldRectangle.y, this.oldRectangle.width, this.oldRectangle.height, this.getView()._canvasComponent());
        }
        this.oldPoint = null;
        this.oldImage = null;
        this.oldRectangle = null;
        this.getView().toComponent().setCursor(this._cursor);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mouseDragged(mouseEvent);
            return;
        }
        this.displayCursorPoint_(mouseEvent);
    }

    public JunImageDisplayView getView() {
        return (JunImageDisplayView)this.view();
    }
}

