/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunLevelGaugeViewSwing
extends JunAbstractViewJPanel
implements JunLevelGaugeView {
    public JunLevelGaugeViewSwing() {
    }

    public JunLevelGaugeViewSwing(JunLevelGaugeModel junLevelGaugeModel) {
        super(junLevelGaugeModel);
    }

    protected void buildComponent() {
        this.setLayout(null);
        if (this.verticalGauge()) {
            this.setPreferredSize(new Dimension(128, 256));
        } else {
            this.setPreferredSize(new Dimension(256, 128));
        }
    }

    public double averageValue() {
        double d = this.getModel().average();
        if (Double.isNaN(d)) {
            d = this.currentValue();
        }
        return d;
    }

    public double currentValue() {
        double d = this.getModel()._doubleValue();
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public double daleValue() {
        double d = this.getModel().dale();
        if (Double.isNaN(d)) {
            d = this.currentValue();
        }
        return d;
    }

    public double hillValue() {
        double d = this.getModel().hill();
        if (Double.isNaN(d)) {
            d = this.currentValue();
        }
        return d;
    }

    public double maximumValue() {
        double d = this.getModel().maximum();
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return d;
    }

    public double minimumValue() {
        double d = this.getModel().minimum();
        if (Double.isNaN(d)) {
            d = -1.0;
        }
        return d;
    }

    public Rectangle averageBox() {
        double d = this.minimumValue();
        double d2 = this.maximumValue();
        double d3 = (this.averageValue() - d) / (d2 - d);
        return this.boxFromRatio_(d3);
    }

    public Rectangle daleBox() {
        double d = this.minimumValue();
        double d2 = this.maximumValue();
        double d3 = (this.daleValue() - d) / (d2 - d);
        return this.boxFromRatio_(d3);
    }

    public Rectangle displayBox() {
        Rectangle rectangle;
        if (this.verticalGauge()) {
            Point point = new Point((int)Math.floor((double)this.getWidth() / 2.0) - (int)Math.floor((double)this.gaugeWidth() / 2.0), Math.max(this.cellSize(), 2));
            rectangle = new StRectangle(new Rectangle(0, 0, this.getWidth(), this.getHeight())).insetBy_(point).toRectangle();
        } else {
            Point point = new Point(Math.max(this.cellSize(), 2), (int)Math.floor((double)this.getHeight() / 2.0) - (int)Math.floor((double)this.gaugeWidth() / 2.0));
            rectangle = new StRectangle(new Rectangle(0, 0, this.getWidth(), this.getHeight())).insetBy_(point).toRectangle();
        }
        return rectangle;
    }

    public Rectangle gaugeBox() {
        Rectangle rectangle = this.displayBox();
        Rectangle rectangle2 = this.verticalGauge() ? new StRectangle(rectangle).insetBy_(new Point(0, (int)Math.floor((double)this.cellSize() / 2.0))).toRectangle() : new StRectangle(rectangle).insetBy_(new Point((int)Math.floor((double)this.cellSize() / 2.0), 0)).toRectangle();
        return rectangle2;
    }

    public Rectangle hillBox() {
        double d = this.minimumValue();
        double d2 = this.maximumValue();
        double d3 = (this.hillValue() - d) / (d2 - d);
        return this.boxFromRatio_(d3);
    }

    public Rectangle valueBox() {
        double d = this.minimumValue();
        double d2 = this.maximumValue();
        double d3 = (this.currentValue() - d) / (d2 - d);
        return this.boxFromRatio_(d3);
    }

    public StController defaultController() {
        return new JunAbstractController();
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayBackgroundOn_(graphics);
        this.displayFrameOn_(graphics);
        this.displayValueOn_(graphics);
        this.displayAverageOn_(graphics);
        this.displayDaleOn_(graphics);
        this.displayHillOn_(graphics);
    }

    protected void displayAverageOn_(Graphics graphics) {
        if (!this.showAverage()) {
            return;
        }
        Rectangle rectangle = this.averageBox();
        Color color = this.averageColor();
        if (this.rainbowColor()) {
            color = this.colorValueOfBox_withColor_(rectangle, color);
        }
        if (this.showEdge()) {
            graphics.setColor(this.edgeColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            if (this.verticalGauge()) {
                Rectangle rectangle2 = new StRectangle(rectangle).insetBy_(new Point(0, 1)).toRectangle();
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                Rectangle rectangle3 = new StRectangle(rectangle).insetBy_(new Point(1, 0)).toRectangle();
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        } else {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void displayBackgroundOn_(Graphics graphics) {
        if (!this.showBackground()) {
            return;
        }
        graphics.setColor(this.backgroundColor());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void displayDaleOn_(Graphics graphics) {
        if (!this.showDale()) {
            return;
        }
        Rectangle rectangle = this.daleBox();
        Color color = this.daleColor();
        if (this.rainbowColor()) {
            color = this.colorValueOfBox_withColor_(rectangle, color);
        }
        if (this.showEdge()) {
            graphics.setColor(this.edgeColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            if (this.verticalGauge()) {
                Rectangle rectangle2 = new StRectangle(rectangle).insetBy_(new Point(0, 1)).toRectangle();
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                Rectangle rectangle3 = new StRectangle(rectangle).insetBy_(new Point(1, 0)).toRectangle();
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        } else {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void displayFrameOn_(Graphics graphics) {
        if (!this.showFrame()) {
            return;
        }
        graphics.setColor(this.frameColor());
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayHillOn_(Graphics graphics) {
        if (!this.showHill()) {
            return;
        }
        Rectangle rectangle = this.hillBox();
        Color color = this.hillColor();
        if (this.rainbowColor()) {
            color = this.colorValueOfBox_withColor_(rectangle, color);
        }
        if (this.showEdge()) {
            graphics.setColor(this.edgeColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            if (this.verticalGauge()) {
                Rectangle rectangle2 = new StRectangle(rectangle).insetBy_(new Point(0, 1)).toRectangle();
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                Rectangle rectangle3 = new StRectangle(rectangle).insetBy_(new Point(1, 0)).toRectangle();
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        } else {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void displayValueOn_(Graphics graphics) {
        if (!this.showValue()) {
            return;
        }
        StRectangle stRectangle = new StRectangle(this.gaugeBox());
        StRectangle stRectangle2 = new StRectangle(this.valueBox());
        ArrayList<StRectangle> arrayList = new ArrayList<StRectangle>();
        StRectangle stRectangle3 = stRectangle2;
        if (this.verticalGauge()) {
            if (this.reverseDirection()) {
                stRectangle3 = stRectangle3.align_with_(stRectangle3.center(), stRectangle.topCenter());
                while (stRectangle3.cornerY() < stRectangle2.cornerY()) {
                    arrayList.add(stRectangle3);
                    stRectangle3 = stRectangle3.translatedBy_(0, stRectangle3.height() + this.cellSpace());
                }
            } else {
                stRectangle3 = stRectangle3.align_with_(stRectangle3.center(), stRectangle.bottomCenter());
                while (stRectangle3.originY() > stRectangle2.originY()) {
                    arrayList.add(stRectangle3);
                    stRectangle3 = stRectangle3.translatedBy_(0, 0 - (stRectangle3.height() + this.cellSpace()));
                }
            }
        } else if (this.reverseDirection()) {
            stRectangle3 = stRectangle3.align_with_(stRectangle3.center(), stRectangle.rightCenter());
            while (stRectangle3.originX() > stRectangle2.originX()) {
                arrayList.add(stRectangle3);
                stRectangle3 = stRectangle3.translatedBy_(0 - (stRectangle3.width() + this.cellSpace()), 0);
            }
        } else {
            stRectangle3 = stRectangle3.align_with_(stRectangle3.center(), stRectangle.leftCenter());
            while (stRectangle3.cornerX() < stRectangle2.cornerX()) {
                arrayList.add(stRectangle3);
                stRectangle3 = stRectangle3.translatedBy_(stRectangle3.width() + this.cellSpace(), 0);
            }
        }
        if (stRectangle3.intersects_(stRectangle2)) {
            stRectangle3 = stRectangle3.intersect_(stRectangle2);
            arrayList.add(stRectangle3);
        }
        StRectangle[] stRectangleArray = arrayList.toArray(new StRectangle[arrayList.size()]);
        for (int i = 0; i < stRectangleArray.length; ++i) {
            stRectangle3 = stRectangleArray[i];
            Color color = this.valueColor();
            if (this.rainbowColor()) {
                color = this.colorValueOfBox_withColor_(stRectangle3.toRectangle(), color);
            }
            if (this.showEdge()) {
                graphics.setColor(this.edgeColor());
                graphics.fillRect(stRectangle3.originX(), stRectangle3.originY(), stRectangle3.width(), stRectangle3.height());
                graphics.setColor(color);
                if (this.verticalGauge()) {
                    stRectangle3 = stRectangle3.insetBy_(new Point(0, 2));
                    graphics.fillRect(stRectangle3.originX(), stRectangle3.originY(), stRectangle3.width(), stRectangle3.height());
                    continue;
                }
                stRectangle3 = stRectangle3.insetBy_(new Point(2, 0));
                graphics.fillRect(stRectangle3.originX(), stRectangle3.originY(), stRectangle3.width(), stRectangle3.height());
                continue;
            }
            graphics.setColor(color);
            graphics.fillRect(stRectangle3.originX(), stRectangle3.originY(), stRectangle3.width(), stRectangle3.height());
        }
    }

    public JunLevelGaugeModel getModel() {
        return (JunLevelGaugeModel)this.model();
    }

    public Color averageColor() {
        return this.getModel().averageColor();
    }

    public Color backgroundColor() {
        return this.getModel().backgroundColor();
    }

    public int cellSize() {
        return this.getModel().cellSize();
    }

    public int cellSpace() {
        return this.getModel().cellSpace();
    }

    public Color daleColor() {
        return this.getModel().daleColor();
    }

    public Color edgeColor() {
        return this.getModel().edgeColor();
    }

    public Color frameColor() {
        return this.getModel().frameColor();
    }

    public int gaugeWidth() {
        return this.getModel().gaugeWidth();
    }

    public Color hillColor() {
        return this.getModel().hillColor();
    }

    public boolean horizontalGauge() {
        return this.getModel().horizontalGauge();
    }

    public boolean rainbowColor() {
        return this.getModel().rainbowColor();
    }

    public boolean reverseDirection() {
        return this.getModel().reverseDirection();
    }

    public boolean showAverage() {
        return this.getModel().showAverage();
    }

    public boolean showBackground() {
        return this.getModel().showBackground();
    }

    public boolean showDale() {
        return this.getModel().showDale();
    }

    public boolean showEdge() {
        return this.getModel().showEdge();
    }

    public boolean showFrame() {
        return this.getModel().showFrame();
    }

    public boolean showHill() {
        return this.getModel().showHill();
    }

    public boolean showValue() {
        return this.getModel().showValue();
    }

    public Color valueColor() {
        return this.getModel().valueColor();
    }

    public boolean verticalGauge() {
        return this.getModel().verticalGauge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunLevelGaugeViewSwing.$((String)"value")) {
            Graphics graphics = this.getGraphics();
            try {
                this.displayOn_(graphics);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
            return;
        }
        super.update_(dependentEvent);
    }

    protected Rectangle boxFromRatio_(double d) {
        Rectangle rectangle = this.gaugeBox();
        Rectangle rectangle2 = this.verticalGauge() ? (this.reverseDirection() ? new Rectangle(rectangle.x, (int)Math.round(d * (double)rectangle.height) + rectangle.y - (int)Math.floor((double)this.cellSize() / 2.0), rectangle.width, this.cellSize()) : new Rectangle(rectangle.x, (int)Math.round((1.0 - d) * (double)rectangle.height) + rectangle.y - (int)Math.floor((double)this.cellSize() / 2.0), rectangle.width, this.cellSize())) : (this.reverseDirection() ? new Rectangle((int)Math.round((1.0 - d) * (double)rectangle.width) + rectangle.x - (int)Math.floor((double)this.cellSize() / 2.0), rectangle.y, this.cellSize(), rectangle.height) : new Rectangle((int)Math.round(d * (double)rectangle.width) + rectangle.x - (int)Math.floor((double)this.cellSize() / 2.0), rectangle.y, this.cellSize(), rectangle.height));
        return rectangle2;
    }

    protected Color colorValueOfBox_withColor_(Rectangle rectangle, Color color) {
        float f = this.normalizedValueOfBox_(rectangle);
        Color color2 = Color.getHSBColor((1.0f - f) * 0.6666667f, 1.0f, StColorValue._GetBrightness((Color)color));
        return color2;
    }

    protected float normalizedValueOfBox_(Rectangle rectangle) {
        Rectangle rectangle2 = this.gaugeBox();
        float f = this.verticalGauge() ? (this.reverseDirection() ? ((float)rectangle.y + (float)rectangle.height / 2.0f - (float)rectangle2.y) / (float)(rectangle2.y + rectangle2.height - rectangle2.y) : ((float)(rectangle2.y + rectangle2.height) - ((float)rectangle.y + (float)rectangle.height / 2.0f)) / (float)(rectangle2.y + rectangle2.height - rectangle2.y)) : (this.reverseDirection() ? ((float)(rectangle2.x + rectangle2.width) - ((float)rectangle.x + (float)rectangle.width / 2.0f)) / (float)(rectangle2.x + rectangle2.width - rectangle2.x) : ((float)rectangle.x + (float)rectangle.width / 2.0f - (float)rectangle2.x) / (float)(rectangle2.x + rectangle2.width - rectangle2.x));
        f = Math.max(0.0f, Math.min(f, 1.0f));
        return f;
    }
}

