/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.freehand;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.colors.JunColorChoiceDialog;
import jp.co.sra.jun.goodies.freehand.JunFreehandView;
import jp.co.sra.jun.goodies.freehand.JunFreehandViewAwt;
import jp.co.sra.jun.goodies.freehand.JunFreehandViewSwing;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.nib.JunNibChoiceDialog;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;

public class JunFreehandPage
extends JunApplicationModel {
    protected JunNibChoiceWithColor nibChoice;
    protected Vector nibCollection;
    protected Vector locusCollection;
    protected Vector scalarCollection;
    protected int currentIndex;

    public JunFreehandPage() {
    }

    public JunFreehandPage(JunLispList junLispList) {
        this();
        this.fromLispList_(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.flushPage();
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public void flushPage() {
        this.nibCollection = new Vector();
        this.locusCollection = new Vector();
        this.scalarCollection = new Vector();
        this.currentIndex = -1;
    }

    public Vector locusCollection() {
        return this.locusCollection;
    }

    public Vector scalarCollection() {
        return this.scalarCollection;
    }

    public Vector nibCollection() {
        return this.nibCollection;
    }

    public JunNibChoiceWithColor nibChoice() {
        if (this.nibChoice == null) {
            double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
            this.nibChoice = new JunNibChoiceWithColor(dArray, 1.0, Color.black, JunFreehandPage.$((String)"circle"));
        }
        return this.nibChoice;
    }

    public Color nibColor() {
        return this.nibChoice().nibColor();
    }

    public void nibColor_(Color color) {
        this.nibChoice().nibColor_(color);
    }

    public int nibWidth() {
        return (int)this.nibChoice().nibWidth();
    }

    public void nibWidth_(int n) {
        this.nibChoice().nibWidth_(n);
    }

    public boolean isEmpty() {
        return this.locusCollection().isEmpty();
    }

    public void changeNibColor() {
        Color color = JunColorChoiceDialog.Request_color_("Select a color.", this.nibColor());
        this.nibColor_(color);
    }

    public void changeNibWidth() {
        Object[] objectArray = new Object[]{this.nibChoice().nibCollection(), new Double(this.nibWidth()), this.nibColor(), JunFreehandPage.$((String)"circle")};
        Object object = JunNibChoiceDialog.Request("Please select a nib", objectArray);
        if (object == null) {
            return;
        }
        this.nibWidth_(((Double)((Object[])object)[1]).intValue());
    }

    public void changeNibWidthAndColor() {
        JunNibChoiceWithColor junNibChoiceWithColor = this.nibChoice();
        Window window = null;
        if (junNibChoiceWithColor.builder() == null || (window = junNibChoiceWithColor.builder().window()) == null || !window.isShowing()) {
            junNibChoiceWithColor.open();
        }
        if ((window = junNibChoiceWithColor.builder().window()) != null) {
            window.setName(JunFreehandPage.$String((String)"Nib Choice"));
        }
    }

    public void clearPage() {
        if (JunDialog.Confirm_(JunFreehandPage.$String((String)"Really clear all?"), false)) {
            this.flushPage();
            this.changed();
        }
    }

    public void goBackward() {
        this.currentIndex = Math.max(-1, Math.min(this.currentIndex() - 1, this.locusCollection().size() - 1));
        this.changed();
    }

    public void goForward() {
        this.currentIndex = Math.max(-1, Math.min(this.currentIndex() + 1, this.locusCollection().size() - 1));
        this.changed();
    }

    public void openViewfinder() {
        JunOpenGL3dObject junOpenGL3dObject = this.threeDimensionalObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_(junOpenGL3dObject, new Jun3dPoint(0.0, 0.0, 1000.0), new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0));
    }

    public StView defaultView() {
        if (JunFreehandPage.GetDefaultViewMode() == 0) {
            return new JunFreehandViewAwt(this);
        }
        return new JunFreehandViewSwing(this);
    }

    protected String windowTitle() {
        return JunFreehandPage.$String((String)"Freehand Page");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        this.nibChoice().closeRequest();
        super.noticeOfWindowClose(windowEvent);
    }

    public void fromLispList_(JunLispList junLispList) {
        this.nibColorFromLispList_(junLispList);
        this.nibWidthFromLispList_(junLispList);
        this.nibCollectionFromLispList_(junLispList);
        this.locusCollectionFromLispList_(junLispList);
        this.scalarCollectionFromLispList_(junLispList);
        this.currentIndexFromLispList_(junLispList);
    }

    protected void nibColorFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"nibColor"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.nibColor_((Color)junLispCons.tail());
    }

    protected void nibWidthFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"nibWidth"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.nibWidth_(((Number)junLispCons.tail()).intValue());
    }

    protected void nibCollectionFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"nibCollection"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Vector<Object[]> vector = new Vector<Object[]>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(((JunLispCons)((Object)objectArray[i])).asArray());
        }
        this.nibCollection = vector;
    }

    protected void locusCollectionFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"locusCollection"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Vector<Object[]> vector = new Vector<Object[]>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(((JunLispCons)((Object)objectArray[i])).asArray());
        }
        this.locusCollection = vector;
    }

    protected void scalarCollectionFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"scalarCollection"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Vector<Object[]> vector = new Vector<Object[]>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(((JunLispCons)((Object)objectArray[i])).asArray());
        }
        this.scalarCollection = vector;
    }

    protected void currentIndexFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 6.$((String)"currentIndex"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.currentIndex = ((Number)junLispCons.tail()).intValue();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        junLispCons.add_((Object)this.nibColorToLispList());
        junLispCons.add_((Object)this.nibWidthToLispList());
        if (!this.nibCollection().isEmpty()) {
            junLispCons.add_((Object)this.nibCollectionToLispList());
        }
        if (!this.locusCollection().isEmpty()) {
            junLispCons.add_((Object)this.locusCollectionToLispList());
        }
        if (!this.scalarCollection().isEmpty()) {
            junLispCons.add_((Object)this.scalarCollectionToLispList());
        }
        junLispCons.add_((Object)this.currentIndexToLispList());
        return junLispCons;
    }

    protected JunLispCons nibColorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"nibColor"));
        junLispCons.tail_(this.nibColor());
        return junLispCons;
    }

    protected JunLispCons nibWidthToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"nibWidth"));
        junLispCons.tail_(new Integer(this.nibWidth()));
        return junLispCons;
    }

    protected JunLispCons nibCollectionToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"nibCollection"));
        JunLispList[] junLispListArray = new JunLispList[this.nibCollection().size()];
        for (int i = 0; i < junLispListArray.length; ++i) {
            junLispListArray[i] = JunLispList.List_((Object[])this.nibCollection().get(i));
        }
        junLispCons.tail_((Object)JunLispList.List_((Object[])junLispListArray));
        return junLispCons;
    }

    protected JunLispCons locusCollectionToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"locusCollection"));
        JunLispList[] junLispListArray = new JunLispList[this.locusCollection().size()];
        for (int i = 0; i < junLispListArray.length; ++i) {
            junLispListArray[i] = JunLispList.List_((Object[])((Jun3dPoint[])this.locusCollection().get(i)));
        }
        junLispCons.tail_((Object)JunLispList.List_((Object[])junLispListArray));
        return junLispCons;
    }

    protected JunLispCons scalarCollectionToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"scalaarCollection"));
        junLispCons.tail_((Object)JunLispList.List_(this.scalarCollection()));
        return junLispCons;
    }

    protected JunLispCons currentIndexToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandPage.$((String)"currentIndex"));
        junLispCons.tail_(new Integer(this.currentIndex()));
        return junLispCons;
    }

    protected void _drawMark(Graphics graphics, Point point) {
        int n = this.nibWidth();
        int n2 = point.x - n / 2;
        int n3 = point.y - n / 2;
        int n4 = n / 2 * 2 + 1;
        graphics.fillRect(n2, n3, n4, n4);
    }

    protected void _drawDotbox(Graphics graphics, StRectangle stRectangle) {
        if (stRectangle.width() < 3) {
            graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        } else {
            StRectangle stRectangle2 = stRectangle.expandedBy_(new StRectangle(0, 0, 1, 1));
            graphics.fillArc(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height(), 0, 360);
        }
    }

    protected void _drawPolyline(Graphics graphics, Point[] pointArray) {
        for (int i = 1; i < pointArray.length; ++i) {
            graphics.drawLine(pointArray[i - 1].x, pointArray[i - 1].y, pointArray[i].x, pointArray[i].y);
        }
    }

    protected void _drawPolyline(Graphics graphics, Vector vector) {
        Object[] objectArray = new Point[vector.size()];
        vector.copyInto(objectArray);
        this._drawPolyline(graphics, (Point[])objectArray);
    }

    protected Stroke _stroke(float f) {
        return new BasicStroke(f, 1, 1);
    }

    protected void nibColor_nibWidth_nibCollection_locusCollection_scalarCollection_currentIndex_(Color color, int n, Vector vector, Vector vector2, Vector vector3, int n2) {
        this.nibColor_(color);
        this.nibWidth_(n);
        this.nibCollection = vector;
        this.locusCollection = vector2;
        this.scalarCollection = vector3;
        this.currentIndex = Math.min(n2, this.locusCollection.size());
    }

    protected void pointCollection_boundingBox_timeCollection_(Vector vector, Rectangle rectangle, Vector vector2) {
        int n;
        int n2;
        if (vector.isEmpty()) {
            return;
        }
        if (vector2.isEmpty()) {
            return;
        }
        int n3 = rectangle.width / 2;
        int n4 = rectangle.height / 2;
        Point point = new Point(n3, n4);
        int n5 = vector.size();
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[n5];
        if (n3 == 0 || n4 == 0) {
            for (n2 = 0; n2 < n5; ++n2) {
                jun2dPointArray[n2] = new Jun2dPoint(0.0, 0.0);
            }
        } else {
            for (n2 = 0; n2 < n5; ++n2) {
                Point point2 = (Point)vector.get(n2);
                double d = (double)(point2.x - point.x) / (double)n3;
                double d2 = (double)(point2.y - point.y) / (double)n4;
                jun2dPointArray[n2] = new Jun2dPoint(d, -d2);
            }
        }
        long l = ((Number)vector2.firstElement()).longValue();
        long l2 = ((Number)vector2.lastElement()).longValue() - l;
        double[] dArray = null;
        if (l2 == 0L) {
            dArray = new double[]{0.0};
        } else {
            int n6 = vector2.size();
            dArray = new double[n6];
            for (n = 0; n < n6; ++n) {
                double d = ((Number)vector2.get(n)).doubleValue();
                dArray[n] = (d - (double)l) / (double)l2;
            }
        }
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n5];
        for (n = 0; n < n5; ++n) {
            jun3dPointArray[n] = new Jun3dPoint(jun2dPointArray[n], dArray[n]);
        }
        this.nibCollection().setSize(this.currentIndex + 1);
        this.locusCollection().setSize(this.currentIndex + 1);
        this.scalarCollection().setSize(this.currentIndex + 1);
        this.nibCollection().add(new Object[]{this.nibColor(), new Integer(this.nibWidth())});
        this.locusCollection().add(jun3dPointArray);
        this.scalarCollection().add(new Jun3dPoint(n3, n4, l2));
        ++this.currentIndex;
    }

    protected JunOpenGL3dObject threeDimensionalObject() {
        if (this.currentIndex() < 0) {
            return null;
        }
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        for (int i = 0; i <= this.currentIndex(); ++i) {
            JunOpenGL3dPrimitiveObject junOpenGL3dPrimitiveObject;
            Jun3dPoint[] jun3dPointArray = (Jun3dPoint[])this.locusCollection.get(i);
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)this.scalarCollection.get(i));
            Object[] objectArray = (Object[])this.nibCollection.get(i);
            Color color = (Color)objectArray[0];
            int n = ((Number)objectArray[1]).intValue();
            Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[jun3dPointArray.length];
            for (int j = 0; j < jun3dPointArray2.length; ++j) {
                jun3dPointArray2[j] = jun3dPointArray[j].multipliedBy_(jun3dPoint2);
            }
            JunOpenGL3dObject junOpenGL3dObject = null;
            if (jun3dPointArray2.length == 1) {
                junOpenGL3dPrimitiveObject = new JunOpenGL3dVertex(jun3dPointArray2[0]);
                ((JunOpenGL3dVertex)junOpenGL3dPrimitiveObject).size_(n);
                junOpenGL3dObject = junOpenGL3dPrimitiveObject;
            } else {
                junOpenGL3dPrimitiveObject = new JunOpenGL3dPolyline(jun3dPointArray2);
                ((JunOpenGL3dPolyline)junOpenGL3dPrimitiveObject).lineWidth_(n);
                junOpenGL3dObject = junOpenGL3dPrimitiveObject;
            }
            junOpenGL3dObject.paint_(color);
            junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint);
            junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
            jun3dPoint = jun3dPoint.plus_(new Jun3dPoint(0.0, 0.0, jun3dPoint2.z()));
        }
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dCompoundObject.boundingBox();
        junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGL3dCompoundObject.scaledBy_(new Jun3dPoint(2.0 / jun3dBoundingBox.width(), 2.0 / jun3dBoundingBox.height(), 2.0 / jun3dBoundingBox.depth()));
        return junOpenGL3dCompoundObject;
    }

    public StView getView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunFreehandView) || ((JunFreehandView)dependentListenerArray[i]).model() != this) continue;
            return (JunFreehandView)dependentListenerArray[i];
        }
        return null;
    }
}

