/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.map;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapController;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModel;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenuViewSwing;

public class JunDrawingMapViewSwing
extends JunAbstractViewJPanel
implements JunDrawingMapView {
    protected int editMode;
    protected StViewJPanel canvas;
    protected JScrollPane scrollPane;
    protected transient HashMap popupMenuTable;
    protected transient Image offScreenImage;
    protected transient Dimension offScreenSize;

    public JunDrawingMapViewSwing() {
    }

    public JunDrawingMapViewSwing(JunDrawingMapModel junDrawingMapModel) {
        super(junDrawingMapModel);
    }

    protected void initialize() {
        super.initialize();
        this.editMode = 0;
        this.canvas = null;
        this.scrollPane = null;
        this.popupMenuTable = null;
        this.offScreenImage = null;
        this.offScreenSize = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeOffScreen() {
        if (this.offScreenImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.offScreenImage.getGraphics().create();
        try {
            graphics2D.setColor(this.canvas().getBackground());
            graphics2D.setClip(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            graphics2D.fillRect(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            graphics2D.translate(-this.scrollPane().getViewport().getViewRect().x, -this.scrollPane().getViewport().getViewRect().y);
            if (this.getDrawingMapModel().isZooming()) {
                Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
                graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
            }
            this.displayCanvasOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    public int editMode() {
        return this.editMode;
    }

    public void editMode_(int n) {
        if (this.editMode != n) {
            int n2 = this.editMode;
            this.editMode = n;
            this.firePropertyChange("editMode", n2, n);
            if (this.getDrawingMapController().startPoint() != null) {
                this.canvas().repaint(0L);
                this.getDrawingMapController().initializeTemporaryVariables();
            }
        }
    }

    public Rectangle areaOfElements_(JunDrawingElement[] junDrawingElementArray) {
        Rectangle rectangle = null;
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            if (rectangle == null) {
                rectangle = new Rectangle(junDrawingElementArray[i].bounds());
                continue;
            }
            rectangle.add(junDrawingElementArray[i].bounds());
        }
        return rectangle;
    }

    public JunDrawingMapModel getDrawingMapModel() {
        return (JunDrawingMapModel)this.model();
    }

    public JunDrawingMapController getDrawingMapController() {
        return (JunDrawingMapController)this.canvas().controller();
    }

    protected void buildComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane(), "Center");
        this.setPreferredSize(new Dimension(300, 200));
    }

    public StViewJPanel canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewJPanel((StModel)this.getDrawingMapModel()){

                protected StController defaultController() {
                    return new JunDrawingMapController();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void displayOn_(Graphics graphics) {
                    JunDrawingMapViewSwing junDrawingMapViewSwing = JunDrawingMapViewSwing.this;
                    Image image = junDrawingMapViewSwing.offScreen();
                    if (image != null) {
                        Rectangle rectangle = graphics.getClipBounds();
                        Graphics2D graphics2D = junDrawingMapViewSwing.graphicsWithZoomFrom_(image);
                        try {
                            if (rectangle != null) {
                                if (junDrawingMapViewSwing.getDrawingMapModel().isZooming()) {
                                    Jun2dPoint jun2dPoint = junDrawingMapViewSwing.getDrawingMapModel().scalePoint();
                                    rectangle = new Rectangle((int)Math.floor((double)rectangle.x / jun2dPoint.x()), (int)Math.floor((double)rectangle.y / jun2dPoint.y()), (int)Math.ceil((double)rectangle.width / jun2dPoint.x()), (int)Math.ceil((double)rectangle.height / jun2dPoint.y()));
                                }
                                graphics2D.setColor(junDrawingMapViewSwing.canvas().getBackground());
                                graphics2D.setClip(rectangle);
                                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            }
                            junDrawingMapViewSwing.displayCanvasOn_(graphics2D);
                        }
                        finally {
                            if (graphics2D != null) {
                                graphics2D.dispose();
                                graphics2D = null;
                            }
                        }
                        junDrawingMapViewSwing.displayCanvasOn_scaledImage_unscaledClip_(graphics, image, null);
                    } else {
                        Graphics2D graphics2D = (Graphics2D)image.getGraphics().create();
                        try {
                            if (junDrawingMapViewSwing.getDrawingMapModel().isZooming()) {
                                Jun2dPoint jun2dPoint = junDrawingMapViewSwing.getDrawingMapModel().scalePoint();
                                graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
                            }
                            junDrawingMapViewSwing.displayCanvasOn_(graphics2D);
                        }
                        finally {
                            if (graphics2D != null) {
                                graphics2D.dispose();
                                graphics2D = null;
                            }
                        }
                    }
                }

                public void _showPopupMenu(int n, int n2) {
                    JPopupMenu jPopupMenu = JunDrawingMapViewSwing.this.popupMenuView(n, n2);
                    if (jPopupMenu != null) {
                        jPopupMenu.show((Component)((Object)this), n, n2);
                    }
                }

                public void update(Graphics graphics) {
                    graphics.setClip(0, 0, this.getWidth(), this.getHeight());
                    this.displayOn_(graphics);
                }

                public void update_(DependentEvent dependentEvent) {
                }
            };
            this.canvas.setBackground(Color.white);
            this.canvas.setLayout(null);
        }
        return this.canvas;
    }

    protected JScrollPane scrollPane() {
        if (this.scrollPane == null) {
            final JunDrawingMapViewSwing junDrawingMapViewSwing = this;
            this.scrollPane = new JScrollPane((Component)this.canvas(), 20, 30);
            this.scrollPane.getHorizontalScrollBar().setFocusable(false);
            this.scrollPane.getVerticalScrollBar().setFocusable(false);
            this.scrollPane.getViewport().setBackground(Color.white);
            this.scrollPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    junDrawingMapViewSwing.updateCanvasSize_(junDrawingMapViewSwing.canvas().getSize());
                }
            });
            this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    junDrawingMapViewSwing.repaint(0L);
                }
            });
            this.updateCanvasSize_(this.canvas().getSize());
        }
        return this.scrollPane;
    }

    public Point centerPointOnScrollPane() {
        Point point = this.scrollPane().getViewport().getViewPosition();
        Dimension dimension = this.scrollPane().getSize();
        return new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    public void displayCanvasOn_(Graphics graphics) {
        if (!this.canvas().isShowing()) {
            return;
        }
        StDisplayable stDisplayable = this.getDrawingMapModel().displayObject();
        if (stDisplayable != null) {
            stDisplayable.displayOn_(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCanvasOn_scaledImage_unscaledClip_(Graphics graphics, Image image, Rectangle rectangle) {
        if (graphics == null) {
            return;
        }
        try {
            Rectangle rectangle2;
            if (rectangle != null) {
                rectangle2 = new Rectangle(rectangle);
                if (this.getDrawingMapModel().isZooming()) {
                    Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
                    rectangle2.setBounds((int)Math.floor((double)rectangle.x * jun2dPoint.x()), (int)Math.floor((double)rectangle.y * jun2dPoint.y()), (int)Math.ceil((double)rectangle.width * jun2dPoint.x()), (int)Math.ceil((double)rectangle.height * jun2dPoint.y()));
                }
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
            }
            rectangle2 = this.scrollPane().getViewport().getViewRect();
            graphics.drawImage(image, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, (ImageObserver)((Object)this));
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _invalidateRectangle_repairNow_(Rectangle rectangle, boolean bl) {
        Object object;
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = null;
        if (this.getDrawingMapModel().isZooming()) {
            object = this.getDrawingMapModel().scalePoint();
            rectangle2 = new Rectangle((int)Math.floor((double)rectangle.x * ((Jun2dPoint)((Object)object)).x()), (int)Math.floor((double)rectangle.y * ((Jun2dPoint)((Object)object)).y()), (int)Math.ceil((double)rectangle.width * ((Jun2dPoint)((Object)object)).x()), (int)Math.ceil((double)rectangle.height * ((Jun2dPoint)((Object)object)).y()));
            rectangle2.grow(5, 5);
        } else {
            rectangle2 = rectangle;
        }
        object = this.canvas().getGraphics();
        if (object == null) {
            return;
        }
        try {
            ((Graphics)object).setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.canvas().displayOn_((Graphics)object);
        }
        finally {
            if (object != null) {
                ((Graphics)object).dispose();
                object = null;
            }
        }
    }

    public Image createOffScreen() {
        this.initializeOffScreen();
        return this.offScreen();
    }

    public Image offScreen() {
        Dimension dimension = this.scrollPane().getViewport().getViewRect().getSize();
        if (!dimension.equals(this.offScreenSize) || this.offScreenImage == null) {
            this.offScreenImage = this.createImage(dimension.width, dimension.height);
            this.offScreenSize = dimension;
            this.initializeOffScreen();
        }
        return this.offScreenImage;
    }

    public Graphics2D graphicsWithZoomFrom_(Image image) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics().create();
        graphics2D.translate(-this.scrollPane().getViewport().getViewRect().x, -this.scrollPane().getViewport().getViewRect().y);
        if (this.getDrawingMapModel().isZooming()) {
            Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
            graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
        }
        return graphics2D;
    }

    public void updateVertexMenuIndication(JunDrawingElement junDrawingElement) {
        StMenu stMenu = (StMenu)this.getDrawingMapModel().popupMenuFor_(junDrawingElement).atNameKey_(JunDrawingMapViewSwing.$((String)"vertexMenu"));
        if (stMenu == null) {
            return;
        }
        JunPathElement junPathElement = null;
        if (junDrawingElement.isPath()) {
            junPathElement = (JunPathElement)junDrawingElement;
        } else if (junDrawingElement.isLink()) {
            junPathElement = ((JunLinkElement)junDrawingElement).pathElement();
        } else {
            return;
        }
        Point point = this.getDrawingMapController().popupMenuPoint();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunDrawingMapViewSwing.$((String)"addVertex"));
        if (stMenuItem != null) {
            if (point != null && junPathElement.containsPoint_(point)) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapViewSwing.$((String)"removeVertex"))) != null) {
            if (point != null && junPathElement.containsPointInControllArea_(point) && junPathElement.points().size() > 2) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
    }

    public JPopupMenu popupMenuView(int n, int n2) {
        StSymbol stSymbol;
        JunDrawingElement junDrawingElement = this.getDrawingMapModel().mapObject().currentElement();
        StSymbol stSymbol2 = stSymbol = junDrawingElement != null ? junDrawingElement._className() : null;
        if (!this.popupMenuTable().containsKey(stSymbol)) {
            JPopupMenu jPopupMenu = new StPopupMenuViewSwing(this.getDrawingMapModel().popupMenuFor_(junDrawingElement)).toPopupMenu();
            this.popupMenuTable().put(stSymbol, jPopupMenu);
            this.canvas().add((Component)jPopupMenu);
        }
        this.updateVertexMenuIndication(junDrawingElement);
        return (JPopupMenu)this.popupMenuTable().get(stSymbol);
    }

    public HashMap popupMenuTable() {
        if (this.popupMenuTable == null) {
            this.popupMenuTable = new HashMap();
        }
        return this.popupMenuTable;
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        this.getDrawingMapModel().updateMenuIndication();
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunDrawingMapViewSwing.$((String)"redisplay")) {
            if (dependentEvent.getParameter() == null) {
                this.updateCanvasSize_(this.canvas().getSize());
            } else {
                this._invalidateRectangle_repairNow_((Rectangle)dependentEvent.getParameter(), true);
            }
            return;
        }
        if (stSymbol == JunDrawingMapViewSwing.$((String)"bounds")) {
            this.updateCanvasSize_(this.scrollPane().getViewport().getExtentSize());
            return;
        }
        if (stSymbol == JunDrawingMapViewSwing.$((String)"selection")) {
            if (dependentEvent.getParameter() == null) {
                Rectangle rectangle = this.areaOfElements_(this.getDrawingMapModel().mapObject()._componentElements());
                if (rectangle != null) {
                    rectangle.grow(3, 3);
                }
                this._invalidateRectangle_repairNow_(rectangle, true);
            } else {
                this._invalidateRectangle_repairNow_((Rectangle)dependentEvent.getParameter(), true);
            }
            return;
        }
        if (stSymbol == JunDrawingMapViewSwing.$((String)"location")) {
            this.updateCanvasSize_(this.canvas().getSize());
            return;
        }
        if (stSymbol == JunDrawingMapViewSwing.$((String)"zoom")) {
            this.offScreenImage = null;
            this.offScreenSize = null;
            this.updateCanvasSize_(this.scrollPane().getViewport().getExtentSize());
            return;
        }
        super.update_(dependentEvent);
    }

    protected void updateCanvasSize_(Dimension dimension) {
        Dimension dimension2 = this.getDrawingMapModel().scaledSize();
        Dimension dimension3 = new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
        if (!this.canvas().getSize().equals(dimension3)) {
            this.canvas().setPreferredSize(dimension3);
            this.scrollPane().getViewport().doLayout();
            this.offScreenImage = null;
            this.offScreenSize = null;
        }
        Rectangle rectangle = this.scrollPane().getViewport().getViewRect();
        if (this.getDrawingMapModel().isZooming()) {
            Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
            rectangle = new Rectangle((int)Math.floor((double)rectangle.x / jun2dPoint.x()), (int)Math.floor((double)rectangle.y / jun2dPoint.y()), (int)Math.ceil((double)rectangle.width / jun2dPoint.x()), (int)Math.ceil((double)rectangle.height / jun2dPoint.y()));
            rectangle.grow(5, 5);
        }
        this._invalidateRectangle_repairNow_(rectangle, true);
    }
}

