/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunRectangularElement
extends JunNodeElement {
    protected Point elementLocation;
    protected Dimension elementExtent;

    public JunRectangularElement() {
    }

    public JunRectangularElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.elementLocation = null;
        this.elementExtent = null;
    }

    public Point location() {
        if (this.elementLocation == null) {
            this.elementLocation = this.defaultLocation();
        }
        return this.elementLocation;
    }

    public void location_(Point point) {
        this.elementLocation = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        this.flushBounds();
    }

    public Dimension extent() {
        if (this.elementExtent == null) {
            this.elementExtent = this.defaultExtent();
        }
        return this.elementExtent;
    }

    public void extent_(Dimension dimension) {
        this.elementExtent = new Dimension(Math.max(dimension.width, this.defaultMinimumExtent().width), Math.max(dimension.height, this.defaultMinimumExtent().height));
        this.flushBounds();
    }

    public Rectangle preferredBounds() {
        return new Rectangle(this.location(), this.extent());
    }

    public HashMap controllPoints() {
        Point point = this.location();
        Point point2 = this.extentPoint();
        HashMap<StSymbol, Point> hashMap = new HashMap<StSymbol, Point>();
        hashMap.put(JunDrawingElement.CONTROLL_POINT_TOP_LEFT, new Point(point.x, point.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_TOP_RIGHT, new Point(point2.x, point.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT, new Point(point.x, point2.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_BOTTOM_RIGHT, new Point(point2.x, point2.y));
        return hashMap;
    }

    public void controllPointAt_put_(StSymbol stSymbol, Point point) {
        int n;
        Rectangle rectangle = this.bounds();
        Point point2 = this.controllPointAt_(stSymbol);
        boolean bl = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_RIGHT;
        boolean bl2 = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT;
        int n2 = Math.max(point.x, 0) - point2.x;
        int n3 = Math.max(point.y, 0) - point2.y;
        int n4 = bl2 ? Math.max(rectangle.x + n2, 0) : rectangle.x;
        int n5 = bl ? Math.max(rectangle.y + n3, 0) : rectangle.y;
        int n6 = bl2 ? rectangle.width + (rectangle.x - n4) : Math.max(rectangle.width + n2, this.defaultMinimumExtent().width);
        int n7 = n = bl ? rectangle.height + (rectangle.y - n5) : Math.max(rectangle.height + n3, this.defaultMinimumExtent().height);
        if (n6 < this.defaultMinimumExtent().width) {
            n4 += n6 - this.defaultMinimumExtent().width;
            n6 = this.defaultMinimumExtent().width;
        }
        if (n < this.defaultMinimumExtent().height) {
            n5 += n - this.defaultMinimumExtent().height;
            n = this.defaultMinimumExtent().height;
        }
        this.bounds_(new Rectangle(n4, n5, n6, n));
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.location_(new Point(this.elementLocation));
        this.extent_(new Dimension(this.elementExtent));
        return this;
    }

    protected void flushBounds() {
    }

    public boolean isRectangular() {
        return true;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.locationToLispList());
        junLispCons.add_((Object)this.extentToLispList());
        return junLispCons;
    }

    protected JunLispCons locationToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunRectangularElement.$((String)"location"));
        junLispCons.tail_((Object)new Jun2dPoint(this.location()));
        return junLispCons;
    }

    protected JunLispCons extentToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunRectangularElement.$((String)"extent"));
        junLispCons.tail_((Object)new Jun2dPoint(this.extent().width, this.extent().height));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.locationFromLispList_(junLispList);
        this.extentFromLispList_(junLispList);
    }

    protected void locationFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"location"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.location_(((Jun2dPoint)((Object)junLispList2.tail()))._toPoint());
    }

    protected void extentFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"extent"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        Point point = ((Jun2dPoint)((Object)junLispList2.tail()))._toPoint();
        this.extent_(new Dimension(point.x, point.y));
    }
}

