/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunPathElement
extends JunVertexesElement {
    protected int beginStyle;
    protected int endStyle;
    protected transient Dimension minimumExtent;
    public static final int ARROW_STYLE_SQUARE = 0;
    public static final int ARROW_STYLE_ARROW = 1;
    public static final int ARROW_STYLE_DIAMOND = 2;
    public static final int ARROW_STYLE_CIRCLE = 3;
    public static DataFlavor DataFlavor = new DataFlavor(JunPathElement.class, "JunPathElement");

    public JunPathElement() {
    }

    public JunPathElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.beginStyle = 0;
        this.endStyle = 0;
        this.minimumExtent = null;
    }

    public Point addOnLine_(Point point) {
        Shape[] shapeArray = this.shapes();
        for (int i = 0; i < this.points().size() - 1; ++i) {
            if (!this.stroke().createStrokedShape(shapeArray[i]).contains(point)) continue;
            Point point2 = this.add_after_(point, this.pointAt_(i));
            return point2;
        }
        Point point3 = this.begin().distance(point) <= this.end().distance(point) ? this.add_at_(point, 0) : this.add_(point);
        return point3;
    }

    public void bounds_(Rectangle rectangle) {
        Rectangle rectangle2 = this.pointBounds();
        if (rectangle2.height == 1) {
            this.location_(rectangle.x, this.y());
            this.extent_(rectangle.width, this.height());
        } else if (rectangle2.width == 1) {
            this.location_(this.x(), rectangle.y);
            this.extent_(this.width(), rectangle.height);
        } else {
            super.bounds_(rectangle);
        }
    }

    public void location_(Point point) {
        if (this.location().equals(point)) {
            return;
        }
        Point point2 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        int n = point2.x - this.x();
        int n2 = point2.y - this.y();
        ArrayList<Point> arrayList = new ArrayList<Point>(this.points().size());
        Iterator iterator = this.points().iterator();
        while (iterator.hasNext()) {
            Point point3 = (Point)iterator.next();
            point3.translate(n, n2);
            arrayList.add(new Point(Math.max(point3.x, 0), Math.max(point3.y, 0)));
        }
        this.points_(arrayList);
    }

    public void extent_(Dimension dimension) {
        if (this.extent().equals(dimension)) {
            return;
        }
        Rectangle rectangle = this.pointBounds();
        Point point = rectangle.getLocation();
        Dimension dimension2 = rectangle.getSize();
        int n = Math.max(dimension.width, this.defaultMinimumExtent().width) - (this.preferredBounds().width - dimension2.width);
        int n2 = Math.max(dimension.height, this.defaultMinimumExtent().height) - (this.preferredBounds().height - dimension2.height);
        Dimension dimension3 = new Dimension(n, n2);
        ArrayList<Point> arrayList = new ArrayList<Point>(this.points().size());
        Iterator iterator = this.points().iterator();
        while (iterator.hasNext()) {
            Point point2 = (Point)iterator.next();
            int n3 = rectangle.width == 1 ? point2.x : point.x + Math.max(Math.round((float)((point2.x - point.x) * dimension3.width) / (float)dimension2.width), 0);
            int n4 = rectangle.height == 1 ? point2.y : point.y + Math.max(Math.round((float)((point2.y - point.y) * dimension3.height) / (float)dimension2.height), 0);
            arrayList.add(new Point(n3, n4));
        }
        this.points_(arrayList);
    }

    public HashMap controllPoints() {
        Point[] pointArray = this.points().toArray(new Point[this.points().size()]);
        HashMap<StSymbol, Point> hashMap = new HashMap<StSymbol, Point>();
        hashMap.put(CONTROLL_POINT_BEGIN, pointArray[0]);
        for (int i = 1; i < pointArray.length - 1; ++i) {
            hashMap.put(JunPathElement.$((String)("point_" + i)), pointArray[i]);
        }
        hashMap.put(CONTROLL_POINT_END, pointArray[pointArray.length - 1]);
        return hashMap;
    }

    public void controllPointAt_put_(StSymbol stSymbol, Point point) {
        Point point2 = this.controllPointAt_(stSymbol);
        if (point2 == null) {
            throw new IllegalArgumentException("'" + stSymbol.toString() + "' does not exist.");
        }
        Point point3 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        if (!point2.equals(point3)) {
            point2.setLocation(point3);
            this.flushBounds();
        }
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.minimumExtent = null;
        return this;
    }

    public Dimension defaultMinimumExtent() {
        if (this.minimumExtent == null) {
            Rectangle rectangle = this.preferredBounds();
            Rectangle rectangle2 = this.pointBounds();
            this.minimumExtent = new Dimension(20, 20);
            this.minimumExtent.setSize(this.minimumExtent.width + rectangle.width - rectangle2.width, this.minimumExtent.height + rectangle.height - rectangle2.height);
        }
        return this.minimumExtent;
    }

    protected void flushBounds() {
        super.flushBounds();
        this.minimumExtent = null;
    }

    public boolean isPath() {
        return true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    public int beginStyle() {
        return this.beginStyle;
    }

    public void beginStyle_(int n) {
        if (this.beginStyle() != n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.beginStyle = n;
                    this.flushBounds();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The number of arrow type as'" + n + "' is faild");
                }
            }
        }
    }

    public int endStyle() {
        return this.endStyle;
    }

    public void endStyle_(int n) {
        if (this.endStyle() != n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.endStyle = n;
                    this.flushBounds();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The number of arrow type as'" + n + "' is faild");
                }
            }
        }
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new JunPathPropertiesModel(this);
        }
        return this.propertiesModel;
    }

    protected Shape[] shapes() {
        if (this.shapes == null) {
            ArrayList<Shape> arrayList = new ArrayList<Shape>();
            Point[] pointArray = this._points();
            for (int i = 1; i < pointArray.length; ++i) {
                arrayList.add(new Line2D.Double(pointArray[i - 1].x, pointArray[i - 1].y, pointArray[i].x, pointArray[i].y));
            }
            Shape[] shapeArray = this.arrowShapes_point_with_(this.beginStyle(), pointArray[0], pointArray[1]);
            for (int i = 0; i < shapeArray.length; ++i) {
                arrayList.add(shapeArray[i]);
            }
            Shape[] shapeArray2 = this.arrowShapes_point_with_(this.endStyle(), pointArray[pointArray.length - 1], pointArray[pointArray.length - 2]);
            for (int i = 0; i < shapeArray2.length; ++i) {
                arrayList.add(shapeArray2[i]);
            }
            this.shapes = arrayList.toArray(new Shape[arrayList.size()]);
        }
        return this.shapes;
    }

    protected Shape[] arrowShapes_point_with_(int n, Point point, Point point2) {
        if (n == 0) {
            return new Line2D.Double[0];
        }
        if (n == 1) {
            double d = new Jun2dPoint(point).minus_(new Jun2dPoint(point2)).theta();
            Jun2dTransformation jun2dTransformation = Jun2dTransformation.RotateZ_(d);
            jun2dTransformation = jun2dTransformation.product_(Jun2dTransformation.Translate_(new Jun2dPoint(point2)));
            Jun2dLine jun2dLine = new Jun2dLine(new Jun2dPoint(point.x - 13 - this.lineWidth() * 2, point.y - 3 - this.lineWidth()), new Jun2dPoint(point));
            jun2dLine = jun2dLine.transform_(jun2dTransformation);
            jun2dLine = jun2dLine.translatedBy_(jun2dLine.to().minus_(new Jun2dPoint(point)).negated());
            Point point3 = jun2dLine.from()._toPoint();
            Jun2dLine jun2dLine2 = new Jun2dLine(new Jun2dPoint(point.x - 13 - this.lineWidth() * 2, point.y + 3 + this.lineWidth()), new Jun2dPoint(point));
            jun2dLine2 = jun2dLine2.transform_(jun2dTransformation);
            jun2dLine2 = jun2dLine2.translatedBy_(jun2dLine2.to().minus_(new Jun2dPoint(point)).negated());
            Point point4 = jun2dLine2.from()._toPoint();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(point3.x, point3.y);
            generalPath.lineTo(point.x, point.y);
            generalPath.lineTo(point4.x, point4.y);
            return new GeneralPath[]{generalPath};
        }
        if (n == 2) {
            double d = new Jun2dPoint(point).minus_(new Jun2dPoint(point2)).theta();
            Jun2dTransformation jun2dTransformation = Jun2dTransformation.RotateZ_(d);
            jun2dTransformation = jun2dTransformation.product_(Jun2dTransformation.Translate_(new Jun2dPoint(point2)));
            int n2 = 10 + this.lineWidth() * 2;
            int[] nArray = new int[]{point.x, point.x - n2, point.x - n2 * 2, point.x - n2};
            int[] nArray2 = new int[]{point.y, point.y - n2 / 2, point.y, point.y + n2 / 2};
            Jun2dPoint jun2dPoint = null;
            for (int i = 0; i < nArray.length; ++i) {
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(nArray[i], nArray2[i]);
                jun2dPoint2 = jun2dPoint2.transform_(jun2dTransformation);
                if (jun2dPoint == null) {
                    jun2dPoint = new Jun2dPoint(jun2dPoint2).minus_(new Jun2dPoint(point)).negated();
                }
                jun2dPoint2 = jun2dPoint2.translatedBy_(jun2dPoint);
                nArray[i] = jun2dPoint2._toPoint().x;
                nArray2[i] = jun2dPoint2._toPoint().y;
            }
            return new Polygon[]{new Polygon(nArray, nArray2, nArray.length)};
        }
        if (n == 3) {
            double d = new Jun2dPoint(point).minus_(new Jun2dPoint(point2)).theta();
            Jun2dTransformation jun2dTransformation = Jun2dTransformation.RotateZ_(d);
            jun2dTransformation = jun2dTransformation.product_(Jun2dTransformation.Translate_(new Jun2dPoint(point2)));
            int n3 = 10 + this.lineWidth() * 2;
            Jun2dPoint jun2dPoint = new Jun2dPoint(point.x - n3 / 2, point.y);
            jun2dPoint = jun2dPoint.transform_(jun2dTransformation);
            Jun2dPoint jun2dPoint3 = new Jun2dPoint(point).transform_(jun2dTransformation).minus_(new Jun2dPoint(point)).negated();
            jun2dPoint = jun2dPoint.translatedBy_(jun2dPoint3);
            return new Ellipse2D.Double[]{new Ellipse2D.Double(jun2dPoint._toPoint().x - n3 / 2, jun2dPoint._toPoint().y - n3 / 2, n3, n3)};
        }
        throw new IllegalArgumentException("The number of arrow type as'" + n + "' is faild");
    }

    protected BasicStroke stroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.lineWidth(), 0, 2);
        }
        return this.stroke;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.beginStyleToLispList());
        junLispCons.add_((Object)this.endStyleToLispList());
        return junLispCons;
    }

    protected JunLispCons beginStyleToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunPathElement.$((String)"beginStyle"));
        junLispCons.tail_(new Integer(this.beginStyle()));
        return junLispCons;
    }

    protected JunLispCons endStyleToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunPathElement.$((String)"endStyle"));
        junLispCons.tail_(new Integer(this.endStyle()));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.beginStyleFromLispList_(junLispList);
        this.endStyleFromLispList_(junLispList);
    }

    protected void beginStyleFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"beginStyle"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.beginStyle_(((Number)junLispList2.tail()).intValue());
    }

    protected void endStyleFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"endStyle"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.endStyle_(((Number)junLispList2.tail()).intValue());
    }
}

