/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularElement;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;

public class JunImageElement
extends JunRectangularElement {
    protected File file;
    protected StImage image;
    protected transient BufferedImage scaledImage;
    public static DataFlavor DataFlavor = new DataFlavor(JunImageElement.class, "JunImageElement");

    public JunImageElement() {
    }

    public JunImageElement(JunLispList junLispList) {
        super(junLispList);
    }

    public File file() {
        return this.file;
    }

    public void file_(File file) {
        this.file = file;
        this.image = null;
        this.scaledImage = null;
    }

    public void filename_(String string) {
        File file = new File(string);
        if (file.exists() || file.isFile()) {
            this.file_(file);
        }
    }

    public StImage image() {
        if (this.image == null && this.file() != null) {
            this.image = JunImageProcessor.ImageFromFile_(this.file());
        }
        return this.image;
    }

    public void image_(StImage stImage) {
        if (this.image != stImage) {
            this.image = stImage;
            this.file = null;
            this.scaledImage = null;
        }
    }

    protected BufferedImage scaledImage() {
        if (this.image() != null && (this.scaledImage == null || this.scaledImage.getWidth() != this.width() || this.scaledImage.getHeight() != this.height())) {
            int n;
            int n2;
            int n3;
            BufferedImage bufferedImage = this.image().image();
            int n4 = bufferedImage.getWidth();
            if ((float)n4 / (float)(n3 = bufferedImage.getHeight()) > (float)(n2 = this.width()) / (float)(n = this.height())) {
                n = Math.round((float)n2 * (float)n3 / (float)n4);
            } else {
                n2 = Math.round((float)n * (float)n4 / (float)n3);
            }
            AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n2 / (double)n4, (double)n / (double)n3), 1);
            this.scaledImage = affineTransformOp.filter(bufferedImage, null);
        }
        return this.scaledImage;
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.scaledImage = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && !rectangle.intersects(this.bounds())) {
            return;
        }
        Graphics graphics2 = graphics.create();
        try {
            rectangle = rectangle == null ? this.bounds() : this.bounds().intersection(rectangle);
            graphics2.setClip(rectangle);
            graphics2.setColor(new Color(32, 32, 32, 32));
            graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.scaledImage() != null) {
                BufferedImage bufferedImage = this.scaledImage();
                int n = this.width() == bufferedImage.getWidth() ? 0 : (this.width() - bufferedImage.getWidth()) / 2;
                int n2 = this.height() == bufferedImage.getHeight() ? 0 : (this.height() - bufferedImage.getHeight()) / 2;
                graphics2.drawImage(bufferedImage, this.x() + n, this.y() + n2, null);
            } else {
                StComposedText stComposedText = new StComposedText("no image");
                if (stComposedText.width() > this.width()) {
                    stComposedText = new StComposedText("no image", this.width());
                }
                int n = stComposedText.width() == this.width() ? 0 : (this.width() - stComposedText.width()) / 2;
                int n3 = (this.height() - stComposedText.height()) / 2;
                graphics2.setColor(Color.black);
                stComposedText.displayOn_at_(graphics2, new Point(this.x() + n, this.y() + n3));
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    protected void initialize() {
        super.initialize();
        this.file = null;
        this.image = null;
        this.scaledImage = null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{JunPathElement.DataFlavor};
    }

    public boolean isImage() {
        return true;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        if (this.file() != null) {
            junLispCons.add_((Object)this.fileToLispList());
        } else if (this.image() != null) {
            junLispCons.add_((Object)this.imageToLispList());
        }
        return junLispCons;
    }

    protected JunLispCons fileToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunImageElement.$((String)"file"));
        junLispCons.tail_(this.file().getPath());
        return junLispCons;
    }

    protected JunLispCons imageToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunImageElement.$((String)"image"));
        junLispCons.tail_(this.image());
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.fileFromLispList_(junLispList);
        this.imageFromLispList_(junLispList);
    }

    protected void fileFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"file"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.filename_((String)junLispList2.tail());
    }

    protected void imageFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"image"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.image_((StImage)junLispList2.tail());
    }
}

