/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.JPopupMenu;
import jp.co.sra.jun.goodies.colors.JunColorChoiceController;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHSB;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.colors.JunColorChoiceView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;

public class JunColorChoiceViewSwing
extends JunAbstractViewJPanel
implements JunColorChoiceView {
    protected JPopupMenu _popupMenu = null;

    public JunColorChoiceViewSwing() {
    }

    public JunColorChoiceViewSwing(JunColorChoiceModel junColorChoiceModel) {
        super(junColorChoiceModel);
    }

    public Rectangle barArea() {
        int n = this.plateArea().x + this.plateArea().width + 16;
        int n2 = this.plateArea().y;
        this.getModel();
        Rectangle rectangle = JunColorChoiceModel._barArea();
        Rectangle rectangle2 = new Rectangle(n, n2, rectangle.width, rectangle.height);
        return rectangle2;
    }

    public double brightness() {
        return this.getModel().brightness();
    }

    public Rectangle brightnessArea() {
        int n = this.saturationArea().x;
        int n2 = this.saturationArea().y + this.saturationArea().height + 3;
        Rectangle rectangle = new Rectangle(n, n2, 56, 18);
        return rectangle;
    }

    public String brightnessString() {
        double d = this.round();
        int n = String.valueOf(d).length();
        double d2 = this.brightness();
        String string = String.valueOf((double)Math.round(d2 / d) * d);
        string = string.substring(0, Math.min(string.length(), n));
        for (int i = 0; i < n - string.length(); ++i) {
            string = string + "0";
        }
        return string;
    }

    public Rectangle colorArea() {
        int n = this.barArea().x + this.barArea().width + 16;
        int n2 = this.barArea().y - 1;
        Rectangle rectangle = new Rectangle(n, n2, 30, 30);
        return rectangle;
    }

    public String colorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(ColorValue hue: ");
        stringBuffer.append(this.hueString());
        stringBuffer.append(" saturation: ");
        stringBuffer.append(this.saturationString());
        stringBuffer.append(" brightness: ");
        stringBuffer.append(this.brightnessString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayPlateOn_(graphics);
        this.displayXYOn_(graphics);
        this.displayBarOn_(graphics);
        this.displayZOn_(graphics);
        this.displayColorOn_(graphics);
        this.displaySpuitOn_(graphics);
        this.displayHueOn_(graphics);
        this.displaySaturationOn_(graphics);
        this.displayBrightnessOn_(graphics);
    }

    public JunColorChoiceModel getModel() {
        return (JunColorChoiceModel)this.model();
    }

    public double hue() {
        return this.getModel().hue();
    }

    public Rectangle hueArea() {
        int n = this.colorArea().x;
        int n2 = this.colorArea().y + this.colorArea().height + 12;
        Rectangle rectangle = new Rectangle(n, n2, 56, 18);
        return rectangle;
    }

    public String hueString() {
        double d = this.round();
        int n = String.valueOf(d).length();
        double d2 = this.hue();
        String string = String.valueOf((double)Math.round(d2 / d) * d);
        string = string.substring(0, Math.min(string.length(), n));
        for (int i = 0; i < n - string.length(); ++i) {
            string = string + "0";
        }
        return string;
    }

    public Rectangle plateArea() {
        this.getModel();
        Rectangle rectangle = JunColorChoiceModel._plateArea();
        Rectangle rectangle2 = new Rectangle(12, 12, rectangle.width, rectangle.height);
        return rectangle2;
    }

    public Rectangle renderingArea() {
        int n = this.colorArea().x + this.colorArea().width + 9;
        int n2 = this.colorArea().y + 7;
        Rectangle rectangle = new Rectangle(n, n2, 17, 17);
        return rectangle;
    }

    public double saturation() {
        return this.getModel().saturation();
    }

    public Rectangle saturationArea() {
        int n = this.hueArea().x;
        int n2 = this.hueArea().y + this.hueArea().height + 3;
        Rectangle rectangle = new Rectangle(n, n2, 56, 18);
        return rectangle;
    }

    public String saturationString() {
        double d = this.round();
        int n = String.valueOf(d).length();
        double d2 = this.saturation();
        String string = String.valueOf((double)Math.round(d2 / d) * d);
        string = string.substring(0, Math.min(string.length(), n));
        for (int i = 0; i < n - string.length(); ++i) {
            string = string + "0";
        }
        return string;
    }

    public void setModel(JunColorChoiceModel junColorChoiceModel) {
        this.model_((StModel)junColorChoiceModel);
    }

    public Rectangle spuitArea() {
        int n = this.colorArea().x + this.colorArea().width + 9;
        int n2 = this.colorArea().y + 7;
        Rectangle rectangle = new Rectangle(n, n2, 17, 17);
        return rectangle;
    }

    public void update_(DependentEvent dependentEvent) {
        Graphics graphics;
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunColorChoiceViewSwing.$((String)"xy")) {
            graphics = this.getGraphics();
            this.displayPlateOn_(graphics);
            this.displayXYOn_(graphics);
            this.displayBarOn_(graphics);
            this.displayColorOn_(graphics);
            this.displayHueOn_(graphics);
            this.displaySaturationOn_(graphics);
            this.displayBrightnessOn_(graphics);
            graphics.dispose();
        }
        if (dependentEvent.getAspect() == JunColorChoiceViewSwing.$((String)"z")) {
            graphics = this.getGraphics();
            this.displayPlateOn_(graphics);
            this.displayXYOn_(graphics);
            this.displayBarOn_(graphics);
            this.displayZOn_(graphics);
            this.displayColorOn_(graphics);
            this.displayHueOn_(graphics);
            this.displaySaturationOn_(graphics);
            this.displayBrightnessOn_(graphics);
            graphics.dispose();
        }
        if (dependentEvent.getAspect() == JunColorChoiceViewSwing.$((String)"color")) {
            graphics = this.getGraphics();
            this.displayOn_(graphics);
            graphics.dispose();
        }
    }

    protected void buildComponent() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(230, 125));
    }

    protected StController defaultController() {
        return new JunColorChoiceController();
    }

    protected StModel defaultModel() {
        return new JunColorChoiceHSB();
    }

    protected void displayBarOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.barArea();
        this.getModel().bar().displayOn_at_(graphics2, rectangle.getLocation());
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayBrightnessOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.brightnessArea();
        String string = "B:".concat(this.brightnessString());
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        Point point = new Point((rectangle.width - n) / 2 + rectangle.x, rectangle.height - n2 / 2 + rectangle.y);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        graphics2.setColor(StColorValue.VeryLightGray);
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        graphics2.drawString(string, point.x, point.y);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayColorOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.colorArea();
        graphics2.setColor(this.getModel().color());
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayHueOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.hueArea();
        String string = "H:".concat(this.hueString());
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        Point point = new Point((rectangle.width - n) / 2 + rectangle.x, rectangle.height - n2 / 2 + rectangle.y);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        graphics2.setColor(StColorValue.VeryLightGray);
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        graphics2.drawString(string, point.x, point.y);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayPlateOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.plateArea();
        this.getModel().plate().displayOn_at_(graphics2, rectangle.getLocation());
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displaySaturationOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.saturationArea();
        String string = "S:".concat(this.saturationString());
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        Point point = new Point((rectangle.width - n) / 2 + rectangle.x, rectangle.height - n2 / 2 + rectangle.y);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        graphics2.setColor(StColorValue.VeryLightGray);
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        graphics2.drawString(string, point.x, point.y);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displaySpuitOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.spuitArea();
        graphics2.drawImage(JunCursors.SpuitCursorImage(), rectangle.x + 1, rectangle.y + 1, (ImageObserver)((Object)this));
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void displayXYOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.plateArea();
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = (int)(this.getModel().xy().x() * (double)(rectangle.width - 1) + (double)rectangle.x);
        int n2 = (int)(this.getModel().xy().y() * (double)(rectangle.height - 1) + (double)rectangle.y);
        Color color = Color.white;
        Color color2 = Color.black;
        graphics2.setColor(color);
        for (int i = 0; i < 360; i += 30) {
            graphics2.drawArc(n - 4, n2 - 4, 8, 8, i, 30);
            if (color2.equals(graphics2.getColor())) {
                graphics2.setColor(color);
                continue;
            }
            graphics2.setColor(color2);
        }
    }

    protected void displayZOn_(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.barArea();
        Rectangle rectangle2 = new Rectangle(rectangle.x - 4, rectangle.y - 3, 4, rectangle.height + 7);
        Rectangle rectangle3 = new Rectangle(rectangle.x + rectangle.width + 1, rectangle.y - 3, 4, rectangle.height + 7);
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics2.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        Point[] pointArray = new Point[]{new Point(0, 0), new Point(3, -3), new Point(3, 3), new Point(0, 0)};
        int n = (int)(this.getModel().z() * (double)(rectangle.height - 1));
        Point point = new Point(rectangle.x + rectangle.width + 1, n + rectangle.y);
        Point point2 = new Point(rectangle.x - 1, n + rectangle.y);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray3[i] = point.x + pointArray[i].x;
            nArray4[i] = point.y + pointArray[i].y;
            nArray[i] = point2.x - pointArray[i].x;
            nArray2[i] = point2.y + pointArray[i].y;
        }
        graphics2.setColor(Color.black);
        graphics2.drawPolyline(nArray3, nArray4, 4);
        graphics2.drawPolyline(nArray, nArray2, 4);
    }

    protected double round() {
        return 0.01;
    }
}

