/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.colors.JunColorChoiceView;
import jp.co.sra.jun.goodies.colors.JunColorSpuit;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.dialog.JunTextInputField;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StView;

public class JunColorChoiceController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    protected JunColorChoiceModel getColorChoiceModel() {
        return (JunColorChoiceModel)this.model();
    }

    protected JunColorChoiceView getColorChoiceView() {
        return (JunColorChoiceView)this.view();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
            super.mouseClicked(mouseEvent);
            return;
        }
        Point point = mouseEvent.getPoint();
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        if (junColorChoiceView.spuitArea().contains(point)) {
            Color color = JunColorSpuit.Request();
            if (!mouseEvent.isShiftDown()) {
                this.getColorChoiceModel().color_(color);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        if (junColorChoiceView.plateArea().contains(point) || junColorChoiceView.barArea().contains(point)) {
            this.mousePressed(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        if (junColorChoiceView.plateArea().contains(point) || junColorChoiceView.barArea().contains(point) || junColorChoiceView.hueArea().contains(point) || junColorChoiceView.saturationArea().contains(point) || junColorChoiceView.brightnessArea().contains(point) || junColorChoiceView.colorArea().contains(point)) {
            junColorChoiceView.toComponent().setCursor(JunCursors.CrossCursor());
        } else {
            junColorChoiceView.toComponent().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            return;
        }
        Point point = mouseEvent.getPoint();
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        if (junColorChoiceView.plateArea().contains(point)) {
            double d = (double)(point.x - junColorChoiceView.plateArea().getLocation().x) / ((double)junColorChoiceView.plateArea().width - 1.0);
            double d2 = (double)(point.y - junColorChoiceView.plateArea().getLocation().y) / ((double)junColorChoiceView.plateArea().height - 1.0);
            Jun2dPoint jun2dPoint = new Jun2dPoint(d, d2);
            this.getColorChoiceModel().xy_(jun2dPoint);
        } else if (junColorChoiceView.barArea().contains(point)) {
            double d = (double)(point.y - junColorChoiceView.barArea().getLocation().y) / ((double)junColorChoiceView.barArea().height - 1.0);
            this.getColorChoiceModel().z_(d);
        } else if (junColorChoiceView.hueArea().contains(point)) {
            this.inputHueActivity(mouseEvent);
        } else if (junColorChoiceView.saturationArea().contains(point)) {
            this.inputSaturationActivity(mouseEvent);
        } else if (junColorChoiceView.brightnessArea().contains(point)) {
            this.inputBrightnessActivity(mouseEvent);
        } else if (junColorChoiceView.colorArea().contains(point)) {
            System.out.println(junColorChoiceView.colorString());
        }
    }

    protected void inputHueActivity(MouseEvent mouseEvent) {
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        String string = null;
        string = mouseEvent.isShiftDown() || mouseEvent.isAltDown() ? JunDialog.Request_(JunColorChoiceController.$String((String)"hue?"), junColorChoiceView.hueString()) : JunTextInputField.PopUpIn_forView_initialAnswer_(junColorChoiceView.hueArea(), junColorChoiceView.toComponent(), junColorChoiceView.hueString());
        if (string != null && string.length() > 0) {
            try {
                double d = Double.parseDouble(string);
                if (0.0 <= d && d <= 1.0) {
                    this.getColorChoiceModel().hue_(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void inputSaturationActivity(MouseEvent mouseEvent) {
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        String string = null;
        string = mouseEvent.isShiftDown() || mouseEvent.isAltDown() ? JunDialog.Request_(JunColorChoiceController.$String((String)"saturation?"), junColorChoiceView.saturationString()) : JunTextInputField.PopUpIn_forView_initialAnswer_(junColorChoiceView.saturationArea(), junColorChoiceView.toComponent(), junColorChoiceView.saturationString());
        if (string != null && string.length() > 0) {
            try {
                double d = Double.parseDouble(string);
                if (0.0 <= d && d <= 1.0) {
                    this.getColorChoiceModel().saturation_(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void inputBrightnessActivity(MouseEvent mouseEvent) {
        JunColorChoiceView junColorChoiceView = this.getColorChoiceView();
        String string = null;
        string = mouseEvent.isShiftDown() || mouseEvent.isAltDown() ? JunDialog.Request_(JunColorChoiceController.$String((String)"brightness?"), junColorChoiceView.brightnessString()) : JunTextInputField.PopUpIn_forView_initialAnswer_(junColorChoiceView.brightnessArea(), junColorChoiceView.toComponent(), junColorChoiceView.brightnessString());
        if (string != null && string.length() > 0) {
            try {
                double d = Double.parseDouble(string);
                if (0.0 <= d && d <= 1.0) {
                    this.getColorChoiceModel().brightness_(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

