/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import jp.co.sra.jun.goodies.colors.JunColorBarController;
import jp.co.sra.jun.goodies.colors.JunColorBarModel;
import jp.co.sra.jun.goodies.colors.JunColorBarView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewJPanel;

public class JunColorBarViewSwing
extends JunAbstractViewJPanel
implements JunColorBarView {
    protected StRectangle firstMarkerRectangle;
    protected StRectangle lastMarkerRectangle;
    protected StRectangle sliderRectangle;
    protected StRectangle savedSliderRectangle;

    public static StView OnBorderedPanel_(JunColorBarModel junColorBarModel) {
        return new StViewJPanel((StModel)junColorBarModel){

            protected void buildComponent() {
                JunColorBarViewSwing junColorBarViewSwing = new JunColorBarViewSwing((JunColorBarModel)this.model());
                this.setLayout(new BorderLayout());
                this.add(junColorBarViewSwing._onBorderedPanel(), "Center");
            }
        };
    }

    public JunColorBarViewSwing(JunColorBarModel junColorBarModel) {
        super(junColorBarModel);
    }

    protected void initialize() {
        this.flushMarkerRectangles();
        this.flushSliderRectangles();
    }

    protected void flushMarkerRectangles() {
        this.firstMarkerRectangle = null;
        this.lastMarkerRectangle = null;
    }

    protected void flushSliderRectangles() {
        this.sliderRectangle = null;
        this.savedSliderRectangle = null;
    }

    protected void buildComponent() {
        this.setPreferredSize(new Dimension(250, 40));
    }

    public JunColorBarModel getColorBarModel() {
        return (JunColorBarModel)this.model();
    }

    protected StController defaultController() {
        return new JunColorBarController();
    }

    public StRectangle firstMarkerRectangle() {
        if (this.firstMarkerRectangle == null) {
            StRectangle stRectangle;
            StRectangle stRectangle2 = this.rangeArea().insetBy_(new StRectangle(0, 0, 1, 1));
            int n = stRectangle2.originX() + Math.round((float)stRectangle2.width() * (float)this.getColorBarModel().interval()[0]);
            this.firstMarkerRectangle = stRectangle = this.markerRectangle().align_with_(this.markerRectangle().bottomRight(), new Point(n, stRectangle2.top()));
        }
        return this.firstMarkerRectangle;
    }

    public StRectangle lastMarkerRectangle() {
        if (this.lastMarkerRectangle == null) {
            StRectangle stRectangle;
            StRectangle stRectangle2 = this.rangeArea().insetBy_(new StRectangle(0, 0, 1, 1));
            int n = stRectangle2.originX() + Math.round((float)stRectangle2.width() * (float)this.getColorBarModel().interval()[1]);
            this.lastMarkerRectangle = stRectangle = this.markerRectangle().align_with_(this.markerRectangle().bottomLeft(), new Point(n, stRectangle2.top()));
        }
        return this.lastMarkerRectangle;
    }

    public StRectangle sliderRectangle() {
        if (this.sliderRectangle == null) {
            this.sliderRectangle = this.sliderRectangleForValue_(this.getColorBarModel()._doubleValue());
        }
        return this.sliderRectangle;
    }

    public StRectangle anotherIntervalRectangle() {
        return StRectangle.Origin_corner_((Point)this.firstMarkerRectangle().topRight(), (Point)this.lastMarkerRectangle().bottomLeft());
    }

    protected StRectangle margin() {
        return new StRectangle(8, 8, 8, 8);
    }

    protected StRectangle markerRectangle() {
        return new StRectangle(0, 0, 4, 8);
    }

    public StRectangle barArea() {
        return new StRectangle(this.getSize());
    }

    protected StRectangle sliderRectangleForValue_(double d) {
        StRectangle stRectangle = this.margin();
        StRectangle stRectangle2 = this.rangeArea().insetBy_(new StRectangle(0, 0, 1, 1));
        int n = stRectangle2.originX() + Math.round((float)stRectangle2.width() * (float)d);
        StRectangle stRectangle3 = StRectangle.Origin_extent_((Point)new Point(n, stRectangle2.bottom()), (Point)new Point(0, stRectangle.bottom()));
        stRectangle3 = stRectangle3.expandedBy_(new StRectangle(stRectangle.left() - 2, 0, stRectangle.right() - 2, 1));
        return stRectangle3;
    }

    public StRectangle rangeArea() {
        return this.barArea().insetBy_(this.margin());
    }

    public StRectangle spectrumArea() {
        int n = this.firstMarkerRectangle().right();
        int n2 = this.lastMarkerRectangle().left() + 1;
        StRectangle stRectangle = this.rangeArea();
        return new StRectangle(n, stRectangle.top() + 1, n2, stRectangle.bottom() - 1);
    }

    public StRectangle ultraFirstArea() {
        int n = this.firstMarkerRectangle().right() + 1;
        StRectangle stRectangle = this.rangeArea();
        return new StRectangle(stRectangle.left(), stRectangle.top(), n, stRectangle.bottom());
    }

    public StRectangle ultraLastArea() {
        int n = this.lastMarkerRectangle().left();
        StRectangle stRectangle = this.rangeArea();
        return new StRectangle(n, stRectangle.top(), stRectangle.right(), stRectangle.bottom());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.flushMarkerRectangles();
        this.flushSliderRectangles();
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayBackgroundOn_(graphics);
        this.displayUltraFirstOn_(graphics);
        this.displayUltraLastOn_(graphics);
        this.displayIntervalOn_(graphics);
        this.displaySpectrumOn_(graphics);
        this.displaySliderOn_withColor_(graphics, Gray20);
    }

    protected void displayBackgroundOn_(Graphics graphics) {
        StRectangle stRectangle = this.barArea();
        graphics.setColor(Gray70);
        graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        graphics.setColor(Gray80);
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right() - 1, stRectangle.top());
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.left(), stRectangle.bottom() - 1);
        graphics.setColor(Gray20);
        graphics.drawLine(stRectangle.left(), stRectangle.bottom() - 1, stRectangle.right() - 1, stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.right() - 1, stRectangle.top(), stRectangle.right() - 1, stRectangle.bottom() - 1);
        stRectangle = this.rangeArea();
        graphics.setColor(Gray80);
        graphics.drawLine(stRectangle.left() + 1, stRectangle.top() + 1, stRectangle.left() + 1, stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.left() + 1, stRectangle.top() + 1, stRectangle.right(), stRectangle.top() + 1);
        graphics.drawLine(stRectangle.left(), stRectangle.bottom(), stRectangle.right(), stRectangle.bottom());
        graphics.drawLine(stRectangle.right(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        graphics.setColor(Gray20);
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.left(), stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right() - 1, stRectangle.top());
        graphics.drawLine(stRectangle.left(), stRectangle.bottom() - 1, stRectangle.right() - 1, stRectangle.bottom() - 1);
        graphics.drawLine(stRectangle.right() - 1, stRectangle.top(), stRectangle.right() - 1, stRectangle.bottom() - 1);
    }

    protected void displayUltraFirstOn_(Graphics graphics) {
        StRectangle stRectangle = this.ultraFirstArea().insetBy_(1);
        graphics.setColor(this.getColorBarModel().ultraFirstColor());
        graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
    }

    protected void displayUltraLastOn_(Graphics graphics) {
        StRectangle stRectangle = this.ultraLastArea().insetBy_(1);
        graphics.setColor(this.getColorBarModel().ultraLastColor());
        graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
    }

    protected void displayIntervalOn_(Graphics graphics) {
        StRectangle stRectangle = this.firstMarkerRectangle();
        graphics.setColor(Color.blue);
        graphics.drawLine(stRectangle.right(), stRectangle.bottom(), stRectangle.right(), stRectangle.top());
        graphics.drawLine(stRectangle.right(), stRectangle.top(), stRectangle.left(), stRectangle.top());
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        stRectangle = this.lastMarkerRectangle();
        graphics.setColor(Color.red);
        graphics.drawLine(stRectangle.left(), stRectangle.bottom(), stRectangle.left(), stRectangle.top());
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.top());
        graphics.drawLine(stRectangle.right(), stRectangle.top(), stRectangle.left(), stRectangle.bottom());
    }

    protected void displaySpectrumOn_(Graphics graphics) {
        StRectangle stRectangle = this.rangeArea().insetBy_(new StRectangle(1, 0, 1, 0));
        StRectangle stRectangle2 = this.spectrumArea();
        int n = stRectangle2.width() - 1;
        for (int i = 0; i <= n; ++i) {
            Point point = new Point(i + stRectangle2.left(), stRectangle2.top());
            Point point2 = new Point(i + stRectangle2.left() + 1, stRectangle2.bottom());
            StRectangle stRectangle3 = StRectangle.Origin_corner_((Point)point, (Point)point2);
            stRectangle3 = stRectangle3.intersect_(stRectangle);
            double d = n == 0 ? 0.0 : (double)i / (double)n;
            graphics.setColor(this.getColorBarModel().getColor_(d));
            graphics.fillRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
        }
    }

    public void displaySliderOn_withColor_(Graphics graphics, Color color) {
        StRectangle stRectangle = this.sliderRectangle();
        graphics.setColor(color);
        graphics.fillPolygon(new int[]{stRectangle.left(), stRectangle.right(), stRectangle.topCenter().x}, new int[]{stRectangle.bottom(), stRectangle.bottom(), stRectangle.top() - 1}, 3);
        this.savedSliderRectangle = stRectangle;
    }

    public boolean isVertical() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunColorBarViewSwing.$((String)"value")) {
            this.sliderRectangle = null;
            StRectangle stRectangle = this.sliderRectangle();
            if (!stRectangle.equals((Object)this.savedSliderRectangle)) {
                Graphics graphics;
                if (this.savedSliderRectangle != null) {
                    stRectangle = stRectangle.merge_(this.savedSliderRectangle);
                }
                if ((graphics = this.getGraphics()) != null) {
                    try {
                        graphics.clipRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
                        this.displayOn_(graphics);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
        } else if (stSymbol == JunColorBarViewSwing.$((String)"interval")) {
            this.flushMarkerRectangles();
            this.repaint();
        } else if (stSymbol == JunColorBarViewSwing.$((String)"color")) {
            this.repaint();
        } else {
            super.update_(dependentEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSliderAt(Point point) {
        this.getColorBarModel().value_(this.valueAtPoint(point));
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.displaySliderOn_withColor_(graphics, JunColorBarView.Gray40);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public void setFirstMarkerAt(Point point) {
        this.getColorBarModel().firstMarker_(this.valueAtPoint(point));
    }

    public void setLastMarkerAt(Point point) {
        this.getColorBarModel().lastMarker_(this.valueAtPoint(point));
    }

    public void setIntervalAt(Point point) {
        double d = this.valueAtPoint(point);
        double d2 = this.getColorBarModel().lastMarker() - this.getColorBarModel().firstMarker();
        double d3 = d - d2 / 2.0;
        double d4 = d3 + d2;
        if (d3 < 0.0) {
            d3 = 0.0;
            d4 = d2;
        }
        if (d4 > 1.0) {
            d3 = 1.0 - d2;
            d4 = 1.0;
        }
        this.getColorBarModel().interval_(new double[]{d3, d4});
    }

    protected double valueAtPoint(Point point) {
        StRectangle stRectangle = this.rangeArea().insetBy_(new StRectangle(0, 0, 1, 1));
        double d = (double)(point.x - stRectangle.originX()) / (double)stRectangle.width();
        return Math.max(0.0, Math.min(d, 1.0));
    }
}

