/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.catalog;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StValueHolder;

public class JunVisualCatalog
extends StObject {
    public static final String DefaultIndexHtmlFileName = "index.html";
    public static final int DIVE_MAX_LEVEL = 8;
    public static final int THUMBNAIL_IMAGE_MIN_SIZE = 32;
    public static final int THUMBNAIL_IMAGE_MAX_SIZE = 256;
    protected File originalVisualDirectory;
    protected File[] originalVisualFiles;
    protected File visualCatalogDirectory;
    protected double keyFramePosition;
    protected Dimension thumbnailImageSize;
    protected int numberOfColumns;
    protected boolean withFileName;
    protected StValueHolder progressValue;
    protected StValueHolder progressMessage;

    public JunVisualCatalog() {
        this.initialize();
    }

    public JunVisualCatalog(File file) {
        this();
        this.originalVisualDirectory_(file);
    }

    public JunVisualCatalog(File file, File file2) {
        this();
        this.originalVisualDirectory_(file);
        this.visualCatalogDirectory_(file2);
    }

    public static JunVisualCatalog Dive_(File file) {
        return JunVisualCatalog._Dive_catalog_(file, new JunVisualCatalog());
    }

    public static JunVisualCatalog Dive_block_(File file, StBlockClosure stBlockClosure) {
        return JunVisualCatalog._Dive_block_catalog_(file, stBlockClosure, new JunVisualCatalog());
    }

    public static String[] Separate_dividers_(String string, char[] cArray) {
        return JunStringUtility.Separate_dividers_(string, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JunVisualCatalog _Dive_block_catalog_(File file, StBlockClosure stBlockClosure, JunVisualCatalog junVisualCatalog) {
        Object object;
        Object object2;
        AbstractCollection abstractCollection = new Vector();
        JunVisualCatalog.Dive_into_(file, abstractCollection);
        abstractCollection = new TreeSet(abstractCollection);
        Vector<String> vector = new Vector<String>(abstractCollection.size());
        String string = file.getPath();
        if (string.charAt(string.length() - 1) == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = new File(junVisualCatalog.defaultDirectory(), junVisualCatalog.defaultVisualCatalogDirectoryName()).getPath();
        String[] stringArray = new String[abstractCollection.size()];
        abstractCollection.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = file.getParent();
            string3 = stringArray[i].substring(string3.length() + 1, stringArray[i].length());
            object2 = new File(string2, string3);
            string3 = ((File)object2).getPath();
            vector.add(string3);
        }
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (String)vector.get(i);
            object = (JunVisualCatalog)((Object)StObject._New(((Object)((Object)junVisualCatalog)).getClass(), (Object)new File(stringArray[i]), (Object)new File((String)object2)));
            stBlockClosure.value_(object);
            if (!((JunVisualCatalog)((Object)object)).isEmpty()) continue;
            vector2.add(object2);
        }
        vector.removeAll(vector2);
        BufferedWriter bufferedWriter = null;
        object2 = new JunCursors(JunCursors.WriteCursor());
        try {
            ((JunCursors)((Object)object2))._show();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(junVisualCatalog.indexHtmlFile()), "MS932"));
            bufferedWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<HTML>");
            bufferedWriter.newLine();
            bufferedWriter.write("<HEAD>");
            bufferedWriter.newLine();
            bufferedWriter.write("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=Shift_JIS\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<LINK REV=\"MADE\" HREF=\"mailto:jun@ktlsva.sra.co.jp\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<LINK REL=\"INDEX\" HREF=\"./index.html\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<TITLE>" + junVisualCatalog.defaultTitleString() + "s" + "</TITLE>");
            bufferedWriter.newLine();
            bufferedWriter.write("</HEAD>");
            bufferedWriter.newLine();
            bufferedWriter.write("<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#0000FF\" VLINK=\"#663399\" ALINK=\"#FF0000\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<H2>" + junVisualCatalog.defaultTitleString() + "s" + "</H2>");
            bufferedWriter.newLine();
            bufferedWriter.write("<OL>");
            bufferedWriter.newLine();
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string4 = (String)object.nextElement();
                String string5 = string4.substring(string2.length(), string4.length());
                string5 = string5.replace(File.separatorChar, '/');
                string5 = "." + string5;
                bufferedWriter.write("<LI><A HREF=\"");
                if (string5.charAt(string5.length() - 1) == '/') {
                    bufferedWriter.write(string5 + DefaultIndexHtmlFileName);
                } else {
                    bufferedWriter.write(string5 + "/" + DefaultIndexHtmlFileName);
                }
                bufferedWriter.write("\">" + string5 + "</A>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</OL>");
            bufferedWriter.newLine();
            bufferedWriter.write("<HR>");
            bufferedWriter.newLine();
            bufferedWriter.write("This page was created by " + junVisualCatalog._className() + " on " + JunSystem.FullName());
            bufferedWriter.newLine();
            bufferedWriter.write("</BODY>");
            bufferedWriter.newLine();
            bufferedWriter.write("</HTML>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    bufferedWriter = null;
                }
            }
            ((JunCursors)((Object)object2))._restore();
        }
        return junVisualCatalog;
    }

    protected static JunVisualCatalog _Dive_catalog_(File file, JunVisualCatalog junVisualCatalog) {
        return JunVisualCatalog._Dive_block_catalog_(file, new StBlockClosure(){

            public Object value_(Object object) {
                final JunVisualCatalog junVisualCatalog = (JunVisualCatalog)((Object)object);
                final JunProgress junProgress = new JunProgress();
                junVisualCatalog.computeWhenProgressMessageChanged_(new StBlockClosure(){

                    public Object value_(Object object) {
                        junProgress.message_((String)object);
                        return null;
                    }
                });
                junVisualCatalog.computeWhenProgressValueChanged_(new StBlockClosure(){

                    public Object value_(Object object) {
                        junProgress.value_(((Number)object).floatValue());
                        return null;
                    }
                });
                junProgress.do_(new StBlockClosure(){

                    public Object value() {
                        junVisualCatalog.make();
                        return null;
                    }
                });
                return null;
            }
        }, junVisualCatalog);
    }

    protected static Collection Dive_into_(File file, Collection collection) {
        return JunVisualCatalog.Dive_into_(file.getPath(), collection);
    }

    protected static Collection Dive_into_(String string, Collection collection) {
        File file = new File(string);
        int n = JunVisualCatalog.Separate_dividers_(file.getPath(), new char[]{File.separatorChar}).length;
        return JunVisualCatalog.Dive_into_start_(file.getPath(), collection, n);
    }

    protected static Collection Dive_into_start_(String string, Collection collection, int n) {
        File file = new File(string);
        int n2 = JunVisualCatalog.Separate_dividers_(file.getPath(), new char[]{File.separatorChar}).length;
        if (n2 - n > 8) {
            return collection;
        }
        if (collection.contains(file.getPath())) {
            return collection;
        }
        if (file.exists() && file.isDirectory() && file.canRead()) {
            collection.add(file.getPath());
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = null;
                string2 = string.charAt(string.length() - 1) == File.separatorChar ? string + stringArray[i] : string + File.separator + stringArray[i];
                JunVisualCatalog.Dive_into_start_(string2, collection, n);
            }
            return collection;
        }
        return collection;
    }

    protected void initialize() {
        this.originalVisualDirectory = null;
        this.originalVisualFiles = null;
        this.visualCatalogDirectory = null;
        this.keyFramePosition_(this.defaultKeyFramePosition());
        this.thumbnailImageSize_(this.defaultThumbnailImageSize());
        this.numberOfColumns_(this.defaultNumberOfColumns());
        this.withFileName_(false);
        this.progressValue = new StValueHolder(0.0);
        this.progressMessage = new StValueHolder((Object)"");
    }

    public double keyFramePosition() {
        return this.keyFramePosition;
    }

    public void keyFramePosition_(double d) {
        this.keyFramePosition = d;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    public void numberOfColumns_(int n) {
        this.numberOfColumns = n;
    }

    public int numberOfVisuals() {
        return this.originalVisualFiles().length;
    }

    public File originalVisualDirectory() {
        return this.originalVisualDirectory;
    }

    public void originalVisualDirectory_(File file) {
        this.originalVisualDirectory = file;
        this.originalVisualFiles = null;
    }

    public Dimension thumbnailImageSize() {
        return this.thumbnailImageSize;
    }

    public void thumbnailImageSize_(int n) {
        this.thumbnailImageSize_(new Dimension(n, n));
    }

    public void thumbnailImageSize_(Dimension dimension) {
        int n = Math.max(32, Math.min(dimension.width, 256));
        int n2 = Math.max(32, Math.min(dimension.height, 256));
        this.thumbnailImageSize = new Dimension(n, n2);
    }

    public File visualCatalogDirectory() {
        if (this.visualCatalogDirectory == null) {
            File file = new File(this.defaultDirectory(), this.defaultVisualCatalogDirectoryName());
            this.visualCatalogDirectory_(file);
        }
        return this.visualCatalogDirectory;
    }

    public void visualCatalogDirectory_(File file) {
        this.visualCatalogDirectory = file;
        if (this.visualCatalogDirectory.exists()) {
            if (!this.visualCatalogDirectory.isDirectory()) {
                new SmalltalkException("Can't access directory: " + this.visualCatalogDirectory.toString());
                this.visualCatalogDirectory = null;
                return;
            }
        } else {
            this.visualCatalogDirectory.mkdirs();
        }
        if (!this.isEmpty()) {
            File file2;
            File file3 = this.visualClipDirectory();
            if (!file3.exists()) {
                file3.mkdir();
            }
            if (!(file2 = this.thumbnailImageDirectory()).exists()) {
                file2.mkdir();
            }
        }
    }

    public boolean withFileName() {
        return this.withFileName;
    }

    public void withFileName_(boolean bl) {
        this.withFileName = bl;
    }

    public int defaultContractLength() {
        return 32;
    }

    public String defaultDirectoryName() {
        return System.getProperty("user.dir");
    }

    public double defaultKeyFramePosition() {
        return 0.5;
    }

    public int defaultNumberOfColumns() {
        return 5;
    }

    public String defaultThumbnailImageDirectoryName() {
        return "thumbnails";
    }

    public Dimension defaultThumbnailImageSize() {
        return new Dimension(72, 72);
    }

    public String defaultTitleString() {
        return "Visual Catalog";
    }

    public String defaultVisualCatalogDirectoryName() {
        return "VisualCatalog";
    }

    public String defaultVisualClipDirectoryName() {
        return "visuals";
    }

    public File defaultDirectory() {
        return new File(this.defaultDirectoryName());
    }

    public File thumbnailImageDirectory() {
        return new File(this.visualCatalogDirectory(), this.defaultThumbnailImageDirectoryName());
    }

    public File visualClipDirectory() {
        return new File(this.visualCatalogDirectory(), this.defaultVisualClipDirectoryName());
    }

    public void computeWhenProgressMessageChanged_(StBlockClosure stBlockClosure) {
        this.progressMessage.compute_(stBlockClosure);
    }

    public void computeWhenProgressValueChanged_(StBlockClosure stBlockClosure) {
        this.progressValue.compute_(stBlockClosure);
    }

    public File indexHtmlFile() {
        return new File(this.visualCatalogDirectory(), DefaultIndexHtmlFileName);
    }

    public File[] originalVisualFiles() {
        if (this.originalVisualDirectory() == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.originalVisualDirectory().list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            int n = string2.lastIndexOf(46);
            if (n < 0 || !this.incluesExtensions_(string = string2.substring(n + 1).toLowerCase())) continue;
            File file = new File(this.originalVisualDirectory(), string2);
            arrayList.add(file);
        }
        this.originalVisualFiles = arrayList.toArray(new File[arrayList.size()]);
        return this.originalVisualFiles;
    }

    public File[] thumbnailImageFiles() {
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            File file2 = fileArray[i];
            String string = file2.getName();
            int n = string.lastIndexOf(46);
            String string2 = n < 0 ? string : string.substring(0, n);
            String string3 = n < 0 ? "" : string.substring(n + 1);
            string = string2 + '_' + string3 + '.' + JunSystem.DefaultImageExtension();
            fileArray2[i] = file = new File(this.thumbnailImageDirectory(), string);
        }
        return fileArray2;
    }

    public File[] visualClipFiles() {
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            File file2 = fileArray[i];
            String string = file2.getName();
            fileArray2[i] = file = new File(this.visualClipDirectory(), string);
        }
        return fileArray2;
    }

    public void make() {
        this.makeVisualClipFiles();
        this.makeThumbnailImageFiles();
        this.makeIndexHtmlFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeIndexHtmlFile() {
        final File[] fileArray = this.visualClipFiles();
        final File[] fileArray2 = this.thumbnailImageFiles();
        BufferedWriter bufferedWriter = null;
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            final BufferedWriter bufferedWriter2 = bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexHtmlFile()), "MS932"));
            final JunVisualCatalog junVisualCatalog = this;
            bufferedWriter2.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
            bufferedWriter2.newLine();
            this.on_tag_do_(bufferedWriter2, "HTML", new StBlockClosure(){

                public Object value() {
                    try {
                        bufferedWriter2.newLine();
                        JunVisualCatalog.this.on_tag_do_(bufferedWriter2, "HEAD", new StBlockClosure(){

                            public Object value() {
                                try {
                                    bufferedWriter2.newLine();
                                    bufferedWriter2.write("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=Shift_JIS\">");
                                    bufferedWriter2.newLine();
                                    bufferedWriter2.write("<LINK REV=\"MADE\" HREF=\"mailto:jun@ktlsva.sra.co.jp\">");
                                    bufferedWriter2.newLine();
                                    bufferedWriter2.write("<LINK REL=\"INDEX\" HREF=\"./index.html\">");
                                    bufferedWriter2.newLine();
                                    bufferedWriter2.write("<TITLE>" + junVisualCatalog.defaultTitleString() + "</TITLE>");
                                    bufferedWriter2.newLine();
                                    return null;
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                            }
                        });
                        bufferedWriter2.newLine();
                        JunVisualCatalog.this.on_tag_attributes_do_(bufferedWriter2, "BODY", "BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#0000FF\" VLINK=\"#663399\" ALINK=\"#FF0000\"", new StBlockClosure(){

                            public Object value() {
                                try {
                                    bufferedWriter2.newLine();
                                    JunVisualCatalog.this.on_tag_do_(bufferedWriter2, "H2", new StBlockClosure(){

                                        public Object value() {
                                            try {
                                                bufferedWriter2.write(junVisualCatalog.defaultTitleString());
                                            }
                                            catch (IOException iOException) {
                                                throw new RuntimeException(iOException);
                                            }
                                            return null;
                                        }
                                    });
                                    bufferedWriter2.newLine();
                                    if (!junVisualCatalog.isEmpty()) {
                                        JunVisualCatalog.this.on_tag_attributes_do_(bufferedWriter2, "TABLE", "BORDER=\"0\" CELLPADDING=\"5\"", new StBlockClosure(){

                                            public Object value() {
                                                try {
                                                    bufferedWriter2.newLine();
                                                    JunVisualCatalog.this.on_tag_do_(bufferedWriter2, "TR", new StBlockClosure(){

                                                        public Object value() {
                                                            try {
                                                                bufferedWriter2.newLine();
                                                                junVisualCatalog.urlsDo_(new StBlockClosure(){

                                                                    public Object valueWithArguments_(Object[] objectArray) {
                                                                        final String string = (String)objectArray[0];
                                                                        final String string2 = (String)objectArray[1];
                                                                        final Dimension dimension = (Dimension)objectArray[2];
                                                                        final int n = ((Number)objectArray[3]).intValue();
                                                                        try {
                                                                            JunVisualCatalog.this.on_tag_attributes_do_(bufferedWriter2, "TD", "ALIGN=\"CENTER\" VALIGN=\"MIDDLE\"", new StBlockClosure(){

                                                                                public Object value() {
                                                                                    try {
                                                                                        bufferedWriter2.newLine();
                                                                                        JunVisualCatalog.this.on_tag_attributes_do_(bufferedWriter2, "A", "HREF=\"" + string + "\"", new StBlockClosure(){

                                                                                            public Object value() {
                                                                                                try {
                                                                                                    bufferedWriter2.write("<IMG SRC=\"");
                                                                                                    bufferedWriter2.write(string2);
                                                                                                    bufferedWriter2.write("\" WIDTH=\"");
                                                                                                    bufferedWriter2.write(Integer.toString((this).dimension.width));
                                                                                                    bufferedWriter2.write("\" HEIGHT=\"");
                                                                                                    bufferedWriter2.write(Integer.toString((this).dimension.height));
                                                                                                    bufferedWriter2.write("\" BORDER=\"1\" ALT=\"");
                                                                                                    bufferedWriter2.write(fileArray2[n].getName());
                                                                                                    bufferedWriter2.write("\">");
                                                                                                    if (junVisualCatalog.withFileName()) {
                                                                                                        bufferedWriter2.write("<BR>");
                                                                                                        bufferedWriter2.write(fileArray[n].getName());
                                                                                                    }
                                                                                                }
                                                                                                catch (IOException iOException) {
                                                                                                    throw new RuntimeException(iOException);
                                                                                                }
                                                                                                return null;
                                                                                            }
                                                                                        });
                                                                                        bufferedWriter2.newLine();
                                                                                    }
                                                                                    catch (IOException iOException) {
                                                                                        throw new RuntimeException(iOException);
                                                                                    }
                                                                                    return null;
                                                                                }
                                                                            });
                                                                            bufferedWriter2.newLine();
                                                                            if ((n + 1) % junVisualCatalog.numberOfColumns() == 0 && n < junVisualCatalog.numberOfVisuals()) {
                                                                                bufferedWriter2.write("</TR>");
                                                                                bufferedWriter2.newLine();
                                                                                bufferedWriter2.write("<TR>");
                                                                                bufferedWriter2.newLine();
                                                                            }
                                                                        }
                                                                        catch (IOException iOException) {
                                                                            throw new RuntimeException(iOException);
                                                                        }
                                                                        return null;
                                                                    }
                                                                });
                                                                return null;
                                                            }
                                                            catch (IOException iOException) {
                                                                throw new RuntimeException(iOException);
                                                            }
                                                        }
                                                    });
                                                    bufferedWriter2.newLine();
                                                    return null;
                                                }
                                                catch (IOException iOException) {
                                                    throw new RuntimeException(iOException);
                                                }
                                            }
                                        });
                                        bufferedWriter2.newLine();
                                        bufferedWriter2.write("<HR>");
                                        bufferedWriter2.newLine();
                                        bufferedWriter2.write("This page was created by ");
                                        bufferedWriter2.write(junVisualCatalog._className().toString());
                                        bufferedWriter2.write(" on ");
                                        bufferedWriter2.write(JunSystem.FullName());
                                        bufferedWriter2.newLine();
                                    }
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                                return null;
                            }
                        });
                        bufferedWriter2.newLine();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    return null;
                }
            });
            bufferedWriter2.newLine();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    bufferedWriter = null;
                }
            }
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeThumbnailImageFiles() {
        this.progressValue.value_(0.0f);
        int n = 1;
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = this.thumbnailImageFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = JunVisualCatalog.$String((String)"Thumbnail:") + " " + fileArray2[i].getName();
            this.progressMessage.value_((Object)JunStringUtility._ContractString_to_(string, this.defaultContractLength()));
            StImage stImage = null;
            JunMoviePlayer junMoviePlayer = null;
            try {
                junMoviePlayer = new JunMoviePlayer(fileArray[i]);
                junMoviePlayer.goto_(this.keyFramePosition());
                stImage = junMoviePlayer.asImage();
            }
            finally {
                if (junMoviePlayer != null) {
                    junMoviePlayer.release();
                    junMoviePlayer = null;
                }
            }
            JunImageAdjuster junImageAdjuster = new JunImageAdjuster();
            Dimension dimension = this.proportionalExtentOfImage_within_(stImage, this.thumbnailImageSize());
            stImage = junImageAdjuster.adjust_extent_(stImage, dimension);
            JunImageStream junImageStream = null;
            try {
                junImageStream = JunJpegImageStream.On_(new BufferedOutputStream(new FileOutputStream(fileArray2[i])));
                junImageStream.nextPutImage_(stImage);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            finally {
                if (junImageStream != null) {
                    try {
                        junImageStream.flush();
                        junImageStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        junImageStream = null;
                    }
                }
            }
            this.progressValue.value_((float)n / (float)this.numberOfVisuals());
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeVisualClipFiles() {
        this.progressValue.value_(0.0f);
        int n = 1;
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = this.visualClipFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = JunVisualCatalog.$String((String)"Visual:") + " " + fileArray2[i].getName();
            this.progressMessage.value_((Object)JunStringUtility._ContractString_to_(string, this.defaultContractLength()));
            if (!fileArray[i].equals(fileArray2[i])) {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    int n2;
                    inputStream = new BufferedInputStream(new FileInputStream(fileArray[i]));
                    outputStream = new BufferedOutputStream(new FileOutputStream(fileArray2[i]));
                    byte[] byArray = new byte[1024];
                    while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        outputStream.write(byArray, 0, n2);
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    iOException.printStackTrace();
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            outputStream = null;
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            inputStream = null;
                        }
                    }
                }
            }
            this.progressValue.value_((float)n / (float)this.numberOfVisuals());
            ++n;
        }
    }

    public boolean isEmpty() {
        return this.numberOfVisuals() == 0;
    }

    public boolean incluesExtensions_(String string) {
        String string2 = string.toLowerCase();
        return Arrays.asList(JunSystem.DefaultImageExtensions()).contains(string2) || Arrays.asList(JunSystem.DefaultMovieExtensions()).contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension[] thumbnailImageExtents() {
        File[] fileArray = this.thumbnailImageFiles();
        Dimension[] dimensionArray = new Dimension[fileArray.length];
        StImage stImage = null;
        JunImageStream junImageStream = null;
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                junCursors._show();
                junImageStream = JunJpegImageStream.On_(new FileInputStream(fileArray[i]));
                stImage = junImageStream.nextImage();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            finally {
                if (junImageStream != null) {
                    try {
                        junImageStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        junImageStream = null;
                    }
                }
            }
            dimensionArray[i] = stImage.bounds().getSize();
        }
        return dimensionArray;
    }

    protected String[] thumbnailImageUrls() {
        File[] fileArray = this.thumbnailImageFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.convertFilenameToUrlString_(fileArray[i]);
        }
        return stringArray;
    }

    public void urlsDo_(StBlockClosure stBlockClosure) throws IOException {
        String[] stringArray = this.visualClipUrls();
        String[] stringArray2 = this.thumbnailImageUrls();
        Dimension[] dimensionArray = this.thumbnailImageExtents();
        for (int i = 0; i < this.numberOfVisuals(); ++i) {
            Object object = stBlockClosure.valueWithArguments_(new Object[]{stringArray[i], stringArray2[i], dimensionArray[i], new Integer(i)});
            if (object == null || !(object instanceof IOException)) continue;
            throw (IOException)object;
        }
    }

    protected String[] visualClipUrls() {
        File[] fileArray = this.visualClipFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.convertFilenameToUrlString_(fileArray[i]);
        }
        return stringArray;
    }

    public void show() {
        File file = this.indexHtmlFile();
        if (!file.exists()) {
            return;
        }
        try {
            JunURL.Browse_(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected String convertFilenameToUrlString_(File file) {
        String string = this.visualCatalogDirectory().toString();
        String string2 = file.toString();
        if ((string2 = string2.substring(string.length() + 1)).charAt(0) == File.separatorChar) {
            string2 = string2.substring(1);
        }
        string2 = string2.replace(File.separatorChar, '/');
        return string2;
    }

    protected void on_tag_attributes_do_(Writer writer, String string, String string2, StBlockClosure stBlockClosure) throws IOException {
        JunStringUtility.On_tag_attributes_do_(writer, string, string2, stBlockClosure);
    }

    protected void on_tag_do_(Writer writer, String string, StBlockClosure stBlockClosure) throws IOException {
        JunStringUtility.On_tag_do_(writer, string, stBlockClosure);
    }

    protected Dimension proportionalExtentOfImage_within_(StImage stImage, Dimension dimension) {
        int n;
        Dimension dimension2 = stImage.bounds().getSize();
        if (dimension2.width > dimension.width) {
            n = Math.round((float)(dimension2.height * dimension.width) / (float)dimension2.width);
            dimension2 = new Dimension(dimension.width, n);
        }
        if (dimension2.height > dimension.height) {
            n = Math.round((float)(dimension2.width * dimension.height) / (float)dimension2.height);
            dimension2 = new Dimension(n, dimension.height);
        }
        return dimension2;
    }
}

