/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.calendar;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateModel;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateView;
import jp.co.sra.jun.system.dialog.JunTextInputField;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunCalendarDateController
extends JunAbstractController
implements MouseListener {
    private MouseEvent mEvent;

    public void mousePressed(MouseEvent mouseEvent) {
        this.mEvent = mouseEvent;
        if (this.mEvent.isMetaDown()) {
            this.view()._showPopupMenu(this.mEvent.getX(), this.mEvent.getY());
        } else {
            this.buttonActivity();
        }
    }

    public void buttonActivity() {
        Point point = new Point(this.mEvent.getX(), this.mEvent.getY());
        for (int i = 0; i < this.getView().frames().size(); ++i) {
            Object[] objectArray = (Object[])this.getView().frames().get(i);
            StSymbol stSymbol = (StSymbol)objectArray[0];
            StRectangle stRectangle = (StRectangle)objectArray[objectArray.length - 1];
            if (!stRectangle.containsPoint_(point)) continue;
            if (stSymbol == JunCalendarDateController.$((String)"year")) {
                this.yearActivity_(objectArray);
            }
            if (stSymbol == JunCalendarDateController.$((String)"month")) {
                this.monthActivity_(objectArray);
            }
            if (stSymbol == JunCalendarDateController.$((String)"weekday")) {
                this.weekdayActivity_(objectArray);
            }
            if (stSymbol == JunCalendarDateController.$((String)"day")) {
                this.dayActivity_(objectArray);
            }
            if (stSymbol != JunCalendarDateController.$((String)"button")) continue;
            this.buttonActivity_(objectArray);
        }
    }

    public void buttonActivity_(Object[] objectArray) {
        StSymbol stSymbol = (StSymbol)objectArray[1];
        if (stSymbol == JunCalendarDateController.$((String)"yearDown")) {
            this.getCalendarDateModel().yearDown();
        }
        if (stSymbol == JunCalendarDateController.$((String)"yearUp")) {
            this.getCalendarDateModel().yearUp();
        }
        if (stSymbol == JunCalendarDateController.$((String)"monthDown")) {
            this.getCalendarDateModel().monthDown();
        }
        if (stSymbol == JunCalendarDateController.$((String)"monthUp")) {
            this.getCalendarDateModel().monthUp();
        }
    }

    public void dayActivity_(Object[] objectArray) {
        Point point = (Point)objectArray[1];
        int n = this.getCalendarDateModel().atPoint_(point);
        this.getCalendarDateModel().day_(n);
    }

    public void monthActivity_(Object[] objectArray) {
        String string;
        if (this.mEvent.isShiftDown() || this.mEvent.isAltDown()) {
            string = JunDialog.Request_(JunSystem.$String((String)"Month?"), String.valueOf(this.getCalendarDateModel().month()));
        } else {
            StRectangle stRectangle = this.detectFrame(this.getView().frames(), JunCalendarDateController.$((String)"month")).insetBy_(2);
            if (stRectangle == null) {
                return;
            }
            string = JunTextInputField.PopUpIn_forView_initialAnswer_(stRectangle.toRectangle(), this.getView().toComponent(), String.valueOf(this.getCalendarDateModel().month()));
        }
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            this.getCalendarDateModel().month_(n);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunSystem.$String((String)" is invalid value."));
        }
    }

    public void weekdayActivity_(Object[] objectArray) {
    }

    public void yearActivity_(Object[] objectArray) {
        String string;
        if (this.mEvent.isShiftDown() || this.mEvent.isAltDown()) {
            string = JunDialog.Request_(JunSystem.$String((String)"Year?"), String.valueOf(this.getCalendarDateModel().year()));
        } else {
            StRectangle stRectangle = this.detectFrame(this.getView().frames(), JunCalendarDateController.$((String)"year")).insetBy_(2);
            if (stRectangle == null) {
                return;
            }
            string = JunTextInputField.PopUpIn_forView_initialAnswer_(stRectangle.toRectangle(), this.getView().toComponent(), String.valueOf(this.getCalendarDateModel().year()));
        }
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            this.getCalendarDateModel().year_(n);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunSystem.$String((String)" is invalid value."));
        }
    }

    private StRectangle detectFrame(Vector vector, StSymbol stSymbol) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (!objectArray[0].equals(stSymbol)) continue;
            return (StRectangle)objectArray[objectArray.length - 1];
        }
        return null;
    }

    public JunCalendarDateView getView() {
        return (JunCalendarDateView)this.view();
    }

    public JunCalendarDateModel getCalendarDateModel() {
        return (JunCalendarDateModel)this.model();
    }
}

