/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.JunLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StColorValue;

public class JunPlane
extends JunSurface {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected Jun3dPoint p1;
    protected Jun3dPoint p2;
    protected Jun3dPoint p3;

    public static final JunPlane Xy() {
        return new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0));
    }

    public static final JunPlane Yz() {
        return new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
    }

    public static final JunPlane Zx() {
        return new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0), new Jun3dPoint(1.0, 0.0, 0.0));
    }

    public JunPlane(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        this._initialize(junPoint, junPoint2, junPoint3);
    }

    public JunPlane(double d, double d2, double d3, double d4) {
        this.setA_(d);
        this.setB_(d2);
        this.setC_(d3);
        this.setD_(d4);
        Jun3dPoint jun3dPoint = new Jun3dPoint(d, d2, d3);
        if (jun3dPoint.length() < this.Accuracy()) {
            throw new SmalltalkException("Invalid parameters");
        }
        Jun3dPoint jun3dPoint2 = null;
        Jun3dPoint jun3dPoint3 = null;
        Jun3dPoint jun3dPoint4 = null;
        if (Math.abs(this.a()) > this.Accuracy()) {
            jun3dPoint2 = new Jun3dPoint(0.0 - this.d() / this.a(), 0.0, 0.0);
        }
        if (Math.abs(this.b()) > this.Accuracy()) {
            jun3dPoint3 = new Jun3dPoint(0.0, 0.0 - this.d() / this.b(), 0.0);
        }
        if (Math.abs(this.c()) > this.Accuracy()) {
            jun3dPoint4 = new Jun3dPoint(0.0, 0.0, 0.0 - this.d() / this.c());
        }
        Jun3dPoint jun3dPoint5 = null;
        Jun3dPoint jun3dPoint6 = null;
        Jun3dPoint jun3dPoint7 = null;
        if (jun3dPoint2 != null) {
            jun3dPoint5 = jun3dPoint2;
            jun3dPoint6 = jun3dPoint3 != null ? jun3dPoint3 : (jun3dPoint4 != null ? jun3dPoint4 : new Jun3dPoint(jun3dPoint2.x(), 0.0, 1.0));
        } else if (jun3dPoint3 != null) {
            jun3dPoint5 = jun3dPoint3;
            jun3dPoint6 = jun3dPoint4 != null ? jun3dPoint4 : new Jun3dPoint(1.0, jun3dPoint3.y(), 0.0);
        } else if (jun3dPoint4 != null) {
            jun3dPoint5 = jun3dPoint4;
            jun3dPoint6 = new Jun3dPoint(1.0, 0.0, jun3dPoint4.z());
        } else {
            throw new SmalltalkException("Invalid parameters");
        }
        jun3dPoint6 = jun3dPoint5.plus_(jun3dPoint6.minus_(jun3dPoint5).unitVector());
        jun3dPoint7 = jun3dPoint5.minus_(jun3dPoint6).vectorProduct_(jun3dPoint.unitVector());
        this.setP1_(jun3dPoint5);
        this.setP2_(jun3dPoint6);
        this.setP3_(jun3dPoint7);
    }

    protected JunPlane() {
    }

    public static final JunPlane Between_and_(JunPoint junPoint, JunPoint junPoint2) {
        Jun3dPoint jun3dPoint = junPoint.as3dPoint();
        Jun3dPoint jun3dPoint2 = junPoint2.as3dPoint();
        Jun3dPoint jun3dPoint3 = jun3dPoint.center_(jun3dPoint2);
        return JunPlane.On_vertical_(jun3dPoint3, jun3dPoint.to_(jun3dPoint2));
    }

    public static final JunPlane On_vertical_(JunPoint junPoint, JunLine junLine) {
        JunGeometry junGeometry;
        JunGeometry junGeometry2;
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        Jun3dLine jun3dLine = null;
        jun3dLine = junLine instanceof Jun2dLine ? new Jun3dLine(((Jun2dLine)junLine).from(), ((Jun2dLine)junLine).to()) : (Jun3dLine)junLine;
        JunPlane junPlane = new JunPlane();
        junPlane.setP1_(jun3dPoint);
        junPlane.setA_(jun3dLine.f());
        junPlane.setB_(jun3dLine.g());
        junPlane.setC_(jun3dLine.h());
        junPlane.setD_(-(jun3dLine.f() * jun3dPoint.x() + jun3dLine.g() * jun3dPoint.y() + jun3dLine.h() * jun3dPoint.z()));
        if (Math.pow(junPlane.a(), 2.0) + Math.pow(junPlane.b(), 2.0) + Math.pow(junPlane.c(), 2.0) < JunPlane.Accuracy()) {
            throw SmalltalkException.Error((String)"can not define a plane");
        }
        Jun3dPoint jun3dPoint2 = jun3dPoint;
        Jun3dLine jun3dLine2 = jun3dLine;
        Jun3dLine[] jun3dLineArray = new Jun3dLine[]{new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(1.0, 0.0, 0.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 1.0, 0.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 0.0, 1.0))};
        Jun3dLine jun3dLine3 = null;
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            if (jun3dLine2.isParallelWithLine_(jun3dLineArray[i])) continue;
            jun3dLine3 = jun3dLineArray[i];
            break;
        }
        if (jun3dLine3 == null) {
            throw SmalltalkException.Error((String)"notFoundError");
        }
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Translate_(jun3dLine3.to());
        jun3dPoint = null;
        while (jun3dPoint == null || jun3dPoint.equal_((Object)jun3dPoint2)) {
            jun3dLine2 = jun3dLine2.transform_(jun3dTransformation);
            jun3dPoint = junPlane.intersectingPointWithLine_(jun3dLine2);
        }
        Jun3dPoint jun3dPoint3 = jun3dPoint;
        Jun3dLine jun3dLine4 = jun3dLine2;
        jun3dLineArray = new Jun3dLine[]{new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 1.0, 0.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 0.0, 1.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(1.0, 0.0, 0.0))};
        Jun3dLine jun3dLine5 = null;
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            if (jun3dLine4.isParallelWithLine_(jun3dLineArray[i]) || jun3dLineArray[i].to() == jun3dLine3.to()) continue;
            jun3dLine5 = jun3dLineArray[i];
            break;
        }
        if (jun3dLine5 == null) {
            throw SmalltalkException.Error((String)"notFoundError");
        }
        jun3dTransformation = Jun3dTransformation.Translate_(jun3dLine5.to());
        jun3dPoint = null;
        while (jun3dPoint == null || jun3dPoint.equal_((Object)jun3dPoint3) || jun3dPoint.equal_((Object)jun3dPoint2)) {
            jun3dLine4 = jun3dLine4.transform_(jun3dTransformation);
            jun3dPoint = junPlane.intersectingPointWithLine_(jun3dLine4);
        }
        Jun3dPoint jun3dPoint4 = jun3dPoint;
        if (jun3dPoint2.to_(jun3dPoint3).isParallelWithLine_(jun3dPoint2.to_(jun3dPoint4))) {
            junGeometry2 = jun3dLine2;
            jun3dLineArray = new Jun3dLine[]{new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 0.0, 1.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(1.0, 0.0, 0.0)), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(0.0, 1.0, 0.0))};
            junGeometry = null;
            for (int i = 0; i < jun3dLineArray.length; ++i) {
                if (jun3dLineArray[i].to() == jun3dLine3.to() || jun3dLineArray[i].to() == jun3dLine5.to()) continue;
                junGeometry = jun3dLineArray[i];
                break;
            }
            if (junGeometry == null) {
                throw SmalltalkException.Error((String)"notFoundError");
            }
            jun3dTransformation = Jun3dTransformation.Translate_(((Jun3dLine)junGeometry).to());
            jun3dPoint = null;
            while (jun3dPoint == null || jun3dPoint.equal_((Object)jun3dPoint3)) {
                junGeometry2 = ((Jun3dLine)junGeometry2).transform_(jun3dTransformation);
                jun3dPoint = junPlane.intersectingPointWithLine_((Jun3dLine)junGeometry2);
            }
            jun3dPoint4 = jun3dPoint;
        }
        try {
            junGeometry2 = junPlane.normalUnitVector();
            junGeometry = new JunPlane(jun3dPoint2, jun3dPoint3, jun3dPoint4).normalUnitVector();
            if (((Jun3dPoint)junGeometry2).equal_((Object)junGeometry)) {
                junPlane.setP2_(jun3dPoint3);
                junPlane.setP3_(jun3dPoint4);
            } else {
                junPlane.setP2_(jun3dPoint4);
                junPlane.setP3_(jun3dPoint3);
            }
        }
        catch (Exception exception) {
            junPlane.setP2_(jun3dPoint3);
            junPlane.setP3_(jun3dPoint4);
        }
        return junPlane;
    }

    public static final JunPlane On_normalVector_(JunPoint junPoint, JunPoint junPoint2) {
        return JunPlane.On_vertical_(junPoint, new Jun3dLine(junPoint, junPoint.plus_(junPoint2)));
    }

    protected final void _initialize(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(junPoint2);
        Jun3dPoint jun3dPoint3 = Jun3dPoint.Coerce_(junPoint3);
        this.p1 = jun3dPoint;
        this.p2 = jun3dPoint2;
        this.p3 = jun3dPoint3;
        jun3dPoint2 = jun3dPoint2.minus_(jun3dPoint);
        jun3dPoint3 = jun3dPoint3.minus_(jun3dPoint);
        this.a = jun3dPoint2.y() * jun3dPoint3.z() - jun3dPoint2.z() * jun3dPoint3.y();
        this.b = jun3dPoint2.z() * jun3dPoint3.x() - jun3dPoint2.x() * jun3dPoint3.z();
        this.c = jun3dPoint2.x() * jun3dPoint3.y() - jun3dPoint2.y() * jun3dPoint3.x();
        this.d = -(jun3dPoint.x() * this.a + jun3dPoint.y() * this.b + jun3dPoint.z() * this.c);
    }

    public Jun3dPoint atS_andT_(double d, double d2) {
        return new Jun3dPoint(this.x0() + this.f1() * d + this.f2() * d2, this.y0() + this.g1() * d + this.g2() * d2, this.z0() + this.h1() * d + this.h2() * d2);
    }

    public Jun3dPoint first() {
        return this.p1();
    }

    public Jun3dPoint last() {
        return this.p3();
    }

    public Jun3dPoint middle() {
        return this.p2();
    }

    public Jun3dPoint p1() {
        return this.p1;
    }

    public Jun3dPoint p2() {
        return this.p2;
    }

    public Jun3dPoint p3() {
        return this.p3;
    }

    public Jun3dPoint second() {
        return this.p2();
    }

    public Jun3dPoint third() {
        return this.p3();
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunPlane junPlane = (JunPlane)((Object)object);
        return this.isEqualNumber_to_(this.a, junPlane.a) && this.isEqualNumber_to_(this.b, junPlane.b) && this.isEqualNumber_to_(this.c, junPlane.c) && this.isEqualNumber_to_(this.d, junPlane.d);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunPlane junPlane = (JunPlane)((Object)object);
        return this.a == junPlane.a && this.b == junPlane.b && this.c == junPlane.c && this.d == junPlane.d;
    }

    public Jun3dTriangle[] asArrayOf3dTriangles() {
        return this.asArrayOfTriangles();
    }

    public JunPlane[] asArrayOfPlanes() {
        return new JunPlane[]{this.asPlane()};
    }

    public Jun3dTriangle[] asArrayOfTriangles() {
        return new Jun3dTriangle[]{this.asTriangle()};
    }

    public Jun3dPoint[][] asArrays() {
        return new Jun3dPoint[][]{{this.p1(), this.p2(), this.p3(), this.p1()}};
    }

    public Jun3dCircle asCircle() {
        return this.asTriangle().asCircle();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        Jun3dPoint[] jun3dPointArray = this.asCircle().trackPointsBy_(36);
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dPolygon junOpenGL3dPolygon2 = (JunOpenGL3dPolygon)junOpenGL3dPolygon.reversed();
        junOpenGL3dPolygon2.paint_alpha_(StColorValue.Blend((Color)this.defaultColor(), (Color)Color.black), this.defaultAlpha());
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon2);
        junOpenGL3dPolygon.paint_alpha_(this.defaultColor(), this.defaultAlpha());
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(this.asJunOpenGL3dObject());
        JunOpenGL3dObject junOpenGL3dObject = this.p1().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGL3dObject junOpenGL3dObject2 = this.p1().asJunOpenGL3dObject();
        junOpenGL3dObject2.paint_(Color.green);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        JunOpenGL3dObject junOpenGL3dObject3 = this.p1().asJunOpenGL3dObject();
        junOpenGL3dObject3.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject3);
        return this.asJunOpenGL3dObject();
    }

    public JunPlane asPlane() {
        return this;
    }

    public Point[][] asPointArrays() {
        Jun3dPoint[][] jun3dPointArray = this.asArrays();
        Point[][] pointArray = new Point[jun3dPointArray.length][];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            pointArray[i] = new Point[jun3dPointArray[i].length];
            for (int j = 0; j < jun3dPointArray[i].length; ++j) {
                pointArray[i][j] = jun3dPointArray[i][j].asPoint();
            }
        }
        return pointArray;
    }

    public Jun3dTriangle asTriangle() {
        return new Jun3dTriangle(this.p1(), this.p2(), this.p3());
    }

    public JunAngle angleWithLine_(JunLine junLine) {
        Jun3dLine jun3dLine = null;
        if (junLine instanceof Jun3dLine) {
            jun3dLine = (Jun3dLine)junLine;
        } else {
            Jun2dLine jun2dLine = (Jun2dLine)junLine;
            jun3dLine = new Jun3dLine(jun2dLine.first(), jun2dLine.last());
        }
        double d = jun3dLine.f();
        double d2 = jun3dLine.g();
        double d3 = jun3dLine.h();
        double d4 = Math.sqrt((this.a * this.a + this.b * this.b + this.c * this.c) * (d * d + d2 * d2 + d3 * d3));
        if (d4 < 1.0E-12) {
            throw new IllegalArgumentException("unexpected line or plane parameters");
        }
        double d5 = this.a * d + this.b * d2 + this.c * d3;
        double d6 = Math.min(Math.max(d5 / d4, -1.0), 1.0);
        return JunAngle.FromRad_(1.5707963267948966 - Math.acos(d6));
    }

    public JunAngle angleWithPlane_(JunPlane junPlane) {
        double d = (Math.sqrt(this.a()) + Math.sqrt(this.b()) + Math.sqrt(this.c())) * (Math.sqrt(junPlane.a()) + Math.sqrt(junPlane.b()) + Math.sqrt(junPlane.c()));
        if (d < this.accuracy()) {
            throw new IllegalArgumentException("unexpected plane parameters");
        }
        double d2 = this.a() * junPlane.a() + this.b() * junPlane.b() + this.c() * junPlane.c();
        double d3 = Math.min(Math.max(Math.sqrt(d2 / d), -1.0), 1.0);
        return JunAngle.FromRad_(Math.acos(d3));
    }

    public JunAngle angleWithTriangle_(JunTriangle junTriangle) {
        return this.angleWithPlane_(junTriangle.asPlane());
    }

    public double distanceFromPoint_(Jun3dPoint jun3dPoint) {
        double d = this.a * this.a + this.b * this.b + this.c * this.c;
        if (d - 1.0E-12 < 0.0) {
            throw new IllegalArgumentException("unexpect plane parameters");
        }
        double d2 = this.a * jun3dPoint.x() + this.b * jun3dPoint.y() + this.c * jun3dPoint.z() + this.d;
        d2 *= d2;
        return Math.sqrt(d2 / d);
    }

    public Jun3dLine intersectingLineWithPlane_(JunPlane junPlane) {
        double d = this.b() * junPlane.c() - junPlane.b() * this.c();
        double d2 = this.c() * junPlane.a() - junPlane.c() * this.a();
        double d3 = this.a() * junPlane.b() - junPlane.a() * this.b();
        double d4 = Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0);
        if (d4 < this.Accuracy()) {
            return null;
        }
        double d5 = this.d() * junPlane.c() - this.c() * junPlane.d();
        double d6 = this.d() * junPlane.b() - this.b() * junPlane.d();
        double d7 = this.a() * junPlane.d() - this.d() * junPlane.a();
        double d8 = (d2 * d5 - d3 * d6) / d4;
        double d9 = (0.0 - (d * d5 + d3 * d7)) / d4;
        double d10 = (d * d6 + d2 * d7) / d4;
        return new Jun3dLine(new Jun3dPoint(d8, d9, d10), new Jun3dPoint(d8 + d, d9 + d2, d10 + d3));
    }

    public Jun3dPoint intersectingPointWithLine_(Jun3dLine jun3dLine) {
        double d = jun3dLine.f();
        double d2 = jun3dLine.g();
        double d3 = jun3dLine.h();
        double d4 = this.a * d + this.b * d2 + this.c * d3;
        if (Math.abs(d4) < 1.0E-12) {
            return null;
        }
        double d5 = jun3dLine.x0();
        double d6 = jun3dLine.y0();
        double d7 = jun3dLine.z0();
        double d8 = -(this.a * d5 + this.b * d6 + this.c * d7 + this.d);
        Jun3dPoint jun3dPoint = new Jun3dPoint(d5 + d * d8 / d4, d6 + d2 * d8 / d4, d7 + d3 * d8 / d4);
        return jun3dPoint;
    }

    public Jun3dPoint intersectingPointWithLineSegment_(Jun3dLine jun3dLine) {
        Jun3dPoint jun3dPoint = this.intersectingPointWithLine_(jun3dLine);
        if (jun3dPoint == null || !jun3dLine.lineSegmentContainsPoint_(jun3dPoint)) {
            return null;
        }
        return jun3dPoint;
    }

    public Jun3dPoint intersectingPointWithPlane_wihtPlane_(JunPlane junPlane, JunPlane junPlane2) {
        double d = junPlane.b() * junPlane2.c() - junPlane2.b() * junPlane.c();
        double d2 = junPlane.a() * junPlane2.c() - junPlane2.a() * junPlane.c();
        double d3 = junPlane.a() * junPlane2.b() - junPlane2.a() * junPlane.b();
        double d4 = this.a() * d - this.b() * d2 + this.c() * d3;
        if (Math.abs(d4) < this.Accuracy()) {
            return null;
        }
        double d5 = junPlane.d() * junPlane2.c() - junPlane2.d() * junPlane.c();
        double d6 = junPlane.d() * junPlane2.b() - junPlane2.d() * junPlane.b();
        double d7 = junPlane.a() * junPlane2.d() - junPlane2.a() * junPlane.d();
        return new Jun3dPoint((this.b() * d5 - this.d() * d - this.c() * d6) / d4, (this.d() * d2 - this.a() * d5 - this.c() * d7) / d4, (this.b() * d7 + this.a() * d6 - this.d() * d3) / d4);
    }

    public Jun3dPoint nearestPointFromPoint_(Jun3dPoint jun3dPoint) {
        double d = Math.pow(this.a(), 2.0) + Math.pow(this.b(), 2.0) + Math.pow(this.c(), 2.0);
        if (Math.abs(d) < JunPlane.Accuracy()) {
            this.error_("Can't define a plane");
            return null;
        }
        double d2 = 0.0 - (this.a() * jun3dPoint.x() + this.b() * jun3dPoint.y() + this.c() * jun3dPoint.z() + this.d());
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun3dPoint.x() + this.a() * d2 / d, jun3dPoint.y() + this.b() * d2 / d, jun3dPoint.z() + this.c() * d2 / d);
        return jun3dPoint2;
    }

    public Jun3dPoint normalUnitVector() {
        double d = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        return new Jun3dPoint(this.a / d, this.b / d, this.c / d);
    }

    public Jun3dPoint normalVector() {
        return new Jun3dPoint(this.a, this.b, this.c);
    }

    public Jun3dLine projectionOfLine_(Jun3dLine jun3dLine) {
        Jun3dPoint jun3dPoint = jun3dLine.from();
        Jun3dPoint jun3dPoint2 = jun3dLine.to();
        return new Jun3dLine(this.projectionOfPoint_(jun3dPoint), this.projectionOfPoint_(jun3dPoint2));
    }

    public Jun3dPoint projectionOfPoint_(Jun3dPoint jun3dPoint) {
        double d = this.a * this.a + this.b * this.b + this.c * this.c;
        if (Math.abs(d) < 1.0E-12) {
            this.normalizeParameters();
            d = this.a * this.a + this.b * this.b + this.c * this.c;
            if (Math.abs(d) < 1.0E-12) {
                throw SmalltalkException.Error((String)"can not define a plane");
            }
        }
        double d2 = -(this.a * jun3dPoint.x() + this.b * jun3dPoint.y() + this.c * jun3dPoint.z() + this.d);
        double d3 = jun3dPoint.x() + this.a * d2 / d;
        double d4 = jun3dPoint.y() + this.b * d2 / d;
        double d5 = jun3dPoint.z() + this.c * d2 / d;
        return new Jun3dPoint(d3, d4, d5);
    }

    public Jun3dLine reflectingLineWithLine_(Jun3dLine jun3dLine) {
        Jun3dPoint jun3dPoint;
        Jun3dPoint jun3dPoint2;
        Jun3dPoint jun3dPoint3 = this.intersectingPointWithLine_(jun3dLine);
        if (jun3dPoint3 == null) {
            jun3dPoint2 = jun3dLine.last();
            jun3dPoint = jun3dLine.last().minus_(jun3dLine.first());
        } else if (this.containsPoint_(jun3dLine.first())) {
            Jun3dPoint jun3dPoint4 = this.nearestPointFromPoint_(jun3dLine.last());
            jun3dPoint2 = jun3dLine.first();
            jun3dPoint = jun3dLine.last().to_(jun3dPoint4).atT_(2.0).minus_(jun3dPoint2);
        } else {
            Jun3dPoint jun3dPoint5 = this.nearestPointFromPoint_(jun3dLine.first());
            Jun3dPoint jun3dPoint6 = jun3dPoint5.to_(jun3dPoint3).atT_(2.0);
            jun3dPoint2 = jun3dPoint6.minus_(jun3dPoint5.minus_(jun3dLine.first()));
            jun3dPoint = this.whichSide_(jun3dLine.first()) >= 0 ? jun3dPoint3.to_(jun3dPoint2).normalized().atT_(jun3dLine.length()).minus_(jun3dPoint3) : jun3dPoint2.to_(jun3dPoint3).normalized().atT_(jun3dLine.length()).minus_(jun3dPoint2);
        }
        return new Jun3dLine(jun3dPoint2, jun3dPoint2.plus_(jun3dPoint));
    }

    public JunPlane reversed() {
        return new JunPlane(this.p3(), this.p2(), this.p1());
    }

    public double valueF_(JunPoint junPoint) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        return this.a() * jun3dPoint.x() + this.b() * jun3dPoint.y() + this.c() * jun3dPoint.z() + this.d();
    }

    public int whichSide_(JunPoint junPoint) {
        double d = this.valueF_(junPoint);
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public double c() {
        return this.c;
    }

    public double d() {
        return this.d;
    }

    public double f1() {
        return this.p2().x() - this.p1().x();
    }

    public double f2() {
        return this.p3().x() - this.p1().x();
    }

    public double g1() {
        return this.p2().y() - this.p1().y();
    }

    public double g2() {
        return this.p3().y() - this.p1().y();
    }

    public double h1() {
        return this.p2().z() - this.p1().z();
    }

    public double h2() {
        return this.p3().z() - this.p1().z();
    }

    public double n() {
        double d = Math.pow(this.a(), 2.0) + Math.pow(this.b(), 2.0) + Math.pow(this.c(), 2.0);
        if (d < this.Accuracy()) {
            throw SmalltalkException.Error((String)"can not define a plane");
        }
        return 1.0 / Math.sqrt(d);
    }

    public double n1() {
        double d = Math.pow(this.f1(), 2.0) + Math.pow(this.g1(), 2.0) + Math.pow(this.h1(), 2.0);
        if (d < this.Accuracy()) {
            throw SmalltalkException.Error((String)"can not define a plane");
        }
        return 1.0 / Math.sqrt(d);
    }

    public double n2() {
        double d = Math.pow(this.f2(), 2.0) + Math.pow(this.g2(), 2.0) + Math.pow(this.h2(), 2.0);
        if (d < this.Accuracy()) {
            throw SmalltalkException.Error((String)"can not define a plane");
        }
        return 1.0 / Math.sqrt(d);
    }

    public double x0() {
        return this.p1().x();
    }

    public double y0() {
        return this.p1().y();
    }

    public double z0() {
        return this.p1().z();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        this.p1().printOn_(writer);
        writer.write(" plane: ");
        this.p2().printOn_(writer);
        writer.write(" and: ");
        this.p3().printOn_(writer);
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" on:: ");
        this.p1().storeOn_(writer);
        writer.write(" on:: ");
        this.p2().storeOn_(writer);
        writer.write(" on:: ");
        this.p3().storeOn_(writer);
        writer.write(41);
    }

    public boolean containsPoint_(Jun3dPoint jun3dPoint) {
        return Math.abs(this.valueF_(jun3dPoint)) < 1.0E-12;
    }

    public boolean is3d() {
        return true;
    }

    public boolean isPlane() {
        return true;
    }

    public JunPlane rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public JunPlane scaledBy_(double d) {
        return this.transform_(Jun3dTransformation.Scale_(d));
    }

    public JunPlane scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public JunPlane transform_(Jun3dTransformation jun3dTransformation) {
        Object[] objectArray = new Object[]{this.p1.transform_(jun3dTransformation), this.p2.transform_(jun3dTransformation), this.p3.transform_(jun3dTransformation)};
        return (JunPlane)((Object)JunPlane._New(((Object)((Object)this)).getClass(), (Object[])objectArray));
    }

    public JunPlane translatedBy_(double d) {
        return this.transform_(Jun3dTransformation.Translate_(d));
    }

    public JunPlane translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }

    protected void normalizeParameters() {
        double d = Math.max(Math.max(Math.abs(this.a), Math.abs(this.b)), Math.abs(this.c));
        this.a /= d;
        this.b /= d;
        this.c /= d;
        this.d /= d;
    }

    protected void setA_(double d) {
        this.a = d;
    }

    protected void setB_(double d) {
        this.b = d;
    }

    protected void setC_(double d) {
        this.c = d;
    }

    protected void setD_(double d) {
        this.d = d;
    }

    protected void setP1_(Jun3dPoint jun3dPoint) {
        this.p1 = Jun3dPoint.Coerce_(jun3dPoint);
    }

    protected void setP2_(Jun3dPoint jun3dPoint) {
        this.p2 = Jun3dPoint.Coerce_(jun3dPoint);
    }

    protected void setP3_(Jun3dPoint jun3dPoint) {
        this.p3 = Jun3dPoint.Coerce_(jun3dPoint);
    }
}

