/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Point;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.support.JunBSplineFunction;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

public class JunNurbsSurface
extends JunSurface {
    protected JunMatrix controlPoints;
    protected JunDoubleMatrix weights;
    protected double[] uKnotVector;
    protected double[] vKnotVector;

    public static final JunNurbsSurface BezierControlPoints_(JunMatrix junMatrix) {
        int n = junMatrix.columnSize();
        int n2 = junMatrix.rowSize();
        double[] dArray = new double[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            dArray[i + n2] = 1.0;
        }
        double[] dArray2 = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
            dArray2[i + n] = 1.0;
        }
        return JunNurbsSurface.BSplineControlPoints_uKnotVector_vKnotVector_(junMatrix, dArray, dArray2);
    }

    public static final JunNurbsSurface BSplineControlPoints_uKnotVector_vKnotVector_(JunMatrix junMatrix, double[] dArray, double[] dArray2) {
        int n = junMatrix.rowSize();
        int n2 = junMatrix.columnSize();
        double[] dArray3 = new double[n * n2];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 1.0;
        }
        return JunNurbsSurface.ControlPoints_weights_uKnotVector_vKnotVector_(junMatrix, new JunDoubleMatrix(n, n2, dArray3), dArray, dArray2);
    }

    public static final JunNurbsSurface ControlPoints_weights_uKnotVector_vKnotVector_(JunMatrix junMatrix, JunDoubleMatrix junDoubleMatrix, double[] dArray, double[] dArray2) {
        return new JunNurbsSurface(junMatrix, junDoubleMatrix, dArray, dArray2);
    }

    public JunNurbsSurface(JunMatrix junMatrix, JunDoubleMatrix junDoubleMatrix, double[] dArray, double[] dArray2) {
        this.controlPoints_(junMatrix);
        this.weights_(junDoubleMatrix);
        this.uKnotVector_(dArray);
        this.vKnotVector_(dArray2);
    }

    protected void initialize() {
        super.initialize();
        this.controlPoints = null;
        this.weights = null;
        this.uKnotVector = null;
        this.vKnotVector = null;
    }

    public Jun3dPoint atU_v_(double d, double d2) {
        if (d < 0.0 || 1.0 < d) {
            return null;
        }
        if (d2 < 0.0 || 1.0 < d2) {
            return null;
        }
        JunBSplineFunction junBSplineFunction = this.uBspline();
        JunBSplineFunction junBSplineFunction2 = this.vBspline();
        Jun3dPoint jun3dPoint = Jun3dPoint.Zero();
        double d3 = 0.0;
        for (int i = 0; i < this.uSize(); ++i) {
            for (int j = 0; j < this.vSize(); ++j) {
                double d4 = junBSplineFunction.i_t_(i, d) * junBSplineFunction2.i_t_(j, d2) * this.weightAtU_v_(i, j);
                jun3dPoint = jun3dPoint.plus_(this.controlPointAtU_v_(i, j).multipliedBy_(d4));
                d3 += d4;
            }
        }
        if (d3 == 0.0) {
            return this.controlPointAtU_v_(this.uSize() - 1, this.vSize() - 1);
        }
        return jun3dPoint.dividedBy_(d3);
    }

    public Jun3dPoint controlPointAt_(Point point) {
        return (Jun3dPoint)((Object)this.controlPoints._at(point.x, point.y));
    }

    public void controlPointAt_put_(Point point, Jun3dPoint jun3dPoint) {
        this.controlPoints._put(point.x, point.y, (Object)jun3dPoint);
    }

    public Jun3dPoint controlPointAtU_v_(int n, int n2) {
        return (Jun3dPoint)((Object)this.controlPoints._at(n, n2));
    }

    public JunMatrix controlPoints() {
        return this.controlPoints;
    }

    public void controlPoints_(JunMatrix junMatrix) {
        this.controlPoints = junMatrix;
    }

    public Point controlPointSize() {
        return this.controlPoints.matrixSize();
    }

    public JunBSplineFunction uBspline() {
        return new JunBSplineFunction((double[])this.uKnotVector().clone(), this.uOrder());
    }

    public double[] uKnotVector() {
        return this.uKnotVector;
    }

    public void uKnotVector_(double[] dArray) {
        this.uKnotVector = dArray;
    }

    public int uOrder() {
        return this.uKnotVector.length - this.uSize();
    }

    public int uSize() {
        return this.controlPoints.rowSize();
    }

    public JunBSplineFunction vBspline() {
        return new JunBSplineFunction((double[])this.vKnotVector().clone(), this.uOrder());
    }

    public double[] vKnotVector() {
        return this.vKnotVector;
    }

    public void vKnotVector_(double[] dArray) {
        this.vKnotVector = dArray;
    }

    public int vOrder() {
        return this.vKnotVector.length - this.vSize();
    }

    public int vSize() {
        return this.controlPoints.columnSize();
    }

    public double weightAtU_v_(int n, int n2) {
        return this.weights._doubleValueAt(n, n2);
    }

    public JunDoubleMatrix weights() {
        return this.weights;
    }

    public void weights_(JunDoubleMatrix junDoubleMatrix) {
        this.weights = junDoubleMatrix;
    }

    public boolean equal_(Object object) {
        int n;
        int n2;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunNurbsSurface junNurbsSurface = (JunNurbsSurface)((Object)object);
        if (this.controlPoints().rowSize() != junNurbsSurface.controlPoints().rowSize()) {
            return false;
        }
        if (this.controlPoints().columnSize() != junNurbsSurface.controlPoints().columnSize()) {
            return false;
        }
        for (n2 = 0; n2 < this.controlPoints().rowSize(); ++n2) {
            for (n = 0; n < this.controlPoints().columnSize(); ++n) {
                if (this.controlPointAtU_v_(n2, n).equal_((Object)junNurbsSurface.controlPointAtU_v_(n2, n))) continue;
                return false;
            }
        }
        if (this.weights().rowSize() != junNurbsSurface.weights().rowSize()) {
            return false;
        }
        if (this.weights().columnSize() != junNurbsSurface.weights().columnSize()) {
            return false;
        }
        for (n2 = 0; n2 < this.weights().rowSize(); ++n2) {
            for (n = 0; n < this.weights().columnSize(); ++n) {
                if (this.isEqualNumber_to_(this.weightAtU_v_(n2, n), junNurbsSurface.weightAtU_v_(n2, n))) continue;
                return false;
            }
        }
        n2 = this.uKnotVector().length;
        if (n2 != junNurbsSurface.uKnotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.isEqualNumber_to_(this.uKnotVector()[n], junNurbsSurface.uKnotVector()[n])) continue;
            return false;
        }
        n2 = this.vKnotVector().length;
        if (n2 != junNurbsSurface.vKnotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.isEqualNumber_to_(this.vKnotVector()[n], junNurbsSurface.vKnotVector()[n])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        int n;
        int n2;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunNurbsSurface junNurbsSurface = (JunNurbsSurface)((Object)object);
        if (this.controlPoints().rowSize() != junNurbsSurface.controlPoints().rowSize()) {
            return false;
        }
        if (this.controlPoints().columnSize() != junNurbsSurface.controlPoints().columnSize()) {
            return false;
        }
        for (n2 = 0; n2 < this.controlPoints().rowSize(); ++n2) {
            for (n = 0; n < this.controlPoints().columnSize(); ++n) {
                if (this.controlPointAtU_v_(n2, n).equals((Object)junNurbsSurface.controlPointAtU_v_(n2, n))) continue;
                return false;
            }
        }
        if (this.weights().rowSize() != junNurbsSurface.weights().rowSize()) {
            return false;
        }
        if (this.weights().columnSize() != junNurbsSurface.weights().columnSize()) {
            return false;
        }
        for (n2 = 0; n2 < this.weights().rowSize(); ++n2) {
            for (n = 0; n < this.weights().columnSize(); ++n) {
                if (this.weightAtU_v_(n2, n) == junNurbsSurface.weightAtU_v_(n2, n)) continue;
                return false;
            }
        }
        n2 = this.uKnotVector().length;
        if (n2 != junNurbsSurface.uKnotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.uKnotVector()[n] == junNurbsSurface.uKnotVector()[n]) continue;
            return false;
        }
        n2 = this.vKnotVector().length;
        if (n2 != junNurbsSurface.vKnotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.vKnotVector()[n] == junNurbsSurface.vKnotVector()[n]) continue;
            return false;
        }
        return true;
    }

    public boolean is3d() {
        return true;
    }

    public boolean isPlane() {
        return true;
    }

    public JunOpenGL3dNurbsSurface asJunOpenGL3dNurbsSurface() {
        return new JunOpenGL3dNurbsSurface(this.controlPoints, this.weights, this.uKnotVector, this.vKnotVector);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        return this.asJunOpenGL3dNurbsSurface();
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.displayNurbsSurface_(this);
    }

    public Object trimCurvesDo_(Object object) {
        return null;
    }
}

