/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.util.ArrayList;
import java.util.List;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;

public class JunCompoundSurface
extends JunSurface {
    protected List components;
    protected JunBoundingBox boundingBox;

    protected JunCompoundSurface() {
    }

    public JunCompoundSurface(JunSurface[] junSurfaceArray) {
        this.setComponents_(junSurfaceArray);
    }

    public JunCompoundSurface(List list) {
        this.setComponents_(list);
    }

    protected List _components() {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        return this.components;
    }

    public JunSurface[] components() {
        return this._components().toArray(new JunSurface[this._components().size()]);
    }

    public JunBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.preferredBoundingBox();
        }
        return this.boundingBox;
    }

    public boolean equal_(Object object) {
        JunSurface[] junSurfaceArray;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunCompoundSurface junCompoundSurface = (JunCompoundSurface)((Object)object);
        JunSurface[] junSurfaceArray2 = this.components();
        if (junSurfaceArray2.length != (junSurfaceArray = junCompoundSurface.components()).length) {
            return false;
        }
        for (int i = 0; i < junSurfaceArray2.length; ++i) {
            if (junSurfaceArray2[i].equal_((Object)junSurfaceArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        JunSurface[] junSurfaceArray;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunCompoundSurface junCompoundSurface = (JunCompoundSurface)((Object)object);
        JunSurface[] junSurfaceArray2 = this.components();
        if (junSurfaceArray2.length != (junSurfaceArray = junCompoundSurface.components()).length) {
            return false;
        }
        for (int i = 0; i < junSurfaceArray2.length; ++i) {
            if (junSurfaceArray2[i].equals((Object)junSurfaceArray[i])) continue;
            return false;
        }
        return true;
    }

    public double distanceFromPoint_(Jun3dPoint jun3dPoint) {
        return this.nearestPointFromPoint_(jun3dPoint).distance_(jun3dPoint);
    }

    public Jun3dPoint intersectingPointWithLine_(Jun3dLine jun3dLine) {
        JunSurface[] junSurfaceArray = this.components();
        for (int i = 0; i < junSurfaceArray.length; ++i) {
            try {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)junSurfaceArray[i].perform_with_("intersectingPointWithLine_", (Object)jun3dLine));
                if (jun3dPoint == null) continue;
                return jun3dPoint;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        return null;
    }

    public Jun3dPoint intersectingPointWithLineSegment_(Jun3dLine jun3dLine) {
        JunSurface[] junSurfaceArray = this.components();
        for (int i = 0; i < junSurfaceArray.length; ++i) {
            try {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)junSurfaceArray[i].perform_with_("intersectingPointWithLineSegment_", (Object)jun3dLine));
                if (jun3dPoint == null) continue;
                return jun3dPoint;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        return null;
    }

    public Jun3dPoint nearestPointFromPoint_(Jun3dPoint jun3dPoint) {
        JunSurface[] junSurfaceArray = this.components();
        Jun3dPoint jun3dPoint2 = null;
        try {
            jun3dPoint2 = (Jun3dPoint)((Object)junSurfaceArray[0].perform_with_("nearestPointFromPoint_", (Object)jun3dPoint));
            double d = jun3dPoint.distance_(jun3dPoint2);
            for (int i = 1; i < junSurfaceArray.length; ++i) {
                Jun3dPoint jun3dPoint3 = (Jun3dPoint)((Object)junSurfaceArray[i].perform_with_("nearestPointFromPoint_", (Object)jun3dPoint));
                double d2 = jun3dPoint.distance_(jun3dPoint3);
                if (!(d > d2)) continue;
                jun3dPoint2 = jun3dPoint3;
                d = d2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return jun3dPoint2;
    }

    public boolean isCompoundSurface() {
        return true;
    }

    protected JunBoundingBox preferredBoundingBox() {
        JunSurface[] junSurfaceArray = this.components();
        JunBoundingBox junBoundingBox = null;
        try {
            if (junSurfaceArray[0].is2d()) {
                Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)((Object)junSurfaceArray[0].perform_("boundingBox"));
                for (int i = 1; i < junSurfaceArray.length; ++i) {
                    jun2dBoundingBox.merge_((Jun2dBoundingBox)((Object)junSurfaceArray[i].perform_("boundingBox")));
                }
                junBoundingBox = jun2dBoundingBox;
            } else {
                Jun3dBoundingBox jun3dBoundingBox = (Jun3dBoundingBox)((Object)junSurfaceArray[0].perform_("boundingBox"));
                for (int i = 1; i < junSurfaceArray.length; ++i) {
                    jun3dBoundingBox.merge_((Jun3dBoundingBox)((Object)junSurfaceArray[i].perform_("boundingBox")));
                }
                junBoundingBox = jun3dBoundingBox;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return junBoundingBox;
    }

    protected void setComponents_(List list) {
        this.components = list;
        this.boundingBox = null;
    }

    protected void setComponents_(JunSurface[] junSurfaceArray) {
        ArrayList<JunSurface> arrayList = new ArrayList<JunSurface>();
        for (int i = 0; i < junSurfaceArray.length; ++i) {
            arrayList.add(junSurfaceArray[i]);
        }
        this.setComponents_(arrayList);
    }
}

